package com.parsec.servlets;

import java.io.*;
import java.rmi.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;

import com.parsec.ejbs.portfolio.*;
import com.parsec.ejbs.deal.*;

public class PortfolioRetriever extends HttpServlet
{	 
	PortfolioDescriptor pd;
	 
	public void init() throws ServletException
	{
		System.out.println("in init of PortfolioRetServlet");
		try
		{
			InitialContext ic = new InitialContext();
			Object objref = ic.lookup("java:comp/env/ejb/PortfolioDescriptor");
			PortfolioDescriptorHome home = (PortfolioDescriptorHome)PortableRemoteObject.narrow(objref,PortfolioDescriptorHome.class);
			pd = home.create();

		} catch(Exception e)
		{
			e.printStackTrace();
		}

	} 

	public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)//new user
		{
			out.println(ContentTemplate.invalidPage);
			
		}
		else
			doPost(req,res);
		out.close();	
	}	

	public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);
			return;
		}
		String uid=(String)session.getAttribute("com.parsec.servlets.login");
		out.println(ContentTemplate.header+ContentTemplate.bodyStart);
		generatePortfolio(out,uid); 
		out.println(ContentTemplate.bodyEnd);
		out.close();
	}
 
 	private void generatePortfolio(PrintWriter out,String uid)
 	{
		try
		{
		System.out.println("Beg of post method");
		Vector v= new Vector(pd.holdings(uid));
		System.out.println("Vector cast ok");
		out.println(ContentTemplate.portfolioDetail);
        out.println(ContentTemplate.portfolioHoldingHeader);
		Object[] array=v.toArray();
		System.out.println("toArray ok");
		for( int i=0;i<array.length;i++)
		{
			PortfolioData d=(PortfolioData)array[i];
			out.println(ContentTemplate.generatePortfolioHoldings(d.getShareId(),d.getAvgBuyingPrice(),d.getHolding(),d.getTotalValue(),d.getMarketValue(),d.getGain(),d.getGainPercent()));
		}
		out.println(ContentTemplate.portfolioHoldingEnd);
		//buys and sales
		v=new Vector(pd.buys(uid));
		for(int i=0;i<v.size();i++)
		{
			Deal d=(Deal)v.elementAt(i);
			out.println(ContentTemplate.generateBuyingDeals(d.getSellerId(),
															d.getShareId(),
															d.getDealTime(),
															d.getNoOfShares(),
															d.getPrice()));
		}
		out.println(ContentTemplate.buysEnd);
		v=new Vector(pd.sales(uid));
		for(int i=0;i<v.size();i++)
		{
			Deal d=(Deal)v.elementAt(i);
			out.println(ContentTemplate.generateBuyingDeals(d.getBuyerId(),
															d.getShareId(),
															d.getDealTime(),
															d.getNoOfShares(),
															d.getPrice()));
		}				
		out.println(ContentTemplate.salesEnd);
		out.println(ContentTemplate.bodyEnd+ContentTemplate.footnote);
		}catch(RemoteException e)
		{
			out.println(e.getMessage()+
						ContentTemplate.bodyEnd+
						ContentTemplate.footnote);
		}
 	}

	
} 

