package com.parsec.servlets;

import java.io.*;
import java.util.*;
import java.rmi.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;
import javax.ejb.*;

import com.parsec.ejbs.company.*;
import com.parsec.ejbs.share.*;


public class ScripLocator extends HttpServlet
{	 
	CompanyHome chome;
	ShareUnitHome suhome;
	CurrentShareStateHome csshome;
	SharePerformanceHome sphome;
	
	public void init() throws ServletException
	{
		System.out.println("in init of LoginServlet");
		try
		{
			InitialContext ic = new InitialContext();
			Object objref = ic.lookup("java:comp/env/ejb/Company");
			chome = (CompanyHome)PortableRemoteObject.narrow(objref,CompanyHome.class);
	 	
			objref = ic.lookup("java:comp/env/ejb/ShareUnit");
			suhome = (ShareUnitHome)PortableRemoteObject.narrow(objref,ShareUnitHome.class);
	
			objref = ic.lookup("java:comp/env/ejb/SharePerformance");
			sphome = (SharePerformanceHome)PortableRemoteObject.narrow(objref,SharePerformanceHome.class);
	 	
			objref = ic.lookup("java:comp/env/ejb/CurrentShareState");
			csshome = (CurrentShareStateHome)PortableRemoteObject.narrow(objref,CurrentShareStateHome.class);
	 	
	 	} catch(Exception e)
		{
			e.printStackTrace();
		}

	} 

	public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
 		String compId=req.getParameter("cname");
		String scripCode=req.getParameter("shareId");
		if (scripCode==null&&compId==null)
		{
			out.println(ContentTemplate.scripLocatorResultStart); 
			out.println(ContentTemplate.scripLocatorResultEnd);
			return; 
		}
		if (scripCode!=null)
		{
			generateSharePage(scripCode,out);
		}else
		{
			generatePossibleCompaniesPage(compId,out);
		}
		out.close();
    }
  
  	
	private void generateSharePage(String scripCode,PrintWriter out)
	{
		try
		{
			ShareUnit su=suhome.findByPrimaryKey(scripCode);
			CurrentShareState css=csshome.findByPrimaryKey(scripCode);
			Company c=chome.findByPrimaryKey(scripCode);
	 
			String name=su.getName();
			Date launchDate=su.getLaunchDate();
			int volume=su.getVolume();
			float faceValue=su.getFaceValue();
	 		float currentPrice=css.getCurrentPrice();
	 		float todaysHigh=css.getTodaysHigh();
	 		float todaysLow=css.getTodaysLow();
	 		
			out.println(ContentTemplate.scripLocatorStart(scripCode));
			out.println(ContentTemplate.scripLocatorShowShareStats(scripCode,currentPrice,todaysHigh,todaysLow,volume,faceValue));
			out.println(ContentTemplate.companyInfo(name,
													launchDate,
													c.getStreet(),
													c.getCity(),
											 		c.getState(),
													c.getPinCode(),
													c.getEmail(),
													c.getTelephone()));
			out.println(ContentTemplate.shareHistoryStart);											
			Vector history=new Vector(sphome.findByShareId(scripCode));
			for(int i=0;i<history.size();i++)
			{
				SharePerformance sp=(SharePerformance)history.elementAt(i);
				out.println(ContentTemplate.generateSharePerformanceRow(sp.getAssessDate(),
																		sp.getOpening(),
																		sp.getClosing(),
																		sp.getDaysHigh(),
																		sp.getDaysLow()));
			
			}	
			out.println(ContentTemplate.shareHistoryEnd);
		}catch(FinderException e)
		{
			out.println(ContentTemplate.internalServerError);
			e.printStackTrace();
		}catch(RemoteException e)
		{
			out.println(ContentTemplate.internalServerError);
			e.printStackTrace();
		}
	}
	
  	private void generatePossibleCompaniesPage(String compId,PrintWriter out)
  	{
		Vector cv=new Vector();
		System.out.println("in genposscompanies");
  		try
		{
			cv = new Vector(chome.findByNameDesc(compId));
		}catch (FinderException fe)
		{
			fe.printStackTrace();
		}catch (RemoteException fe)
		{
			out.println(ContentTemplate.internalServerError);
			System.out.println(fe);
			return;
		}
		
		out.println(ContentTemplate.scripLocatorResultStart); 
		for(int i=0;i<cv.size();i++)
		{
			try
			{
				Company c=(Company)cv.elementAt(i);
				out.println(ContentTemplate.scripLocatorResult(c.getCompanyId(),c.getDescription()));	
			}catch(RemoteException e)
			{
				e.printStackTrace();
			} 
		}
		out.println(ContentTemplate.scripLocatorEnd);	
  	}
} 

