package com.parsec.utils;

import java.io.*;
import java.rmi.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.*;
import javax.ejb.*;
import java.sql.*;
import javax.sql.*;

import com.parsec.ejbs.config.*;
import oracle.jdbc.pool.*;


public class ParsecUtils
{

    static int lookbackTime=0;
 	static int startHour=0;
 	static int startMinute=1;	
 	static int stopHour=23;
	static int stopMinute=0;
	static int dealAffectorHour=18;
	static int dealAffectorMinute=0;	
	static int refreshRate=1000;
	static int swingMargin=16;
	static String adminPasswd;
  	
	static ParsecConfigHome home;
	
	//Database stuuff
	static OracleConnectionPoolDataSource opds;
	static OracleConnectionCacheImpl occi;
	static PooledConnection pc;
	static
	{
		try
		{
			opds=new OracleConnectionPoolDataSource();
			opds.setURL("jdbc:oracle:thin:@everest:1521:GEN");
			opds.setUser("sarvjeet");
			opds.setPassword("sarv");
 			
			occi=new OracleConnectionCacheImpl(opds);
			occi.setMaxLimit(15);
			occi.setCacheScheme (OracleConnectionCacheImpl.DYNAMIC_SCHEME);
 			pc=opds.getPooledConnection();
 		}catch(SQLException e)
		{
			e.printStackTrace();
		}
	}
	
	static
	{
		System.out.println("starting astatic block");
	 	try
		{
			InitialContext ic = new InitialContext();
			Object objref = ic.lookup("ParsecConfigBean");
	 		home = (ParsecConfigHome)PortableRemoteObject.narrow(objref,ParsecConfigHome.class);
	 		System.out.println("came thru starting block");
	 		
	 	} catch(Exception e)
		{
			e.printStackTrace();
		}
		loadConfig();
	}
	static Properties settings = new Properties();

	public static Connection getDBConnection() 
	{  
		try
		{
			return occi.getConnection();
		}catch(SQLException e)
		{
			e.printStackTrace();
		}
		return null;
	}

	public static boolean checkValidTime()
	{
		java.util.Date now=new java.util.Date();
		if (now.getHours()*60+now.getMinutes()<stopHour*60+stopMinute&&
			now.getHours()*60+now.getMinutes()>startHour*60+startMinute)
		{
			return true;
		}
		return false;
	}
	 
	public static int getSwingMargin()
	{
		return swingMargin;
	}
	
	
	public static String getAdminPassword()
	{
		return adminPasswd;
	}
	
	
	public static int getLookbackTime()
	{
		return lookbackTime;
	}
	
	
	public static int  getDealAffectorHour()
	{
		return dealAffectorHour;
	}
	
	
	public static int getDealAffectorMinute()
	{
		return dealAffectorMinute;
	}
	
	
	public static int getRefreshRate()
	{
		return refreshRate;
	}
	
	
	public static int getStartHour()
	{
		return startHour;
	}
	
	
	public static int getStartMinute()
	{
		return startMinute;
	}
	
	
	public static int getStopHour()
	{
		return stopHour;
	}
	
	
	public static int getStopMinute()
	{
		return stopMinute;
	}
	
	//sets
	public static void setSwingMargin(int swing)
	{
		swingMargin=swing;
		store("Swing_Limit",""+swing);
	}
	
	
	public static void setAdminPassword(String swing)
	{
		adminPasswd=swing;
		store("Admin_Passwd",""+swing);
	}
	
	
	public static void setLookbackTime(int swing)
	{
		lookbackTime=swing;
		store("Lookback_Time",""+swing);
	}
	
	
	public static void  setDealAffectorHour(int swing)
	{
		dealAffectorHour=swing;
		store("DealAffector_Hour",""+swing);
	}
	
	
	public static void setDealAffectorMinute(int swing)
	{
		dealAffectorMinute=swing;
		store("DealAffector_Minute",""+swing);
	}
	
	
	public static void setRefreshRate(int swing)
	{
		refreshRate=swing;
		store("Refresh_Rate",""+swing);
	}
	
	
	public static void setStartHour(int swing)
	{
		startHour=swing;
    	store("DealBreaker_Start_Hour",""+swing);
	}
	
	
	public static void setStartMinute(int swing)
	{
		startMinute=swing;
		store("DealBreaker_Start_Minute",""+swing);
	}
	
	
	public static void setStopHour(int swing)
	{
		stopHour=swing;
		store("DealBreaker_Stop_Hour",""+swing);
	}
	
	
	public static void setStopMinute(int swing)
	{
		stopMinute=swing;
		store("DealBreaker_Stop_Minute",""+swing);
	}
	
	
	private static void store(String key,String value)
	{
		try
		{
     		ParsecConfig c=home.findByPrimaryKey(key);
			c.setPropValue(value);
		}catch(FinderException e)
		{
			System.out.println("FATAL ERROR"+e);
		}
		catch(RemoteException e)
		{
			System.out.println("FATAL ERROR"+e);
		}
	}
	
	private static void loadConfig()
	{
		try
		{
			ParsecConfig c = home.findByPrimaryKey("Refresh_Rate");
			refreshRate=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("Lookback_Time");
		    lookbackTime=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("Admin_Passwd");
			adminPasswd=c.getPropValue();
	 		c=home.findByPrimaryKey("DealAffector_Hour");
			dealAffectorHour=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("DealAffector_Minute");
			dealAffectorMinute=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("DealBreaker_Start_Hour");
			startHour=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("DealBreaker_Start_Minute");
			startMinute=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("DealBreaker_Stop_Hour");
			stopHour=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("DealBreaker_Stop_Minute");
			stopMinute=Integer.parseInt(c.getPropValue());
	 		c=home.findByPrimaryKey("Swing_Limit");
	       	swingMargin=Integer.parseInt(c.getPropValue());
		}catch(FinderException e)
		{
			System.out.println("FATAL ERROR"+e);
		}
		catch(RemoteException e)
		{
			System.out.println("FATAL ERROR"+e);
		}
	
	}	
	

}
