// Program to solve the second question of the Fourth Lab assignment
import java.lang.*;
import java.io.*;
import java.sql.*;
import java.util.*;

public class Soln2
{
    // Functions to do dreary HTML printing
    public static void HTML_start(){
	System.out.println("<HTML><HEAD></HEAD><BODY>");
    }

    public static void HTML_end(){
	System.out.println("</BODY></HTML>");
    }

    public static void Table_start(){
	System.out.println("<TABLE BORDER=2>");
    }

    public static void Table_end(){
	System.out.println("</TABLE>");
    }

    public static void main(String argv[]) throws IOException
    {
	// These three variables remember what the user told us
	boolean p_got,s_got,c_got;

	p_got=s_got=c_got=false;
	double p_id=0;
	String c_city="",s_city="";
	String extra_query=new String("");
	String input_arg="";

	int count;
	int next_token;

	// Prepare the string that we got from the command line
	for (count = 0; count < argv.length; count++){
	    
	    input_arg = input_arg.concat(argv[count]);
	    input_arg = input_arg.concat(" ");
	}

	// System.out.println("Staring up...");

	// Take the input String and parse it
	StreamTokenizer ST=new StreamTokenizer(new StringReader(input_arg));
	ST.whitespaceChars('=','=');
	while ((next_token = ST.nextToken()) != ST.TT_EOF){
	    if(ST.TT_NUMBER == next_token){
		// Erroneous value
		// System.out.println("Error: " + ST.nval);
	    }
	    else if (ST.sval.equals("p")){
		ST.nextToken();
		// System.out.println("Found a Product ID: " + ST.nval);
		p_id = ST.nval;
		p_got = true;
	    }
	    else if (ST.sval.equals("s")){
		ST.nextToken();
		// System.out.println("Found a Salesman City: " + ST.sval);
		s_city = ST.sval;
		s_got = true;
	    }
	    else if (ST.sval.equals("c") ){
		ST.nextToken();
		// System.out.println("Found a Client City: " + ST.sval);
		c_city = ST.sval;
		c_got = true;
	    }
	} /* while more tokens */
	
	// Compose the extra query
	extra_query = "";
	if (c_got || s_got || p_got){
	    if (c_got){
		extra_query = extra_query.concat(" and client.city=\'" + c_city + "\'");
	    }
	    if (p_got){
		extra_query = extra_query.concat(" and product.product_id=" + p_id);
	    }
	    if (s_got){
		extra_query = extra_query.concat(" and salesman.city=\'" + s_city + "\'");
	    }
	    // Debugging only
	    //	    System.out.println(extra_query);
	}

	// Compose, and submit SQL queries	
	try
	    {
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		Connection myCom =
		    DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","aggarwal","FooledYou");
		Statement stmt = myCom.createStatement();
		
		HTML_start();
		
		Table_start();
		
		System.out.println("<TR><TD>Product Name <TD>Sale</TR>");
		// First Query: Total sales grouped by Product Id
		ResultSet rset = stmt.executeQuery("Select distinct product.description,product.product_id,sum(product.cost*order_details.quantity) from client,salesman,product,order_details,sales_order where order_details.product_id=product.product_id and sales_order.order_id=order_details.order_id" + extra_query + " group by product.description,product.product_id");
		while (rset.next()) {
		    System.out.println("<TR><TD>" + rset.getString(1) + "<TD> " + rset.getInt(3) +"</TR>");		
		}
		Table_end();
		
		// Second Query: Total sales grouped by Client City
		Table_start();
		System.out.println("<TR><TD>Client City<TD>Sale</TR>");
		rset = stmt.executeQuery("Select distinct client.city,sum(product.cost*order_details.quantity) from salesman,product,client,order_details,sales_order where client.client_id=sales_order.client_id and sales_order.order_id=order_details.order_id and product.product_id=order_details.product_id" + extra_query + " group by client.city");
		while (rset.next()) {
		    System.out.println("<TR><TD>" + rset.getString(1) + "<TD>  " + rset.getInt(2)+"</TR>");		
		}
		
		Table_end();
		
		// Third Query: Total sales grouped by Salesman City
		Table_start();
		System.out.println("<TR><TD>Salesman city<TD>Sale</TR>");
		rset = stmt.executeQuery("Select distinct salesman.city,sum(product.cost*order_details.quantity) from client,salesman,product,order_details,sales_order where order_details.product_id=product.product_id and sales_order.order_id=order_details.order_id and salesman.salesman_id=sales_order.salesman_id" + extra_query + " group by salesman.city");
		while (rset.next()) {
		    System.out.println("<TR><TD>" + rset.getString(1) + " <TD> " + rset.getInt(2)+"</TR>");		
		}
		    
		Table_end();
		HTML_end();
	    }
	    
	catch (SQLException sqle)
	    { 
		System.out.println("SQLException : " + sqle);
	    }
    }
}



