/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.Context;
import com.sun.web.core.ForwardedRequest;
import com.sun.web.core.HttpServletRequestFacade;
import com.sun.web.core.HttpServletResponseFacade;
import com.sun.web.core.IncludedResponse;
import com.sun.web.core.LookupResult;
import com.sun.web.core.Request;
import com.sun.web.core.Response;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class RequestDispatcherImpl
implements RequestDispatcher {
    static final String ATRB_REQUEST_URI = "javax.servlet.include.request_uri";
    static final String ATRB_SERVLET_PATH = "javax.servlet.include.servlet_path";
    static final String ATRB_PATH_INFO = "javax.servlet.include.path_info";
    static final String ATRB_QUERY_STRING = "javax.servlet.include.query_string";
    private Context context;
    private String urlPath;
    private String queryString;

    RequestDispatcherImpl(Context context, String string) {
        this.context = context;
        int n = string.indexOf("?");
        if (n > -1) {
            try {
                this.queryString = string.substring(n + 1, string.length());
            }
            catch (Exception exception) {}
            string = string.substring(0, n);
        }
        this.urlPath = string;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequestFacade httpServletRequestFacade = (HttpServletRequestFacade)servletRequest;
        HttpServletResponseFacade httpServletResponseFacade = (HttpServletResponseFacade)servletResponse;
        Request request = httpServletRequestFacade.getRealRequest();
        Response response = httpServletResponseFacade.getRealResponse();
        if (response.isStarted()) {
            throw new IllegalStateException("Can't forward! OutputStream or Writer has already been obtained.");
        }
        LookupResult lookupResult = this.context.getContainer().lookupServlet(this.urlPath);
        this.urlPath = String.valueOf(this.context.getPath()) + this.urlPath;
        ForwardedRequest forwardedRequest = new ForwardedRequest(request, this.urlPath);
        forwardedRequest.setServletPath(lookupResult.getServletPath());
        forwardedRequest.setPathInfo(lookupResult.getPathInfo());
        lookupResult.getWrapper().handleRequest(forwardedRequest, httpServletResponseFacade);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = (String)httpServletRequest.getAttribute(ATRB_REQUEST_URI);
        String string2 = (String)httpServletRequest.getAttribute(ATRB_SERVLET_PATH);
        String string3 = (String)httpServletRequest.getAttribute(ATRB_PATH_INFO);
        String string4 = (String)httpServletRequest.getAttribute(ATRB_QUERY_STRING);
        HttpServletRequestFacade httpServletRequestFacade = (HttpServletRequestFacade)servletRequest;
        HttpServletResponseFacade httpServletResponseFacade = (HttpServletResponseFacade)servletResponse;
        httpServletRequestFacade.getRealRequest();
        Response response = httpServletResponseFacade.getRealResponse();
        LookupResult lookupResult = this.context.getContainer().lookupServlet(this.urlPath);
        httpServletRequest.setAttribute(ATRB_REQUEST_URI, (Object)(String.valueOf(this.context.getPath()) + this.urlPath));
        if (lookupResult.getServletPath() != null) {
            httpServletRequest.setAttribute(ATRB_SERVLET_PATH, (Object)lookupResult.getServletPath());
        }
        if (lookupResult.getPathInfo() != null) {
            httpServletRequest.setAttribute(ATRB_PATH_INFO, (Object)lookupResult.getPathInfo());
        }
        if (this.queryString != null) {
            httpServletRequest.setAttribute(ATRB_QUERY_STRING, (Object)this.queryString);
        }
        IncludedResponse includedResponse = new IncludedResponse(response);
        lookupResult.getWrapper().handleRequest(httpServletRequestFacade, includedResponse);
        if (string != null) {
            httpServletRequest.setAttribute(ATRB_REQUEST_URI, (Object)string);
        } else {
            httpServletRequestFacade.removeAttribute(ATRB_REQUEST_URI);
        }
        if (string2 != null) {
            httpServletRequest.setAttribute(ATRB_SERVLET_PATH, (Object)string2);
        } else {
            httpServletRequestFacade.removeAttribute(ATRB_SERVLET_PATH);
        }
        if (string3 != null) {
            httpServletRequest.setAttribute(ATRB_PATH_INFO, (Object)string3);
        } else {
            httpServletRequestFacade.removeAttribute(ATRB_PATH_INFO);
        }
        if (string4 != null) {
            httpServletRequest.setAttribute(ATRB_QUERY_STRING, (Object)string4);
            return;
        }
        httpServletRequestFacade.removeAttribute(ATRB_QUERY_STRING);
    }
}

