/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.Context;
import com.sun.web.core.RequestDispatcherImpl;
import com.sun.web.core.Server;
import com.sun.web.util.StringManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ServletContextFacade
implements ServletContext {
    private StringManager sm = StringManager.getManager("com.sun.web.core");
    private Server server;
    private Context context;

    ServletContextFacade(Server server, Context context) {
        this.server = server;
        this.context = context;
    }

    Context getRealContext() {
        return this.context;
    }

    public Object getAttribute(String string) {
        this.context.getAttribute(string);
        return this.context.getAttribute(string);
    }

    public Enumeration getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public void setAttribute(String string, Object object) {
        this.context.setAttribute(string, object);
    }

    public void removeAttribute(String string) {
        this.context.removeAttribute(string);
    }

    public ServletContext getContext(String string) {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("Servlet context paths must begin with \"/\"");
        }
        return this.server.getContextByPath(string).getFacade();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public String getMimeType(String string) {
        return this.context.getMimeMap().getContentTypeFor(string);
    }

    public String getRealPath(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL != null) {
                if (uRL.getProtocol().equals("file")) {
                    return uRL.getFile();
                }
                return null;
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getResource(String string) throws MalformedURLException {
        URL uRL = this.context.getDocumentBase();
        if (string.equals("")) {
            return uRL;
        }
        if (!string.startsWith("/")) {
            String string2 = this.sm.getString("scfacade.getresource.iae", string);
            throw new IllegalArgumentException(string2);
        }
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(uRL.getFile()) + string.substring(1, string.length()));
        return uRL2;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            return uRLConnection.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("Request dispatcher paths must begin with \"/\"");
        }
        return new RequestDispatcherImpl(this.context, string);
    }

    public String getServerInfo() {
        return this.server.getServerInfo();
    }

    public void log(String string) {
        this.context.getLogModule().log(string);
    }

    public void log(String string, Throwable throwable) {
        this.context.getLogModule().log(string, throwable);
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public Servlet getServlet(String string) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        Vector vector = new Vector();
        return vector.elements();
    }

    public Enumeration getServletNames() {
        Vector vector = new Vector();
        return vector.elements();
    }
}

