/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.core.Response;
import com.sun.web.server.ServletOutputStreamImpl;
import com.sun.web.util.CookieUtils;
import com.sun.web.util.HttpDate;
import com.sun.web.util.MimeHeaders;
import com.sun.web.util.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;

public class ServerResponse
extends Response {
    private StringManager sm = StringManager.getManager("com.sun.web.server");
    private Socket socket;
    private MimeHeaders headers = new MimeHeaders();
    private ServletOutputStreamImpl out;
    private PrintWriter writer;
    private boolean usingStream = false;
    private boolean usingWriter = false;
    private boolean started = false;
    private boolean committed = false;
    private boolean omitHeaders = false;

    public boolean isStarted() {
        return this.started;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setOmitHeaders(boolean bl) {
        this.omitHeaders = bl;
    }

    void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        OutputStream outputStream = socket.getOutputStream();
        this.out = new ServletOutputStreamImpl(this, outputStream);
    }

    void writeHeaders(OutputStream outputStream) throws IOException {
        Enumeration enumeration;
        if (this.omitHeaders) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.sm.getString("sc." + this.status);
        stringBuffer.append("HTTP/1.0 " + this.status);
        if (string != null) {
            stringBuffer.append(" " + string);
        }
        stringBuffer.append("\r\n");
        HttpDate httpDate = new HttpDate(System.currentTimeMillis());
        stringBuffer.append("Date: " + httpDate + "\r\n");
        stringBuffer.append("Server: Tomcat/2.1\r\n");
        stringBuffer.append("Content-Type: " + this.contentType + "\r\n");
        if (this.contentLength != -1) {
            stringBuffer.append("Content-Length: " + this.contentLength + "\r\n");
        }
        Enumeration enumeration2 = this.cookies.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = (Cookie)enumeration2.nextElement();
            stringBuffer.append(String.valueOf(CookieUtils.getCookieHeader((Cookie)enumeration)) + "\r\n");
        }
        enumeration = this.headers.names();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.headers.getHeader(string2);
            stringBuffer.append(String.valueOf(string2) + ": " + string3 + "\r\n");
        }
        stringBuffer.append("\r\n");
        outputStream.write(stringBuffer.toString().getBytes());
    }

    public void reset() {
        super.reset();
        this.headers.clear();
        this.usingWriter = false;
        this.out = null;
        this.started = false;
        this.committed = false;
    }

    void finish() throws IOException {
        try {
            if (this.usingWriter) {
                this.writer.flush();
            }
            this.out.flush();
            return;
        }
        catch (SocketException socketException) {
            return;
        }
    }

    public boolean containsHeader(String string) {
        return this.headers.containsHeader(string);
    }

    public ServletOutputStream getOutputStream() {
        this.started = true;
        if (this.usingWriter) {
            String string = "Writer is already being used for this request";
            throw new IllegalStateException(string);
        }
        this.usingStream = true;
        return this.out;
    }

    public PrintWriter getWriter() {
        this.started = true;
        if (this.usingStream) {
            String string = "OutputStream is already being used for this request";
            throw new IllegalStateException(string);
        }
        this.usingWriter = true;
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)((Object)this.out));
        }
        return this.writer;
    }

    public void setDateHeader(String string, long l) {
        this.headers.putDateHeader(string, l);
    }

    public void setHeader(String string, String string2) {
        this.headers.putHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.headers.putIntHeader(string, n);
    }
}

