/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.server.ServerRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

class ServletInputStreamImpl
extends ServletInputStream {
    private ServerRequest request;
    private InputStream in;
    private int bytesRead;
    private int limit = -1;

    ServletInputStreamImpl(ServerRequest serverRequest, InputStream inputStream) {
        this.request = serverRequest;
        this.in = inputStream;
    }

    void setLimit(int n) {
        this.bytesRead = 0;
        this.limit = n;
    }

    public int read() throws IOException {
        if (this.limit != -1) {
            if (this.bytesRead < this.limit) {
                ++this.bytesRead;
                return this.in.read();
            }
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.limit != -1) {
            int n3;
            if (this.bytesRead == this.limit) {
                return -1;
            }
            if (this.bytesRead + n2 > this.limit) {
                n2 = this.limit - this.bytesRead;
            }
            if ((n3 = this.in.read(byArray, n, n2)) > 0) {
                this.bytesRead += n3;
            }
            return n3;
        }
        return this.in.read(byArray, n, n2);
    }

    public String readLine() throws IOException {
        byte[] byArray = new byte[1024];
        int n = this.readLine(byArray, 0, byArray.length);
        if (n >= 0) {
            return new String(byArray, 0, n);
        }
        return "";
    }
}

