
create table users (user_id varchar(8) not null,  name varchar(50) not null, passwd varchar(8) not null, email varchar(100) not null, primary key (user_id));
create table room (room_id varchar(20) not null, type varchar(50) not null, capacity integer not null, facilities varchar(100), location varchar(100), primary key(room_id));


create table mailing_alias (group_id varchar(20) not null, post_id varchar(100) not null, email_id varchar(100) not null,primary key (group_id));

create table talk (talk_id integer not null, topic varchar(100), speaker varchar(50),  date_for_talk date not null, start_time varchar(05) not null, end_time varchar(05) not null, start_slot integer not null, end_slot integer not null, primary key (talk_id));
create table talk_booking (talk_id integer not null, room_id varchar(20) not null, user_id varchar(8) not null, booking_date date not null, primary key(talk_id), foreign key(room_id) references room on delete cascade, foreign key(talk_id) references talk on delete cascade, foreign key(user_id) references users on delete cascade);
create table talk_group(talk_id integer not null, group_id varchar(20) not null, primary key (talk_id,group_id), foreign key (talk_id) references talk on delete cascade, foreign key (group_id) references mailing_alias on delete cascade);



create table IITBSlots (slot_no integer not null, slot_id char(1) not null, day char(03) not null, start_time varchar(05) not null , end_time varchar(05) not null, primary key(slot_no,slot_id));
create table course (course_no varchar(05) not null, course_name varchar(100) not null , user_id varchar(08) not null, primary key(course_no),foreign key(user_id) references users on delete cascade);
create table course_group(course_no varchar(05) not null, group_id varchar(20) not null, primary key (course_no,group_id), foreign key (course_no) references course on delete cascade, foreign key (group_id) references mailing_alias on delete cascade);
create table lecture (course_no varchar(05) not null, lecture_no integer not null, start_time varchar(05) not null, end_time varchar(05) not null, start_date date not null, end_date date not null, period integer not null , primary key (course_no,lecture_no),foreign key(course_no) references course on delete cascade);
create table allotted (course_no varchar(05) not null, lecture_no integer not null, slot_no integer not null, slot_id char(1) not null, primary key(course_no, lecture_no), foreign key(course_no,lecture_no) references lecture on delete cascade, foreign key(slot_no, slot_id) references IITBSlots on delete cascade);
create table extra_lecture (course_no varchar(05) not null, extralecture_no integer not null, room_id varchar(20) not null,date_for_extralecture date not null, start_time varchar(05) not null, end_time varchar(05) not null, primary key (course_no,extralecture_no),foreign key(course_no) references course on delete cascade,foreign key(room_id) references room on delete cascade);
create table lecture_booking (course_no varchar(05) not null, lecture_no integer not null, room_id varchar(20) not null, primary key(course_no, lecture_no), foreign key(course_no, lecture_no) references lecture on delete cascade, foreign key(room_id) references room on delete cascade);
create table delete_lecture(course_no varchar(05) not null,lecture_no integer not null, cancel_date date not null , primary key(course_no,lecture_no,cancel_date),foreign key(course_no,lecture_no) references lecture on delete cascade);


create view lecture_info as (select users.user_id,users.name,lecture.course_no,lecture.lecture_no,lecture.start_time,lecture.end_time,start_date,end_date,period,day,room_id,group_id,iitbslots.slot_no,iitbslots.slot_id
				        from users,course,lecture, allotted,iitbslots,lecture_booking,course_group  
					   where users.user_id=course.user_id and
					   course.course_no=lecture.course_no and
                            lecture.course_no=allotted.course_no and lecture.lecture_no=allotted.lecture_no
					   and lecture_booking.course_no=lecture.course_no and lecture_booking.lecture_no=lecture.lecture_no 
                            and allotted.slot_no=iitbslots.slot_no and allotted.slot_id=iitbslots.slot_id
					   and course_group.course_no=course.course_no);
create view talk_info as (select talk.talk_id,user_id,topic,speaker,room_id,date_for_talk,start_time,end_time,group_id
					 from talk,talk_booking,talk_group
					 where talk.talk_id=talk_booking.talk_id and talk_group.talk_id=talk.talk_id);		 
create view extra_lecture_info as (select course.course_no,extralecture_no,room_id,users.name,users.user_id,group_id,date_for_extralecture,start_time,end_time
					 from extra_lecture,course,course_group,users
					 where course.course_no=extra_lecture.course_no and course.course_no=course_group.course_no
					 and users.user_id=course.user_id);		 
					 				 
