/** This file contains the common functions */

package Interface;


import java.io.*;
import javax.servlet.http.*;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;
	


public class Common {

	public static final int COLUMNS=8;
	
	
	/** This function takes the vector output of query and converts it into a string matrix .
	 * In turn it feeds it to the main Make Table function */

	public static String[][] Vector2String(Vector table){
		String res[][]= new String[table.size()][((Vector)table.elementAt(0)).size()];
		for(int i=0;i<res.length;i++)
			for(int j=0;j<res[0].length;j++)
				res[i][j]=(String)((Vector)table.elementAt(i)).elementAt(j);
		return res;
	}
	
	
	public static String[][] Vector2String(Vector table1,Vector table2){
		String res[][]= new String[table1.size() + table2.size() - 1][((Vector)table1.elementAt(0)).size()];
		for(int i=0;i<res.length+1;i++)
			for(int j=0;j<res[0].length;j++)
				if(i<table1.size())
					res[i][j]=(String)((Vector)table1.elementAt(i)).elementAt(j);
				else if(!((i-table1.size())==0))
					res[i-1][j]=(String)((Vector)table2.elementAt(i-table1.size())).elementAt(j);
		return res;
	}

	/** This function Initializes the table */
	
	public static String[][][] initTable(Date begindate,Date enddate){

		String table[][][] = new String[2+Common.getDateDiff(begindate,enddate)][COLUMNS][2];
		// the difference + 1 for headings + 1 (Sun - Mon =1, we need two rows)
		
		//This is hard coded for the time being can be extended	
		table[0][0][0]="<TD>DAY\\TIME";
		table[0][1][0]="<TD>8:30-9:30";
		table[0][2][0]="<TD>9:30-10:30";
		table[0][3][0]="<TD>10:30-11:30";
		table[0][4][0]="<TD>11:30-12:30";
		table[0][5][0]="<TD>2:00-3:00";
		table[0][6][0]="<TD>3:00-4:00";
		table[0][7][0]="<TD>4:00-5:00";
		
		Calendar cal= Calendar.getInstance();
		cal.setTime(begindate);
		for(int i=1;i<(2+Common.getDateDiff(begindate,enddate));i++){
			table[i][0][0]="<TD><TABLE BGCOLOR=beige><TR><TD>"+Common.noToDay(cal.get(Calendar.DAY_OF_WEEK)-1)+ "</TD></TR>"+ 
						"<TR><TD>" + cal.get(Calendar.DAY_OF_MONTH) + "-" + (cal.get(Calendar.MONTH)+1) + "-" + cal.get(Calendar.YEAR)+"</TD></TR></TABLE>";
			cal.add(Calendar.DAY_OF_YEAR,1);
			table[i][0][1]="1"; // colspan
			for(int j=1; j < COLUMNS ; j++){
				table[i][j][0]="<TD>-";
				table[i][j][1]="1";
			}
		}
		return table;
	}
	
	
	public static String toHTML(Vector vec){
		String table[][]=new String[vec.size()][((String[])vec.elementAt(0)).length];
		vec.copyInto(table);
		String htm="<TABLE BORDER>";
		for(int i = 0 ; i < table.length ;i++){
			htm+="<TR>";
			for (int j=0;j<table[0].length ; j++)
				htm+="<TD>"+table[i][j]+"</TD>";
			htm+="</TR>";
		}
      return htm+"</TABLE>";
	}

	
	public static String toHTML(String[][][] table){
		String html = "<TABLE BORDER WIDTH=\"100%\">";
		for(int i=0;i<table.length;i++){
			if(i==0)
				html+="<TR BGCOLOR=beige>";
			else
				html+="<TR ALIGN=CENTER>";
			for(int j=0; j < table[0].length; j++)
				if(!(table[i][j][0].equals("")))
					html+=table[i][j][0]+"</TD>";
			html+="</TR>";
		}
		html+="</TABLE>";
		return html;
	}
				
	
	
	/** function for getting the number of days represented by the difference
	  of two dates  */
	public static int getDateDiff(Date date2,Date date1)
	{
		long msec=24*3600*1000;
		Calendar cal1=Calendar.getInstance();
		Calendar cal2=Calendar.getInstance();
		cal1.setTime(date1);
		cal2.setTime(date2);
		cal1.clear();
		cal2.clear();
		date1=cal1.getTime();
		date2=cal2.getTime();
		return((int)((date1.getTime()-date2.getTime())/msec));
	}  
	
	/**function to get a java.util.Date object from a date encoded in
	  a string in the format dd-mm-yyyy */
	public static java.util.Date stringToDate(String str)
	{
		int day;
		int month;
		int year;
		StringTokenizer strtok=new StringTokenizer(str,"-");
		day=Integer.parseInt(strtok.nextToken());
		month=Integer.parseInt(strtok.nextToken())-1;
		year=Integer.parseInt(strtok.nextToken())-1900;
		return(new java.util.Date(year,month,day));
	}      
	
	public static int getSlot(String time,char c)
	{
		StringTokenizer strtok = new StringTokenizer(time,":");
		Integer hrs = new Integer(strtok.nextToken());
		Integer min = new Integer(strtok.nextToken());
		double slot = (hrs.intValue() * 60 + min.intValue())/30.0 ;
		if(c=='f') 
			return((int)Math.floor(slot));
		else
			return((int)Math.ceil(slot));
	}	

	public static int getColSpan(String time1,String time2){
		int s1 = getSlot(time1,'f');
		int s2 = getSlot(time2,'c');
		return (int)(Math.ceil((s2 -s1)/2.0));
	}


	public static int getColumn(String time){
		int slot = getSlot(time,'f');
		int column=0;
		if(slot<getSlot("8:30",'f'))
			 column=0;			 
		else if (slot < getSlot("9:30",'f'))
			column+=1;
		else if (slot < getSlot("10:30",'f'))
			column+=2;
		else if (slot < getSlot("11:30",'f'))
			column+=3;
		else if (slot < getSlot("12:30",'f'))
			column+=4;
		else if (slot < getSlot("15:00",'f'))
			column+=5;
		else if (slot < getSlot("16:00",'f'))
			column+=6;
		else if (slot < getSlot("17:00",'f'))
			column+=7;
		else 
			column=0;
		return column;
	}
		
	/**simple function just to return the number corresponding to each time interval*/
	public static int getSlot(String time) {
		int column=0;
		if(time.equals("08:30"))
			column=1;
		if(time.equals("09:30"))
			column=2;
		if(time.equals("10:30"))
			column=3;
		if(time.equals("11:30"))
			column=4;
		if(time.equals("02:00"))
			column=5;
		if(time.equals("03:00"))
			column=6;
		if(time.equals("04:00"))
			column=7;
		return(column);
	}

	/** function for getting the String day corresponding to a number*/
	public static String noToDay(int no)
	{
		String day="";
		switch(no)
		{
			case 0: day="Sun"; 
				   break;
			case 1: day="Mon"; 
				   break;
			case 2: day="Tue"; 
				   break;
			case 3: day="Wed"; 
				   break;
			case 4: day="Thu"; 
				   break;
			case 5: day="Fri";
				   break;
			case 6: day="Sat"; 
				   break;
			default : day="Sun";
		} 
		return(day);

	}  

	/** function for getting the number corresponding to a day (String)*/
	public static int dayToNo(String day)
	{
		int no=-1;
		if(day.equals("Sun"))
			no=0; 
		if(day.equals("Mon")) 
			no=1; 
		if(day.equals("Tue")) 
			no=2; 
		if(day.equals("Wed")) 
			no=3; 
		if(day.equals("Thu"))
			no=4; 
		if(day.equals("Fri")) 
			no=5; 
		if(day.equals("Sat")) 
			no=6; 
		return(no);
	}  
}
