/** This file defines the interface as seen by a group . */
package Interface;

import java.io.*;
import javax.servlet.http.*;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;

public class GroupInterface {

	private static boolean  debug=true;

	public static final int COLUMNS=8;


	/** This function takes the vector output of query and converts it into a string matrix .
	 * In turn it feeds it to the main Make Table function */

	public static String MakeTable(Vector table,Date begindate,Date enddate,HttpServletResponse response){
		return (MakeTable(Common.Vector2String(table),begindate,enddate,response));
	}


	public static String MakeTable(Vector lectureTable,Vector extraLectureTable,Vector talkTable,Date begindate,Date enddate,HttpServletResponse response){
			return (MakeTable(Common.Vector2String(lectureTable,extraLectureTable),Common.Vector2String(talkTable),begindate,enddate,response));
	}
	
	public static String MakeTable(Vector lectureTable,Vector talkTable,Date begindate,Date enddate,HttpServletResponse response){
			return (MakeTable(Common.Vector2String(lectureTable),Common.Vector2String(talkTable),begindate,enddate,response));
	}
	/** This funciton makes the actual table tuples */ 
	public static String MakeTable(String[][] scheme,Date begindate,Date enddate,HttpServletResponse response) {
	
		String timetable[][][] = Common.initTable(begindate,enddate);
          int colspan=0;
		int counter=1;
		int nrows = scheme.length;
		int ncols = scheme[0].length;

		// These are the imp fields for lecture
		int lecturedate=4;
		int lecturecourse=2;
		int lecturetime=5;
		int lectureendtime=6;
		int lectureroom=7;
		int lecturespeaker=3;

		// This defines the initializations and the two fields are
		// first : the actual HTML part
		// Second : The column span

		for(int i=1;i<nrows;i++)
		{
			/*this takes each tuple of the schema array and makes the entry 
			 * corresponding to it in the timetable array ,the assignment is as
			 * timetable[day_in_this_tuple][slot_found_by_starttime]=course_no_of_this_tuple*/
			
			/*if (timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getSlot(scheme[i][lecturetime])][0].equals("<TD>-"))
				timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getSlot(scheme[i][lecturetime])][0]="<TD>" + 
					"<TABLE><TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A></TD></TR>" +
								"<TR><TD>"+scheme[i][lecturespeaker]+"</TD></TR>" +
                                        "<TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A></TD></TR>" +
					"</TABLE>";
			else
				timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getSlot(scheme[i][lecturetime])][0]="" + 
					timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getSlot(scheme[i][lecturetime])][0]    + 
					"<TABLE ><TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A></TD></TR>" +
								"<TR><TD>"+scheme[i][lecturespeaker]+"</TD></TR>" +
                                        "<TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A></TD></TR>" +
					"</TABLE>";*/
			if (Common.getColumn(scheme[i][lecturetime])>0)
				if (timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0].equals("<TD>-")){
					colspan=Common.getColSpan(scheme[i][lecturetime],scheme[i][lectureendtime]);
					timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0]="<TD COLSPAN=" + colspan + ">" + 
						//"<TABLE bgcolor=beige><TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A></TD></TR>" +
						//		"<TR><TD>"+scheme[i][lecturespeaker]+"</TD></TR>" +
                              //         "<TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A></TD></TR>" +
						//"</TABLE>";
						"<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A>" +
						"/"+scheme[i][lecturespeaker] +
                              "/<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A>";
					while(counter<colspan)
						timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])+(counter++)][0]="";
					counter=1;
					// Make the covered fields empty
				}
				else if (!(timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0].equals("")))
					timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getSlot(scheme[i][lecturetime])][0]="" + 
						timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getSlot(scheme[i][lecturetime])][0]    + 
						//	"<TABLE bgcolor=beige><TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A></TD></TR>" +
						//				"<TR><TD>"+scheme[i][lecturespeaker]+"</TD></TR>" +
						//                    "<TR><TD><A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A></TD></TR>" +
						//	"</TABLE>";
						"<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A>" +
						"/"+scheme[i][lecturespeaker] +
						"/<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A>";
		}
		return(Common.toHTML(timetable));
	}
	
	
	/** This funciton makes the actual table tuples */ 
	public static String MakeTable(String[][] scheme,String[][] scheme1,Date begindate,Date enddate,HttpServletResponse response) {
	
		String timetable[][][] = Common.initTable(begindate,enddate);
          int colspan=0;
		int counter=1;
		int nlrows = scheme.length;
		int ntrows = scheme1.length;

		boolean lectureflag=false;   // flag to check whether anything inserted 
		Vector lectureleftout = new Vector();
		boolean talkflag=false;
		Vector talkleftout    = new Vector();

		// These are the imp fields for lecture
		int lecturedate=4;
		int lecturecourse=2;
		int lecturetime=5;
		int lectureendtime=6;
		int lectureroom=7;
		int lecturespeaker=3;
		
		int talkdate=4;
		int talkcourse=2;
		int talktime=5;
		int talkendtime=6;
		int talkroom=7;
		int talkspeaker=3;

		// This defines the initializations and the two fields are
		// first : the actual HTML part
		// Second : The column span

		lectureleftout.addElement(scheme[0]);
		for(int i=1;i<nlrows;i++)
		{
			
			if (Common.getColumn(scheme[i][lecturetime])>0){
				if (timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0].equals("<TD>-")){
					colspan=Common.getColSpan(scheme[i][lecturetime],scheme[i][lectureendtime]);
					timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0]="<TD COLSPAN=" + colspan + ">" + 
						"[<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A>" +
						"/"+scheme[i][lecturespeaker] +
                              "/<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A>]";
					while(counter<colspan)
						timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])+(counter++)][0]="";
					counter=1;
					// Make the covered fields empty
				}
				else if (!(timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0].equals("")))
					timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0]="" + 
						timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme[i][lecturedate])) + 1][Common.getColumn(scheme[i][lecturetime])][0]    + "[" +
						"<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=course&query=where(course_no='" +scheme[i][lecturecourse]+"')")+"\">"+scheme[i][lecturecourse]+"</A>" +
						"/"+scheme[i][lecturespeaker] +
						"/<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme[i][lectureroom]+"')")+"\">"+scheme[i][lectureroom]+"</A>]";
				else{
					lectureleftout.addElement(scheme[i]);
					lectureflag=true;
				}
			}else{
				lectureleftout.addElement(scheme[i]);
				lectureflag=true;
			}
		}


		talkleftout.addElement(scheme1[0]);
		for(int i=1;i<ntrows;i++)
		{

			if (Common.getColumn(scheme1[i][talktime])>0){
				if (timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme1[i][talkdate])) + 1][Common.getColumn(scheme1[i][talktime])][0].equals("<TD>-")){
					colspan=Common.getColSpan(scheme1[i][talktime],scheme1[i][talkendtime]);
					timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme1[i][talkdate])) + 1][Common.getColumn(scheme1[i][talktime])][0]="<TD COLSPAN=" + colspan + ">[" + 
						scheme1[i][talkcourse]+
						"/"+scheme1[i][talkspeaker] +
						"/<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme1[i][talkroom]+"')")+"\">"+scheme1[i][talkroom]+"</A>]";
			
					
					
					while(counter<colspan)
						timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme1[i][talkdate])) + 1][Common.getColumn(scheme1[i][talktime])+(counter++)][0]="";
					counter=1;
					// Make the covered fields empty
				}
				else if (!(timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme1[i][talkdate])) + 1][Common.getColumn(scheme1[i][talktime])][0].equals("")))
					timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme1[i][talkdate])) + 1][Common.getColumn(scheme1[i][talktime])][0]="" + 
						timetable[Common.getDateDiff(begindate,Common.stringToDate(scheme1[i][talkdate])) + 1][Common.getColumn(scheme1[i][talktime])][0]    + "[" +
						scheme1[i][talkcourse] +
						"/"+scheme1[i][talkspeaker] +
						"/<A Href=\""+response.encodeUrl("/servlet/info?type=timetable&param=room&query=where(room_id='" +scheme1[i][talkroom]+"')")+"\">"+scheme1[i][talkroom]+"</A>]";
				else {
					talkleftout.addElement(scheme1[i]);
					talkflag=true;
				}
			}else{
				
				talkleftout.addElement(scheme1[i]);
				talkflag=true;
			}
		}

		String result = Common.toHTML(timetable);
		if (lectureflag) result+=Common.toHTML(lectureleftout);
		if (talkflag) result+=Common.toHTML(talkleftout);

		return result;
	}

}
