/** This implements the Calendar. Lectures Schedules */
package Utils;

import java.util.*;
import javax.servlet.http.*;

public class CalUtils {	
	public static String[][]  monthTable(Calendar cal){
		String  mtable[][] = new String[7][7];
		for(int i=0;i<7;i++)
			for(int j=0;j<7;j++)
				mtable[i][j]="";  //initialize
		mtable[0][0] = "Sun";
		mtable[0][1] = "Mon";
		mtable[0][2] = "Tue";
		mtable[0][3] = "Wed";
		mtable[0][4] = "Thu";
		mtable[0][5] = "Fri";
		mtable[0][6] = "Sat";
		cal.set(Calendar.DAY_OF_MONTH,1);
		int month = cal.get(Calendar.MONTH);
		while(cal.get(Calendar.MONTH) == month){
			mtable[cal.get(Calendar.WEEK_OF_MONTH)][cal.get(Calendar.DAY_OF_WEEK)-1]=""+cal.get(Calendar.DAY_OF_MONTH);
			cal.roll(cal.DAY_OF_YEAR,true);
		}
		return mtable;
	}	


	/** This function converts a two dimensional array into HTML table.*/
	public static String toHTML(String[][] mtable,Calendar cal,HttpServletResponse response){
		int fontsize=-15;
		String  htmlTable ="<table bgcolor=\"yellow\">";
		for(int i=0;i<7;i++){
			htmlTable=htmlTable+"<tr>";
			for(int j=0;j<7;j++)
				if(!mtable[i][j].equals("")&&(i>0))
					 htmlTable=htmlTable + "<td><font size=\""+fontsize+"\">" + 
						 "<A HREF=\""+
						 response.encodeUrl("/servlet/info?type=timeperiod&begin_date="+mtable[i][j]+"-"+(cal.get(Calendar.MONTH)+1)+"-"+cal.get(Calendar.YEAR)+"&end_date="+mtable[i][j]+"-"+(cal.get(Calendar.MONTH)+1)+"-"+cal.get(Calendar.YEAR)+"\"") +">"+mtable[i][j]+"</A></font></td>";
			     else
					 htmlTable=htmlTable + "<td><font size=\""+fontsize+"\" >" + mtable[i][j] + "</font></td>";
			htmlTable=htmlTable+"</tr> \n";
		}
		return htmlTable+"</table>\n";
	}


	/** This function converts a three dimensional array of months to Html table */

	public static String toHTML(String[][][] mtable,HttpServletResponse response,Date base_date){
		
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR,base_date.getYear());
		cal.set(Calendar.MONTH,base_date.getMonth());
		String htmlTable="<table  align=\"center\" bgcolor=\"lightgreen\"><tr>";
		for(int month= 0;month<mtable.length;month++){
			htmlTable= htmlTable + "<td><b>" + (cal.get(Calendar.MONTH)+1) + "  " + cal.get(Calendar.YEAR) + "</b>" +  toHTML(mtable[month],cal,response) + "</td>";
			cal.roll(Calendar.MONTH,true);
		}
	  return (htmlTable=htmlTable + "</tr></table>");	
	};



			
	/** Get the month no, for the date, in the semSchedule */
	public static int monthNo(Date date,Date base_date){
		int year = date.getYear() - base_date.getYear();
		int month = date.getMonth() - base_date.getMonth();
		return (12 * year + month);
	}
		

	/** Get the calendar for the sem */
	public static String[][][] semSchedule(Date begin_date, Date end_date){
		
		int begin_year = begin_date.getYear();
          int end_year   = end_date.getYear();

		Calendar cal = Calendar.getInstance();
		
		
		// Initialize the initial date 
		cal.set(Calendar.YEAR,begin_date.getYear());
		cal.set(Calendar.MONTH,begin_date.getMonth());
		
		//Now generate the calendar for various months
		int nmonths = monthNo(end_date,begin_date);
		String months[][][] = new String[nmonths+1][7][7];
		for(int i=0;i<=nmonths; i++){
			months[i]=monthTable(cal);
			cal.add(Calendar.MONTH,0);
		}
		return months;
	}
}

