/** This class contains some general functions to be used.*/
package Utils;

import java.util.*;
import javax.servlet.http.*;

public class General {
	public static String today_date=SQLUtils.sdf.format(new java.util.Date());
	public static String example_time="00:00";
	public static String sem_sdate="12-07-2000";
	public static String sem_fdate="01-12-2000";
	/** This function returns the value for slot for a particular time */
	public static int get_Slot(String time){
		StringTokenizer strtok = new StringTokenizer(time,":");
		Integer hrs = new Integer(strtok.nextToken());
		Integer min = new Integer(strtok.nextToken());
		int slot = (hrs.intValue() * 60 + min.intValue())/30 ;
		return(slot);
	} 

	/** function for getting the internal slot from time */  
	public static int get_Slot(String time,char c)
	{
		StringTokenizer strtok = new StringTokenizer(time,":");
		Integer hrs = new Integer(strtok.nextToken());
		Integer min = new Integer(strtok.nextToken());
		double slot = (hrs.intValue() * 60 + min.intValue())/30.0 ;
		if(c=='l') 
			return((int)Math.floor(slot));
		else
			return((int)Math.ceil(slot));
	}	

 static public String checkDateInterval(String start_date,String end_date)
 {
     
	String message="";
	java.util.Date sdate=SQLUtils.string_To_Date(start_date);
	java.util.Date fdate=SQLUtils.string_To_Date(end_date);
	if(fdate.before(sdate))
		message+="The starting date can not be after the finish date";
	if(sdate.before(SQLUtils.string_To_Date(sem_sdate)))
		message+="The starting date has to be after the starting of the sem that is "+(SQLUtils.sdf).format(sem_sdate);
	if(fdate.after(SQLUtils.string_To_Date(sem_fdate)))
		message+="The ending date has to be before the starting of the sem that is "+(SQLUtils.sdf).format(sem_fdate);
     return(message);
}
static public String checkTimeInterval(String stime,String ftime)
 {
     
	String message="";
	if(get_Slot(stime)>get_Slot(ftime))
		message+="The starting time can not be after the finish time";
     return(message);
}	
	
	public static Hashtable SessionObject(Hashtable obj, String key, String val) {
		obj.put(key, val);
		return obj;
	}

	/**This function is for getting the talk_id that have been selected*/
	public static Vector getSelectedTable(HttpServletRequest request) {
          Vector talk_id=new Vector();
		Enumeration en = request.getParameterNames();
		String parameter=null;
		//all the checkboxes have the same name, so it does not matter
		//which name you choose
		if (en.hasMoreElements())
			parameter=(String)en.nextElement();
		//ensure that at least one row has been selected
		if(parameter!=null)
		{ 
		  StringTokenizer valtok=new StringTokenizer(request.getParameter(parameter),",");
		  int nrow = valtok.countTokens(); 
		  while(valtok.hasMoreTokens())
			talk_id.addElement(new Integer(valtok.nextToken()));
            return(talk_id);
	     } 		  
		else 
		 return(talk_id);
	}

	/** Function to get week's Monday and Friday*/
	 public  static String[] getWeek(){
		  String[] week=new String[3];
		  Calendar cal = Calendar.getInstance();
		  int date = cal.get(Calendar.DAY_OF_YEAR);
		  int today = cal.get(Calendar.DAY_OF_WEEK);
		  switch(today)
		  {
			   case 1: cal.set(Calendar.DAY_OF_YEAR,date+1);
					   date=cal.get(Calendar.DAY_OF_YEAR);
					   week[0]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   week[2]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   cal.set(Calendar.DAY_OF_YEAR,date+4);
					   week[1]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   break;
			   case 7: cal.set(Calendar.DAY_OF_YEAR,date+2);
					   date=cal.get(Calendar.DAY_OF_YEAR);
					   week[0]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   week[2]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   cal.set(Calendar.DAY_OF_YEAR,date+4);
					   week[1]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   break;
			  default: week[2]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   cal.set(Calendar.DAY_OF_YEAR,date-today+2);
					   date=cal.get(Calendar.DAY_OF_YEAR);
					   week[0]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
					   cal.set(Calendar.DAY_OF_YEAR,date+4);
					   week[1]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
		  }
		  return(week);
	 }

	 /** Function to get week's Monday and Friday*/
	 public  static String[] getWeek(Date in_date){
		 String[] week=new String[3];
		 Calendar cal = Calendar.getInstance();
		 cal.setTime(in_date);
		 int date = cal.get(Calendar.DAY_OF_YEAR);
		 int today = cal.get(Calendar.DAY_OF_WEEK);
		 switch(today)
		 {
			 case 1: 
				 date=cal.get(Calendar.DAY_OF_YEAR);
				 week[0]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
				 cal.set(Calendar.DAY_OF_YEAR,date+6);
				 week[1]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
				 cal.add(Calendar.DAY_OF_YEAR,1);
				 week[2]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
				 break;
			 case 7: cal.set(Calendar.DAY_OF_YEAR,date+1);
				    date=cal.get(Calendar.DAY_OF_YEAR);
				    week[0]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
				    cal.set(Calendar.DAY_OF_YEAR,date+6);
				    week[1]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
				    cal.add(Calendar.DAY_OF_YEAR,1);
				    week[2]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
				    break;
			 default :		   cal.set(Calendar.DAY_OF_YEAR,date-today+1);
							   date=cal.get(Calendar.DAY_OF_YEAR);
							   week[0]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
							   cal.set(Calendar.DAY_OF_YEAR,date+6);
							   week[1]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
							   cal.add(Calendar.DAY_OF_YEAR,1);
							   week[2]=""+cal.get(Calendar.DAY_OF_MONTH)+"-"+(cal.get(Calendar.MONTH) + 1)+"-"+cal.get(Calendar.YEAR);
		 }
		 return(week);
	 }
	 }
