/** This program provides some basic functions to work out SQL queries */


package Utils;

import java.util.*;
import javax.servlet.http.*;
import java.sql.*;
import java.text.*;

public class SQLUtils{

	static SimpleDateFormat sdf=new SimpleDateFormat("dd-MM-yyyy");
	static String format = "dd-mm-yyyy";
	/** The following prints/deletes tuples*/
	public static void DeleteTuples(String tablename, String[][] tuples) {
		int nrows = tuples.length;
		int ncols = tuples[0].length;
		String labels[] = new String[ncols];
		for (int i = 0; i<ncols; i++)
			labels[i] = tuples[0][i];
		for (int j = 1; j<nrows; j++) {
			String deleteString = "delete from "+tablename+" where ";
			for (int i = 0; i< ncols; i++) {
				deleteString = deleteString+labels[i]+" = '"+tuples[j][i]+"'";
				if (i < (ncols-1))
					deleteString = deleteString + " and ";
				else
					deleteString = deleteString + ";";
			}
			//System.out.println(deleteString);
		}
	}

	public static String getCondition(String user_id,String speaker,String room_id,String group_id)
	{	 
		int no=0;         
		String condition="";
		StringTokenizer strtok=new StringTokenizer(group_id,",");
		if(!user_id.equals(""))
		{
			no++;
			condition+= " user_id='"+user_id+"'";
		}
		if(!speaker.equals(""))
		{
			if(no==0)
				no++;
			else  
				condition+= " and ";
			condition+= " speaker='"+speaker+"'";
		}

		if(!room_id.equals(""))
		{
			if(no==0)
				no++;
			else  
				condition+= " and ";
			condition+= " room_id='"+room_id+"'";
		}
		if(!group_id.equals(""))
		{
			if(no==0)
				no++;
			else  
				condition+= " and "; 
			condition+= " (group_id='"+strtok.nextToken()+"'";
			while(strtok.hasMoreTokens())		
				condition+= " or group_id='"+strtok.nextToken()+"'";
			condition+=" ) ";

		}

		if(no!=0)
			condition = " where "+ condition;
		return(condition);
		/*
		   if(user_id==null)
		   System.out.println("user_id-getcond null");
		   if(speaker==null)
		   System.out.println("speaker-getcond null");
		   if(room_id==null)
		   System.out.println("room_id-getcond null");
		   if(group_id==null)
		   System.out.println("group_id-getcond null");



		   return "";*/
	}

	/** function for getting the internal slot from time */  
	public static int get_Slot(String time,char c)
	{
		StringTokenizer strtok = new StringTokenizer(time,":");
		Integer hrs = new Integer(strtok.nextToken());
		Integer min = new Integer(strtok.nextToken());
		double slot = (hrs.intValue() * 60 + min.intValue())/30.0 ;
		if(c=='l') 
			return((int)Math.floor(slot));
		else
			return((int)Math.ceil(slot));
	}	

	/**function to get a java.util.Date object from a date encoded in
	  a string in the format dd-mm-yyyy */
	public static java.util.Date string_To_Date(String str)
	{
		int day;
		int month;
		int year;
		StringTokenizer strtok=new StringTokenizer(str,"-");
		day=Integer.parseInt(strtok.nextToken());
		month=Integer.parseInt(strtok.nextToken())-1;
		year=Integer.parseInt(strtok.nextToken())-1900;
		return(new java.util.Date(year,month,day));
	}      

	/** function for getting the String day corresponding to a number*/
	public static String no_To_Day(int no)
	{
		String day;
		switch(no)
		{
			case 0: day="Sun"; 
				   break;
			case 1: day="Mon"; 
				   break;
			case 2: day="Tue"; 
				   break;
			case 3: day="Wed"; 
				   break;
			case 4: day="Thu"; 
				   break;
			case 5: day="Fri";
				   break;
			case 6: day="Sat"; 
				   break;
			default: System.out.println("Something wrong with the argument supplied to no_To_Day");
				    day="error"; 
		} 
		return(day);

	}  

	/** function for getting the number corresponding to a day (String)*/
	public static int day_To_no(String day)
	{
		int no=-1;
		if(day.equals("Sun"))
			no=0; 
		if(day.equals("Mon")) 
			no=1; 
		if(day.equals("Tue")) 
			no=2; 
		if(day.equals("Wed")) 
			no=3; 
		if(day.equals("Thu"))
			no=4; 
		if(day.equals("Fri")) 
			no=5; 
		if(day.equals("Sat")) 
			no=6; 

		if(no==-1) 
			System.out.println("Something wrong with the argument supplied to day_To_no");

		return(no);

	}  

	/** function for getting the date after specified number of the days of
	  the given date */
	public static java.util.Date add_Days(java.util.Date date,int days)
	{
		Calendar cal=Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DATE,days);
		date=cal.getTime();
		return(date);
	}   

	/** function for getting the number of days represented by the difference
	  of two days  */
	public static int get_Daydiff(java.util.Date date1,java.util.Date date2)
	{
		long msec=24*3600*1000;
		Calendar cal1=Calendar.getInstance();
		Calendar cal2=Calendar.getInstance();
		cal1.setTime(date1);
		cal2.setTime(date2);
		cal1.clear();
		cal2.clear();
		date1=cal1.getTime();
		date2=cal2.getTime();
		return((int)((date1.getTime()-date2.getTime())/msec));
	}  

	/** function for getting the first date when a particular event (in this 
	  case the first day of the lecture) occurred given the start date and
	  the day of the week */
	public static java.util.Date get_Firstdate(java.util.Date date,String day)
	{
		int day_no1=day_To_no(day);  //actual day number
		int day_no2=date.getDay();  //date's day number
		if(day_no1==day_no2)
			return(date);
		else
		{  
			if(day_no1<day_no2)
				day_no1 +=7;
			return(add_Days(date,day_no1 - day_no2));
		}  
	}    

	/**function for checking whether a given date lies between to dates or not */
	public static boolean is_Betweendate(java.util.Date date,java.util.Date start_date,java.util.Date end_date)
	{  
		Calendar cal=Calendar.getInstance();
		cal.setTime(date);
		cal.clear();
		date=cal.getTime();
		cal.setTime(start_date);
		cal.clear();
		start_date=cal.getTime();
		cal.setTime(end_date);
		cal.clear();
		end_date=cal.getTime();

		if( ((date.equals(start_date)) || (date.after(start_date))) &&
				((date.equals(end_date)) || (date.before(end_date))) )

			return(true);
		else
			return(false);

	}     


	/** function for creating a vector of table of deleted lectures */
	public static Vector deleted_Lecture_Table(Connection con) throws SQLException
	{
		String course_no;
		int lecture_no;
		java.util.Date cancel_date;
		ResultSet rset;
		Statement stmt=con.createStatement();
		Vector table = new Vector();
		Vector tuples= new Vector();
		/*tuples.addElement("course_no"); 
		  tuples.addElement("lecture_no"); 
		  tuples.addElement("cancel_date"); 
		  table.addElement(tuples); */
		rset=stmt.executeQuery("select * from delete_lecture");
		while(rset.next())
		{	
			course_no=rset.getString("course_no");
			lecture_no=rset.getInt("lecture_no");
			cancel_date=(java.util.Date)(rset.getDate("cancel_date"));
			Calendar cal=Calendar.getInstance();
			cal.setTime(cancel_date);
			cal.clear();
			cancel_date=cal.getTime();
			tuples=new Vector();
			tuples.addElement(course_no); 
			tuples.addElement(new Integer(lecture_no)); 
			tuples.addElement(cancel_date); 
			table.addElement(tuples);
		}
		rset.close();
		stmt.close();
		return(table);
	}

	/** function for checking whether the periodic lecture has been cancelled or not*/

	public static boolean is_Lecture_Deleted(Vector table,String course_no,int lecture_no,java.util.Date date)
	{
		int i=0;
		Enumeration en=table.elements();
		Enumeration en_val;
		Calendar cal=Calendar.getInstance();
		cal.setTime(date);
		cal.clear();
		date=cal.getTime();
		while((i<=0) && (en.hasMoreElements()))
		{
			en_val=((Vector)en.nextElement()).elements();
			if((course_no.equals(en_val.nextElement())) && 
					((new Integer(lecture_no)).equals(en_val.nextElement())) &&					   
					(date.equals(en_val.nextElement())))
				i++ ;
		} 

		if(i>0)
			return(true);
		else
			return(false);
	}  

	/**function for checking whether on a particular date whether there is 
	  a particular lecture or not */

	public static boolean is_Lecture(java.util.Date date,java.util.Date start_date,java.util.Date end_date,int period)
	{
		if ( is_Betweendate(date,start_date,end_date) && 
				(get_Daydiff(date,start_date)%(period*7)==0)  )
			return(true);
		else
			return(false);
	}	    



	/**function for verifying the user and password */
	public static boolean is_Verified(Connection con,String user_id, String passwd)
		throws SQLException
		{  
			int i=0;
			ResultSet rset;
			Statement stmt=con.createStatement();
			rset=stmt.executeQuery("select count(*) from users where user_id='"+
					user_id+"'  and passwd='"+ passwd + "'");
			rset.next();
			i=rset.getInt(1);
			rset.close();
			stmt.close();
			if(i>0)
				return(true);
			else
				return(false);
		}

	/**function for inserting into talk table */

	public static int insert_Talk(Connection con,String topic, String speaker,java.util.Date date,Interval intv) throws SQLException
	{
		int id=0;
		String str_date;
		Statement stmt;
		ResultSet rset;
		str_date=sdf.format(date);
		stmt=con.createStatement();
		rset=stmt.executeQuery("select talk_id from talk order by talk_id desc");
		if(rset.next())
			id=rset.getInt(1);
		while(rset.next())
		{}
		id++;
		//System.out.println("insert into talk values( "+id+",'"+topic+"','"+speaker+"',to_date('"+str_date+"','"+format+"'),'"+intv.stime+"','"+intv.ftime+"',"+get_Slot(intv.stime,'l')+","+get_Slot(intv.ftime,'u')+")");
		stmt.executeUpdate("insert into talk values( "+id+",'"+topic+"','"+speaker+"',to_date('"+str_date+"','"+format+"'),'"+intv.stime+"','"+intv.ftime+"',"+get_Slot(intv.stime,'l')+","+get_Slot(intv.ftime,'u')+")");
		rset.close();
		stmt.close();
		return(id);
	}   

	/**function for inserting into extra lecture table */

	public static int insert_ExtraLecture(Connection con,String course_no, String room_id, java.util.Date date,Interval intv) throws SQLException
	{
		int id=0;
		String str_date;
		Statement stmt;
		ResultSet rset;
		str_date=sdf.format(date);
		stmt=con.createStatement();

		//System.out.println("select extralecture_no from extra_lecture where course_no='"+course_no+"' order by extralecture_no desc");
		rset=stmt.executeQuery("select extralecture_no from extra_lecture where course_no='"+course_no+"' order by extralecture_no desc");
		if(rset.next())
			id=rset.getInt(1);
		while(rset.next())
		{}		
		id++;
		//System.out.println("insert into extra_lecture values('"+course_no+"',"+id+",'"+room_id+"',to_date('"+str_date+"','"+format+"'),'"+intv.stime+"','"+intv.ftime+"')");
		stmt.executeUpdate("insert into extra_lecture values('"+course_no+"',"+id+",'"+room_id+"',to_date('"+str_date+"','"+format+"'),'"+intv.stime+"','"+intv.ftime+"')");
		stmt.close();
		rset.close();
		return(id);
	}   

	/**function for inserting into booking table*/
	public static void insert_Booking(Connection con,int talk_id,String room_id,String user_id) throws SQLException
	{
		String str_date;
		Statement stmt;
		str_date=sdf.format(new java.util.Date()); /**today's date*/
		stmt=con.createStatement();
		//System.out.println("insert into talk_booking values("+talk_id+",'"+room_id+"','"+user_id+"',to_date('"+str_date+"','"+format+"'))");
		stmt.executeUpdate("insert into talk_booking values("+talk_id+",'"+room_id+"','"+user_id+"',to_date('"+str_date+"','"+format+"'))");
		stmt.close();
	}
	/** function for inserting into talk_group */ 
	public static void insert_talkGroup(Connection con,int talk_id,String group_id) throws SQLException
	{
		Statement stmt=con.createStatement();
		StringTokenizer strtok=new StringTokenizer(group_id,",");
		while(strtok.hasMoreTokens())
			stmt.executeUpdate("insert into talk_group values("+talk_id+",'"+strtok.nextToken()+"')");
		stmt.close();
	}			    




	/**function for checking whether a given room is booked or not on a 
	 *  particular day during a particular time interval or not */
	public static Vector check_Booked(Connection con,java.util.Date date,Interval intv,String room_id,String user_id,String group_id) throws SQLException
	{
		int booked=0;
		String message="";
		String cond;
		Vector result=new Vector();
		Vector table=new Vector();
		Vector tuples;
		ResultSet rset;
		ResultSet myrset;
		Statement  mystmt;
		Statement stmt;
		String str_date;
		String day;
		Interval booked_intv;
		String course_no;
		int lecture_no,period;
		java.util.Date start_date,end_date;
		String start_time;
		String end_time;
		Vector deleted_vec;
		str_date=sdf.format(date);
		stmt=con.createStatement();
		mystmt=con.createStatement();
		rset=stmt.executeQuery("select * from talk_info where room_id='"+
				room_id+"' and date_for_talk=to_date('"+
				str_date+"','"+format+"')");

		while(rset.next())
		{
			start_time=rset.getString("start_time");	  
			end_time=rset.getString("end_time");
			booked_intv=new Interval(start_time,end_time);
			if(intv.intersects(booked_intv))
			{ 
				if(booked==0)
				{	 
					tuples=new Vector();
					booked=1;
					tuples.addElement("talk_id");
					tuples.addElement("user_id"); 
					tuples.addElement("topic"); 
					tuples.addElement("speaker"); 
					//tuples.addElement("date"); 
					tuples.addElement("start_time"); 
					tuples.addElement("end_time"); 
					tuples.addElement("room_id"); 
					table.addElement(tuples);
				}
				tuples=new Vector();
				tuples.addElement(rset.getString("talk_id"));
				tuples.addElement(rset.getString("user_id")); 
				tuples.addElement(rset.getString("topic")); 
				tuples.addElement(rset.getString("speaker")); 
				//tuples.addElement(rset.getDate("date")); 
				tuples.addElement(rset.getString("start_time")); 
				tuples.addElement(rset.getString("end_time")); 
				tuples.addElement(rset.getString("room_id")); 
				table.addElement(tuples);
			} 
		}	
		if(booked==1)
		{ 
			message="<BR> Sorry, the booking can not be made, room is busy at"+
				" the specified time on the given date";
			result.addElement(new Integer(booked));
			result.addElement(message);
			result.addElement(table);
			return(result);	
		} 
		stmt.close();
		stmt=con.createStatement();
		rset=stmt.executeQuery("select * from extra_lecture_info where room_id='"+
				room_id+"' and date_for_extralecture=to_date('"+
				str_date+"','"+format+"')");

		while(rset.next())
		{
			start_time=rset.getString("start_time");	  
			end_time=rset.getString("end_time");
			booked_intv=new Interval(start_time,end_time);
			if(intv.intersects(booked_intv))
			{ 
				if(booked==0)
				{	 
					tuples=new Vector();
					booked=1;
					tuples.addElement("course_no");
					tuples.addElement("extralecture_no");
					tuples.addElement("user_id"); 
					//tuples.addElement("date"); 
					tuples.addElement("start_time"); 
					tuples.addElement("end_time"); 
					tuples.addElement("room_id"); 
					table.addElement(tuples);
				}
				tuples=new Vector();
				tuples.addElement(rset.getString("course_no"));
				tuples.addElement(rset.getString("extralecture_no"));
				tuples.addElement(rset.getString("user_id")); 
				//tuples.addElement(rset.getDate("date")); 
				tuples.addElement(rset.getString("start_time")); 
				tuples.addElement(rset.getString("end_time")); 
				tuples.addElement(rset.getString("room_id")); 
				table.addElement(tuples);
			} 
		}	
		if(booked==1)
		{ 
			message="<BR> Sorry, the booking can not be made, room is busy at"+
				" the specified time on the given date";
			result.addElement(new Integer(booked));
			result.addElement(message);
			result.addElement(table);
			return(result);	
		} 

		stmt.close();
		deleted_vec=deleted_Lecture_Table(con);
		stmt=con.createStatement();
		mystmt=con.createStatement();
		rset=stmt.executeQuery("select * from lecture_info where room_id='"+
				room_id+"'");
		while(rset.next())
		{
			day=rset.getString("day");
			start_date=get_Firstdate((java.util.Date)rset.getDate("start_date"),day);
			end_date=(java.util.Date)rset.getDate("end_date");
			period=rset.getInt("period");
			course_no=rset.getString("course_no");
			lecture_no=rset.getInt("lecture_no");
			start_time=rset.getString("start_time");	  
			end_time=rset.getString("end_time");
			booked_intv=new Interval(start_time,end_time);
			if( (is_Lecture(date,start_date,end_date,period)))
				if( (!is_Lecture_Deleted(deleted_vec,course_no,lecture_no,date)))
					if (intv.intersects(booked_intv))
					{
						if(booked==0)
						{	 
							tuples=new Vector();
							booked=1;
							tuples.addElement("course_no");
							tuples.addElement("lecture_no");
							tuples.addElement("user_id"); 
							//tuples.addElement("date"); 
							tuples.addElement("start_time"); 
							tuples.addElement("end_time"); 
							tuples.addElement("room_id"); 
							table.addElement(tuples);
						}
						tuples=new Vector();
						tuples.addElement(rset.getString("course_no"));
						tuples.addElement(rset.getString("lecture_no"));
						tuples.addElement(rset.getString("user_id")); 
						//tuples.addElement(rset.getDate("date")); 
						tuples.addElement(rset.getString("start_time")); 
						tuples.addElement(rset.getString("end_time")); 
						tuples.addElement(rset.getString("room_id")); 
						table.addElement(tuples);
					} 
		}
		if(booked==1)
		{ 
			message="<BR> Sorry, the booking can not be made, room is busy at"+
				" the specified time on the given date";
			result.addElement(new Integer(booked));
			result.addElement(message);
			result.addElement(table);
			return(result);	
		}


		stmt.close();

		//if nothing intersect, it means the slot is free

		stmt=con.createStatement();
		StringTokenizer strtok=new StringTokenizer(group_id);
		cond=" group_id='"+strtok.nextToken()+"' ";
		while(strtok.hasMoreTokens())
			cond+=" or group_id='"+strtok.nextToken()+"' ";

		rset=stmt.executeQuery("select * from talk_info where (user_id='"+
				user_id+"' or "+ cond+" ) and date_for_talk=to_date('"+
				str_date+"','"+format+"')");

		while(rset.next())
		{
			start_time=rset.getString("start_time");	  
			end_time=rset.getString("end_time");
			booked_intv=new Interval(start_time,end_time);
			if(intv.intersects(booked_intv))
			{ 
				if(booked==0)
				{	 
					tuples=new Vector();
					booked=1;
					tuples.addElement("talk_id");
					tuples.addElement("user_id"); 
					tuples.addElement("topic"); 
					tuples.addElement("speaker"); 
					//tuples.addElement("date"); 
					tuples.addElement("start_time"); 
					tuples.addElement("end_time"); 
					tuples.addElement("room_id"); 
					table.addElement(tuples);
				}
				tuples=new Vector();
				tuples.addElement(rset.getString("talk_id"));
				tuples.addElement(rset.getString("user_id")); 
				tuples.addElement(rset.getString("topic")); 
				tuples.addElement(rset.getString("speaker")); 
				//tuples.addElement(rset.getDate("date")); 
				tuples.addElement(rset.getString("start_time")); 
				tuples.addElement(rset.getString("end_time")); 
				tuples.addElement(rset.getString("room_id")); 
				table.addElement(tuples);
			} 
		}	
		if(booked==1)
		{ 
			booked=0; //the slot is free
			message+="<BR> Warning: The instructor/group is busy at specified time";
			message+=" though booking has been made";
			result.addElement(new Integer(booked));
			result.addElement(message);
			result.addElement(table);
			return(result);	
		}


		stmt.close();
		stmt=con.createStatement();

		rset=stmt.executeQuery("select * from extra_lecture_info where (user_id='"+
				user_id+"'or "+ cond+") and date_for_extralecture=to_date('"+
				str_date+"','"+format+"')");
		while(rset.next())
		{
			start_time=rset.getString("start_time");	  
			end_time=rset.getString("end_time");
			booked_intv=new Interval(start_time,end_time);
			if(intv.intersects(booked_intv))
			{
				if(booked==0)
				{	 
					tuples=new Vector();
					booked=1;
					tuples.addElement("course_no");
					tuples.addElement("extralecture_no");
					tuples.addElement("user_id"); 
					//tuples.addElement("date"); 
					tuples.addElement("start_time"); 
					tuples.addElement("end_time"); 
					tuples.addElement("room_id"); 
					table.addElement(tuples);
				}
				tuples=new Vector();
				tuples.addElement(rset.getString("course_no"));
				tuples.addElement(rset.getString("extralecture_no"));
				tuples.addElement(rset.getString("user_id")); 
				//tuples.addElement(rset.getDate("date")); 
				tuples.addElement(rset.getString("start_time")); 
				tuples.addElement(rset.getString("end_time")); 
				tuples.addElement(rset.getString("room_id")); 
				table.addElement(tuples);
			} 
		}	
		if(booked==1)
		{     
			booked=0;
			message+="<BR> Warning: The instructor/group is busy at specified time";
			message+=" though booking has been made";
			result.addElement(new Integer(booked));
			result.addElement(message);
			result.addElement(table);
			return(result);	
		}


		stmt.close();
		stmt=con.createStatement();
		deleted_vec=deleted_Lecture_Table(con);
		rset=stmt.executeQuery("select * from lecture_info where user_id='"+
				user_id+"' or "+cond);
		while(rset.next())
		{
			day=rset.getString("day");
			start_date=get_Firstdate((java.util.Date)rset.getDate("start_date"),day);
			end_date=(java.util.Date)rset.getDate("end_date");
			period=rset.getInt("period");
			course_no=rset.getString("course_no");
			lecture_no=rset.getInt("lecture_no");
			start_time=rset.getString("start_time");	  
			end_time=rset.getString("end_time");
			booked_intv=new Interval(start_time,end_time);
			if( (is_Lecture(date,start_date,end_date,period)))
				if( (!is_Lecture_Deleted(deleted_vec,course_no,lecture_no,date)))
					if (intv.intersects(booked_intv))
					{   
						if(booked==0)
						{	 
							tuples=new Vector();
							booked=1;
							tuples.addElement("course_no");
							tuples.addElement("lecture_no");
							tuples.addElement("user_id"); 
							//tuples.addElement("date"); 
							tuples.addElement("start_time"); 
							tuples.addElement("end_time"); 
							tuples.addElement("room_id"); 
							table.addElement(tuples);
						}
						tuples=new Vector();
						tuples.addElement(rset.getString("course_no"));
						tuples.addElement(rset.getString("lecture_no"));
						tuples.addElement(rset.getString("user_id")); 
						//tuples.addElement(rset.getDate("date")); 
						tuples.addElement(rset.getString("start_time")); 
						tuples.addElement(rset.getString("end_time")); 
						tuples.addElement(rset.getString("room_id")); 
						table.addElement(tuples);
					}
		}
		if(booked==1)
		{ 
			booked=0;
			message+="<BR> Warning: The instructor/group is busy at specified time";
			message+=" though booking has been made";
			result.addElement(new Integer(booked));
			result.addElement(message);
			result.addElement(table);
			return(result);	
		}

	message=" Execution successful ";
	booked=0;
	result.addElement(new Integer(booked));
	result.addElement(message);
	stmt.close();
	rset.close();
	return(result);
}	 
/** Function to get Resultset for talk satisfying the "condition" */
public static Vector talk_Commitments(Connection con,String user_id1,String speaker1,String room_id1,Interval intv,String sdate,String fdate,String group_id1)
	throws SQLException {
		Vector vec = new Vector();
		Interval booked_intv;
		String booked_stime;
		String booked_ftime;
		String talk_id,user_id,topic,room_id,speaker,group_id;
		java.util.Date date;
		String condition=getCondition(user_id1,speaker1,room_id1,group_id1);
		Statement stmt= con.createStatement();
		ResultSet rset= stmt.executeQuery("select unique talk_id,user_id,topic,speaker,room_id,date_for_talk,start_time,end_time from talk_info "+condition);
		Statement stm= con.createStatement();
		Vector table = new Vector();
		Vector tuples= new Vector();
		tuples.addElement("talk_id");
		tuples.addElement("user_id"); 
		tuples.addElement("topic"); 
		tuples.addElement("speaker"); 
		tuples.addElement("date"); 
		tuples.addElement("start_time"); 
		tuples.addElement("end_time"); 
		tuples.addElement("room_id"); 
		table.addElement(tuples);
		while(rset.next())
		{
			booked_stime=rset.getString("start_time");
			booked_ftime=rset.getString("end_time");
			talk_id=rset.getString("talk_id");
			user_id=rset.getString("user_id");
			room_id=rset.getString("room_id");
			topic=rset.getString("topic");
			speaker=rset.getString("speaker");
			booked_intv=new Interval(booked_stime,booked_ftime);
			date=(java.util.Date)(rset.getDate("date_for_talk"));


			if(is_Betweendate(date,string_To_Date(sdate),string_To_Date(fdate)) &&
					(intv.intersects(booked_intv))){
				tuples=new Vector();
				tuples.addElement(talk_id);
				tuples.addElement(user_id); 
				tuples.addElement(topic); 
				tuples.addElement(speaker); 
				tuples.addElement(sdf.format(date)); 
				tuples.addElement(rset.getString("start_time")); 
				tuples.addElement(rset.getString("end_time")); 
				tuples.addElement(room_id); 
				table.addElement(tuples);
			}
		}
		rset.close();
		stmt.close();
		stm.close();
		return(table);
	}

	/** Function to get Resultset for extra lecture satisfying the "condition" */
public static Vector extralecture_Commitments(Connection con,String user_id1,String room_id1,Interval intv,String sdate,String fdate,String group_id1)
	throws SQLException {
		Vector vec = new Vector();
		Interval booked_intv;
		String booked_stime;
		String booked_ftime;
		String extralecture_no,user_id,topic,room_id,speaker,group_id;
		String course_no;
		java.util.Date date;
		String condition=getCondition(user_id1,"",room_id1,group_id1);
		Statement stmt= con.createStatement();
		ResultSet rset= stmt.executeQuery("select unique course_no,extralecture_no,user_id,room_id,date_for_extralecture,name,start_time,end_time from extra_lecture_info "+condition);
		Statement stm= con.createStatement();
		Vector table = new Vector();
		Vector tuples= new Vector();
		tuples.addElement("user_id"); 
		tuples.addElement("extralecture_no");
		tuples.addElement("course_no");
		tuples.addElement("name");
		tuples.addElement("date"); 
		tuples.addElement("start_time"); 
		tuples.addElement("end_time"); 
		tuples.addElement("room_id"); 
		table.addElement(tuples);
		while(rset.next())
		{
			booked_stime=rset.getString("start_time");
			booked_ftime=rset.getString("end_time");
			extralecture_no=rset.getString("extralecture_no");
			course_no=rset.getString("course_no");
			user_id=rset.getString("user_id");
			room_id=rset.getString("room_id");
			booked_intv=new Interval(booked_stime,booked_ftime);
			date=(java.util.Date)(rset.getDate("date_for_extralecture"));


			if(is_Betweendate(date,string_To_Date(sdate),string_To_Date(fdate)) &&
					(intv.intersects(booked_intv))){
				tuples=new Vector();

				tuples.addElement(user_id); 
				tuples.addElement(extralecture_no);
				tuples.addElement(course_no);
				tuples.addElement(rset.getString("name"));
				tuples.addElement(sdf.format(date)); 
				tuples.addElement(rset.getString("start_time")); 
				tuples.addElement(rset.getString("end_time")); 
				tuples.addElement(room_id); 
				table.addElement(tuples);
			}
		}
		rset.close();
		stmt.close();
		stm.close();
		return(table);
	}

	/** Function to get Resultset for lecture satisfying the given constraints */
public static Vector lecture_Commitments(Connection con,String user_id,String room_id,Interval intv,String sdate,String fdate,String group_id)
	throws SQLException {
		Calendar cal=Calendar.getInstance();
		Interval booked_intv;
		Vector deleted_vec;
		String booked_stime;
		String booked_ftime;
		String booked_group_id;
		String day;
		String course_no;
		int lecture_no;
		int period;
		java.util.Date booked_sdate,booked_fdate,tempdate;
		java.util.Date date=null;

		String condition=getCondition(user_id,"",room_id,group_id);
		deleted_vec=deleted_Lecture_Table(con);
		Statement stm = con.createStatement();
		Statement stmt= con.createStatement();
		//  System.out.println("select unique user_id,name,course_no,lecture_no,start_time,end_time,start_date,end_date,period,day,room_id from lecture_info " + condition );
		ResultSet rset= stmt.executeQuery("select unique user_id,name,course_no,lecture_no,start_time,end_time,start_date,end_date,period,day,room_id from lecture_info " + condition );
		Vector table = new Vector();
		Vector tuples= new Vector();
		tuples.addElement("user_id"); 
		tuples.addElement("lecture_no");
		tuples.addElement("course_no");
		tuples.addElement("name");
		tuples.addElement("date"); 
		tuples.addElement("start_time"); 
		tuples.addElement("end_time"); 
		tuples.addElement("room_id"); 
		table.addElement(tuples);
		while(rset.next())
		{


			booked_stime=rset.getString("start_time");
			booked_ftime=rset.getString("end_time");
			booked_sdate=(java.util.Date)rset.getDate("start_date");
			booked_fdate=(java.util.Date)rset.getDate("end_date");
			cal.setTime(booked_sdate);
			cal.clear();
			booked_sdate=cal.getTime();	   
			cal.setTime(booked_fdate);
			cal.clear();
			booked_fdate=cal.getTime();	   

			booked_intv=new Interval(booked_stime,booked_ftime);
			course_no=rset.getString("course_no");
			lecture_no=rset.getInt("lecture_no");
			period=rset.getInt("period");
			day=rset.getString("day");
			if(intv.intersects(booked_intv))
			{
				tempdate=get_Firstdate(booked_sdate,day);
				cal.setTime(tempdate);
				cal.clear();
				tempdate=cal.getTime();	   
				while(tempdate.before(string_To_Date(sdate)))  
					tempdate=add_Days(tempdate,period*7);
				while(!((booked_fdate.before(tempdate))||((string_To_Date(fdate)).before(tempdate)))){
					if(! is_Lecture_Deleted(deleted_vec,course_no,lecture_no,tempdate)){
						tuples=new Vector();

						tuples.addElement(rset.getString("user_id")); 
						tuples.addElement(""+lecture_no); 
						tuples.addElement(course_no); 
						tuples.addElement(rset.getString("name"));
						tuples.addElement(sdf.format(tempdate)); 
						tuples.addElement(booked_stime); 
						tuples.addElement(booked_ftime); 
						tuples.addElement(rset.getString("room_id")); 
						table.addElement(tuples);
					}
					tempdate=add_Days(tempdate,period*7);
				}

			}
		}
		rset.close();
		stmt.close();
		stm.close();
		return(table);
	}

	/** Function to get Resultset for deleted lectures satisfying the given 
	 * constraints */
public static Vector deletelecture_Commitments(Connection con,String user_id,String room_id,Interval intv,String sdate,String fdate,String group_id)
	throws SQLException {
		Calendar cal=Calendar.getInstance();
		Interval booked_intv;
		Vector deleted_vec;
		String booked_stime;
		String booked_ftime;
		String booked_group_id;
		String day;
		String course_no;
		int lecture_no;
		int period;
		java.util.Date booked_sdate,booked_fdate,tempdate;
		java.util.Date date=null;

		String condition=getCondition(user_id,"",room_id,group_id);
		deleted_vec=deleted_Lecture_Table(con);
		Statement stm = con.createStatement();
		Statement stmt= con.createStatement();
		//  System.out.println("select unique user_id,name,course_no,lecture_no,start_time,end_time,start_date,end_date,period,day,room_id from lecture_info " + condition );
		ResultSet rset= stmt.executeQuery("select unique user_id,name,course_no,lecture_no,start_time,end_time,start_date,end_date,period,day,room_id from lecture_info " + condition );
		Vector table = new Vector();
		Vector tuples= new Vector();
		tuples.addElement("user_id"); 
		tuples.addElement("lecture_no");
		tuples.addElement("course_no");
		tuples.addElement("name");
		tuples.addElement("date"); 
		tuples.addElement("start_time"); 
		tuples.addElement("end_time"); 
		tuples.addElement("room_id"); 
		table.addElement(tuples);
		while(rset.next())
		{
			booked_stime=rset.getString("start_time");
			booked_ftime=rset.getString("end_time");
			booked_sdate=(java.util.Date)rset.getDate("start_date");
			booked_fdate=(java.util.Date)rset.getDate("end_date");
			cal.setTime(booked_sdate);
			cal.clear();
			booked_sdate=cal.getTime();	   
			cal.setTime(booked_fdate);
			cal.clear();
			booked_fdate=cal.getTime();	   

			booked_intv=new Interval(booked_stime,booked_ftime);
			course_no=rset.getString("course_no");
			lecture_no=rset.getInt("lecture_no");
			period=rset.getInt("period");
			day=rset.getString("day");
			if(intv.intersects(booked_intv))
			{
				tempdate=get_Firstdate(booked_sdate,day);
				cal.setTime(tempdate);
				cal.clear();
				tempdate=cal.getTime();	   
				while(tempdate.before(string_To_Date(sdate)))  
					tempdate=add_Days(tempdate,period*7);
				while(!((booked_fdate.before(tempdate))||((string_To_Date(fdate)).before(tempdate)))){
					if(is_Lecture_Deleted(deleted_vec,course_no,lecture_no,tempdate)){
						tuples=new Vector();

						tuples.addElement(rset.getString("user_id")); 
						tuples.addElement(""+lecture_no); 
						tuples.addElement(course_no); 
						tuples.addElement(rset.getString("name"));
						tuples.addElement(sdf.format(tempdate)); 
						tuples.addElement(booked_stime); 
						tuples.addElement(booked_ftime); 
						tuples.addElement(rset.getString("room_id")); 
						table.addElement(tuples);
					}
					tempdate=add_Days(tempdate,period*7);
				}

			}
		}
		rset.close();
		stmt.close();
		stm.close();
		return(table);
	}

	/** Function to get Resultset for lectures within the given constraints */
public static Vector lectureInfo(Connection con,String user_id,String room_id,Interval intv,String sdate,String fdate,String group_id)
	throws SQLException {
		Calendar cal=Calendar.getInstance();
		Interval booked_intv;
		String booked_stime;
		String booked_ftime;
		String booked_group_id;
		String day;
		String course_no;
		int lecture_no;
		int period;
		java.util.Date booked_sdate,booked_fdate,start_date,end_date;
		java.util.Date date=null;

		String condition=getCondition(user_id,"",room_id,group_id);
		Statement stm = con.createStatement();
		Statement stmt= con.createStatement();
		//  System.out.println("select unique user_id,name,course_no,lecture_no,start_time,end_time,start_date,end_date,period,day,room_id from lecture_info " + condition );
		ResultSet rset= stmt.executeQuery("select unique user_id,name,course_no,lecture_no,start_time,end_time,start_date,end_date,period,day,room_id from lecture_info " + condition );
		Vector table = new Vector();
		Vector tuples= new Vector();
		tuples.addElement("user_id"); 
		tuples.addElement("lecture_no");
		tuples.addElement("course_no");
		tuples.addElement("name");
		tuples.addElement("day"); 
		tuples.addElement("start_time"); 
		tuples.addElement("end_time"); 
		tuples.addElement("room_id"); 
		table.addElement(tuples);
		while(rset.next())
		{
			booked_stime=rset.getString("start_time");
			booked_ftime=rset.getString("end_time");
			booked_sdate=(java.util.Date)rset.getDate("start_date");
			booked_fdate=(java.util.Date)rset.getDate("end_date");
			cal.setTime(booked_sdate);
			cal.clear();
			booked_sdate=cal.getTime();	   
			cal.setTime(booked_fdate);
			cal.clear();
			booked_fdate=cal.getTime();	   
			start_date=string_To_Date(sdate);
			end_date=string_To_Date(fdate);
			booked_intv=new Interval(booked_stime,booked_ftime);
			course_no=rset.getString("course_no");
			lecture_no=rset.getInt("lecture_no");
			period=rset.getInt("period");
			day=rset.getString("day");
			if(intv.intersects(booked_intv))
			{
				tuples=new Vector();
				tuples.addElement(rset.getString("user_id")); 
				tuples.addElement(""+lecture_no); 
				tuples.addElement(course_no); 
				tuples.addElement(rset.getString("name"));
				tuples.addElement(day); 
				tuples.addElement(booked_stime); 
				tuples.addElement(booked_ftime); 
				tuples.addElement(rset.getString("room_id")); 
				table.addElement(tuples);
			}
		}	

		rset.close();
		stmt.close();
		stm.close();
		return(table);
	}



	public static void deleteCommitments(Connection con,HttpServletRequest request) throws SQLException {

		Statement stmt=con.createStatement();
		Enumeration en;
		String parameter="null";
		String differentiator=";;";
		String row,colname,colid,course_no="";
		int lecture_no=0,extralecture_no=0;
		int talk_id=0;
		String date="";
		String insertu;
		String query="";
		StringTokenizer valtok,coltok,recordtok;
		en=request.getParameterNames();
		while(en.hasMoreElements()&& !parameter.equals("lecture"))
			parameter=(String)en.nextElement();
		//case of lectures
		//System.out.println("hi , iam here");
		if(parameter.equals("lecture"))
		{
			recordtok=new StringTokenizer(request.getParameter(parameter),",");
			while(recordtok.hasMoreElements())
			{ 
				row=(String)recordtok.nextElement();
				coltok=new StringTokenizer(row,";;");
				while(coltok.hasMoreElements())
				{
					colid=(String)coltok.nextElement();
					valtok=new StringTokenizer(colid,"=");   
					colname=(String)valtok.nextElement();
					if( colname.equals("course_no"))
						course_no=(String)valtok.nextElement();
					if( colname.equals("lecture_no"))
						lecture_no=Integer.parseInt((String)valtok.nextElement());
					if( colname.equals("date"))
						date=(String)valtok.nextElement();
				}	


				//System.out.println("insert into delete_lecture values('"+course_no+"',"+lecture_no+",to_date('"+date+"','"+format+"'))");
				stmt.executeUpdate("insert into delete_lecture values('"+course_no+"',"+lecture_no+",to_date('"+date+"','"+format+"'))");
			}				    
		}
		//stmt.close();
		en = request.getParameterNames();
		while(en.hasMoreElements()&& !parameter.equals("talk"))
			parameter=(String)en.nextElement();

		// case of talk
		if(parameter.equals("talk"))
		{
			int count=0;
			recordtok=new StringTokenizer(request.getParameter(parameter),",");
			while(recordtok.hasMoreElements())
			{ 

				row=(String)recordtok.nextElement();
				coltok=new StringTokenizer(row,";;");
				while(coltok.hasMoreElements())
				{
					colid=(String)coltok.nextElement();
					valtok=new StringTokenizer(colid,"=");   
					colname=(String)valtok.nextElement();
					if(colname.equals("talk_id"))
						talk_id=Integer.parseInt((String)valtok.nextElement());
				}  
				if(count==0)
					query="talk_id="+talk_id;
				else
					query+=" or talk_id="+talk_id;

				count++; 
			}	

			stmt.executeUpdate("delete from talk where "+query);
		}				    
		//stmt.close();
		en = request.getParameterNames();
		while(en.hasMoreElements()&& !parameter.equals("extralecture"))
			parameter=(String)en.nextElement();

		// case of extralecture


		if(parameter.equals("extralecture"))
		{
			//System.out.println("hi , came inside extra lecture");
			int count=0;
			recordtok=new StringTokenizer(request.getParameter(parameter),",");
			while(recordtok.hasMoreElements())
			{ 

				row=(String)recordtok.nextElement();
				coltok=new StringTokenizer(row,";;");
				while(coltok.hasMoreElements())
				{
					colid=(String)coltok.nextElement();
					valtok=new StringTokenizer(colid,"=");   
					colname=(String)valtok.nextElement();
					if(colname.equals("course_no"))
						course_no=(String)valtok.nextElement();
					if(colname.equals("extralecture_no"))
						extralecture_no=Integer.parseInt((String)valtok.nextElement());
				}  
				if(count==0)
					query=" (course_no='"+course_no+"' and extralecture_no="+extralecture_no+")";
				else
					query+=" or (course_no='"+course_no+"' and extralecture_no="+extralecture_no+")";

				count++; 
			}	
			//System.out.println("delete from extra_lecture where "+query);
			stmt.executeUpdate("delete from extra_lecture where "+query);
		}				    
		stmt.close();
	}     

	/** this function is to delete all the talk bookings of a user during a 
	 * specified period of time */
	public static void deleteTalkbookings(Connection con,String user_id,String start_date,String end_date,Interval intv) throws SQLException
{
	Statement stmt1=con.createStatement();
	Statement stmt2=con.createStatement();
	ResultSet rset;
	String query="";
	String booked_stime,booked_ftime;
	Interval booked_intv;
	int talk_id,count=0;
	start_date=sdf.format(string_To_Date(start_date));
	end_date=sdf.format(string_To_Date(end_date));

	//System.out.println("hi talk1 i am here");
	rset=stmt1.executeQuery("select * from talk_info where date_for_talk >="+
			"to_date('"+start_date+"','"+format+"') and "+
			"date_for_talk <="+
			"to_date('"+end_date+"','"+format+"') and "+
			"user_id='"+user_id+"'");

	//System.out.println("hi talk2 i am here");
	while(rset.next())
	{
		booked_stime=rset.getString("start_time");
		booked_ftime=rset.getString("end_time");
		booked_intv=new Interval(booked_stime,booked_ftime);
		talk_id=rset.getInt("talk_id");
		if(intv.intersects(booked_intv))
		{ 
			if(count==0)
				query=" talk_id="+talk_id;
			else
				query+=" or talk_id="+talk_id;
			count++;
		}
	}	   
	if(!query.equals(""))
		stmt2.executeUpdate("delete from talk where "+ query); 

	rset.close();
	stmt1.close();
	stmt2.close();

}			 
/** this function is to delete all the extra lecture bookings of a user during a 
 * specified period of time */
public static void deleteExtralecturebookings(Connection con,String user_id,String start_date,String end_date,Interval intv) throws SQLException
{
	Statement stmt1=con.createStatement();
	Statement stmt2=con.createStatement();
	ResultSet rset;
	String query="";
	String booked_stime,booked_ftime;
	String course_no;
	Interval booked_intv;
	int extralecture_no,count=0;
	start_date=sdf.format(string_To_Date(start_date));
	end_date=sdf.format(string_To_Date(end_date));

	rset=stmt1.executeQuery("select * from extra_lecture_info where date_for_extralecture >="+
			"to_date('"+start_date+"','"+format+"') and "+
			"date_for_extralecture <="+
			"to_date('"+end_date+"','"+format+"') and "+
			"user_id='"+user_id+"'");

	while(rset.next())
	{
		booked_stime=rset.getString("start_time");
		booked_ftime=rset.getString("end_time");
		course_no=rset.getString("course_no");
		booked_intv=new Interval(booked_stime,booked_ftime);
		extralecture_no=rset.getInt("extralecture_no");
		if(intv.intersects(booked_intv))
		{ 
			if(count==0)
				query=" (extralecture_no="+extralecture_no+" and course_no='"+course_no+"')";
			else
				query+=" or (extralecture_no="+extralecture_no+" and course_no='"+course_no+"')";
			count++;
		}
	}	   
	if(!query.equals(""))
		stmt2.executeUpdate("delete from extra_lecture where "+ query); 

	rset.close();
	stmt1.close();
	stmt2.close();

}			 


/**this function is to delete all the course commitments of a user during a 
  given period of time */
public static void deleteLecturebookings(Connection con,String user_id,String sdate,String fdate,Interval intv) throws SQLException
{
	Calendar cal=Calendar.getInstance();
	java.util.Date tempdate;
	Vector deleted_vec;
	Interval booked_intv;
	ResultSet rset;
	String booked_stime,booked_ftime,course_no;
	java.util.Date booked_sdate,booked_fdate;
	Statement stmt1=con.createStatement();
	Statement stmt2=con.createStatement();
	String day;
	int lecture_no,period;
	//System.out.println("hi lecture1 i am here");
	//System.out.println("select * from lecture_info where user_id='"+user_id+"'");
	rset=stmt1.executeQuery("select * from lecture_info where user_id='"+user_id+"'");
	//System.out.println("hi lecture2 i am here");
	while(rset.next())
	{
		booked_stime=rset.getString("start_time");
		booked_ftime=rset.getString("end_time");
		booked_sdate=(java.util.Date)rset.getDate("start_date");
		booked_fdate=(java.util.Date)rset.getDate("end_date");
		cal.setTime(booked_sdate);
		cal.clear();
		booked_sdate=cal.getTime();	   
		cal.setTime(booked_fdate);
		cal.clear();
		booked_fdate=cal.getTime();	   
		booked_intv=new Interval(booked_stime,booked_ftime);
		course_no=rset.getString("course_no");
		lecture_no=rset.getInt("lecture_no");
		period=rset.getInt("period");
		day=rset.getString("day");
		deleted_vec=deleted_Lecture_Table(con);
		if(intv.intersects(booked_intv))
		{
			tempdate=get_Firstdate(booked_sdate,day);
			cal.setTime(tempdate);
			cal.clear();
			tempdate=cal.getTime();	   
			while(tempdate.before(string_To_Date(sdate)))  
				tempdate=add_Days(tempdate,period*7);
			while(!((booked_fdate.before(tempdate))||((string_To_Date(fdate)).before(tempdate))))
			{	
				if(! is_Lecture_Deleted(deleted_vec,course_no,lecture_no,tempdate))
				{  
					stmt2.executeUpdate("insert into delete_lecture values('"+course_no+"',"+lecture_no+",to_date('"+sdf.format(tempdate)+"','"+format+"'))");
					//System.out.println("insert into delete_lecture values('"+course_no+"',"+lecture_no+",to_date('"+sdf.format(tempdate)+"','"+format+"'))");
				}     
				tempdate=add_Days(tempdate,period*7);
			}      
		}				 
	}
	rset.close();
	stmt1.close();
	stmt2.close();
}
}	
