package Utils;

import java.io.*;
import javax.servlet.http.*;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;

public class TimeTable{

	 /**this main program just gives a sample 2-dim array and 
	  * converts it to timetable type array.
	
		 scheme[0][0]="speaker";
		 scheme[0][1]="courseno";
		 scheme[0][2]="day";
		 scheme[0][3]="starttime";
		 scheme[0][4]="endtime";
		 */
		 
		 
	 
	

public static String[][][] MakeTimeTable(Vector table){
	String res[][]= new String[table.size()][((Vector)table.elementAt(0)).size()];
	for(int i=0;i<res.length;i++)
		for(int j=0;j<res[0].length;j++)
			res[i][j]=(String)((Vector)table.elementAt(i)).elementAt(j);
	return (MakeTimeTable(res));
}
	
	
	 
 public static String toHTML(String[][][] timetable,HttpServletResponse response) {
		  String htmlfile;                      
	      htmlfile="<html><head><title>Results</title></head>\n";
	      htmlfile=htmlfile+"<body bgcolor=white text=black align=center >";
	      htmlfile=htmlfile+"<table border  align=center>\n";
	      htmlfile=htmlfile+"<tr bgcolor=lightblue>\n";
		  for(int i=0;i<timetable[0].length;i++)
		  {
			   htmlfile=htmlfile+"<td>" + timetable[0][i][0] + "</td>";
		  }
		  htmlfile=htmlfile+"</tr>\n";
		  for(int i=1;i<timetable.length;i++)
		  {
			   htmlfile=htmlfile+"<tr>\n";
			   for(int j=0;j<timetable[0].length;j++)
			   {
					if(j==0)
						 htmlfile=htmlfile+"<td><center>"+timetable[i][j][0]+"</center></td>";
					else if(timetable[i][j][0].equals("-"))
						 	htmlfile=htmlfile+"<td><center>"+timetable[i][j][0]+"</center></td>";
						else
						 	htmlfile=htmlfile+"<td><center><A Href=\""+response.encodeUrl("/servlet/timetable?param=course&query=where(course_no='" +timetable[i][j][0]+"')")+"\">"+timetable[i][j][0]+"</A>/" + 
									timetable[i][j][2] + "/" +
								     "<A Href=\""+response.encodeUrl("/servlet/timetable?param=room&query=where(room_id='" +timetable[i][j][1]+"')")+"\">"+timetable[i][j][1]+"</A>" +
									"</center></td>";
			   }
			   htmlfile=htmlfile+"</tr>\n";
		  }
		  htmlfile=htmlfile+"</table>";
		  htmlfile=htmlfile+"</body></html>";
		  return(htmlfile);
 }
		  

	 
	 
	 
	/**this is the main functtion that takes as input the schema array
	  * and converts it to the timetable array*/
	 public static String[][][] MakeTimeTable(String[][] scheme) {
		String[][][] timetable=new String[6][8][4];
		int nrows = scheme.length;
		int ncols = scheme[0].length;
		int date=4;
		int course=2;
		int time=5;
		int room=7;
		int user=1;
		for(int i=0;i<6;i++)
		{
			for(int j=0;j<8;j++)
			{
				timetable[i][j][0]= "-";
			}
		}
		timetable[0][0][0]="day\\time";
		timetable[0][1][0]="8:30-9:30";
		timetable[0][2][0]="9:30-10:30";
		timetable[0][3][0]="10:30-11:30";
		timetable[0][4][0]="11:30-12:30";
		timetable[0][5][0]="2:00-3:00";
		timetable[0][6][0]="3:00-4:00";
		timetable[0][7][0]="4:00-5:00";
		for(int i=1;i<6;i++)
		{
			timetable[i][0][0]=no_To_Day(i);
		}
		for(int i=1;i<nrows;i++)
		{
			/**this takes each tuple of the schema array and makes the entry 
			 * corresponding to it in the timetable array ,the assignment is as
			 * timetable[day_in_this_tuple][slot_found_by_starttime]=course_no_of_this_tuple*/
			timetable[(SQLUtils.string_To_Date(scheme[i][date])).getDay()][SlotIs(scheme[i][time])][0]=scheme[i][course];
			timetable[(SQLUtils.string_To_Date(scheme[i][date])).getDay()][SlotIs(scheme[i][time])][1]=scheme[i][room];
			timetable[(SQLUtils.string_To_Date(scheme[i][date])).getDay()][SlotIs(scheme[i][time])][2]=scheme[i][user];
		}
		return(timetable);
	 }


	 /**simple function just to return the number corresponding to each time interval*/
	 public static int SlotIs(String time) {
		 int column=0;
		 if(time.equals("08:30"))
			 column=1;
		 if(time.equals("09:30"))
			 column=2;
		 if(time.equals("10:30"))
			 column=3;
		 if(time.equals("11:30"))
			 column=4;
		 if(time.equals("02:00"))
			 column=5;
		 if(time.equals("03:00"))
			 column=6;
		 if(time.equals("04:00"))
			 column=7;
		 return(column);
	 }

	 /** function for getting the String day corresponding to a number*/
	 public static String no_To_Day(int no)
	 {
		 String day;
		 switch(no)
		 {
			 case 0: day="Sun"; 
				    break;
			 case 1: day="Mon"; 
				    break;
			 case 2: day="Tue"; 
				    break;
			 case 3: day="Wed"; 
				    break;
			 case 4: day="Thu"; 
				    break;
			 case 5: day="Fri";
				    break;
			 case 6: day="Sat"; 
				    break;
			 default: System.out.println("Something wrong with the argument supplied to no_To_Day");
					day="error"; 
		 } 
		 return(day);

	 }  

	 /** function for getting the number corresponding to a day (String)*/
	 public static int day_To_no(String day)
	 {
		 int no=-1;
		 if(day.equals("Sun"))
			 no=0; 
		 if(day.equals("Mon")) 
			 no=1; 
		 if(day.equals("Tue")) 
			 no=2; 
		 if(day.equals("Wed")) 
			 no=3; 
		 if(day.equals("Thu"))
			 no=4; 
		 if(day.equals("Fri")) 
			 no=5; 
		 if(day.equals("Sat")) 
			 no=6; 

		 if(no==-1) 
			 System.out.println("Something wrong with the argument supplied to day_To_no");

		 return(no);

	 }  


}
