#!/usr/bin/perl -w
my $text;


open IN, "xslt.dtd";
read IN, $text, 5000000;
close IN;


$text =~ s/<!--.*?-->//sg;
$text =~ s/xsl://g;
$text =~ s/<!ELEMENT\s+(\S+)\s+EMPTY>/<element name="$1"\/>/g;
$text =~ s/<!ELEMENT\s+(\S+)\s+%(\S+);\s*>/<element name="$1" children="_$2"\/>/g;


my($tmp,@list);
@list = qw(URI pattern avt expr char );

foreach $tmp (@list) {
    $text =~ s/%$tmp;/CDATA/g;
    $text =~ s/<.*?%.*?$tmp.*?>//g;
    
}

@list = qw(qname priority);

foreach $tmp (@list) {
    $text =~ s/%$tmp;/NMTOKEN/g;
    $text =~ s/<.*?%.*?$tmp.*?>//g;
    
}

@list = qw(qnames);

foreach $tmp (@list) {
    $text =~ s/%$tmp;/NMTOKENS/g;
    $text =~ s/<.*?%.*?$tmp.*?>//g;
    
}


$text =~ s/<!ATTLIST\s+(\S+)\s+(\S+)\s+(\S+)\s+\#(\S+)\s*>/<attribute name="$2" element="$1" type="$3" occurence="$4"\/>/g;


while ($text =~ s/<!ATTLIST\s+(\S+)\s+(.*?)>/QQQQQQQQQ/s ) {
    my $name = $1;
    my $contents = '';
    
    my @lines = split(/\n/,$2);

    foreach $tmp (@lines) {
	$tmp =~ /\s*(\S+)\s+(\S+)\s\#(\S+)/;
	$contents = "$contents\n <attribute name='$1' element='$name' type='$2' occurence='$3' />";
    }
    
    $text =~ s/QQQQQQQQQ/$contents/;
 }

open OUT, ">xsltTransformed.dtd";
print OUT $text;
close OUT;


