import os,sys,re,tempfile

from cStringIO import StringIO

def htmlize(text):
    text=re.compile("&").sub("&amp;",text)
    text=re.compile("<").sub("&lt;",text)
    text=re.compile(">").sub("&gt;",text)
    text=re.compile(" ").sub("&nbsp;",text)
    text=re.compile(" ").sub("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",text)  #tab
    text=re.compile("\n").sub("<br>\n",text)
    return text


def uniqueSortedList(lst):
    lst.sort()

    try:
        out = [lst.pop(0)]
    except IndexError:
        return []

    try:
        while 1:
            item = lst.pop(0)
            if item != out[len(out)-1]:
                out.append(item)
    except IndexError:
        return out

        

def runXSLT(xml,xslt,html=''):
    saxon = "../../bin/saxon"
    sys.stdout.flush()
    if html: html = " -o "+html

    tempfile.tempdir="../WorkDir"
    errorFile = tempfile.mktemp()
    
    os.system(saxon + html+" "+xml+" "+xslt+" 2> "+errorFile)
    if os.path.getsize(errorFile) > 0:
        input = open(errorFile)
        data = input.read()
        input.close()
        print "<div class='error'>"
        try:
            error =  re.compile('WorkDir.*?:(.*)',re.S).search(data).group(1)
            print re.compile("java\..*?:").sub('',error)
        except AttributeError:
            print data
        print "</div>"
        
    try:
        os.unlink(errorFile)
    except IOerror:
        pass

## def printHeader(title):
##     print "Content-type: text/html\n\n"

##     print "<html><head><title>"+title+"</title>"
##     print "<link rel='stylesheet' type='text/css' href='/CSS/xsltBench.css'/>"
##     print "</head><body>"



## def menubar(name):
##     print "<table class='menu' width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td class='menu'>"
##     print "&nbsp;&nbsp;&nbsp;<a href='../../bin/index.py' class='menu'>index</a></td><td class='menuRight'><a href='/XSLTreference/Output/index.html' class='menu'>XSLT Reference</a>&nbsp;&nbsp;&nbsp;"
##     print "</td></tr></table>"
##     print "<h2>" + name + "</h2>"



## def printSource(source):
##     input = open(source)
##     data = input.read()
##     input.close()
##     print "<table cellpadding='10' width='100%' class='source'><tr><td class='source'>"+htmlize(data)+"</td></tr></table>"

## def sourceSelection(application,xmlSource,xpath=''):
##     printHeader("xlab: XPath")
##     menubar("X Lab - XML Source Selection")

##     dir = "../XML/"
##     outFile=xmlSource+".xml"
##     print "<table cellpadding='10' width='100%' class='input'><tr><td class='function'>Click on names to browse sources, when satisfied press <b>Submit</b>:<br><br>"
##     for f in os.listdir(dir):
##         hit = re.compile('(.*?)\.xml\Z').search(f)
##         if not hit: continue
##         print "<a class='index' href='"+application+".py?selectSource=1&xmlSource="+hit.group(1)+"&xpath="+xpath+"'>"+hit.group(1)+"</a> &nbsp;&nbsp;"

##     print "<form src='"+application+".py' method='post'>"
##     print "<input type='hidden' name='xmlSource' value='"+xmlSource+"'>"
##     print "<input type='hidden' name='xpath' value='"+xpath+"'>"
##     print "<input class='submit' type='submit' value='  Submit  '>"
##     print "</form>"
##     print "</td></tr></table>"

##     printSource(dir+outFile)
##     print "<hr>"
##     zvon.printAuthor('nicmila')
##     zvon.printZvonLink()

##     print "</body></html>"




