#!/usr/bin/python

## XSLT Reference
## Copyright (C) 2000 Miloslav Nic (nicmila@idoox.com)
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License
## as published by the Free Software Foundation; either version 2
## of the License, or (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import os

os.system("saxon -o ../Output/elementIndex.html ../Data/xsltElements.xml   ../XSLT/elementIndex.xslt")
os.system("saxon -o ../Output/xpathFunctionIndex.html ../Data/xpathFunctions.xml   ../XSLT/functionIndex.xslt")
os.system("saxon -o ../Output/axesIndex.html ../Data/axes.xml   ../XSLT/axesIndex.xslt")

frame=open("../Output/index.html","w")
frame.write("""
<html>
 <head>
   <title>XSLT Reference</title>
 </head>
  <frameset cols="250,*">
    <frame name="mainIndex" src="elementIndex.html">
    <frame name="mainWindow" src="introduction.html">
  </frameset>
</html>
""")
frame.close()

introduction=open("../Output/introduction.html","w")
introduction.write("""
<html><head><link rel="stylesheet" type="text/css" href="../CSS/style.css"/></head><body>
<h3>Miloslav Nic [<a href="mailto:nicmila@idoox.com">nicmila@idoox.com</a>]</h3>
<h2>XSLT Reference</h2>
<h3>Main features</h3>
<ul>
<li>Names of elements, attributes, functions, and axes in XSLT stylesheets are clickable</li>
<li>Click on "Go to standard" leads to the relevant part of the specification</li>
<li>Where applicable, links to interactive X Lab enable practicing of the given topic</li>
</ul>
<h3>Contributors welcomed</h3>
<p>If you have a stylesheet or an XML source document, which you feel suitable for this reference,  please send it to me. Your name will be listed under your contribution. I would also like to extend this reference in the near future. If you would like to see some other feature here, please ask.</p>
<h3>Zvon</h3>
<p>This reference has been developed for <a href="http://www.zvon.org">Zvon</a>, where you can find  other not only  XML related materials (both basic and advanced tutorials about XSLT, XML, DTD, Mozilla, CSS, regular expressions, ...) </p>
<h3>Download</h3>
<p>The reference including xslt and python sources can be downloaded at <a href="http://www.zvon.org/downloads/xsltReference.zip">www.zvon.org/downloads/xsltReference.zip</a></p>
<hr>
Generated with <a href="http://users.iclway.co.uk/mhkay/saxon/index.html">Saxon</a> and <a href="http://www.python.org">Python</a>
<hr>
Copyright (c) 2000 <a href='www.idoox.com'>IDOOX</a><br>
      Permission is granted to copy, distribute and/or modify this document
      under the terms of the GNU Free Documentation License, Version 1.1
      or any later version published by the Free Software Foundation;
      with no Invariant Sections with the no Front-Cover Texts, and with no Back-Cover Texts.
      A copy of the license is included in the section entitled <a href="../GNU/fdl.html">"GNU
      Free Documentation License"</a>.

<hr>
The programs used to prepare this reference are covered by
<a href="../GNU/gpl.html">"GNU General Public License"</a>
</body></html>
""")
introduction.close()


