<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" version="1.0"> 

<xsl:import href="headers.xslt"/>

<xsl:variable name="css">../CSS/style.css</xsl:variable>

<xsl:output method="html"/>

<xsl:template match="/">
  <html>
    <head>
      <link rel="stylesheet" type="text/css" href="{$css}"/> 
    </head>
    <body>
      <xsl:call-template name="index-header">
	<xsl:with-param name="on">axes</xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates select="//axis">
	<xsl:sort select="@name"/>
      </xsl:apply-templates>
    </body>
  </html>
</xsl:template>


<xsl:template match="axis">
  <div>
    <a href="axis_{@name}.html" target="mainWindow"><xsl:value-of select="@name"/></a>
  </div>

    <saxon:output file="../Output/axis_{@name}.html">
    <html>
      <head>
	<link rel="stylesheet" type="text/css" href="{$css}"/> 
      </head>
      <body>
	<xsl:call-template name="description-header">
	  <xsl:with-param name="standard">xpath.html#axes</xsl:with-param>
	</xsl:call-template>
	<h2>
	  <span class="axis"><xsl:value-of select="@name"/>
	  <xsl:text>::</xsl:text></span>
	</h2>
	<p>
	  <xsl:apply-templates select="attribute"/></p>
	  <h3>Standard excerpt:</h3>
	  <xsl:value-of select="standard"/>
	  <hr/>
	  <b>Examples (xslt:xml): </b> 
	  <a href='../OutputOverview/axis_{@name}_frame.html'>Overview</a><br/>
	  <xsl:comment>AllStart</xsl:comment>
	  <xsl:comment>AllEnd</xsl:comment>
	  <p><b>Interactive xlab: </b>
	  <xsl:apply-templates select="document('../Data/xlab.xml')/xlab/xl[axes]"/>
	</p>
	</body>
    </html>
  </saxon:output>
</xsl:template>

<xsl:template match="xl[axes]">
  <a href="{@url}" target='_blank'> [<xsl:value-of select="@name"/>] </a>
</xsl:template>



</xsl:stylesheet>



