<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" version="1.0"> 

<xsl:import href="headers.xslt"/>

<xsl:variable name="css">../CSS/style.css</xsl:variable>

<xsl:output method="html"/>

<xsl:template match="/">
  <html>
    <head>
      <link rel="stylesheet" type="text/css" href="{$css}"/>
    </head>
    <body>
      <xsl:call-template name="index-header">
	<xsl:with-param name="on">element</xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates select="//element">
	<xsl:sort select="@name"/>
      </xsl:apply-templates>
    </body>
  </html>
</xsl:template>


<xsl:template match="element">
  <div>
    <a href="xslt_{@name}.html" target="mainWindow"><xsl:value-of select="@name"/></a>
  </div>

    <saxon:output file="../Output/xslt_{@name}.html">
    <html>
      <head>
	<link rel="stylesheet" type="text/css" href="{$css}"/> 
      </head>
      <body>
	<xsl:call-template name="description-header">
	  <xsl:with-param name="standard"><xsl:value-of select="concat('xslt.html#',@standardAnchor)"/></xsl:with-param>
	</xsl:call-template>
	<table><tr>
	  <td><span class="element">&lt;<xsl:value-of select="@name"/>&gt;</span></td></tr>
	  <xsl:if test="attribute">
	    <tr><td class="el-attr">attributes:
	      <xsl:apply-templates select="attribute"/></td></tr>
	    </xsl:if>
	    <xsl:if test="@children">
	    <tr><td class="el-attr">child elements:
	      <xsl:call-template name="children">
		<xsl:with-param name="data"><xsl:value-of select="@children"/></xsl:with-param>
	      </xsl:call-template>
	    </td></tr>
	  </xsl:if>
	  <tr><td class="el-attr">Standard excerpt:</td></tr>
	  <tr><td colspan="2">
	    <xsl:value-of select="standard"/>
	    <hr/>
	  <b>Examples (xslt:xml): </b> 
	  <a href='../OutputOverview/xslt_{@name}_frame.html'>Overview</a><br/>
	  <xsl:comment>AllStart</xsl:comment>
	  <xsl:comment>AllEnd</xsl:comment>
	  <p><b>Interactive xlab: </b>
	  <xsl:apply-templates select="document('../Data/xlab.xml')/xlab/xl/element[@name=current()/@name]"/>
	</p>
	  </td></tr></table>
	
      </body>
    </html>
  </saxon:output>
</xsl:template>

<xsl:template match="element" mode="exampleLink">
  <xsl:variable name="sourceXML">
    <xsl:value-of select="document('../WorkDir/elementIndex.xml')/index/example[@xslt=current()/@xslt]/@sourceXML"/>
  </xsl:variable>
  <a target="_blank"  href="example_{$sourceXML}_{@xslt}_frame.html"><xsl:value-of select="@xslt"/></a>
  <xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="attribute">
  <a class="{@occurence}" href="../Output/xslt_{parent::element/@name}_{@name}.html"><xsl:value-of select="@name"/></a>
  <xsl:if test="not(last()=position())">, </xsl:if>
    
    <saxon:output file="../Output/xslt_{parent::element/@name}_{@name}.html">
    <html>
      <head>
		<link rel="stylesheet" type="text/css" href="{$css}"/> 
      </head>
      <body>
	<xsl:call-template name="description-header">
	  <xsl:with-param name="standard"><xsl:value-of select="concat('xslt.html#',@standardAnchor)"/></xsl:with-param>
	</xsl:call-template>
	<br/>
	<div>
	  <a href="xslt_{parent::element/@name}.html" class="element"><xsl:value-of select="concat('&lt;',parent::*/@name,'&gt;')"/></a>
	  <xsl:text> : </xsl:text>
	  <span class="attribute"><xsl:value-of select="@name"/></span>
	</div>
	  
	  <h3>Standard excerpt:</h3>
	  <xsl:value-of select="standard"/>
	  <hr/>
	  <b>Examples (xslt:xml): </b> 
	  <a href='../OutputOverview/xslt_{parent::element/@name}_{@name}_frame.html'>Overview</a><br/>
	  <xsl:comment>AllStart</xsl:comment>
	  <xsl:comment>AllEnd</xsl:comment>

	  <p><b>Interactive xlab: </b>
	  <xsl:apply-templates select="document('../Data/xlab.xml')/xlab/xl/element[@name=current()/parent::element/@name]/attribute[normalize-space(.)=current()/@name]"/>
	</p>
	</body>
      </html>
    </saxon:output>

</xsl:template>

<xsl:template match="xl/element/attribute | xl/element">
  <a href="{ancestor::xl/@url}" target='_blank'> [<xsl:value-of select="ancestor::xl/@name"/>] </a>
</xsl:template>

<xsl:template name="children">
  <xsl:param name="data"/>
  <xsl:variable name="first">
    <xsl:choose>
      <xsl:when test="contains($data,' ')">
	<xsl:value-of select="substring-before($data,' ')"/>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="$data"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="rest">
    <xsl:value-of select="substring-after($data,' ')"/>
  </xsl:variable>

  <xsl:if test="not($first='')">
    <xsl:text> </xsl:text>
    <a class="element" href="xslt_{$first}.html"><xsl:value-of select="$first"/></a>
  </xsl:if>

  <xsl:if test="not($rest='')">
    <xsl:call-template name="children">
      <xsl:with-param name="data"><xsl:value-of select="$rest"/></xsl:with-param>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>












