<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" version="1.0"> 

<xsl:output method="html"/>
<xsl:variable name="css">../CSS/style.css</xsl:variable>
<xsl:param name="xml"/>
<xsl:param name="xslt"/>

<xsl:preserve-space elements="xsl:text"/>

<xsl:template match="/">
  
    <html>
      <head>
	<link rel="stylesheet" type="text/css" href="{$css}"/>
	<title>xml <xsl:value-of select="concat($xslt,':',$xml)"/></title>
      </head>
      <body>
	<xsl:call-template name="menu"/>
	<xsl:apply-templates mode="xmlPrint"/>
	<hr/>
	<xsl:text>Author: </xsl:text>
	<xsl:apply-templates select="document('../Data/authors.xml')/authors/author[email = current()/*/@author]" mode="author"/>
      </body>
    </html>

  <saxon:output file="../WorkDir/xslt.html">
    <html>
      <head>
	<link rel="stylesheet" type="text/css" href="{$css}"/>
	<title>xslt <xsl:value-of select="concat($xslt,':',$xml)"/></title>
      </head>
      <body>
	<xsl:call-template name="menu"/>
	<xsl:apply-templates select="document('../WorkDir/xslt.xslt')" mode="xsltPrint"/>
	<hr/>
	<xsl:text>Author: </xsl:text>
	<xsl:apply-templates select="document('../Data/authors.xml')/authors/author[email = document('../WorkDir/xslt.xslt')/*/@author]" mode="author"/>
      </body>
    </html>
  </saxon:output>

  <saxon:output file="../WorkDir/xsltIndexes.dat">
	<xsl:apply-templates select="document('../WorkDir/xslt.xslt')" mode="xsltIndex"/>
  </saxon:output>
</xsl:template>

<xsl:template match="*" mode="xsltIndex">
  <xsl:if test="namespace-uri()='http://www.w3.org/1999/XSL/Transform'">
    <xsl:value-of select="local-name()"/><xsl:text> --- </xsl:text>
    <xsl:for-each select="@*">
      <xsl:value-of select="name()"/><xsl:text> </xsl:text>
    </xsl:for-each>
    <xsl:text>
    </xsl:text>
  </xsl:if>
  <xsl:apply-templates mode="xsltIndex"/>
</xsl:template>

<xsl:template match="text()" mode="xsltIndex"/>

<xsl:template name="menu">
<table width="100%" class="menu" cellspacing='0' cellpadding='0' border='0'><tr>
	  <td>
	    &#160;&#160;&#160;<a class="menu" href="javascript:back()">back</a>
	    &#160;&#160;&#160;<a class="menu" href="example_{$xml}_{$xslt}_frame.html" target="_top">all</a>
	    &#160;&#160;&#160;<a class="menu" href="example_{$xml}_{$xslt}_xml.html" target="_top">xml</a>
	    &#160;&#160;&#160;<a class="menu" href="example_{$xml}_{$xslt}_xslt.html" target="_top">xslt</a>
	    &#160;&#160;&#160;<a class="menu" href="example_{$xml}_{$xslt}_result.html" target="_top">out</a>
	  </td>
	  <td class="right"><span class="menu">
	    <xsl:value-of select="concat($xslt,':',$xml)"/>
	  </span>&#160;&#160;&#160;</td>
	</tr></table>
</xsl:template>

<xsl:template match="author" mode="author">
  <xsl:value-of select="concat(firstName,' ',surname, ' [')"/>
  <a href="mailto:{email}" class="mailto"><xsl:value-of select="email"/></a>
  <xsl:text>]</xsl:text>
</xsl:template>

<!-- XML print  -->

<xsl:template match="*" mode="xmlPrint">
<xsl:param name='tab'>&#160;&#160;&#160;&#160;&#160;</xsl:param>
<br/>
<xsl:if test="name()='xsl:template'"><br/></xsl:if>

<xsl:value-of select="$tab"/>
<xsl:choose>
<xsl:when test='node()'>
  <xsl:text>&lt;</xsl:text>
<span class="element"><xsl:value-of select="name()"/></span>
<xsl:if test="@*[not(name()='author')]">
  <xsl:text> </xsl:text>
</xsl:if>
<xsl:apply-templates select="@*" mode="xmlPrint"/>
<xsl:text>&gt;</xsl:text>

<xsl:apply-templates mode="xmlPrint">
<xsl:with-param name="tab"><xsl:value-of select="concat($tab,'&#160;&#160;&#160;&#160;&#160;')"/></xsl:with-param>
</xsl:apply-templates>

<xsl:if test="*"><br/><xsl:value-of select="$tab"/></xsl:if>

&lt;/<span class="element"><xsl:value-of select="name()"/></span>&gt;
</xsl:when>
<xsl:otherwise>
  <xsl:text>&lt;</xsl:text>
<span class="element"><xsl:value-of select="name()"/></span>

<xsl:if test="@*[not(name()='author')]">
  <xsl:text> </xsl:text>
</xsl:if>

<xsl:if test="not(namespace-uri()='')">
  <span class="namespace">
  <xsl:text> xmlns:</xsl:text>
  <xsl:value-of select="substring-after(namespace-uri(),'org/')"/>
  <xsl:text> = "</xsl:text>
  <xsl:value-of select="namespace-uri()"/>
  <xsl:text>" </xsl:text>
</span>
</xsl:if>

<xsl:if test="@*[not(name()='author')]">
  <xsl:text> </xsl:text>
</xsl:if>
<xsl:apply-templates select="@*" mode="xmlPrint"/>/&gt;
</xsl:otherwise>
</xsl:choose>

</xsl:template>

<xsl:template match="@*" mode="xmlPrint">
<xsl:if test="position() mod 3 = 0"> <br/> </xsl:if>
<span class="attribute"><xsl:value-of select="name()"/></span>
=
"<span class="attValue"><xsl:value-of select="."/></span><xsl:text>" </xsl:text>
</xsl:template>


<xsl:template match="/*/@author" mode="xmlPrint"/>

<xsl:template match="comment()" mode="xmlPrint">
  <br/>
  <xsl:text>&lt;!-- </xsl:text>  
  <xsl:value-of select="."/>
  <xsl:text> --&gt;</xsl:text>
</xsl:template>

<xsl:template match="processing-instruction()" mode="xmlPrint">
  <br/>
  <xsl:text>&lt;?</xsl:text>
  <xsl:value-of select="concat(name(),' ',.)"/>
  <xsl:text> ?&gt;</xsl:text>
</xsl:template>

<!--  XSLT print  -->


<xsl:template match="*" mode="xsltPrint">
  <xsl:param name='tab'>&#160;&#160;&#160;&#160;&#160;</xsl:param>
  <br/>
  <xsl:if test="name()='xsl:template'"><br/></xsl:if>
  
  <xsl:value-of select="$tab"/>
  <xsl:choose>
    <xsl:when test='node()'>
      <xsl:text>&lt;</xsl:text>
      <xsl:choose>
	<xsl:when test="namespace-uri()='http://www.w3.org/1999/XSL/Transform'">
	  <a href="../Output/xslt_{local-name()}.html" class="element"><xsl:value-of select="name()"/></a>
	</xsl:when>
	<xsl:otherwise><span class="nonXSLTelement"><xsl:value-of select="name()"/></span></xsl:otherwise>
      </xsl:choose>
      <xsl:if test="name()='xsl:stylesheet' ">
	<span class="namespace">
	  <xsl:text> xmlns:xsl = "http://www.w3.org/1999/XSL/Transform"</xsl:text> </span>
	  
	  <xsl:if test="@extension-element-prefixes">
	    <span class="namespace">
	      <xsl:text> xmlns:saxon = "http://icl.com/saxon" </xsl:text> </span>
	  </xsl:if>

	  <xsl:if test="/*/xsl:namespace-alias">
	    <span class="namespace">
	      <xsl:text> xmlns:alias = "alias-namespace" </xsl:text> </span>
	  </xsl:if>
	</xsl:if>
	<xsl:text> </xsl:text><xsl:apply-templates select="@*" mode="xsltPrint">
	  <xsl:with-param name="tab"><xsl:value-of select="$tab"/></xsl:with-param>
	</xsl:apply-templates>
	<xsl:text>&gt;</xsl:text>
	
	<xsl:choose>
	  <xsl:when test="name()='xsl:text'">XXTEXT<xsl:value-of select="."/>YYTEXT</xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates mode="xsltPrint">
	      <xsl:with-param name="tab"><xsl:value-of select="concat($tab,'&#160;&#160;&#160;&#160;&#160;')"/></xsl:with-param>
	    </xsl:apply-templates>
	  </xsl:otherwise>
	</xsl:choose>
	
	  
	<xsl:if test="*">
	  <br/><xsl:value-of select="$tab"/></xsl:if>
	  <xsl:text>&lt;/</xsl:text>
	  <xsl:choose>
	    <xsl:when test="namespace-uri()='http://www.w3.org/1999/XSL/Transform'">
	      <a href="../Output/xslt_{local-name()}.html" class="element"><xsl:value-of select="name()"/></a>
	    </xsl:when>
	    <xsl:otherwise><span class="nonXSLTelement"><xsl:value-of select="name()"/></span></xsl:otherwise>
	  </xsl:choose>
	  <xsl:text>&gt;</xsl:text>
	
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>&lt;</xsl:text>
	  <xsl:choose>
	  <xsl:when test="namespace-uri()='http://www.w3.org/1999/XSL/Transform'">
	    <a href="../Output/xslt_{local-name()}.html" class="element"><xsl:value-of select="name()"/></a>
	  </xsl:when>
	  <xsl:otherwise><span class="nonXSLTelement"><xsl:value-of select="name()"/></span></xsl:otherwise>
	</xsl:choose>
	
	<xsl:text> </xsl:text>
	<xsl:apply-templates select="@*" mode="xsltPrint">
	  <xsl:with-param name="tab"><xsl:value-of select="$tab"/></xsl:with-param>
	</xsl:apply-templates>
	<xsl:text>/&gt;</xsl:text>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:template>

<xsl:template match="@*" mode="xsltPrint">
  <xsl:param name="tab"/>
  <xsl:if test="position() mod 3 = 0"> 
    <br/><xsl:value-of select="concat('&#160;&#160;&#160;&#160;&#160;',$tab)"/>
  </xsl:if>
      <xsl:choose>
	<xsl:when test="namespace-uri(parent::*)='http://www.w3.org/1999/XSL/Transform'">
	  <a href="../Output/xslt_{local-name(parent::*)}_{local-name()}.html" class="attribute"><xsl:value-of select="name()"/></a>
	</xsl:when>
	<xsl:otherwise><span class="nonXSLTattribute"><xsl:value-of select="name()"/></span></xsl:otherwise>
      </xsl:choose>
      <xsl:text> = </xsl:text>
"<span class="attValue">XyX<xsl:value-of select="."/>YxY</span><xsl:text>" </xsl:text>
</xsl:template>

<xsl:template match="xsl:import/@href | xsl:include/@href" mode="xsltPrint">
  <xsl:variable name="xslt">
    <xsl:value-of select="substring-before(substring-after(.,'xslt'),'.')"/>
  </xsl:variable>
  <a href="../Output/xslt_{local-name(parent::*)}_{local-name()}.html" class="attribute"><xsl:value-of select="name()"/></a>
=
  "<a class="href" href="example_{$xml}_{$xslt}_xslt.html"><xsl:value-of select="."/></a>"
</xsl:template>

<xsl:template match="xsl:stylesheet/@author" mode="xsltPrint"/>
</xsl:stylesheet>







