<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" version="1.0"> 

<xsl:import href="headers.xslt"/>

<xsl:variable name="css">../CSS/style.css</xsl:variable>

<xsl:output method="html"/>

<xsl:template match="/">
  <html>
    <head>
      <link rel="stylesheet" type="text/css" href="{$css}"/> 
    </head>
    <body>
      <xsl:call-template name="index-header">
	<xsl:with-param name="on">function</xsl:with-param>
      </xsl:call-template>

      <xsl:apply-templates select="//function | document('../Data/xsltFunctions.xml')//function">
	<xsl:sort select="@name"/>
      </xsl:apply-templates>
    </body>
  </html>
</xsl:template>


<xsl:template match="function">
  <div>
    <a href="function_{@name}.html" target="mainWindow"><xsl:value-of select="@name"/></a>
  </div>

    <saxon:output file="../Output/function_{@name}.html">
    <html>
      <head>
	<link rel="stylesheet" type="text/css" href="{$css}"/> 
      </head>
      <body>
	<xsl:variable name="st">
	  <xsl:choose>
	    <xsl:when test="starts-with(name(/*),'xslt')">xslt</xsl:when>
	    <xsl:otherwise>xpath</xsl:otherwise>
	  </xsl:choose>
	</xsl:variable>
	<xsl:call-template name="description-header">
	  <xsl:with-param name="standard">
	    <xsl:value-of select="concat($st,'.html#',@standardAnchor)"/>
	  </xsl:with-param>
	</xsl:call-template>
	<h2>
	  <span class="return"><xsl:value-of select="@return"/></span> <xsl:text> </xsl:text>
	  <span class="name"><xsl:value-of select="@name"/></span>  <xsl:text> (</xsl:text>
	  <xsl:apply-templates select="argument"/>
	  <xsl:text>) [</xsl:text>
	  <xsl:value-of select="$st"/>
	  <xsl:text>]</xsl:text>

	</h2>
	<p>
	  <xsl:apply-templates select="attribute"/></p>
	  <h3>Standard excerpt:</h3>
	  <xsl:value-of select="standard"/>
	  <hr/>
	  <b>Examples (xslt:xml): </b> 
	  <a href='../OutputOverview/function_{@name}_frame.html'>Overview</a><br/>
	  <xsl:comment>AllStart</xsl:comment>
	  <xsl:comment>AllEnd</xsl:comment>
	  <p><b>Interactive xlab: </b>
	    <xsl:apply-templates select="document('../Data/xlab.xml')/xlab/xl/function[normalize-space(.)=current()/@name]"/>
	    <xsl:apply-templates select="document('../Data/xlab.xml')/xlab/xl/functions"/>
	</p>
	</body>
    </html>
  </saxon:output>
</xsl:template>

<xsl:template match="xl/function | xl/functions">
  <a href="{../@url}" target='_blank'> [<xsl:value-of select="../@name"/>] </a>
</xsl:template>

<xsl:template match="argument">
  <span class="argument"><xsl:value-of select="@type"/>
  <xsl:if test="@occur='zero-multiple'">*</xsl:if>
  <xsl:if test="@occur='zero-once'">?</xsl:if>

</span>
  <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>



