#
# poker makefile
# Time-stamp: <97/01/28 14:32:48 dcl3a>
# Author: Devon Lockwood
#


#
# The following directives let make know that you may be using files
# with a cpp extension.
#

.SUFFIXES:
.SUFFIXES: .cpp $(SUFFIXES)


#
# You may have to set the directories so that are appropiate for 
# your account.
#

CCC       = CC
RANDOMDIR = ../../EzWindows


# The CPPFLAGS macro lets the compiler know where to find include files 
#

CPPFLAGS=-I$(RANDOMDIR)/include -DUSING_CC


#
# The LDFLAGS macro lets the linker know where to find library files
#

LDFLAGS=-L$(RANDOMDIR)/lib -lrandom


#
# The OBJS macro tells the compiler which object files need to be present 
# to link your program into an executable. 
#

OBJS=card.o deck.o poker.o pokemain.o


#
# The following sequence of commands defines a target for the program 
# executable.
#

poker: $(OBJS)
	$(CCC) -o poker $(OBJS) pokehelp.o $(LDFLAGS)


#
# The target below indicates to make how to process files with a cpp 
# extension. Normally this is necessary but the cpp extension isn't 
# defined for make.
#

.cpp.o:
	$(CCC) $(CPPFLAGS) -c $< 


#
# As a standard practice, a clean target is included in most make files.
# By executing 'make clean', all object files, backup files, and the 
# executable are deleted.
#

clean:
	rm -f $(OBJS) *~ poker



