#
# BugHunt makefile
# Time-stamp: <97/01/25 20:30:06 dcl3a>
# Author: Devon Lockwood
#


#
# The following directives let make know that you may be using files
# with a cpp extension.
#

.SUFFIXES:
.SUFFIXES: .cpp $(SUFFIXES)


#
# You may have to set the directories so that are appropiate for 
# your account.
#

CC       = CC
EZWINDIR = ../EzWindows
X11DIR   = /X11.6


#
# The CPPFLAGS macro lets the compiler know where to find include files 
#

CPPFLAGS=-I$(X11DIR)/include -I$(EZWINDIR)/include


#
# The LDFLAGS macro lets the linker know where to find library files
#

LDFLAGS=-L$(X11DIR)/lib -lX11 -lsocket \
	-L$(EZWINDIR)/lib -lezwin -lXpm


#
# The OBJS macro tells the compiler which object files need to be present 
# to link your program into an executable. 
#

OBJS=bughunt.o control.o bug.o


#
# The following sequence of commands defines a target for the program 
# executable.
#

default:
	make BugHunt


BugHunt: $(OBJS)
	$(CC) -o BugHunt $(OBJS) $(LDFLAGS) 


#
# The target below indicates to make how to process files with a cpp 
# extension. Normally this is necessary but the cpp extension isn't 
# defined for make.
#

.cpp.o:
	$(CC) $(CPPFLAGS) -c $< 


#
# As a standard practice, a clean target is included in most make files.
# By executing 'make clean', all object files, backup files, and the 
# executable are deleted.
#

clean:
	rm -f *.o *~ BugHunt
