#
# poker obj makefile
# Author: Jack Davidson
#


#
# The following directives let make know that you may be using files
# with a cpp extension.
#

.SUFFIXES:
.SUFFIXES: .cpp $(SUFFIXES)


#
# You may have to set the directories so that are appropiate for 
# your account.
#

CC       = CC
CHAP10   = ../../../../Student/chap10
INCLUDE  = ../../../../Student/EzWindows/include
CPPFLAGS=-I$(CHAP10)/poker -I$(INCLUDE) -DUSING_CC

#
# The following sequence of commands defines a target for the program 
# executable.
#

pokehelp.o: pokehelp.cc
	$(CC) $(CPPFLAGS) -c pokehelp.cc
	cp pokehelp.o $(CHAP10)/poker/pokehelp.o
	cp -r Templates.DB $(CHAP10)/poker

#
# The target below indicates to make how to process files with a cpp 
# extension. Normally this is necessary but the cpp extension isn't 
# defined for make.
#

.cpp.o:
	$(CC) $(CPPFLAGS) -c $< 


#
# As a standard practice, a clean target is included in most make files.
# By executing 'make clean', all object files, backup files, and the 
# executable are deleted.
#

clean:
	rm -f *.o *~ 
	rm -r -f Templates.DB

