#include <assert.h>
#include "ezwin.h"
#include "bitmap.h"
#include <cstring>
#include <iostream>
#include <fstream>
#include <cstdio>
#include <cstdlib>
#include <cmath>

using namespace std;

SimpleWindow w("Snake Returns", 23.0, 14.0, Position(2.0, 2.0));

SimpleWindow menu("Snake Returns", 23, 14, Position(2,2));
SimpleWindow exitDialog("Exit", 6, 3, Position(9, 4));
SimpleWindow go("Gave Over", 10, 8, Position(6,3));


/* Variable Description:

snake      : array to represent snake
map        : array to represent the map on which the snake moves
hs         : array to store the high scores
lvlReached : array to store the level reached corresponding to high scores
level      : represents the level on which user is playing
subLevel   : represents the number of fruits eaten (length of the snake)
lives      : represents the number of tries a player gets 
delay      : represents the time delay between calling the functions
xSnake, ySnake : represent the co-ordinates of the snake's head
dir        : represents the direction of the snake(initially right)
str        : represents the string in which digits of a high score will be stored
xFruit, yFruit : represents the coordinates of the fruit
xBonusFruit, yBonusFruit : represents the coordinates of the bonus fruit
gameScore  : score of the player in a game
levelScore : score of the player in a level 
distanceCount: distance travelled by the snake to take the fruit
bonusDistanceCount: distance travelled by  the snake to take the bonus fruit
leastDistance : minimum distance a snake has to travel to take the fruit
bonusLeastDistance : minimum distance a snake has to travel t
center     : center of the window
menuMode   :represents the simple windows to be opened at mouseclicks
subLevelChange:boolean variable which stores whether sublevel changed or not
bonusFruitPresence:boolean variable which stores whether bonus fruit is present or not
head       : head of the snake
body       : body of the snake
*/ 

int snake[30][2];
int map[40][28];
int hs[5], lvlReached[5];
int level=0, subLevel=0, lives=3;
int delay=250;
int xSnake=0, ySnake=0;				
char dir = 'R';
char str[100];
int xFruit=0, yFruit=0, xBonusFruit=0, yBonusFruit=0;
long distanceCount=0, bonusDistanceCount=0, leastDistance=0, bonusLeastDistance=0;
int gameScore=0, levelScore=0;
int menuMode=1;
bool subLevelChange=false, bonusFruitPresence=false;
Position center=w.GetCenter();
BitMap head(w);
BitMap body(w);
BitMap fruit(w);
BitMap bonusFruit(w);
BitMap wall(w);
BitMap life(w);
BitMap noLife(w);

BitMap background(menu);
BitMap newGame(menu);
BitMap highScore(menu);
BitMap help(menu);
BitMap credit(menu);
BitMap ext(menu);
BitMap yes(exitDialog);
BitMap no(exitDialog);
BitMap back(menu);
BitMap instr(menu);
BitMap credits(menu);
BitMap go1(go);

/* Function Description:

prepLevel   : function to design the level
playgame    : function for the basic gameplay
move        : function to move the snake 
turn        : function to turn the snake direction according to mouse click 
randomCood  : function to generate the random co-ordinates of the fruit
loadMap     : function to load the bitmap images of the level
plotFruit   : function to plot the fruit randomly
mouseClick  : function to be invoked when a mouse click event occurs
timerClick  : function to be invoked repeatedly after certain time
check       : function to check for head crash
plotBonusFruit:function to plot the bonus fruit randomly
handleBonusFruit:function to deal with bonus fruit presence
addscore    :function to calculate new score when snake eats the fuit
scorePane   :function to handle the score pane
itoa        :function to convert integer to string
menuClick   :function to invoke when mouse is clicked on main menu
exitDialogClick:function to exit the game on mouse click
loadMenu:function to load the menu
mainMenu:function to handle mouse clicks on main menu
startGame:function to start the game
exitMenu:function to exit from main menu screen
hsDisplay:function to display the high score
loadHS:function to load the high score window
instruction:function to load the instruction window
creditLoad:function to load the credits window
gameOver:function toend the game
chkScore:function to compare player score with high scores


*/

int prepLevel();
int playGame();
int move();
int turn();
int randomCood(int l);
int loadMap();
int plotFruit();
int mouseClick(const Position &p);
int timerClick();
int check();
int plotBonusFruit();
int handleBonusFruit();
int addScore(char a);
int scorePane(char b);
int itoa(int);

int menuClick(const Position &p);
int exitDialogClick(const Position &p);
int loadMenu();
int mainMenu();
int startGame();
int exitMenu();
int hsDisplay();
int loadHS();
int instruction();
int creditLoad();
int gameOver();
int gameOverClick(const Position &p);
int chkScore();


// main program
int ApiMain()
{	
	loadHS();
	menu.Open();
	loadMenu();
	mainMenu();
	return 0;


	/*



	//initialization of the co-ordinates of the head, body and tail of the snake
	//snake[1][0]=18;snake[1][1]=13;snake[0][0]=19;snake[0][1]=13;snake[2][0]=17;snake[2][1]=13;
	//opening the game window
	w.Open();
	assert(w.GetStatus()==WindowOpen);
	
	//loading the images of the head, body and tail
	head.Load("headR.xpm");
	assert(head.GetStatus()==BitMapOkay);
	body.Load("body.xpm");
	assert(body.GetStatus()==BitMapOkay);
	wall.Load("./walls/wall.xpm");
	bonusFruit.Load("./fruits/bonus.xpm");
	life.Load("life.xpm");
	noLife.Load("noLife.xpm");
	
	//starting the game
	playGame();
	return 0;
	
	
	*/
}

int loadMenu()
{

	//load the images on the opening screen
	
	background.Load("./menu/wall1.xpm");
	background.SetPosition(Position(1,0));
	
	newGame.Load("./menu/newGame.xpm");
	newGame.SetPosition(Position(11.0,1.5));
	
	highScore.Load("./menu/highScore.xpm");
	highScore.SetPosition(Position(10.85,2.7));
	
	help.Load("./menu/help.xpm");
	help.SetPosition(Position(10.3,3.9));
	
	credit.Load("./menu/credit.xpm");
	credit.SetPosition(Position(11.3,5.1));
	
	ext.Load("./menu/exit.xpm");
	ext.SetPosition(Position(11.8,6.2));
	
	back.Load("./menu/back.xpm");
	back.SetPosition(Position(12, 6.6));
	
	return 0;
}

int mainMenu()
{	
	menuMode=1;
	menu.Open();
	background.Draw();
	newGame.Draw();
	highScore.Draw();
	help.Draw();
	credit.Draw();
	ext.Draw();
	menu.SetMouseClickCallback(menuClick);
	return 0;
}

int menuClick(const Position &p)
{
	cout<<p.GetXDistance()<< '\t';
	cout<<p.GetYDistance()<< '\n';
	
	//positions of mouse clicks on the main menu and the corresponding call back functions
	if(menuMode==1)
	{
		if((p.GetXDistance()>11.0455 && p.GetXDistance()<14.4318)&&(p.GetYDistance()>1.56818 && p.GetYDistance()<2.45455))
		{
			menu.Close();
			startGame();
		}	
		else if((p.GetXDistance()>10.8636 && p.GetXDistance()<14.6136)&&(p.GetYDistance()>2.75 && p.GetYDistance()<3.56818))
		{
			hsDisplay();
		}
		else if((p.GetXDistance()>10.3182 && p.GetXDistance()<15.2273)&&(p.GetYDistance()>3.95455 && p.GetYDistance()<4.81818))
		{
			instruction();
		}
		else if((p.GetXDistance()>11.3182 && p.GetXDistance()<14.3409)&&(p.GetYDistance()>5.15909 && p.GetYDistance()<6.02273))
		{
			creditLoad();
		}
		else if((p.GetXDistance()>11.7727 && p.GetXDistance()<13.7045)&&(p.GetYDistance()>6.25 && p.GetYDistance()<7.09091))
		{
			menu.Close();
			exitMenu();
		}
	}
	else
	{
		if((p.GetXDistance()>12 && p.GetXDistance()<13.2273)&&(p.GetYDistance()>6.63636 && p.GetYDistance()<7.29545))
		{
			mainMenu();
		}
	}
	return 0;
}

int hsDisplay()
{
	menuMode=2;
	
	//display the rank, score and level reached of the players in high scores window
	
	menu.RenderRectangle(Position(7.8, 1), Position(17.1, 7.7), White, false);
	menu.RenderText(Position(8, 2.2), Position(12, 2.2), "Rank", Black);
	menu.RenderText(Position(12.3, 2.2), Position(14, 2.2), "Score", Black);
	menu.RenderText(Position(14.3, 2.2), Position(17, 2.2), "Level Reached", Black);
	for(int i=0; i<5; i++)
	{
		itoa(i+1);
		menu.RenderText(Position(8, 2.8+0.5*i), Position(12, 2.8+0.5*i), str, Blue);
		itoa(hs[i]);
		menu.RenderText(Position(12.3, 2.8+0.5*i), Position(14, 2.8+0.5*i), str, Red);
		itoa(lvlReached[i]);
		menu.RenderText(Position(14.3, 2.8+0.5*i), Position(17, 2.8+0.5*i), str, Red);
	}
	back.Draw();
	return 0;
}

int instruction()
{

	//display the instructions window on mouse click
	
	menuMode=3;
	menu.RenderRectangle(Position(7.8, 1), Position(17.1, 7.7), White, false);
	instr.Load("./menu/instr.xpm");
	instr.SetPosition(Position(7.8,0));
	instr.Draw();
	back.Draw();
	return 0;
}

int creditLoad()
{

	//display the credits page window on mouse click
	
	menuMode=4;
	menu.RenderRectangle(Position(7.8, 1), Position(17.1, 7.7), White, false);
	credits.Load("./menu/credits.xpm");
	credits.SetPosition(Position(7.8,0.3));
	credits.Draw();
	back.Draw();
	return 0;
}

int exitMenu()
{

	//display the exit dialog box and corresponding 'yes' or 'no' options
	
	exitDialog.Open();
	exitDialog.RenderText(Position(0.5,0.5),Position(5.5,1),"You really want to exit?", Black);
	yes.Load("./menu/yes.xpm");
	yes.SetPosition(Position(1, 1.7));
	yes.Draw();
	no.Load("./menu/no.xpm");
	no.SetPosition(Position(3.8,1.7));
	no.Draw();
	exitDialog.SetMouseClickCallback(exitDialogClick);
	return 0;
}

int exitDialogClick(const Position &p)
{
	
	//function to exit from the game on mouse click
	
	cout  << p.GetXDistance() << '\t' << p.GetYDistance() << '\n';
	if((p.GetXDistance()>1.06818 && p.GetXDistance()<2.65909)&&(p.GetYDistance()>1.75 && p.GetYDistance()<2.56818))
	{
		exit(0);
	}
	else if((p.GetXDistance()>3.79545 && p.GetXDistance()<5.11364)&&(p.GetYDistance()>1.75 && p.GetYDistance()<2.56818))
	{
		exitDialog.Close();
		mainMenu();
	}
		
	return 0;
}

int startGame()
{
	//initialization of the co-ordinates of the head, body and tail of the snake
	//snake[1][0]=18;snake[1][1]=13;snake[0][0]=19;snake[0][1]=13;snake[2][0]=17;snake[2][1]=13;
	//opening the game window
	w.Open();
	assert(w.GetStatus()==WindowOpen);
	
	//loading the images of the head, body and tail
	head.Load("headR.xpm");
	assert(head.GetStatus()==BitMapOkay);
	body.Load("body.xpm");
	assert(body.GetStatus()==BitMapOkay);
	wall.Load("./walls/wall.xpm");
	bonusFruit.Load("./fruits/bonus.xpm");
	life.Load("life.xpm");
	noLife.Load("noLife.xpm");
	
	//initialise the game score,level score,sub level and lives at the start of the game
	
	gameScore=0;
	levelScore=0;
	subLevel=0;
	level=0;
	lives=3;
	bonusFruitPresence=false;
	subLevelChange=false;
	
	//starting the game
	playGame();
	return 0;
}


int playGame()
{
	//preparing the level
	prepLevel();
	scorePane('N');
	
	//taking the input from mouse
	w.SetMouseClickCallback(mouseClick);
	//starting the timer and calling "timerClick" regularly
	w.SetTimerCallback(timerClick);
	w.StartTimer(delay);
	return 0;
}

int mouseClick(const Position &p)
{
	//if the direction of the snake is up or down then to change it, following code works:
	if(dir=='U'|| dir=='D')
	{
		//if the mouse click is to the left of the snake, then turn left
		if(p.GetXDistance()*2<snake[0][0])
		{
			dir='L';
		}
		//if the mouse click is to the right of the snake, then turn right
		else if(p.GetXDistance()*2>snake[0][0])
		{
			dir='R';
		}
	}
	//if the direction of the snake is left or right then to change it, following code works:
	else
	{
		//if the mouse click is above the snake, then turn upwards
		if(p.GetYDistance()*2<snake[0][1])
		{
			dir='U';
		}
		//if the mouse click is below the snake, then turn downwards 
		else if(p.GetYDistance()*2>snake[0][1])
		{
			dir='D';
		}
	}
	//turn the snake in the new direction
	turn();
	//move the snake
	move();
	return 0;
}

int timerClick()
{
	//call the following functions repeatedly after a certain time interval
	distanceCount++;
	if(bonusFruitPresence)
		handleBonusFruit();
	move();
	return 0;
}

int move()
{	
	//Store the initial co-ordinates of head
	int tempX1,tempX2,tempY1,tempY2;	
	tempX1=snake[0][0]; tempY1=snake[0][1];
	tempX2=snake[1][0]; tempY2=snake[1][1];
	//"for" loop to transfer the co-ordinates of a body part to the next body part
	for(int i=1;i<subLevel+2;i++)
	{
		snake[i][0]=tempX1; snake[i][1]=tempY1;
		tempX1=tempX2; tempY1=tempY2;
		tempX2=snake[i+1][0]; tempY2=snake[i+1][1];
	}
	
	if(subLevelChange)
	{
		snake[subLevel+2][0]=snake[subLevel+1][0];
		snake[subLevel+2][1]=snake[subLevel+1][1];
		subLevelChange=false;
	}
	else
	{
		snake[subLevel+2][0]=tempX1;snake[subLevel+2][1]=tempY1;
	}
	
	switch(dir)
	{
		//if snake goes upwards
		case 'U' : snake[0][1]-=1;
		break;
		//if snake goes downwards
		case 'D' : snake[0][1]+=1;
		break;
		//if snake goes left
		case 'L' : snake[0][0]-=1;
		break;
		//if snake goes right
		case 'R' : snake[0][0]+=1;
		break;
	}



	//generate new coordinates for the snake to come from left of screen to right of screen
	//generate new coordinates for the snake to come from top of screen to bottom of the screen
	
	if(snake[0][0]==40)
		snake[0][0]=0;
	else if(snake[0][0]==-1)
		snake[0][0]=39;
	if(snake[0][1]==28)
		snake[0][1]=0;	
	else if(snake[0][1]==-1)
		snake[0][1]=27;
	
	//cout<<snake[0][1]<<" "<<snake[1][1]<<" "<<snake[2][1] << endl; //used for debugging while checking the program
	//cout << subLevel;
	
	int chk=check();
	int bodyLength=(chk==1)?subLevel+1:subLevel+3;
	//Setting new position for image of head
	//head.Erase();
	head.SetPosition(Position((float)(snake[0][0])/2,((float)snake[0][1])/2));
	head.Draw();
	
	//Setting new position for image of body
	body.Erase();
	for(int i=1; i<bodyLength; i++)
	{
		body.SetPosition(Position((float)(snake[i][0])/2,(float)(snake[i][1])/2));
		body.Draw();
	}
	return 0;
}

int turn()
{
	//switches according to the newly assigned direction
	switch(dir)
	{
		//changes the image for head and tail as per the new direction
		case 'U' : head.Load("headU.xpm");
		//tail.Load("tailU.xpm");
		break;
		case 'D' : head.Load("headD.xpm");
		//tail.Load("tailD.xpm");
		break;
		case 'R' : head.Load("headR.xpm");
		//tail.Load("tailR.xpm");
		break;
		case 'L' : head.Load("headL.xpm");
		//tail.Load("tailL.xpm");
		break;
	}
	return 0;
}

int check()
{
	/*
	  map[][]=1 means there is a wall on that position
	  map[][]=-1 means there is a fruit on that position
	  map[][]=-2 means there is a bonus fruit on that position
	*/
	
	xSnake=snake[0][0];
	ySnake=snake[0][1];
	
	//The snake collides with wall
	if(map[xSnake][ySnake]==1)
	{
		//level=11 means game over
		if(lives!=0)
		{
			lives--;
			subLevel=0;
			delay=250;
			levelScore=0;
			//scorePane('L');
			playGame();
		}
		else
		{
			//level=11;
			//restart the game
			//w.StopTimer();
			gameOver();
		}
		return 0;
	}

	//The snake eats the fruit	
	else if(map[xSnake][ySnake]==-1)
	{
		map[xSnake][ySnake]=0;
		//if the number of fruits eaten is less than 12
		if(subLevel<22)
		{
			//change the sublevel(that is the no. of fruits eaten)
			subLevel+=2;
			subLevelChange=true;
			w.StopTimer();
			delay-=5;
			w.StartTimer(delay);
			
			//adding scores
			addScore('S');
			
			//plotting bonus fruit as per the case
			if(subLevel==8 || subLevel==16)
			{
				plotBonusFruit();
				bonusFruitPresence=true;
			}
			//plot the next fruit
			plotFruit();
			return 1;
		}

		//if number of the fruits eaten is 12 
		else
		{
			if(level==9)
				gameOver();
			else
			{
				//go to the next level
				level++;
				//snake comes back to initial length
				subLevel=0;
				
				gameScore+=levelScore;
				levelScore=0;
				
				w.StopTimer();
				delay=250;
							
				addScore('S');
				//start the next level
				playGame();
			}
			return 0;
		} 
	}
	else if(map[xSnake][ySnake]==-2)
	{
		addScore('B');
		map[xBonusFruit][yBonusFruit]=0;
		return 0;
	}
	//The snake collides with the body
	else
	{
		for(int i=1; i<subLevel+3; i++)
		{
			//Co-ordinates of head and a body part become same
			if(snake[0][0]==snake[i][0] && snake[0][1]==snake[i][1])
			{
				//game over
				if(lives!=0)
				{
					lives--;
					//scorePane('L');
					subLevel=0;
					delay=250;
					levelScore=0;
					playGame();
				}
				else
				{
					//level=11;
					//w.StopTimer();
					gameOver();
					//restart the game
					//playGame();
				}
				return 0;
			}
		}
	}
					
}

int prepLevel()
{	

	//prepare the next level by checking conditions
	
	if(level==11)
	{
		gameOver();
		return 0;
	}
	loadMap();
	plotFruit();
	dir='R';
	turn();
	return 0;
}


int plotFruit()
{
	int flag;
	do{	
		flag=0;

		//generating random co-ordinates for the fruit
    		xFruit=randomCood(40);
    		yFruit=randomCood(28);

    		//if the co-ordinates generated lie on wall or snake
    		//checking for wall
		if(map[xFruit][yFruit]==1 || map[xFruit][yFruit]==-2)
		{
			flag=1;
		}
		//checking for snake
		else
		{
			for(int i=0; i<subLevel+3; i++)
			{
				if(snake[i][0]==xFruit && snake[i][1]==yFruit)
					flag=1;
			}
		}
	}while(flag==1);	//if flag=1, generate another pair of co-ordinates
	
	//setting new fruit co-ordinate to -1
	map[xFruit][yFruit]=-1;
	
	//random fruit type
	int fruitRand=randomCood(10);
	string a="./fruits/fruit";
	string c=".xpm";
	string imageF =a+(char)(48+fruitRand)+c;
	//loading new fruit
	fruit.Load(imageF);
	fruit.SetPosition(Position((float)xFruit/2,(float)yFruit/2));
	fruit.Draw();
	
	// calculate the least distance of the snake from the fruit
	
	leastDistance=abs(snake[0][0]-xFruit)+abs(snake[0][1]-yFruit);
		
	return 0;
}  	


int randomCood(int l)
{
	//seed value dependent on time
	srand(GetMilliseconds());
			
	//generating random co-ordinates			
  	return rand()%l;
}


int loadMap()
{

	//load the map from the text files of the maps prepared
	//load the walls in the game according to text file of the maps
	
	w.RenderRectangle(Position(0,0),Position(20.0,14.0),White,false);
	char a[10]="map2.lvl";
	FILE *fp;
	a[3]=(char)(49+level);
	fp=fopen(a,"r");
	
	
	//load the wall where map array contains '1'
	
	for(int i=0; i<40; i++)
	{
		for(int j=0; j<28; j++)
		{
			fscanf(fp, "%d", &map[i][j]);
			if(map[i][j]==1)
			{
				wall.SetPosition(Position((float)i/2, (float)j/2));
				wall.Draw();
			}
		}
	}
	
	//initial position of the snake as per the level
	for(int i=0; i<3;i++)
	{
		for(int j=0; j<2; j++)	
			fscanf(fp, "%d", &snake[i][j]);
	}
	
	fclose(fp);
	
	//drawing the snake at the initial co-ordinates
	head.SetPosition(Position((float)snake[0][0]/2,(float)snake[0][1]/2));
	head.Draw();
	body.SetPosition(Position((float)snake[1][0]/2,(float)snake[1][1]/2));
	body.Draw();
	body.SetPosition(Position((float)snake[2][0]/2,(float)snake[2][1]/2));
	body.Draw();
	
	return 0;
}

int plotBonusFruit()
{
	int flag;
	do{	
		flag=0;

		//generating random co-ordinates for the fruit
    		xBonusFruit=randomCood(40);
    		yBonusFruit=randomCood(28);

    		//if the co-ordinates generated lie on wall or snake
    		//checking for wall
		if(map[xBonusFruit][yBonusFruit]==1 || map[xBonusFruit][yBonusFruit]==-1)
		{
			flag=1;
		}
		//checking for snake
		else
		{
			for(int i=0; i<subLevel+3; i++)
			{
				if(snake[i][0]==xBonusFruit && snake[i][1]==yBonusFruit)
					flag=1;
			}
		}
	}while(flag==1);
	
	map[xBonusFruit][yBonusFruit]=-2;
	
	bonusFruit.SetPosition(Position((float)xBonusFruit/2,(float)yBonusFruit/2));
	bonusFruit.Draw();
	
	
	//find the distance of the bonus fruit from the snake
	
	bonusLeastDistance=abs(snake[0][0]-xBonusFruit) + abs(snake[0][1]-yBonusFruit);
		
	return 0;
}

int handleBonusFruit()
{

	//conditions for the presence of the bonus fruit
	
	if(bonusDistanceCount<=bonusLeastDistance*1.5)
	{	
		bonusDistanceCount++;
		
		//condition so that the bonus fruit blinks on screen
		
		if(bonusDistanceCount%3==0)
			bonusFruit.Erase();
		else
			bonusFruit.Draw();
		
	}
	
	//condition to bonus fruit to vanish
	
	else
	{
		map[xBonusFruit][yBonusFruit]=0;
		bonusFruit.Erase();
		bonusDistanceCount=0;
		bonusFruitPresence=false;
	}
	return 0;
}

int addScore(char a)
{

	//function to calculate the new score after the snake eats the fruit
	
	switch(a)
	{
		case 'S' : levelScore+=((float)leastDistance/distanceCount)*1000;
		distanceCount=0;
		//cout << gameScore << endl;
		scorePane(a);
		break;
		case 'B' : levelScore+=((float)bonusLeastDistance/bonusDistanceCount)*5000;
		bonusDistanceCount=0;
		//cout << gameScore << endl;
		map[xBonusFruit][yBonusFruit]=0;
		bonusFruitPresence=false;
		scorePane('S');
		break;
	}
	return 0;
}

int scorePane(char b)
{

	
	switch(b)
	{
		case 'S': itoa(gameScore+levelScore);
		w.Erase(Position(20.2,2.25), 2.8, 0.5);
		w.RenderText(Position(20.2,2.25), Position(23,2.75), str, Red);
		itoa(level+1);
		w.RenderText(Position(20.2,3.75), Position(23,4.25), str, Red);
		itoa(12-(subLevel/2));
		w.Erase(Position(20.2,5.0), 2.8, 0.5);
		w.RenderText(Position(20.2,5.0), Position(23,5.5), str, Red);
		break;
		
		case 'L': w.Erase(Position(20.2,11.75), 2.8, 0.6);
		for(int i=0; i<3; i++)
		{
			if(i<lives)
			{
				life.SetPosition(Position(20.5+i*0.75,11.75));
				life.Draw();
			}
			else
			{
				noLife.SetPosition(Position(20.5+i*0.75,11.75));
				noLife.Draw();
			}
		}
		break;
		
		case 'N': w.RenderLine(Position(20.1,0), Position(20.1,14), Black, 0.1);
		w.RenderText(Position(20.2,0), Position(23,0.5) , "High Score", Black);
		itoa(hs[0]);
		w.RenderText(Position(20.2,0.75), Position(23,1.25), str, Red);
		w.RenderText(Position(20.2,1.5), Position(23,2.0), "Score", Black);
		w.RenderText(Position(20.2,3.0), Position(23,3.5), "Level", Black);
		w.RenderText(Position(20.2,4.5), Position(23,4.75), "Fruits Left", Black);
		w.RenderText(Position(20.2,11), Position(23,11.5), "Lives Left", Black);
		scorePane('L');
		scorePane('S');
		break;
	}
	return 0;
}

int itoa(int num)
{
	int i=0, num2=num;
	while(num2!=0)
	{
		i++;
		num2=num2/10;
	}
	str[i]='\0';	
	if(num==0)
	{
		str[0]='0';
		i=1;
	}
	else
	{
		while(num!=0)
		{
			str[i-1]=(char)((num%10)+48);
			num/=10;
			i--;
		}
	}
	return 0;
}

int loadHS()
{
	ifstream in;
	in.open("hs.hs");
	for(int i=0;i<5;i++)
		in>>hs[i]>>lvlReached[i];
	in.close();
	return 0;
}

int gameOver()
{	
	int rank=chkScore();
	w.StopTimer();
	//w.Close();
	go.Open();
	go1.Load("./go.xpm");
	go1.SetPosition(Position(1.9,0));
	go1.Draw();
	if(rank<0)
	{
		go.RenderText(Position(0,1),Position(10,2),"You couldn't make it to the hisgscores.", Red);
	}
	else
	{
		go.RenderText(Position(0,1),Position(10,2),"Congrats! You made it into the highscores.", Green);
		itoa(rank);
		go.RenderText(Position(0,2),Position(3,3), str, Red);
		itoa(gameScore);
		go.RenderText(Position(5,2),Position(9,3), str, Blue);
	}
	go.SetMouseClickCallback(gameOverClick);
	go.RenderText(Position(0,4),Position(10,5),"Have Another Go?", Black);
	BitMap y(go);
	BitMap n(go);
	y.Load("./menu/yes.xpm");
	y.SetPosition(Position(1.7,5.5));
	n.Load("./menu/no.xpm");
	n.SetPosition(Position(6.6,5.5));
	y.Draw();
	n.Draw();
	return 0;
}

int gameOverClick(const Position &p)
{
	cout  << p.GetXDistance() << '\t' << p.GetYDistance() << '\n';
	if((p.GetXDistance()>1.72 && p.GetXDistance()<3.318)&&(p.GetYDistance()>5.5 && p.GetYDistance()<6.4))
	{
		go.Close();
		w.Close();
		mainMenu();
	}
	else if((p.GetXDistance()>6.613 && p.GetXDistance()<7.886)&&(p.GetYDistance()>5.5 && p.GetYDistance()<6.4))
	{
		go.Close();
		exit(0);
	}
	return 0;
}

int chkScore()
{
	int i=0, flag=0;
	for(i=0;i<5;i++)
	{
		if(gameScore>hs[i])
		{
			for(int j=4;j>i;j--)
			{
				hs[j]=hs[j-1];
				lvlReached[j]=lvlReached[j-1];
			}
			hs[i]=gameScore;
			lvlReached[i]=level+1;
			flag=1;
			ofstream write;
			write.open("hs.hs",ios::out | ios::trunc);
			for(int k=0;k<5;k++)
				write<<hs[k]<<'\t'<<lvlReached[k]<<"\n";
			write.close();
		}
		if(flag==1) break;
	}
	if(flag==1)
		return i+1;
	else
		return -1;
}
