#include "ezwin.h"
#include "position.h"
#include "rect.h"
#include "circle.h"
#include "triangle.h"
#include "square.h"
#include "wobject.h"
#include "shape.h"
#include "bitmap.h"
#include "label.h"
#include <iostream>
#include <unistd.h>
#include <assert.h>
#include <cstring>
#include <ctime>
#include <cmath>
#include <stdio.h>
#include <time.h>
#include <cstdlib>

int choice;
FILE*fqread;
int n_questions = 0;//no more than 200 questions in the file
int Count_Question[200];
int rand_line;
char Input_Line[1000];
char Question[10][1000];
char opt_a[10][100];
char opt_b[10][100];
char opt_c[10][100];
char opt_d[10][100];
char right_ans[10][2];
char user_ans;
int l=0;
char h='0';
int rans_count=0;
int m,i,k,t,g=0,j,b,z;
int status=0;

SimpleWindow Instruction("QUIZ-Instruction", 25, 15);
SimpleWindow Choice("QUIZ-Choice", 25, 15);
SimpleWindow Quiz("QUIZ", 25, 15);


BitMap BackBmp(Quiz),ABmp(Quiz),BBmp(Quiz),CBmp(Quiz),DBmp(Quiz),QuitBmp(Quiz),SkipBmp(Quiz),InitABmp(Quiz),InitBBmp(Quiz),InitCBmp(Quiz),InitDBmp(Quiz),FinalABmp(Quiz),FinalBBmp(Quiz),FinalCBmp(Quiz),FinalDBmp(Quiz),Choice1Bmp(Choice),Choice2Bmp(Choice),Choice3Bmp(Choice),Choice4Bmp(Choice),Choice5Bmp(Choice),Choice6Bmp(Choice),Choice7Bmp(Choice),Choice8Bmp(Choice),Choice9Bmp(Choice),Choice10Bmp(Choice),Choice11Bmp(Choice),Choice12Bmp(Choice);


void instruct_window();
void choice_window();
void quiz_window();
void read_q();
int check_repeat(int);
int valid_file();
void print_q(int);
int ReportMousePosition(const Position&);
int result(int);


int ApiMain()
{

instruct_window();//function to open the instructions window
choice_window();//function to open the choices window

/*------------------------------------------*/

cin>>choice;//user's choice

//select user's choice of quiz
switch (choice)
	{
	case 1:
	{fqread=fopen("basics.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 2:
	{fqread=fopen("iterative_loops.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 3:
	{fqread=fopen("conditional.txt","r");
	Choice.Message("You Have chosen-");	
	break;}
	case 4:
	{fqread=fopen("functions.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 5:
	{fqread=fopen("arrays.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 6:
	{fqread=fopen("pointers.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 7:
	{fqread=fopen("strings.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 8:
	{fqread=fopen("files.txt","r");
	Choice.Message("You Have chosen-General Quiz");
	break;}
	case 9:
	{fqread=fopen("library_functions.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 10:
	{fqread=fopen("structures.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 11:
	{fqread=fopen("obj_and_class.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	case 12:
	{fqread=fopen("questions.txt","r");
	Choice.Message("You Have chosen-");
	break;}
	default:
	{Choice.Message("Invalid Entry.Start Again.");
	return 1;}
		
	}

Choice.Close();

	j=valid_file();//check the validity of the file
	if(j==1) return 1;

read_q();

quiz_window();//opens quiz window
print_q(0);//print 1st question and options
Quiz.SetMouseClickCallback(ReportMousePosition);



return 0;
}

/*---------------------------------------------------*/



void instruct_window(){


Instruction.Open();
assert(Instruction.GetStatus() == WindowOpen);

Instruction.RenderRectangle(Position(0.0,0.0), Position(25.0,15),
			   Red, true);

Instruction.RenderRectangle(Position(10.0,1.0), Position(15.0,2),
			   Cyan, true);

Instruction.RenderText(Position(10.0,1.0), Position(15.0,2),
	 	" Instructions ", Black);


Instruction.RenderRectangle(Position(1.0,3.0), Position(24.0,5),
			   Yellow, true);
Instruction.RenderText(Position(2.0,3.0), Position(23.0,5.0),
	 	" 1.You can choose on which topic you want the quiz. ", Black,Yellow);

Instruction.RenderRectangle(Position(1.0,6.0), Position(24.0,8),
			   Yellow, true);
Instruction.RenderText(Position(2.0,6.0), Position(23.0,8.0),
	 	" 2.You can lock your response by clicking in the respective option box. ", Black,Yellow);


Instruction.RenderRectangle(Position(1.0,9.0), Position(24.0,11),
			   Yellow, true);Instruction.RenderText(Position(2.0,9.0), Position(23.0,11.0),
	 	" 3.There will be 10 questions in the quiz and you are expected to answer all. ", Black,Yellow);

Instruction.RenderRectangle(Position(1.0,12.0), Position(24.0,14),
			   Yellow, true);
Instruction.RenderText(Position(2.0,12.0), Position(23.0,14.0),
	 	" 4.Skipped Questions will be counted as unanswered. ", Black,Yellow);
	// 10 seconds sleep(argument in Microseconds)

	usleep(1000000);
	Instruction.Close();
	return;
}
/*---------------------------------------------------------------------*/


void choice_window(){

Choice.Open();
assert(Choice.GetStatus() == WindowOpen);



	Choice1Bmp.Load ("image_choice.xpm");
	Choice1Bmp.SetPosition(Position(10.0, 2.0));
	Choice1Bmp.Draw();

	Choice2Bmp.Load ("image_choice.xpm");
	Choice2Bmp.SetPosition(Position(10.0, 3.0));
	Choice2Bmp.Draw();

	Choice3Bmp.Load ("image_choice.xpm");
	Choice3Bmp.SetPosition(Position(10.0, 4.0));
	Choice3Bmp.Draw();

	Choice4Bmp.Load ("image_choice.xpm");
	Choice4Bmp.SetPosition(Position(10.0, 5.0));
	Choice4Bmp.Draw();

	Choice5Bmp.Load ("image_choice.xpm");
	Choice5Bmp.SetPosition(Position(10.0, 6.0));
	Choice5Bmp.Draw();

	Choice6Bmp.Load ("image_choice.xpm");
	Choice6Bmp.SetPosition(Position(10.0, 7.0));
	Choice6Bmp.Draw();

	Choice7Bmp.Load ("image_choice.xpm");
	Choice7Bmp.SetPosition(Position(10.0, 8.0));
	Choice7Bmp.Draw();

	Choice8Bmp.Load ("image_choice.xpm");
	Choice8Bmp.SetPosition(Position(10.0, 9.0));
	Choice8Bmp.Draw();

	Choice9Bmp.Load ("image_choice.xpm");
	Choice9Bmp.SetPosition(Position(10.0, 10.0));
	Choice9Bmp.Draw();

	Choice10Bmp.Load ("image_choice.xpm");
	Choice10Bmp.SetPosition(Position(10.0, 11.0));
	Choice10Bmp.Draw();

	Choice11Bmp.Load ("image_choice.xpm");
	Choice11Bmp.SetPosition(Position(10.0, 12.0));
	Choice11Bmp.Draw();

	Choice12Bmp.Load ("image_choice.xpm");
	Choice12Bmp.SetPosition(Position(10.0, 13.0));
	Choice12Bmp.Draw();


Choice.RenderText(Position(10.0,1.0), Position(15.0,2),
	 	" CHOICES ", Black);
Choice.RenderText(Position(10.0,2.0), Position(15.0,3),
	 	" 1. ", Black);
Choice.RenderText(Position(10.0,3.0), Position(15.0,4),
	 	" 2.", Black);
Choice.RenderText(Position(10.0,4.0), Position(15.0,5),
	 	" 3. ", Black);
Choice.RenderText(Position(10.0,5.0), Position(15.0,6),
	 	" 4. ", Black);
Choice.RenderText(Position(10.0,6.0), Position(15.0,7),
	 	" 5. ", Black);
Choice.RenderText(Position(10.0,7.0), Position(15.0,8),
	 	" 6. ", Black);
Choice.RenderText(Position(10.0,8.0), Position(15.0,9),
	 	" 7.", Black);
Choice.RenderText(Position(10.0,9.0), Position(15.0,10),
	 	" 8. ", Black);
Choice.RenderText(Position(10.0,10.0), Position(15.0,11),
	 	" 9. ", Black);
Choice.RenderText(Position(10.0,11.0), Position(15.0,12),
	 	" 10. ", Black);
Choice.RenderText(Position(10.0,12.0), Position(15.0,13),
	 	" 11. ", Black);
Choice.RenderText(Position(10.0,13.0), Position(15.0,14),
	 	" 12. ", Black);
Choice.RenderText(Position(10.0,14.0), Position(15.0,15),
	 	" ENTER THE CHOICE NUMBER ON THE TERMINAL ", Black);

return;
}
/*---------------------------------------------------------------------*/



void read_q()
{
	//counting the number of questions in the txt file
	while(!feof(fqread))
	{
	fgets(Input_Line, 1000, fqread);
	n_questions++;
	}

	//Setting the count of each question to be 0 
	for (i=0;i<200;i++)
	Count_Question[i]=0;
	
	//setting seed for random generations of questions
	srand(time(NULL));


	for(m=0;m<10;m++)//repeat the loop until the total number of questions in the quiz are completed
	{	
		//Generating questions at random from the txt file
		
		
		rand_line = rand() % (n_questions);//value of randLine is between 0 and number of questions in the txt file

		t=check_repeat(Count_Question[rand_line]);//Ensuring that questions do not repeat



		if(t==0)
		{
			Count_Question[rand_line]++;//increase the count of the question appearing to 1
			fseek(fqread, 0, SEEK_SET);

			for(i = 0; !feof(fqread),i<=rand_line; i++)
			fgets(Input_Line,1000, fqread);//cursor position now in the line corresponding to the randLine


			if(m!=9)			
			{
			i=2;
			k=0;
			h=h+1;//q.no
			l=l+1;//index of Question array

			Question[l-1][0]=h;
			Question[l-1][1]='.';
			
			while((Question[l-1][i++]=Input_Line[k++])!='@');//question
			Question[l-1][i-1]='\0';
			}
			
			if(m==9)
			{Question[l-1][0]='1';
			Question[l-1][1]='0';
			Question[l-1][2]='.';
			i=3;
			k=0;
			while((Question[l-1][i++]=Input_Line[k++])!='@');//question
			Question[l-1][i-1]='\0';
			}
			
			 i=0;
			//Option A
			while((opt_a[l-1][i++]=Input_Line[k++])!='@');
			opt_a[l-1][i-1] ='\0'; i=0;

			//Option B
			while((opt_b[l-1][i++]=Input_Line[k++])!='@');
			opt_b[l-1][i-1] ='\0'; i=0;

			//Option C
			while((opt_c[l-1][i++]=Input_Line[k++])!='@');
			opt_c[l-1][i-1] ='\0'; i=0;

			//Option D
			while((opt_d[l-1][i++]=Input_Line[k++])!='@');
			opt_d[l-1][i-1] ='\0'; i=0;

			//Answer in the format-(<option(in capital)>)
			right_ans[l-1][0]=Input_Line[k];
			right_ans[l-1][1]='\0';
		}
	}
	fclose(fqread);
}
/*----------------------------------------------------------------------------------------------*/
void quiz_window()
{
	//opening the mainquiz window
	Quiz.Open();
       // assert(Quiz.GetStatus() == WindowOpen);

	//Background image
	BackBmp.Load ("image_back.xpm");
	BackBmp.SetPosition(Position(-1.0, -5.5));
	BackBmp.Draw();

	//Title rectangle
	Quiz.RenderRectangle(Position(10.0,1.0), Position(15.0,2),
			   Magenta, true);

	Quiz.RenderText(Position(10.0,1.0), Position(15.0,2),
	 	" Quiz - CS 101 ", Black);

	//Question's Rectangle
	Quiz.RenderRectangle(Position(1.0,3.0), Position(24.0,5),
			   Yellow, true);

		
	//option A image
	ABmp.Load ("image_a.xpm");
	ABmp.SetPosition(Position(1.0, 6.0));
	ABmp.Draw();
	FinalABmp.Load ("image_final_a.xpm");

	InitABmp.Load ("image_init_a.xpm");
	InitABmp.SetPosition(Position(3.0, 6.0));
	InitABmp.Draw();
	

	//option B image
	BBmp.Load ("image_b.xpm");
	BBmp.SetPosition(Position(15.0, 6.0));
	BBmp.Draw();
	FinalBBmp.Load ("image_final_b.xpm");
	InitBBmp.Load ("image_init_b.xpm");
	InitBBmp.SetPosition(Position(17.0, 6.0));
	InitBBmp.Draw();

	//option C image
	CBmp.Load ("image_c.xpm");
	CBmp.SetPosition(Position(1.0, 9.0));
	CBmp.Draw();
	FinalCBmp.Load ("image_final_c.xpm");
	InitCBmp.Load ("image_init_c.xpm");
	InitCBmp.SetPosition(Position(3, 9.0));
	InitCBmp.Draw();

	//option D image
	DBmp.Load ("image_d.xpm");
	DBmp.SetPosition(Position(15.0, 9.0));
	DBmp.Draw();
	FinalDBmp.Load ("image_final_d.xpm");
	
	InitDBmp.Load ("image_init_d.xpm");
	InitDBmp.SetPosition(Position(17.0, 9));
	InitDBmp.Draw();

	//quit image
	QuitBmp.Load ("image_quit.xpm");
	QuitBmp.SetPosition(Position(2.0, 13.0));
	QuitBmp.Draw();

	SkipBmp.Load ("image_skip.xpm");
	SkipBmp.SetPosition(Position(23.0, 13.0));
	SkipBmp.Draw();


	return;
}

/*----------------------------------------------------------------------------------------------*/

void print_q(int y)
{
	//print the question
	Quiz.RenderText(Position(2.0,3.0), Position(23.0,5.0),
	 	Question[y], Black);

	//option A
	Quiz.RenderText(Position(1,6), Position(3,6.5),
			   "Option A",Red);
	Quiz.RenderText(Position(1.0,6.5), Position(10,8.0),opt_a[y], Black,Green);

	//option B
	Quiz.RenderText(Position(15,6), Position(17,6.5),
			   "Option B",Red);
	Quiz.RenderText(Position(15,6.5), Position(24,8.0),opt_b[y], Black,Green);

	//option c
	Quiz.RenderText(Position(1,9), Position(3,9.5),
			   "Option C",Red);
	Quiz.RenderText(Position(1,9.5), Position(10,11.0),opt_c[y], Black,Green);

	//option d
	Quiz.RenderText(Position(15,9), Position(17,9.5),
			   "Option D",Red);
	Quiz.RenderText(Position(15,9.5), Position(24,11),opt_d[y], Black,Green);

	

}

/*----------------------------------------------------------------------------------------------*/

//Function to ensure that questions don't repeat
int check_repeat(int r)
{if (r==0) return 0;
else return 1;
}
/*----------------------------------------------------------------------------------------------*/

int valid_file()
{
	//check the existance of the file in the current directory
	if (fqread == NULL)
	{
	cout << "Could not open file" << endl;
	return 1;
	}

	else return 0;
}
/*----------------------------------------------------------------------------------------------*/

int ReportMousePosition(const Position& p)
{	
	
	if(ABmp.IsInside(p)) 
			{user_ans='A';
			InitABmp.Erase();
			FinalABmp.SetPosition(Position(3.0, 6.0));
			FinalABmp.Draw();
			status=1;
			}
				
	else if(BBmp.IsInside(p)) 
			{user_ans='B';
			InitBBmp.Erase();
			FinalBBmp.SetPosition(Position(17.0, 6.0));
			FinalBBmp.Draw();
			status=1;
			}

	else if(CBmp.IsInside(p)) 
			{user_ans='C';
			InitCBmp.Erase();
			FinalCBmp.SetPosition(Position(3, 9.0));
			FinalCBmp.Draw();
			status=1;
			}


	else if(DBmp.IsInside(p))
			{ user_ans='D';
			InitDBmp.Erase();
			FinalDBmp.SetPosition(Position(17.0, 9));
			FinalDBmp.Draw();
			status =1;
			}		
	else if(QuitBmp.IsInside(p)) {user_ans='X';status=1;}
	else if(SkipBmp.IsInside(p)) {user_ans='S';status=1;}
	else {status =0;}

/*----------------------------------------------------------------------------------------------*/

	
if(status==1)
{
if(user_ans==right_ans[g][0]) b=1;
else if(user_ans=='X') b=2;
else if(user_ans=='S') b=4;
else if(user_ans!=right_ans[g][0])b=3;

/*-------------------------------------------------------------------------------------------------*/


	

	if (b==1){usleep(500000);
		Quiz.Message("Right Answer");
		//Quiz.RenderText(Position(9.0,12.5), Position(16.0,13.5)," Right Answer ", Black );
                rans_count++;
		}

	if(b==2){usleep(500000);                           
                Quiz.Message(" Your Quiz is Over.Your Result is Displayed on the Terminal");
                cout<<"Total Correct Answers are:"<<rans_count<<endl;
		if(rans_count<=3){cout<<"YOU NEED TO WORK HARD"<<endl;}
		else if(rans_count<=5){cout<<"AVERAGE PERFORMANCE"<<endl;}
		else if(rans_count<=8){cout<<"NICE WORK,KEEP IT UP"<<endl;}
		else if(rans_count<=10){cout<<"EXCELLENT WORK"<<endl;}	
		Quiz.Close();
				                                              
                }

	if (b==3){usleep(500000);
		string s="Wrong Answer. Right Answer is: ";
		s=s+right_ans[g];
		Quiz.Message(s);
		}

	if(b==4){
		quiz_window();	
		print_q(++g);
		}
	else if((b!=4) && (b!=2))	
	{quiz_window();	
	print_q(++g);
	}
	
	
	if(g==9)
	{	
		Quiz.Message("Quiz is Over.Your Result is Displayed on the Terminal");
		cout<<"Total Correct Answers are:"<<rans_count<<endl;
		if(rans_count<=3){cout<<"YOU NEED TO WORK HARD"<<endl;}
		else if(rans_count<=5){cout<<"AVERAGE PERFORMANCE"<<endl;}
		else if(rans_count<=8){cout<<"NICE WORK,KEEP IT UP"<<endl;}
		else if(rans_count<=10){cout<<"EXCELLENT WORK"<<endl;}		
		Quiz.Close();//Terminate();
	}	
	
	
	//quiz_window();	
	//print_q(++g);
	


//Quiz.Close();
}
return 0;
}
/*----------------------------------------------------------------------------------------------------*/
