#include "ezwin.h"
#include "position.h"
#include "rect.h"
#include "circle.h"
#include "triangle.h"
#include "square.h"
#include "wobject.h"
#include "shape.h"
#include "bitmap.h"
#include "label.h"
#include <iostream>
#include <unistd.h>
#include <assert.h>
#include <cstring>
#include <ctime>
#include <cmath>
#include <stdio.h>
#include <time.h>
#include <cstdlib>

int choice;
FILE*fqread;
int n_questions = 0;//no more than 200 questions in the file
int Count_Question[200];
int rand_line;
char Input_Line[1000];
char Question[10][1000];
char opt_a[10][100];
char opt_b[10][100];
char opt_c[10][100];
char opt_d[10][100];
char right_ans[10][2];
char user_ans;
int l=0;
char h='0';
int rans_count=0;
int m,i,k,t,g=0,j,b,z;
int status=0;
int status2;

//Defining the Windows
SimpleWindow Instruction("QUIZ-Instruction", 25, 15);
SimpleWindow Quiz("QUIZ", 25, 15);
SimpleWindow Choice("QUIZ-Choice", 25, 15);
SimpleWindow Result("QUIZ-Choice", 25, 15);

//Defining Bitmaps
BitMap BackBmp(Quiz),ABmp(Quiz),BBmp(Quiz),CBmp(Quiz),DBmp(Quiz),QuitBmp(Quiz),SkipBmp(Quiz),InitABmp(Quiz),InitBBmp(Quiz),InitCBmp(Quiz),InitDBmp(Quiz),FinalABmp(Quiz),FinalBBmp(Quiz),FinalCBmp(Quiz),FinalDBmp(Quiz),ChoiceBmp(Choice),Choice1Bmp(Choice),Choice2Bmp(Choice),Choice3Bmp(Choice),Choice4Bmp(Choice),Choice5Bmp(Choice),Choice6Bmp(Choice),Choice7Bmp(Choice),Choice8Bmp(Choice),Choice9Bmp(Choice),Choice10Bmp(Choice),Choice11Bmp(Choice),Choice12Bmp(Choice),InstructionBmp(Instruction),WelcomeBmp(Instruction),EndBmp(Result);

//Defining Functions
void instruct_window();//function to open the instructions window
void choice_window();//function to open the choices window
void quiz_window();//function opens the main quiz window
void read_q();//reads the questions in the chosen topic from the file and stores it in an array
int check_repeat(int);//to ensure questions don't repeat
void print_q(int);//function prints the question and the options on the window 
int ReportMousePosition(const Position&);//takes mouse click of the answer chosen
int ChoicePosition(const Position&);//Takes the mouse click of the choices window

/*---------------------------------------------------------------------*/
//MAIN PROGRAM 

int ApiMain()
{

instruct_window();//function to open the instructions window
choice_window();//function to open the choices window
Choice.SetMouseClickCallback(ChoicePosition);//Takes the mouse click of the choices window

return 0;

}

/*---------------------------------------------------*/
//Following all are the functions used


void instruct_window(){

//Welcome Wimdow
Instruction.Open();
assert(Instruction.GetStatus() == WindowOpen);

InstructionBmp.Load ("image_welcome.xpm");
InstructionBmp.SetPosition(Position(-1.0,-5.5));
InstructionBmp.Draw();

usleep(3000000);//3 seconds
Instruction.Close();

//Instruction Window
Instruction.Open();
assert(Instruction.GetStatus() == WindowOpen);

InstructionBmp.Load ("instructions.xpm");
InstructionBmp.SetPosition(Position(-1.0,-5.5));
InstructionBmp.Draw();

Instruction.RenderRectangle(Position(10.0,1.0), Position(15.0,2),
			   Cyan, true);

Instruction.RenderText(Position(10.0,1.0), Position(15.0,2),
	 	" Instructions ", Black,Cyan);

//Following are the Instructions
Instruction.RenderRectangle(Position(1.0,3.0), Position(24.0,5),
			   Yellow, true);
Instruction.RenderText(Position(2.0,3.0), Position(23.0,5.0),
	 	" 1.You can choose on which topic you want the quiz by clicking in the respective box. ", Black,Yellow);

Instruction.RenderRectangle(Position(1.0,6.0), Position(24.0,8),
			   Yellow, true);
Instruction.RenderText(Position(2.0,6.0), Position(23.0,8.0),
	 	" 2.You can lock your response by clicking in the respective option box. ", Black,Yellow);


Instruction.RenderRectangle(Position(1.0,9.0), Position(24.0,11),
			   Yellow, true);Instruction.RenderText(Position(2.0,9.0), Position(23.0,11.0),
	 	" 3.There will be 10 questions in the quiz and you are expected to answer all. ", Black,Yellow);

Instruction.RenderRectangle(Position(1.0,12.0), Position(24.0,14),
			   Yellow, true);
Instruction.RenderText(Position(2.0,12.0), Position(23.0,14.0),
	 	" 4.Skipped Questions will be counted as unanswered. ", Black,Yellow);
	// 15 seconds sleep(argument in Microseconds)

Instruction.RenderText(Position(2.0,14), Position(23.0,15.0),
	 	"(This window closes automatically after 15 seconds) ", Black,Yellow);
	


	usleep(15000000);
	Instruction.Close();
	return;

}
/*---------------------------------------------------------------------*/


void choice_window(){

	//Display the kinds of quiz
	Choice.Open();
	assert(Choice.GetStatus() == WindowOpen);


	ChoiceBmp.Load ("choice.xpm");
	ChoiceBmp.SetPosition(Position(-1.0,-5.5));
	ChoiceBmp.Draw();

	Choice1Bmp.Load ("image_choice.xpm");
	Choice1Bmp.SetPosition(Position(8.0, 2.0));
	Choice1Bmp.Draw();

	Choice2Bmp.Load ("image_choice.xpm");
	Choice2Bmp.SetPosition(Position(8.0, 3.0));
	Choice2Bmp.Draw();

	Choice3Bmp.Load ("image_choice.xpm");
	Choice3Bmp.SetPosition(Position(8.0, 4.0));
	Choice3Bmp.Draw();

	Choice4Bmp.Load ("image_choice.xpm");
	Choice4Bmp.SetPosition(Position(8.0, 5.0));
	Choice4Bmp.Draw();

	Choice5Bmp.Load ("image_choice.xpm");
	Choice5Bmp.SetPosition(Position(8.0, 6.0));
	Choice5Bmp.Draw();

	Choice6Bmp.Load ("image_choice.xpm");
	Choice6Bmp.SetPosition(Position(8.0, 7.0));
	Choice6Bmp.Draw();

	Choice7Bmp.Load ("image_choice.xpm");
	Choice7Bmp.SetPosition(Position(8.0, 8.0));
	Choice7Bmp.Draw();

	Choice8Bmp.Load ("image_choice.xpm");
	Choice8Bmp.SetPosition(Position(8.0, 9.0));
	Choice8Bmp.Draw();

	Choice9Bmp.Load ("image_choice.xpm");
	Choice9Bmp.SetPosition(Position(8.0, 10.0));
	Choice9Bmp.Draw();

	Choice10Bmp.Load ("image_choice.xpm");
	Choice10Bmp.SetPosition(Position(8.0, 11.0));
	Choice10Bmp.Draw();

	Choice11Bmp.Load ("image_choice.xpm");
	Choice11Bmp.SetPosition(Position(8.0, 12.0));
	Choice11Bmp.Draw();

	Choice12Bmp.Load ("image_choice.xpm");
	Choice12Bmp.SetPosition(Position(8.0, 13.0));
	Choice12Bmp.Draw();

	//Choices
	Choice.RenderText(Position(10.0,1.0), Position(15.0,2),
	 	" CLICK ON YOUR CHOICE ", Black,Cyan);
	Choice.RenderText(Position(10.0,2.0), Position(15.0,3),
	 	" 1.BASICS ", Black,Cyan);
	Choice.RenderText(Position(10.0,3.0), Position(15.0,4),
	 	" 2.ITERATIVE LOOPS ", Black,Cyan);
	Choice.RenderText(Position(10.0,4.0), Position(15.0,5),
	 	" 3. CONDITIONAL", Black,Cyan);
	Choice.RenderText(Position(10.0,5.0), Position(15.0,6),
	 	" 4. FUNCTIONS ", Black,Cyan);
	Choice.RenderText(Position(10.0,6.0), Position(15.0,7),
	 	" 5. ARRAYS", Black,Cyan);
	Choice.RenderText(Position(10.0,7.0), Position(15.0,8),
	 	" 6. POINTERS", Black,Cyan);
	Choice.RenderText(Position(10.0,8.0), Position(15.0,9),
	 	" 7. STRINGS", Black,Cyan);
	Choice.RenderText(Position(10.0,9.0), Position(15.0,10),
	 	" 8. FILES", Black,Cyan);
	Choice.RenderText(Position(10.0,10.0), Position(15.0,11),
	 	" 9. LIBRARY FUNCTIONS", Black,Cyan);
	Choice.RenderText(Position(10.0,11.0), Position(15.0,12),
	 	" 10. STRUCTURES", Black,Cyan);
	Choice.RenderText(Position(10.0,12.0), Position(15.0,13),
	 	" 11. OBJECTS AND CLASSES", Black,Cyan);
	Choice.RenderText(Position(10.0,13.0), Position(15.0,14),
	 	" 12. GENERAL QUIZ(INCLUDES ALL THE ABOVE)", Black,Cyan);
	


return;
}
/*---------------------------------------------------------------------*/

int ChoicePosition(const Position &r)
{	
	if(Choice1Bmp.IsInside(r))status2=1; 
		if(status2==1)	{
			fqread=fopen("basics.txt","r");//
			if ((fqread = fopen("basics.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "basics.txt");
			Choice.Message("You Have chosen-1.BASICS");
			Choice.Close();
			}
				
	else if(Choice2Bmp.IsInside(r))  status2=2;
		if(status2==2)	{
			fqread=fopen("iterative_loops.txt","r");
			if ((fqread = fopen("iterative_loops.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "iterative_loops.txt");
			Choice.Message("You Have chosen-2.ITERATIVE LOOPS");
			Choice.Close();			
			}
	else if(Choice3Bmp.IsInside(r))status2=3;  
		if(status2==3)	{
			fqread=fopen("conditional.txt","r");
			if ((fqread = fopen("conditional.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "conditional.txt");
			Choice.Message("You Have chosen-3.CONDITIONAL");
			Choice.Close();
			}
	else if(Choice4Bmp.IsInside(r))status2=4;  
		if(status2==4)	{
			fqread=fopen("functions.txt","r");//
			if ((fqread = fopen("functions.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "functions.txt");
			Choice.Message("You Have chosen-4.FUNCTIONS");
			Choice.Close();
			}
	else if(Choice5Bmp.IsInside(r))status2=5;  
		if(status2==5)	{
			fqread=fopen("arrays.txt","r");
			if ((fqread = fopen("arrays.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "arrays.txt");
			Choice.Message("You Have chosen-5.ARRAYS");
			Choice.Close();
			}
	else if(Choice6Bmp.IsInside(r))status2=6;  
		if(status2==6)	{
			fqread=fopen("pointers.txt","r");
			if ((fqread = fopen("pointers.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "pointers.txt");
			Choice.Message("You Have chosen-6.POINTERS");
			Choice.Close();
			}
	else if(Choice7Bmp.IsInside(r))status2=7;  
		if(status2==7)	{
			fqread=fopen("string.txt","r");//
			if ((fqread = fopen("string.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "string.txt");
			Choice.Message("You Have chosen-7.STRINGS");
			Choice.Close();
			}
	else if(Choice8Bmp.IsInside(r))status2=8;  
		if(status2==8)	{
			fqread=fopen("files.txt","r");
			if ((fqread = fopen("files.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "files.txt");
			Choice.Message("You Have chosen-8.FILES");
			Choice.Close();
			}
	else if(Choice9Bmp.IsInside(r))status2=9;  
		if(status2==9)	{
			fqread=fopen("library_functions.txt","r");
			if ((fqread = fopen("library_functions.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "library_functions.txt");
			Choice.Message("You Have chosen-9.LIBRARY FUNCTIONS");
			Choice.Close();
			}
	else if(Choice10Bmp.IsInside(r))status2=10;  
		if(status2==10)	{
			fqread=fopen("structures.txt","r");
			if ((fqread = fopen("structures.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "structures.txt");
			Choice.Message("You Have chosen-10.STRUCTURES");
			Choice.Close();
			}
	else if(Choice11Bmp.IsInside(r))status2=11;  
		if(status2==11)	{
			fqread=fopen("obj_and_class.txt","r");//
			if ((fqread = fopen("obj_and_class.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "obj_and_class.txt");
			Choice.Message("You Have chosen-11.OBJECTS AND CLASSES");
			Choice.Close();
				}
	else if(Choice12Bmp.IsInside(r))status2=12;  
		if(status2==12)	{
			fqread=fopen("questions.txt","r");//
			if ((fqread = fopen("questions.txt", "r")) == NULL)
        		fprintf(stderr, "Cannot open %s\n", "questions.txt");
			Choice.Message("You Have chosen-12.GENERAL QUIZ");
			Choice.Close();
			}
	else {status2=13;}

	if(status2!=13){
				read_q();//function to read questions

				quiz_window();//function opens quiz window
				print_q(0);//function prints 1st question and options
				Quiz.SetMouseClickCallback(ReportMousePosition);//checks the mouse click
							
			}
	
}


/*---------------------------------------------------------------------*/

void read_q()
{
	//counting the number of questions in the txt file
	while(!feof(fqread))
	{
	fgets(Input_Line, 1000, fqread);
	n_questions++;
	}

	//Setting the count of each question to be 0 
	for (i=0;i<200;i++)
	Count_Question[i]=0;
	
	//setting seed for random generations of questions
	srand(time(NULL));


	for(m=0;m<11;)//repeat the loop until the total number of questions in the quiz are completed
	{	
		//Generating questions at random from the txt file
		
		
		rand_line = rand() % (n_questions);//value of randLine is between 0 and number of questions in the txt file

		t=check_repeat(Count_Question[rand_line]);//Ensuring that questions do not repeat



		if(t==0)
		{
			Count_Question[rand_line]++;//increase the count of the question appearing to 1
			fseek(fqread, 0, SEEK_SET);

			for(i = 0; !feof(fqread),i<=rand_line; i++)
			fgets(Input_Line,1000, fqread);//cursor position now in the line corresponding to the randLine


			if(m!=10)			
			{
			i=2;
			k=0;
			h=h+1;//q.no
			l=l+1;//index of Question array

			Question[l-1][0]=h;
			Question[l-1][1]='.';
			
			while((Question[l-1][i++]=Input_Line[k++])!='@');//question
			Question[l-1][i-1]='\0';
			}
			
			if(m==10)
			{Question[l-1][0]='1';
			Question[l-1][1]='0';
			Question[l-1][2]='.';
			i=3;
			k=0;
			while((Question[l-1][i++]=Input_Line[k++])!='@');//question
			Question[l-1][i-1]='\0';
			}
			
			 i=0;
			//Option A
			while((opt_a[l-1][i++]=Input_Line[k++])!='@');
			opt_a[l-1][i-1] ='\0'; i=0;

			//Option B
			while((opt_b[l-1][i++]=Input_Line[k++])!='@');
			opt_b[l-1][i-1] ='\0'; i=0;

			//Option C
			while((opt_c[l-1][i++]=Input_Line[k++])!='@');
			opt_c[l-1][i-1] ='\0'; i=0;

			//Option D
			while((opt_d[l-1][i++]=Input_Line[k++])!='@');
			opt_d[l-1][i-1] ='\0'; i=0;

			//Answer in the format-(<option(in capital)>)
			right_ans[l-1][0]=Input_Line[k];
			right_ans[l-1][1]='\0';

			m=m+1;
		}
		
	}
	
	fclose(fqread); 	
	
	
}
/*----------------------------------------------------------------------------------------------*/
void quiz_window()
{
	//opening the mainquiz window
	Quiz.Open();
       // assert(Quiz.GetStatus() == WindowOpen);

	//Background image
	BackBmp.Load ("image_back.xpm");
	BackBmp.SetPosition(Position(-1.0, -5.5));
	BackBmp.Draw();

	//Title rectangle
	Quiz.RenderRectangle(Position(10.0,1.0), Position(15.0,2),
			   Magenta, true);

	Quiz.RenderText(Position(10.0,1.0), Position(15.0,2),
	 	" Quiz - CS 101 ", Black,Cyan);

	//Question's Rectangle
	Quiz.RenderRectangle(Position(1.0,3.0), Position(24.0,5),
			   Yellow, true);

		
	//option A image
	ABmp.Load ("image_a.xpm");
	ABmp.SetPosition(Position(1.0, 6.0));
	ABmp.Draw();
	FinalABmp.Load ("image_final_a.xpm");

	InitABmp.Load ("image_init_a.xpm");
	InitABmp.SetPosition(Position(3.0, 6.0));
	InitABmp.Draw();
	

	//option B image
	BBmp.Load ("image_b.xpm");
	BBmp.SetPosition(Position(15.0, 6.0));
	BBmp.Draw();
	FinalBBmp.Load ("image_final_b.xpm");
	InitBBmp.Load ("image_init_b.xpm");
	InitBBmp.SetPosition(Position(17.0, 6.0));
	InitBBmp.Draw();

	//option C image
	CBmp.Load ("image_c.xpm");
	CBmp.SetPosition(Position(1.0, 9.0));
	CBmp.Draw();
	FinalCBmp.Load ("image_final_c.xpm");
	InitCBmp.Load ("image_init_c.xpm");
	InitCBmp.SetPosition(Position(3, 9.0));
	InitCBmp.Draw();

	//option D image
	DBmp.Load ("image_d.xpm");
	DBmp.SetPosition(Position(15.0, 9.0));
	DBmp.Draw();
	FinalDBmp.Load ("image_final_d.xpm");
	
	InitDBmp.Load ("image_init_d.xpm");
	InitDBmp.SetPosition(Position(17.0, 9));
	InitDBmp.Draw();

	//quit image
	QuitBmp.Load ("image_quit.xpm");
	QuitBmp.SetPosition(Position(2.0, 13.0));
	QuitBmp.Draw();

	//skip image
	SkipBmp.Load ("image_skip.xpm");
	SkipBmp.SetPosition(Position(23.0, 13.0));
	SkipBmp.Draw();


	return;
}

/*----------------------------------------------------------------------------------------------*/

void print_q(int y)
{
	if(y!=10)
	{
	//print the question
	Quiz.RenderText(Position(2.0,3.0), Position(23.0,5.0),
	 	Question[y], Black);

	//option A
	Quiz.RenderText(Position(1,6), Position(3,6.5),
			   "Option A",Red);
	Quiz.RenderText(Position(1.0,6.5), Position(10,8.0),opt_a[y], Black,Green);

	//option B
	Quiz.RenderText(Position(15,6), Position(17,6.5),
			   "Option B",Red);
	Quiz.RenderText(Position(15,6.5), Position(24,8.0),opt_b[y], Black,Green);

	//option c
	Quiz.RenderText(Position(1,9), Position(3,9.5),
			   "Option C",Red);
	Quiz.RenderText(Position(1,9.5), Position(10,11.0),opt_c[y], Black,Green);

	//option d
	Quiz.RenderText(Position(15,9), Position(17,9.5),
			   "Option D",Red);
	Quiz.RenderText(Position(15,9.5), Position(24,11),opt_d[y], Black,Green);

	}

}

/*----------------------------------------------------------------------------------------------*/

//Function to ensure that questions don't repeat
int check_repeat(int r)
{if (r==0) return 0;
else return 1;
}
/*----------------------------------------------------------------------------------------------*/


int ReportMousePosition(const Position& p)
{	
	
	if(ABmp.IsInside(p)) 
			{user_ans='A';
			InitABmp.Erase();//following 3 lines indicate that the respective choice is clicked
			FinalABmp.SetPosition(Position(3.0, 6.0));
			FinalABmp.Draw();
			status=1;
			}
				
	else if(BBmp.IsInside(p)) 
			{user_ans='B';
			InitBBmp.Erase();//following 3 lines indicate that the respective choice is clicked
			FinalBBmp.SetPosition(Position(17.0, 6.0));
			FinalBBmp.Draw();
			status=1;
			}

	else if(CBmp.IsInside(p)) 
			{user_ans='C';
			InitCBmp.Erase();//following 3 lines indicate that the respective choice is clicked
			FinalCBmp.SetPosition(Position(3, 9.0));
			FinalCBmp.Draw();
			status=1;
			}


	else if(DBmp.IsInside(p))
			{ user_ans='D';
			InitDBmp.Erase();//following 3 lines indicate that the respective choice is clicked
			FinalDBmp.SetPosition(Position(17.0, 9));
			FinalDBmp.Draw();
			status =1;
			}
		
	else if(QuitBmp.IsInside(p)) {user_ans='X';status=1;}
	
	else if(SkipBmp.IsInside(p)) {user_ans='S';status=1;}

	else {status =0;}

/*----------------------------------------------------------------------------------------------*/

	
if(status==1)//do the following only if the mouse is clicked in one of the required parts
	{
		if(user_ans==right_ans[g][0]) b=1;
		else if(user_ans=='X') b=2;
		else if(user_ans=='S') b=4;
		else if(user_ans!=right_ans[g][0])b=3;

/*-------------------------------------------------------------------------------------------------*/


	
	//Right Answer Chosen
	if (b==1){usleep(500000);
		Quiz.Message("Right Answer");
		//Quiz.RenderText(Position(9.0,12.5), Position(16.0,13.5)," Right Answer ", Black );
                rans_count++;
		}
	//Q//function to open the instructions windowuit Chosen
	if(b==2){Quiz.Close();//Terminate();
		
		Result.Open();
		EndBmp.Load ("instructions.xpm");
		EndBmp.SetPosition(Position(-1.0,0.0));
		EndBmp.Draw();		

	
		if(rans_count==0){Result.Message("Quiz is Over.Total Correct Answers are:0.YOU NEED TO WORK HARD");}
		if(rans_count==1){Result.Message("Quiz is Over.Total Correct Answers are:1.YOU NEED TO WORK HARD");}
		if(rans_count==2){Result.Message("Quiz is Over.Total Correct Answers are:2.YOU NEED TO WORK HARD");}
		if(rans_count==3){Result.Message("Quiz is Over.Total Correct Answers are:3.YOU NEED TO WORK HARD");}
		if(rans_count==4){Result.Message("Quiz is Over.Total Correct Answers are:4.AVERAGE PERFORMANCE");}
		if(rans_count==5){Result.Message("Quiz is Over.Total Correct Answers are:5.AVERAGE PERFORMANCE");}
		if(rans_count==6){Result.Message("Quiz is Over.Total Correct Answers are:6.NICE WORK,KEEP IT UP");}
		if(rans_count==7){Result.Message("Quiz is Over.Total Correct Answers are:7.NICE WORK,KEEP IT UP");}
		if(rans_count==8){Result.Message("Quiz is Over.Total Correct Answers are:8.NICE WORK,KEEP IT UP");}
		if(rans_count==9){Result.Message("Quiz is Over.Total Correct Answers are:9.EXCELLENT WORK");}
		if(rans_count==10){Result.Message("Quiz is Over.Total Correct Answers are:10.EXCELLENT WORK");}
			
					
		Result.Close();
	
				                                              
                }

	//Wrong Answer Chosen
	if (b==3){usleep(500000);
		string s="Wrong Answer. Right Answer is: ";
		s=s+right_ans[g];
		Quiz.Message(s);
		}

	//Skip Option Chosen
	if(b==4){Quiz.Message("You Have skipped this question");
		quiz_window();	
		print_q(++g);
		}
		
		else if((b!=4) && (b!=2))	
		{quiz_window();	
		print_q(++g);
	
			if(g==10)
			{
			Quiz.Close();
			Result.Open();
			EndBmp.Load ("instructions.xpm");
			EndBmp.SetPosition(Position(-1.0,0.0));
			EndBmp.Draw();

			
			if(rans_count==0){Result.Message("Quiz is Over.Total Correct Answers are:0.YOU NEED TO WORK HARD");}
			if(rans_count==1){Result.Message("Quiz is Over.Total Correct Answers are:1.YOU NEED TO WORK HARD");}
			if(rans_count==2){Result.Message("Quiz is Over.Total Correct Answers are:2.YOU NEED TO WORK HARD");}
			if(rans_count==3){Result.Message("Quiz is Over.Total Correct Answers are:3.YOU NEED TO WORK HARD");}
			if(rans_count==4){Result.Message("Quiz is Over.Total Correct Answers are:4.AVERAGE PERFORMANCE");}
			if(rans_count==5){Result.Message("Quiz is Over.Total Correct Answers are:5.AVERAGE PERFORMANCE");}
			if(rans_count==6){Result.Message("Quiz is Over.Total Correct Answers are:6.NICE WORK,KEEP IT UP");}
			if(rans_count==7){Result.Message("Quiz is Over.Total Correct Answers are:7.NICE WORK,KEEP IT UP");}
			if(rans_count==8){Result.Message("Quiz is Over.Total Correct Answers are:8.NICE WORK,KEEP IT UP");}
			if(rans_count==9){Result.Message("Quiz is Over.Total Correct Answers are:9.EXCELLENT WORK");}
			if(rans_count==10){Result.Message("Quiz is Over.Total Correct Answers are:10.EXCELLENT WORK");}
			
			Result.Close();
	
		
			}

		
		}
	

	
	}
return 0;
}
/*----------------------------------------------------------------------------------------------------*/
