population=murbadnumeric(:,2);
literate=murbadnumeric(:,14); //literate population
working=murbadnumeric(:,20); //working population
mainwork=murbadnumeric(:,23); //main working population
margwork=murbadnumeric(:,38); //marginal working population

mainwork_cultivator=murbadnumeric(:,26); //main working population engaged in cultivation
mainwork_household=murbadnumeric(:,32); //main working population engaged in household industry
mainwork_other=murbadnumeric(:,35); //main working population engaged in other occupation

margwork_cultivator=murbadnumeric(:,41); //marginal working population engaged in cultivation
margwork_household=murbadnumeric(:,47); //marginal working population engaged in household industry
margwork_other=murbadnumeric(:,50); //marginal working population engaged in other occupation



xval=literate; yval=mainwork; //xval=literate; yval=margwork;
xval_new = xval- mean(xval);
yval_new = yval - mean(yval);
num=0
s1 =0;
s2=0;
for i=1:numvillages
    num = num + (xval_new(i)*yval_new(i));
    s1 = s1 + (xval_new(i)*xval_new(i));
    s2 = s2 + (yval_new(i)*yval_new(i));
end
coefficient = num/sqrt(s1*s2); //division by N not required, since s1 and s2 should have also been divided by sqrt(N) whereas they are not. These N's cancel out 
disp(coefficient)
clf();
plot(xval,yval,'b.');xgrid; title(msprintf("scatter plot")); //scatter plot

xplot=[1:0.5:max(xval)];

xval_a = [xval'; ones(1,numvillages)]'; 
//linear regression
w = 1/(xval_a'*xval_a)*xval_a'*yval
yplot=xplot*w(1) + w(2); 
//plot(xplot,yplot,'r');

//linear regression using scilab command
[w_s_1,w_s_2] = reglin(xval',yval');
yplot_s=xplot*w_s_1 + w_s_2; 
plot(xplot,yplot_s,'b');


//ridge regression
lambda=10;
w_r = 1/(xval_a'*xval_a + lambda*eye(2,2))*xval_a'*yval
yplot_r=xplot*w_r(1) + w_r(2); 
plot(xplot,yplot_r,'y');


//quadratic regression
xvalsq = (xval.^2);
xval_q = [xvalsq'; xval'; ones(1,numvillages)]'; 
w_q = 1/(xval_q'*xval_q)*xval_q'*yval
yplot_q=xplot.^2*w_q(1) + xplot*w_q(2) + w_q(3); 
plot(xplot,yplot_q,'g');


//cubic regression
xvalcube = (xval.^3);
xval_c = [xvalcube'; xvalsq'; xval'; ones(1,numvillages)]'; 
w_c = 1/(xval_c'*xval_c)*xval_c'*yval
yplot_c=xplot.^3*w_c(1) + xplot.^2*w_c(2) + xplot*w_c(3) + w_c(4); 
plot(xplot,yplot_c,'r');




