clf();

lambda=0.05;

//illustration of overfitting in cubic regression
xval = [1 2 3 7]'; yval=[-250 11 1 1200]';

xplot=[1:0.5:max(xval)];

xvalcube = (xval.^3);
xvalsq = (xval.^2);
xval_c = [xvalcube'; xvalsq'; xval'; ones(1,4)]'; 
w_c = 1/(xval_c'*xval_c + lambda*eye(4,4))*xval_c'*yval;
xplot=[1:0.5:max(xval)];
yplot_c=xplot.^3*w_c(1) + xplot.^2*w_c(2) + xplot*w_c(3) + w_c(4); 
plot(xval,yval,'b.');
plot(xplot,yplot_c,'r');

//quadratic regression
xval_q = [xvalsq'; xval'; ones(1,4)]'; 
w_q = 1/(xval_q'*xval_q + lambda*eye(3,3))*xval_q'*yval;
yplot_q=xplot.^2*w_q(1) + xplot*w_q(2) + w_q(3); 
plot(xval,yval,'b.');
plot(xplot,yplot_q,'g');


//linear regression
xval_a = [xval'; ones(1,4)]'; 
w_a = 1/(xval_a'*xval_a + lambda*eye(2,2))*xval_a'*yval;
yplot_a=xplot*w_a(1) + w_a(2); 
plot(xval,yval,'b.');
plot(xplot,yplot_a,'b');


