function gi=gini(table);
// plots the lorenz curve and computes the gini coefficient for table.
// table must be an n-by-2 array where table(I,1) is the frequency and 
// table (I,2) is the value
// assumes that table(I,2) is in increasing order

[n,ig]=size(table);
X=sum(table(:,1));

x(1)=0;
y(1)=0;
for i=2:n+1
x(i)=x(i-1)+table(i-1,1)/X; // cumulative fractions
y(i)=y(i-1)+table(i-1,1)*table(i-1,2)/X; // cumulative value
end;
Y=y(n+1); // this is total value
yy=y/Y; // normalized value 
plot(x,yy);
plot([0 1],[0 1],'r');
A=0;
//disp(x);
//disp(yy);
for i=2:n+1
A=A+((x(i)-yy(i))+(x(i-1)-yy(i-1)))/2*(x(i)-x(i-1)); 
//disp(A);
end;

gi=2*A;

return;



