/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;
import oracle.sql.RAW;

class RawCommonAccessor
extends Accessor {
    RawCommonAccessor() {
    }

    InputStream getAsciiStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        PhysicalConnection physicalConnection = this.stmt.connection;
        return physicalConnection.conversion.ConvertStream(new ByteArrayInputStream(byArray), 2);
    }

    InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    Reader getCharacterStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        char[] cArray = new char[n2 << 1];
        DBConversion cfr_ignored_0 = this.stmt.connection.conversion;
        int n3 = DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
        return new CharArrayReader(cArray, 0, n3);
    }

    Object getObject(int n) throws SQLException {
        return this.getBytes(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getBytes(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getRAW(n);
    }

    RAW getRAW(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new RAW(byArray);
    }

    String getString(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return null;
        }
        return RepConversion.bArray2String(byArray);
    }

    InputStream getUnicodeStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        PhysicalConnection physicalConnection = this.stmt.connection;
        return physicalConnection.conversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
    }

    void init(OracleStatement oracleStatement, int n, int n2, int n3, short s, int n4) throws SQLException {
        this.init(oracleStatement, n, n2, s, false);
        this.initForDataAccess(n4, n3, null);
    }

    void init(OracleStatement oracleStatement, int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s) throws SQLException {
        this.init(oracleStatement, n, n2, s, false);
        this.initForDescribe(n, n3, bl, n4, n5, n6, n7, n8, s, null);
        int n9 = oracleStatement.max_field_size;
        if (n9 > 0 && (n3 == 0 || n9 < n3)) {
            n3 = n9;
        }
        this.initForDataAccess(0, n3, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.t_max_length = Integer.MAX_VALUE;
        if (n2 > 0 && n2 < this.t_max_length) {
            this.t_max_length = n2;
        }
    }
}

