/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPLTZ;

public class OracleTypeTIMESTAMPLTZ
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1615519855865602397L;
    int prec = 0;
    transient OracleConnection connection;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    protected OracleTypeTIMESTAMPLTZ() {
    }

    public OracleTypeTIMESTAMPLTZ(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public int getPrecision() throws SQLException {
        return this.prec;
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public int getTypeCode() {
        return -102;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.prec = streamInfo.readByte();
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.prec = objectInputStream.readByte();
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block9: {
            tIMESTAMPLTZ = null;
            if (object == null) break block9;
            try {
                if (object instanceof TIMESTAMPLTZ) {
                    tIMESTAMPLTZ = (TIMESTAMPLTZ)object;
                    break block9;
                }
                if (object instanceof byte[]) {
                    tIMESTAMPLTZ = new TIMESTAMPLTZ((byte[])object);
                    break block9;
                }
                if (object instanceof Timestamp) {
                    tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (Timestamp)object);
                    break block9;
                }
                if (object instanceof DATE) {
                    tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (DATE)object);
                    break block9;
                }
                if (object instanceof String) {
                    tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (String)object);
                    break block9;
                }
                if (object instanceof Date) {
                    tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (Date)object);
                    break block9;
                }
                if (object instanceof Time) {
                    tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (Time)object);
                    break block9;
                }
                DatabaseError.check_error(59, object);
            }
            catch (Exception exception) {
                DatabaseError.check_error(59, object);
            }
        }
        return tIMESTAMPLTZ;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new TIMESTAMPLTZ(byArray);
            }
            case 2: {
                return TIMESTAMPLTZ.toTimestamp(this.connection, byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.check_error(59);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.prec);
    }
}

