/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

public class OracleTypeTIMESTAMPTZ
extends OracleType
implements Serializable {
    static final long serialVersionUID = 5643686037837085645L;
    int prec = 0;
    transient OracleConnection connection;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    protected OracleTypeTIMESTAMPTZ() {
    }

    public OracleTypeTIMESTAMPTZ(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public int getPrecision() throws SQLException {
        return this.prec;
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public int getTypeCode() {
        return -101;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.prec = streamInfo.readByte();
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.prec = objectInputStream.readByte();
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block9: {
            tIMESTAMPTZ = null;
            if (object == null) break block9;
            try {
                if (object instanceof TIMESTAMPTZ) {
                    tIMESTAMPTZ = (TIMESTAMPTZ)object;
                    break block9;
                }
                if (object instanceof byte[]) {
                    tIMESTAMPTZ = new TIMESTAMPTZ((byte[])object);
                    break block9;
                }
                if (object instanceof Timestamp) {
                    tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (Timestamp)object);
                    break block9;
                }
                if (object instanceof DATE) {
                    tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (DATE)object);
                    break block9;
                }
                if (object instanceof String) {
                    tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (String)object);
                    break block9;
                }
                if (object instanceof Date) {
                    tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (Date)object);
                    break block9;
                }
                if (object instanceof Time) {
                    tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (Time)object);
                    break block9;
                }
                DatabaseError.check_error(59, object);
            }
            catch (Exception exception) {
                DatabaseError.check_error(59, object);
            }
        }
        return tIMESTAMPTZ;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new TIMESTAMPTZ(byArray);
            }
            case 2: {
                return TIMESTAMPTZ.toTimestamp(this.connection, byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.check_error(59);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.prec);
    }
}

