/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jpub.runtime.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class MutableArray {
    int length;
    Object[] elements;
    Datum[] datums;
    ARRAY pickled;
    boolean pickledCorrect;
    int sqlType;
    ORADataFactory factory;
    CustomDatumFactory old_factory;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    public MutableArray(int n, ARRAY aRRAY, ORADataFactory oRADataFactory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = aRRAY;
        this.pickledCorrect = true;
        this.sqlType = n;
        this.factory = oRADataFactory;
    }

    public MutableArray(int n, double[] dArray, ORADataFactory oRADataFactory) {
        this.sqlType = n;
        this.factory = oRADataFactory;
        this.setArray(dArray);
    }

    public MutableArray(int n, float[] fArray, ORADataFactory oRADataFactory) {
        this.sqlType = n;
        this.factory = oRADataFactory;
        this.setArray(fArray);
    }

    public MutableArray(int n, int[] nArray, ORADataFactory oRADataFactory) {
        this.sqlType = n;
        this.factory = oRADataFactory;
        this.setArray(nArray);
    }

    public MutableArray(int n, Object[] objectArray, ORADataFactory oRADataFactory) {
        this.sqlType = n;
        this.factory = oRADataFactory;
        this.setObjectArray(objectArray);
    }

    public MutableArray(int n, Datum[] datumArray, ORADataFactory oRADataFactory) {
        this.sqlType = n;
        this.factory = oRADataFactory;
        this.setDatumArray(datumArray);
    }

    public MutableArray(int n, short[] sArray, ORADataFactory oRADataFactory) {
        this.sqlType = n;
        this.factory = oRADataFactory;
        this.setArray(sArray);
    }

    public MutableArray(ARRAY aRRAY, int n, CustomDatumFactory customDatumFactory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = aRRAY;
        this.pickledCorrect = true;
        this.sqlType = n;
        this.old_factory = customDatumFactory;
    }

    public MutableArray(double[] dArray, int n, CustomDatumFactory customDatumFactory) {
        this.sqlType = n;
        this.old_factory = customDatumFactory;
        this.setArray(dArray);
    }

    public MutableArray(float[] fArray, int n, CustomDatumFactory customDatumFactory) {
        this.sqlType = n;
        this.old_factory = customDatumFactory;
        this.setArray(fArray);
    }

    public MutableArray(int[] nArray, int n, CustomDatumFactory customDatumFactory) {
        this.sqlType = n;
        this.old_factory = customDatumFactory;
        this.setArray(nArray);
    }

    public MutableArray(Object[] objectArray, int n, CustomDatumFactory customDatumFactory) {
        this.sqlType = n;
        this.old_factory = customDatumFactory;
        this.setObjectArray(objectArray);
    }

    public MutableArray(Datum[] datumArray, int n, CustomDatumFactory customDatumFactory) {
        this.sqlType = n;
        this.old_factory = customDatumFactory;
        this.setDatumArray(datumArray);
    }

    public MutableArray(short[] sArray, int n, CustomDatumFactory customDatumFactory) {
        this.sqlType = n;
        this.old_factory = customDatumFactory;
        this.setArray(sArray);
    }

    public Object getArray() throws SQLException {
        return this.getArray(0L, Integer.MAX_VALUE);
    }

    public Object getArray(long l, int n) throws SQLException {
        int n2 = this.sliceLength(l, n);
        int n3 = (int)l;
        if (n2 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 6: 
            case 8: 
            case 101: {
                double[] dArray = new double[n2];
                int n4 = 0;
                while (n4 < n2) {
                    dArray[n4] = (Double)this.getObjectElement(n3++);
                    ++n4;
                }
                return dArray;
            }
            case 100: {
                float[] fArray = new float[n2];
                int n5 = 0;
                while (n5 < n2) {
                    fArray[n5] = ((Float)this.getObjectElement(n3++)).floatValue();
                    ++n5;
                }
                return fArray;
            }
            case 4: {
                int[] nArray = new int[n2];
                int n6 = 0;
                while (n6 < n2) {
                    nArray[n6] = (Integer)this.getObjectElement(n3++);
                    ++n6;
                }
                return nArray;
            }
            case 5: {
                short[] sArray = new short[n2];
                int n7 = 0;
                while (n7 < n2) {
                    sArray[n7] = (short)((Integer)this.getObjectElement(n3++)).intValue();
                    ++n7;
                }
                return sArray;
            }
            case 7: {
                float[] fArray = new float[n2];
                int n8 = 0;
                while (n8 < n2) {
                    fArray[n8] = ((Float)this.getObjectElement(n3++)).floatValue();
                    ++n8;
                }
                return fArray;
            }
        }
        return this.getObjectArray(l, n);
    }

    public int getBaseType() throws SQLException {
        return this.pickled.getBaseType();
    }

    public String getBaseTypeName() throws SQLException {
        return this.pickled.getBaseTypeName();
    }

    Datum[] getDatumArray(Connection connection) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (this.datums == null) {
            return null;
        }
        Datum[] datumArray = new Datum[this.length];
        int n = 0;
        while (n < this.length) {
            datumArray[n] = this.getDatumElement(n, connection);
            ++n;
        }
        return datumArray;
    }

    Datum getDatumElement(long l, Connection connection) throws SQLException {
        Datum datum = this.getLazyOracleArray()[(int)l];
        if (datum == null) {
            Object object = this.getLazyArray()[(int)l];
            this.datums[(int)l] = datum = Util.convertToOracle(object, connection);
        }
        return datum;
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.pickled.getDescriptor();
    }

    Object[] getLazyArray() throws SQLException {
        if (this.length == -1) {
            this.getLazyOracleArray();
        }
        if (this.elements == null) {
            this.elements = new Object[this.length];
        }
        return this.elements;
    }

    Datum[] getLazyOracleArray() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleArray();
                this.length = this.datums.length;
                this.pickledCorrect = true;
                if (this.elements != null) {
                    int n = 0;
                    while (n < this.length) {
                        if (this.elements[n] != null) {
                            this.datums[n] = null;
                            this.pickledCorrect = false;
                        }
                        ++n;
                    }
                }
            } else if (this.length >= 0) {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }

    public Object[] getObjectArray() throws SQLException {
        return this.getObjectArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getObjectArray(long l, int n) throws SQLException {
        Object[] objectArray;
        int n2 = this.sliceLength(l, n);
        if (n2 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 1: 
            case 12: {
                objectArray = new String[n2];
                break;
            }
            case 91: {
                objectArray = new Timestamp[n2];
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n2];
                break;
            }
            case 6: 
            case 8: {
                objectArray = new Double[n2];
                break;
            }
            case 4: 
            case 5: {
                objectArray = new Integer[n2];
                break;
            }
            case 7: {
                objectArray = new Float[n2];
                break;
            }
            case -2: {
                objectArray = (Object[])new byte[n2][];
                break;
            }
            default: {
                return this.getOracleArray(l, n);
            }
        }
        return this.getObjectArray(l, objectArray);
    }

    public Object[] getObjectArray(long l, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        int n = this.sliceLength(l, objectArray.length);
        int n2 = (int)l;
        if (n != objectArray.length) {
            return null;
        }
        switch (this.sqlType) {
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 93: {
                int n3 = 0;
                while (n3 < n) {
                    objectArray[n3] = this.getObjectElement(n2++);
                    ++n3;
                }
                return objectArray;
            }
        }
        return this.getOracleArray(l, objectArray);
    }

    public Object[] getObjectArray(Object[] objectArray) throws SQLException {
        return this.getObjectArray(0L, objectArray);
    }

    public Object getObjectElement(long l) throws SQLException {
        Object object = this.getLazyArray()[(int)l];
        if (object == null) {
            if (this.old_factory == null) {
                Datum datum = this.getLazyOracleArray()[(int)l];
                this.elements[(int)l] = object = Util.convertToObject(datum, this.sqlType, this.factory);
                if (Util.isMutable(datum, this.factory)) {
                    this.resetOracleElement(l);
                }
            } else {
                Datum datum = this.getLazyOracleArray()[(int)l];
                this.elements[(int)l] = object = Util.convertToObject(datum, this.sqlType, this.old_factory);
                if (Util.isMutable(datum, this.old_factory)) {
                    this.resetOracleElement(l);
                }
            }
        }
        return object;
    }

    public Object[] getOracleArray() throws SQLException {
        return this.getOracleArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getOracleArray(long l, int n) throws SQLException {
        Object[] objectArray;
        int n2 = this.sliceLength(l, n);
        if (n2 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case -13: {
                objectArray = new BFILE[n2];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n2];
                break;
            }
            case 1: 
            case 12: {
                objectArray = new CHAR[n2];
                break;
            }
            case 2005: {
                objectArray = new CLOB[n2];
                break;
            }
            case 91: {
                objectArray = new DATE[n2];
                break;
            }
            case 93: {
                objectArray = new TIMESTAMP[n2];
                break;
            }
            case -101: {
                objectArray = new TIMESTAMPTZ[n2];
                break;
            }
            case -102: {
                objectArray = new TIMESTAMPLTZ[n2];
                break;
            }
            case -104: {
                objectArray = new INTERVALDS[n2];
                break;
            }
            case -103: {
                objectArray = new INTERVALYM[n2];
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = new NUMBER[n2];
                break;
            }
            case -2: {
                objectArray = new RAW[n2];
                break;
            }
            case 100: {
                objectArray = new BINARY_FLOAT[n2];
                break;
            }
            case 101: {
                objectArray = new BINARY_DOUBLE[n2];
                break;
            }
            case 0: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: {
                if (this.old_factory == null) {
                    objectArray = new ORAData[n2];
                    break;
                }
                objectArray = new CustomDatum[n2];
                break;
            }
            default: {
                throw new SQLException("Unexpected OracleTypes type code: " + this.sqlType);
            }
        }
        return this.getOracleArray(l, objectArray);
    }

    public Object[] getOracleArray(long l, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        int n = this.sliceLength(l, objectArray.length);
        int n2 = (int)l;
        if (n != objectArray.length) {
            return null;
        }
        if (this.sqlType == 2002 || this.sqlType == 2007 || this.sqlType == 2003 || this.sqlType == 2006 || this.sqlType == 0) {
            if (this.old_factory == null) {
                int n3 = 0;
                while (n3 < n) {
                    objectArray[n3] = this.factory.create(this.getDatumElement(n2++, null), this.sqlType);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < n) {
                    objectArray[n4] = this.old_factory.create(this.getDatumElement(n2++, null), this.sqlType);
                    ++n4;
                }
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                objectArray[n5] = this.getDatumElement(n2++, null);
                ++n5;
            }
        }
        return objectArray;
    }

    public Object[] getOracleArray(Object[] objectArray) throws SQLException {
        return this.getOracleArray(0L, objectArray);
    }

    public Object getOracleElement(long l) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            Datum datum = this.getDatumElement(l, null);
            if (Util.isMutable(datum, this.factory)) {
                this.pickledCorrect = false;
            }
            return datum;
        }
        return this.getObjectElement(l);
    }

    public int length() throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        return this.length;
    }

    void resetElement(long l) throws SQLException {
        if (this.elements != null) {
            this.elements[(int)l] = null;
        }
    }

    void resetOracleElement(long l) throws SQLException {
        if (this.datums != null) {
            this.datums[(int)l] = null;
        }
        this.pickledCorrect = false;
    }

    public void setArray(double[] dArray) {
        if (dArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(dArray.length);
            this.elements = new Object[this.length];
            int n = 0;
            while (n < this.length) {
                this.elements[n] = new Double(dArray[n]);
                ++n;
            }
        }
    }

    public void setArray(double[] dArray, long l) throws SQLException {
        if (dArray == null) {
            return;
        }
        int n = this.sliceLength(l, dArray.length);
        int n2 = (int)l;
        int n3 = 0;
        while (n3 < n) {
            this.setObjectElement(new Double(dArray[n3]), n2++);
            ++n3;
        }
    }

    public void setArray(float[] fArray) {
        if (fArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(fArray.length);
            this.elements = new Object[this.length];
            int n = 0;
            while (n < this.length) {
                this.elements[n] = new Float(fArray[n]);
                ++n;
            }
        }
    }

    public void setArray(float[] fArray, long l) throws SQLException {
        if (fArray == null) {
            return;
        }
        int n = this.sliceLength(l, fArray.length);
        int n2 = (int)l;
        int n3 = 0;
        while (n3 < n) {
            this.setObjectElement(new Float(fArray[n3]), n2++);
            ++n3;
        }
    }

    public void setArray(int[] nArray) {
        if (nArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(nArray.length);
            this.elements = new Object[this.length];
            int n = 0;
            while (n < this.length) {
                this.elements[n] = new Integer(nArray[n]);
                ++n;
            }
        }
    }

    public void setArray(int[] nArray, long l) throws SQLException {
        if (nArray == null) {
            return;
        }
        int n = this.sliceLength(l, nArray.length);
        int n2 = (int)l;
        int n3 = 0;
        while (n3 < n) {
            this.setObjectElement(new Integer(nArray[n3]), n2++);
            ++n3;
        }
    }

    public void setArray(short[] sArray) {
        if (sArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(sArray.length);
            this.elements = new Object[this.length];
            int n = 0;
            while (n < this.length) {
                this.elements[n] = new Integer(sArray[n]);
                ++n;
            }
        }
    }

    public void setArray(short[] sArray, long l) throws SQLException {
        if (sArray == null) {
            return;
        }
        int n = this.sliceLength(l, sArray.length);
        int n2 = (int)l;
        int n3 = 0;
        while (n3 < n) {
            this.setObjectElement(new Integer(sArray[n3]), n2++);
            ++n3;
        }
    }

    void setArrayGeneric(int n) {
        this.length = n;
        this.datums = new Datum[n];
        this.pickled = null;
        this.pickledCorrect = false;
    }

    void setDatumArray(Datum[] datumArray) {
        if (datumArray == null) {
            this.setNullArray();
        } else {
            this.length = datumArray.length;
            this.elements = null;
            this.datums = (Datum[])datumArray.clone();
            this.pickled = null;
            this.pickledCorrect = false;
        }
    }

    void setDatumArray(Datum[] datumArray, long l) throws SQLException {
        if (datumArray == null) {
            return;
        }
        int n = this.sliceLength(l, datumArray.length);
        int n2 = (int)l;
        int n3 = 0;
        while (n3 < n) {
            this.setDatumElement(datumArray[n3], n2++);
            ++n3;
        }
    }

    void setDatumElement(Datum datum, long l) throws SQLException {
        this.resetElement(l);
        this.getLazyOracleArray()[(int)l] = datum;
        this.pickledCorrect = false;
    }

    void setNullArray() {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = null;
        this.pickledCorrect = false;
    }

    public void setObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(objectArray.length);
            this.elements = new Object[this.length];
            int n = 0;
            while (n < this.length) {
                this.elements[n] = objectArray[n];
                ++n;
            }
        }
    }

    public void setObjectArray(Object[] objectArray, long l) throws SQLException {
        if (objectArray == null) {
            return;
        }
        int n = this.sliceLength(l, objectArray.length);
        int n2 = (int)l;
        int n3 = 0;
        while (n3 < n) {
            this.setObjectElement(objectArray[n3], n2++);
            ++n3;
        }
    }

    public void setObjectElement(Object object, long l) throws SQLException {
        OracleLog.print(this, 2048, 2, 64, "MutableArray.setObjectElement( element = " + object + ",  n = " + l + ")");
        if (object == null) {
            this.getLazyOracleArray();
        }
        this.resetOracleElement(l);
        this.getLazyArray()[(int)l] = object;
    }

    public void setOracleArray(Object[] objectArray) {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])objectArray);
        } else {
            this.setObjectArray(objectArray);
        }
    }

    public void setOracleArray(Object[] objectArray, long l) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])objectArray, l);
        } else {
            this.setObjectArray(objectArray, l);
        }
    }

    public void setOracleElement(Object object, long l) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumElement((Datum)object, l);
        } else {
            this.setObjectElement(object, l);
        }
    }

    public int sliceLength(long l, int n) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (l < 0L) {
            return (int)l;
        }
        return Math.min(this.length - (int)l, n);
    }

    public Datum toDatum(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new ARRAY(ArrayDescriptor.createDescriptor(string, connection), connection, this.getDatumArray(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Datum toDatum(OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }
}

