import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.sql.*;
import java.io.*;
import javax.swing.event.*;

public class Analysis implements ActionListener,ListSelectionListener {
    
    private JButton logoutButton,displayButton,gotographicsBtn;
    private JFrame frame;
    private JPanel resultPanel;
    private Vector comboBox,checkBox;
    private String[] subjects = new String[15];
    private int noOfSubjects;
    private JTable tbl;
    private Vector rowVector;

    //Create a Menu Bar
    private JMenuBar createMenuBar() {
	JMenuBar menuBar;
	JMenu menu;
	JMenuItem menuItem;
	menuBar = new JMenuBar();
	menu = new JMenu("Mode");
	menuBar.add(menu);
	menuItem = new JMenuItem("Default Mode");
	menuItem.setEnabled(false);
	menuItem.addActionListener(this);
	menu.add(menuItem);	
	menuItem = new JMenuItem("Graphical Mode");
	menuItem.addActionListener(this);
	menu.add(menuItem);	
	menuItem = new JMenuItem("About");
	menuItem.setMaximumSize(new Dimension(60,100));
	menuItem.addActionListener(this);
	menuBar.add(menuItem);
	return menuBar;
    }
    
    //Create the components to be added to the frame
    private Component createComponents() {
	JLabel label;
	JPanel mainPanel = new JPanel(new GridLayout(2,0));
        JPanel queryPanel = new JPanel(new GridLayout(3,0));
	resultPanel = new JPanel(new GridLayout(1,1));
	resultPanel.setSize(400,200);
	resultPanel.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	mainPanel.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	
	label = new JLabel("Display Marks of students filtered by ");
	queryPanel.add(label);
	Box  vertBox = new Box(BoxLayout.Y_AXIS);
	Box  horBox = new Box(BoxLayout.X_AXIS);
        label = new JLabel("Subject");
	vertBox.add(label);
	try {
          Install ins=new Install();
	  ins.init();
	  ResultSet rs = ins.getSubjects();
	  int i=0;
	  checkBox = new Vector();
	  JCheckBox chkBx;
	  while(rs.next()) {
	      subjects[i]=rs.getString(1);
	      chkBx = new JCheckBox(subjects[i]);
	      checkBox.addElement(chkBx);
	      vertBox.add((JCheckBox)checkBox.elementAt(i));
	      i++;
	  }
          noOfSubjects=i;
	  ins.destroy();
        } catch(java.sql.SQLException sqle) {
	  System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
	  sqle.printStackTrace();
	  }
	Box  vertBox1 = new Box(BoxLayout.Y_AXIS);
	Box  vertBox2 = new Box(BoxLayout.Y_AXIS);
	comboBox = new Vector();
	JComboBox cB;
	label = new JLabel("From");
	vertBox1.add(label);
	label = new JLabel("To");
	vertBox2.add(label);
	String[] grades={"0","1","2","3","4","5","6","7","8","9","10"};
	for(int i=0;i<noOfSubjects;i++) {
	    cB = new JComboBox(grades);
	    comboBox.addElement(cB);
	    vertBox1.add(cB);
	    cB = new JComboBox(grades);
	    comboBox.addElement(cB);
	    vertBox2.add(cB);
	}
	horBox.add(Box.createGlue());
	horBox.add(vertBox);
	horBox.add(Box.createGlue());
	horBox.add(vertBox1);
	horBox.add(Box.createGlue());
	horBox.add(vertBox2);
	horBox.add(Box.createGlue());
	queryPanel.add(horBox);
	
	horBox = new Box(BoxLayout.X_AXIS);
	logoutButton = new JButton("Logout");
	displayButton = new JButton("Display");
	gotographicsBtn = new JButton("Graphical Analysis Mode");
	displayButton.addActionListener(this);
	logoutButton.addActionListener(this);
	gotographicsBtn.addActionListener(this);
	horBox.add(Box.createGlue());	
	horBox.add(logoutButton);
	horBox.add(Box.createGlue());
	horBox.add(displayButton);
	horBox.add(Box.createGlue());
	horBox.add(gotographicsBtn);
	horBox.add(Box.createGlue());
	queryPanel.add(horBox);

	mainPanel.add(queryPanel);
	mainPanel.add(resultPanel);
	return(mainPanel);
    }

    
    //Invoked when any button or menu item is clicked
     public void actionPerformed(ActionEvent event) {
 	String command=event.getActionCommand();
	if (command.equals("Display")) {
	    int[] lvalue = new int[15];
	    int[] hvalue = new int[15];
	    for(int i=0;i<noOfSubjects;i++) {
		lvalue[i]=0;
		hvalue[i]=10;
		if (((JCheckBox)checkBox.elementAt(i)).isSelected()) {
		    lvalue[i]=((JComboBox)comboBox.elementAt(2*i)).getSelectedIndex();
		    hvalue[i]=((JComboBox)comboBox.elementAt(2*i+1)).getSelectedIndex();
		    if (lvalue[i]>hvalue[i]) {
			JOptionPane.showMessageDialog(frame,"Incorrect range of marks in " + subjects[i]);
			return;
		    }

	    }
	    }
	    Vector row;
	    rowVector= new Vector();
	    Vector columnNames = new Vector();
	    try {
		Install ins=new Install();
		ins.init();
		ResultSet rs=ins.getMarks(lvalue,hvalue,noOfSubjects);
		columnNames.addElement("loginname");
		for(int i=0;i<noOfSubjects;i++) {
		    columnNames.addElement(subjects[i]);
		}
		while (rs.next()) {
		    row = new Vector();
		    row.addElement(rs.getString(1));
		    for(int i=1;i<=noOfSubjects;i++) {
			row.addElement(new Integer(rs.getInt(i+1)));
		    }
		    rowVector.addElement(row);
		}
		ins.destroy();
	    } catch(java.sql.SQLException sqle) {
		System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
		sqle.printStackTrace();
	    }
	    tbl = new JTable(rowVector,columnNames);
	    tbl.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
	    ListSelectionModel rowSM = tbl.getSelectionModel();
            rowSM.addListSelectionListener(this);
	    resultPanel.removeAll();
	    resultPanel.add(new JScrollPane(tbl,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED),BorderLayout.CENTER);
	    resultPanel.repaint();
	    frame.setVisible(true);
	}
	else if (command.equals("Logout")) {
	    System.exit(0);
	}else if (command.equals("About")) {
	    JOptionPane.showMessageDialog(frame," Assignment 4 : Java Using Swing \n \n Group No.           :  G6 \n Group members :  Dheren Gala (04305011)\n                              Kriti Puniyani (04305012)");
	}else if (command.equals("Graphical Mode")||command.equals("Graphical Analysis Mode")) {
	    frame.setVisible(false);
	    Graphics2 g = new Graphics2();
	    g.panels();
	}
     }

    //Invoked when any cell in the table of results is clicked
    public void valueChanged(ListSelectionEvent e) {
	int row1 = tbl.getSelectedRow();
	int col = tbl.getSelectedColumn();
	Vector row = null;
	Vector columnNames = new Vector(); 
	columnNames.addElement("loginname");
	for(int i=0;i<noOfSubjects;i++) {
	    columnNames.addElement(subjects[i]);
	}
	if (col!=0) {
	    int marks = ((Integer)(((Vector)rowVector.elementAt(row1)).elementAt(col))).intValue();
	int[] lvalue = new int[15];
	int[] hvalue = new int[15];
	for(int i=0;i<noOfSubjects;i++) {
	    lvalue[i]=0;
		hvalue[i]=10;
		if (i==(col-1)) {
		    lvalue[i]=marks;
		    hvalue[i]=marks;
		}
	    }
	    try {
		rowVector= new Vector();
		Install ins=new Install();
		ins.init();
		ResultSet rs=ins.getMarks(lvalue,hvalue,noOfSubjects);
		while (rs.next()) {
		    row = new Vector();
		    row.addElement(rs.getString(1));
		    for(int i=1;i<=noOfSubjects;i++) {
			row.addElement(new Integer(rs.getInt(i+1)));
		    }
		    rowVector.addElement(row);
		}
		ins.destroy();
	    } catch(java.sql.SQLException sqle) {
		System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
		sqle.printStackTrace();
	    }
	}else {
	    String login = (String)(((Vector)rowVector.elementAt(row1)).elementAt(col));
	    try {
		rowVector= new Vector();
		Install ins=new Install();
		ins.init();
		ResultSet rs=ins.getStudentMarks(login);
		row = new Vector();
		row.addElement(login);
		while (rs.next()) {
		    row.addElement(new Integer(rs.getInt(2)));
    		}
		ins.destroy();
	    } catch(java.sql.SQLException sqle) {
		System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
		sqle.printStackTrace();
	    }
	    rowVector.addElement(row);
	    
	}
	    tbl = new JTable(rowVector,columnNames);
	    tbl.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
	    ListSelectionModel rowSM = tbl.getSelectionModel();
            rowSM.addListSelectionListener(this);
	    resultPanel.removeAll();
	    resultPanel.add(new JScrollPane(tbl,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED),BorderLayout.CENTER);
	    resultPanel.repaint();
	    frame.setVisible(true);
  
    } 


    public  void createAndShowGUI() {
        
	//Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create and set up the window.
        frame = new JFrame("Analysis");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	frame.setJMenuBar(createMenuBar());
        //Survey sur = new Survey();
        Component contents = createComponents();
        frame.getContentPane().add(contents, BorderLayout.CENTER);

        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }

    /* public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
	       	Analysis anl = new Analysis();
		anl.createAndShowGUI();
            }
        });
	}*/
}
