import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;
import java.sql.*;
import java.io.*;
                                                                                        
public class BarChart extends JPanel {
    final static int maxCharHeight = 15;
    final static int minFontSize = 6;

    private Properties formProps = null;    
    private static String conffile = "graphicalForm.cfg";
	String colorString;

    static Color bg;
    static Color fg = Color.black;
    static Color red = Color.red;
   
    int width, interbarsdist, intrabarsdist;
    final static BasicStroke stroke = new BasicStroke(2.0f);
    final static BasicStroke wideStroke = new BasicStroke(8.0f);

    Dimension totalSize;
    FontMetrics fontMetrics;

	 Color[] c;
	 int[][] displayValues;
	 String[] subjects;
	 int[] rangeStart;
	 int noOfBars;
	 int countFields;
	 int noOfColors;
	 int maxValue;

	
          private void initialiseColor(String colorStr)
		{		
		String[] colorArray = colorStr.split("\\s");
		noOfColors = colorArray.length;
		
		for(int i=0; i<noOfColors; i++)
			c[i] = returnColor(colorArray[i]);		
		
		}   

	public Color returnColor(String color)
	{
	Color c;

	if(color.equals("red"))	c = Color.red;
	else  if(color.equals("blue"))  c = Color.blue; 
	else  if(color.equals("green"))  c = Color.green;
	else  if(color.equals("black"))  c = Color.black;
	else  if(color.equals("cyan"))  c = Color.cyan;
	else  if(color.equals("gray"))  c = Color.gray;
	else  if(color.equals("darkGray"))  c = Color.darkGray;
        else  if(color.equals("orange"))  c = Color.orange;
        else  if(color.equals("white"))  c = Color.white;
        else  if(color.equals("yellow"))  c = Color.yellow;
        else  if(color.equals("pink"))  c = Color.pink;
        else  if(color.equals("magenta"))  c = Color.magenta;
        else  if(color.equals("lightGray"))  c = Color.lightGray;
	else c = Color.red;
	return c;

	}

	


      private void loadProperties(String propFileName)  throws IOException {
        File f = new File(propFileName);
       
        FileInputStream fis = new FileInputStream(propFileName);
        formProps = new Properties();
        formProps.load(fis);
        colorString = formProps.getProperty("barColorOrder");
	String formBGColor = formProps.getProperty("bkgndColor");
	bg = new Color(Integer.parseInt(formBGColor,16));
	String fgColor =  formProps.getProperty("frgnd");
	fg = returnColor(fgColor);
	
        initialiseColor(colorString);
	
	String s1 = formProps.getProperty("width");
        width = Integer.parseInt(s1);
	s1 = formProps.getProperty("interbarsdist");
        interbarsdist = Integer.parseInt(s1);
	s1 = formProps.getProperty("intrabarsdist");
        intrabarsdist = Integer.parseInt(s1);
	

      }
 
                                                                                    
    public void init(int displayValues1[][], String subjects1[], int rangeStart1[], int noOfBars1, int CountFields1) {
       
	int i,j,k;
	 displayValues = new int[15][15];
         subjects = new String[15];
         rangeStart = new int[15];
         c = new Color[10];

	//initialise parameters
	maxValue=0;
	noOfBars = noOfBars1;
	countFields = CountFields1;
	for(i=0; i< countFields; i++)
		subjects[i] = subjects1[i];
	for(i=0; i< noOfBars; i++)
		rangeStart[i] = rangeStart1[i];
	for(i=0; i< countFields; i++)
		for(j=0; j< noOfBars; j++)
			{
			displayValues[i][j] = displayValues1[i][j];
			if(displayValues[i][j] > maxValue)
				maxValue = displayValues[i][j];
			}
	rangeStart[noOfBars] = 11;

	try{
        loadProperties(conffile);

        } catch(Exception e)
        {
        System.out.println("Properties could not be loaded");
        e.printStackTrace(System.out);
        }
	
	setBackground(bg);
        setForeground(fg);

	}

  
     public void paintComponent(Graphics g1) {
	super.paintComponent(g1);
	if(g1 instanceof Graphics2D)
	{
        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension d = getSize();
	int gridWidth = interbarsdist;
        int gridHeight = d.height - 40;

	// some nice 3d rectangle as border in gray color
        Color fg3D = Color.lightGray;
        g2.setPaint(fg3D);
        g2.draw3DRect(0, 0, d.width - 1, d.height - 1, true);
        g2.draw3DRect(3, 3, d.width - 7, d.height - 7, false);
        g2.setPaint(fg);
                                                         
	// set parameters                                                                    
        int x = 80;
        int y ;
        int rectWidth = width;
	int rectHeight;

	//draw the axes and name them
	y = gridHeight - 40;
	g2.draw(new Line2D.Double(x, y, x + d.width, y));
        g2.drawString("X Axis - Value", d.width/2, y+20);
	g2.draw(new Line2D.Double(x, y, x, 10 ));
        g2.drawString("Y Axis", 5, d.height/2-10);
	g2.drawString("Count", 5, d.height/2+15);
        x += gridWidth/2;
                                                                                                                             
	// label the y axis
	int pos = gridHeight - 40;
        int total = gridHeight/11;
	for(int i=0; i<=10; i++)
	 	{
		g2.drawString(Integer.toString(i*(int)(maxValue /10 + 1)), 40, pos);
		pos -= (total-3);
		}
		

	// draw the rectangles
	for(int i=0; i< noOfBars; i++)
		{
		for( int j=0; j< countFields; j++)
	  		{
			
			rectHeight = (int)(displayValues[j][i] * (gridHeight) / ((int)(maxValue/10 +2)*10)); 
			y = gridHeight - rectHeight - 40;
			//set Color
			g2.setPaint(c[j%noOfColors]);
		
			g2.fill(new Rectangle2D.Double(x, y, rectWidth, rectHeight));
		      	x+=width+intrabarsdist;
			}

	        g2.setPaint(fg);	
		g2.drawString(Integer.toString(rangeStart[i]) + "-" + Integer.toString(rangeStart[i+1]-1), x-countFields*(width+intrabarsdist), gridHeight-30);
	        x += gridWidth;
		}

	// write the key
	y=d.height-20;
	for(int i=countFields-1; i>=0; i--)
		{
		 g2.setPaint(c[i%noOfColors]);
                 g2.fill(new Rectangle2D.Double(100, y, 24, 12));
		g2.drawString(subjects[i],150,y+12);
		y-=12;

		
		}


	}	// end of if G1 instanceof
  }       // end of paint


}	// end of class

