import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.sql.*;
import java.io.*;
import javax.swing.event.*;

public class CreateSurvey implements ActionListener {
   
    JFrame frame;
    JTextArea textArea;

     private Component createComponents() {
	 JPanel panel = new JPanel(new GridLayout(0,1));
	 JLabel label = new JLabel("List the names of subjects :");
	 textArea = new JTextArea();
	 textArea.setEditable(true);
	 JButton logoutButton = new JButton("Logout");
	 logoutButton.addActionListener(this);
	 JButton createButton = new JButton("Create");
	 createButton.addActionListener(this);
	
	 Box  vertBox= new Box(BoxLayout.Y_AXIS);
	 Box  horBox = new Box(BoxLayout.X_AXIS);
	 
	 horBox.add(Box.createGlue());
	 horBox.add(label);
	 horBox.add(Box.createGlue());
	 vertBox.add(horBox);
	 
	 horBox = new Box(BoxLayout.X_AXIS);
	 horBox.add(Box.createGlue());
	 horBox.add(new JScrollPane(textArea,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED),BorderLayout.CENTER);
	 horBox.add(Box.createGlue());
	 vertBox.add(horBox);

	 horBox = new Box(BoxLayout.X_AXIS);
	 horBox.add(Box.createGlue());
	 horBox.add(logoutButton);
	 horBox.add(Box.createGlue());
	 horBox.add(createButton);
	 horBox.add(Box.createGlue());
	 vertBox.add(horBox);

	 panel.add(vertBox);
	return panel;
     }

    public void actionPerformed(ActionEvent event) {
	String command = event.getActionCommand();
	if (command.equals("Create")) {
	    String text = textArea.getText();
	    if (text.equals("")) {
		JOptionPane.showMessageDialog(frame,"Subject list empty");
		return;
	    }
	    String[] subjects = text.split("\n");
	    Install ins = new Install();
	    ins.setSubjects(subjects);
	    JOptionPane.showMessageDialog(frame,"Subject list changed successfully");
	    System.exit(0);
	}else if (command.equals("Logout")) {
	    System.exit(0);
	}
	
    }

    public  void createAndShowGUI() {
        
	//Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create and set up the window.
        frame = new JFrame("Create Survey");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        Component contents = createComponents();
        frame.getContentPane().add(contents, BorderLayout.CENTER);

        //Display the window.
        frame.pack();
	frame.setSize(500,380);
        frame.setVisible(true);
    }

    /*public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
	       	CreateSurvey cS = new CreateSurvey();
		cS.createAndShowGUI();
            }
        });
	}*/
}
