import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;  
import java.sql.*;
import java.io.*;
                                    
public class Graphics2 implements ActionListener {
	JFrame barChartFrame;
	JPanel radioOptions, barOptions, graphicChoicePanel, middlePanel;
	final ButtonGroup graphicType = new ButtonGroup();
	final ButtonGroup graphicTypep = new ButtonGroup();
	final ButtonGroup graphicTypex = new ButtonGroup();
	final ButtonGroup graphicTypey = new ButtonGroup();

	final String barCommand = "Bar chart";    
	final String pieCommand = "Pie chart";
	final String scatterCommand = "Scatter diagram";
	final int numButtons = 3;
	Vector checkBox;
	Vector comboBox;
	Vector comboBoxp;
    	JButton cancelButton,submitButton, analysisButton;
    	int noOfSubjects;
	Box vertBox, pieBox, scatterBox;
	String[] subjects = new String[15];
	JRadioButton[] radioButtons, radioButtonp, radioButtonx, radioButtony;
	int sizex, sizey;


    private JMenuBar createMenuBar() {
	JMenuBar menuBar;
	JMenu menu;
	JMenuItem menuItem;
	menuBar = new JMenuBar();
	menu = new JMenu("Mode");
	menuBar.add(menu);
	menuItem = new JMenuItem("Default Mode");
	menuItem.addActionListener(this);
	menu.add(menuItem);	
	menuItem = new JMenuItem("Graphical Mode");
	menuItem.setEnabled(false);
	menuItem.addActionListener(this);
	menu.add(menuItem);	
	menuItem = new JMenuItem("About");
	menuItem.setMaximumSize(new Dimension(60,100));
	menuItem.addActionListener(this);
	menuBar.add(menuItem);
	return menuBar;
    }


public void panels()
	{
	barChartFrame = new JFrame("Graphical Analysis");
	barChartFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	barChartFrame.setJMenuBar(createMenuBar());
	radioOptions = new JPanel();
	barOptions = new JPanel();
	middlePanel = new JPanel();
	addWidgets();

	graphicChoicePanel.setSize(new Dimension(100,50));
	barChartFrame.getContentPane().add(graphicChoicePanel, BorderLayout.NORTH);
	barChartFrame.getContentPane().add(middlePanel, BorderLayout.CENTER);
	barChartFrame.getContentPane().add(barOptions, BorderLayout.SOUTH);

        barChartFrame.pack();
        barChartFrame.setSize(new Dimension(500, 450));
        barChartFrame.setVisible(true);
	}


/*algo for submit:
if radiobutton == Bar chart then
	1. read checkbox values and store in array check along with countFields
	2. raed combovalue = noOfBars
	2(a) calculate range starting point for every bar and store it in rangeStart[]
	3. call query to find count of all those selected in checkbox (hockey_count + chess-count) for each range value i
	4. store in 2 d array displayValues
	5. pass 2d array, fieldValue(hockey...), rangeStart, noOfBars and countFields to barChart.java
todo : define function in barchart & call it
write query

*/
public void actionPerformed(ActionEvent event) 
	{
	String command=event.getActionCommand();

	// get query for Bar Chart
	if (command.equals("Show Results") && radioButtons[0].isSelected()) 
		{
		Install ins=new Install();
		int i, k;
		int[] check = new int[15];
		int[][] displayValues = new int[15][15];
		int noOfBars = ((JComboBox)comboBox.elementAt(0)).getSelectedIndex() + 1;
		int[] rangeStart = new int[15];

		// Calculate rangestart		
		for(i = 0; i<=noOfBars; i++)
			rangeStart[i] = 0;
		for(i = 0; i<=10; i++)
			rangeStart[i%noOfBars]++;
		rangeStart[noOfBars+1] = 11;
		for(i = noOfBars; i>=0; i--)
			rangeStart[i] = rangeStart[i+1] - rangeStart[i];

		
		int countFields = 0;

		// read checkboxes and combobox
		for(i=0;i<noOfSubjects;i++) 
			{
			if (((JCheckBox)checkBox.elementAt(i)).isSelected()) 
				{ check[i] = 1; countFields++;	}
				
			else 	check[i] = 0;
			}
		
		// store subject & display values by firing queries
		ins.init();
		try{
		ResultSet rs = ins.getSubjects();
		i=0;
		Install ins1 = new Install();
		int j=0;
	        while(rs.next()) 
		      {
	             
		      if(check[i] == 1)
			        {
				subjects[j]=rs.getString(1);

				for(k = 0; k < noOfBars; k++)
					{
					ins1.init();
					displayValues[j][k] = ins1.getStats(subjects[i], rangeStart[k], rangeStart[k+1]-1);
					ins1.destroy();
					}
				j++;		
				} 
			i++;
			}		
		}catch(Exception e) {}
		ins.destroy();
	        


	// call the barchart class wih the values
	// pass 2d array, fieldValue(hockey...), rangeStart, noOfBars and countFields to barChart.java
	BarChartListen b = new BarChartListen();
	b.create(displayValues, subjects, rangeStart, noOfBars, countFields);

	return;
	}  //end of bar chart part
	
	
//------------------------------------------------------------------------------------------
	

	//Pie chart display - displyValue[], FieldValue, rangeStart[], noOfSectors
	if (command.equals("Show Results") && radioButtons[1].isSelected()) 
		{
		Install ins=new Install();
		int i, k;
		int[] displayValues = new int[15];
		int noOfSectors = ((JComboBox)comboBoxp.elementAt(0)).getSelectedIndex() + 1;
		int[] rangeStart = new int[15];
		String subject = new String();

		// Calculate rangestart		
		for(i = 0; i<=noOfSectors; i++)
			rangeStart[i] = 0;
		for(i = 0; i<=10; i++)
			rangeStart[i%noOfSectors]++;
		rangeStart[noOfSectors+1] = 11;
		for(i = noOfSectors; i>=0; i--)
			rangeStart[i] = rangeStart[i+1] - rangeStart[i];

		try{
		for(i=0;i<radioButtonp.length;i++) 
			{
			if(radioButtonp[i].isSelected()) break;	
			}
		subject = subjects[i];

		}catch(Exception e) {System.out.println("subjectexception");
				e.printStackTrace();	}

		// store display values by firing queries
		try{
		i=0;
		for(k = 0; k < noOfSectors; k++)
			{
			ins.init();
			displayValues[k] = ins.getStats(subject, rangeStart[k], rangeStart[k+1]-1);
			ins.destroy();
			}
		}catch(Exception e) {System.out.println("exception");}
	
		//call the PieChartListen function
		PieChartListen p = new PieChartListen();
	        p.create(displayValues, subject, rangeStart, noOfSectors);
		return;
                                                                                                                             
		} 
//----------------------------------------------------------------------------------------

	// Scatter chart - use displayValuesx[], displayValuesy[], subjectx, subjecty
	else if (command.equals("Show Results") && radioButtons[2].isSelected())
		{
		Install ins=new Install();
		int i, k;
		int[] displayValuesx = new int[100];
		int[] displayValuesy = new int[100];
		String subjectx = new String();
		String subjecty = new String();


		try{
		for(i=0;i<radioButtonx.length;i++) 
			{
			if(radioButtonx[i].isSelected()) break;	
			}
		subjectx = subjects[i];
		for(i=0;i<radioButtony.length;i++) 
			{
			if(radioButtony[i].isSelected()) break;	
			}
		subjecty = subjects[i];
		if(subjecty.equals(subjectx))
			{	
			JOptionPane.showMessageDialog(barChartFrame, "Error\nPlease select different subjects on X and Y axes");
			return;
			}
		}catch(Exception e) {System.out.println("subjectexception");
				e.printStackTrace();	}

		// store display values by firing queries
		try{
		ins.init();
		i=0;
		ResultSet rs =  ins.getScatter(subjectx);
		while(rs.next())
	              {
	                displayValuesx[i] = rs.getInt(1);
	                i++;
	                }
		sizex = i;
		ins.destroy();
		ins.init();
		i=0;
		rs =  ins.getScatter(subjecty);
                while(rs.next())
                      {
                        displayValuesy[i] = rs.getInt(1);
                        i++;
                        }
                sizey = i;

		ins.destroy();
		}catch(Exception e) {System.out.println("exception"); e.printStackTrace();}

		//call the scatterListen function
		ScatterChartListen s = new ScatterChartListen();
	        s.create(displayValuesx, displayValuesy, subjectx, subjecty, sizex, sizey);
		return;
                                                                                                                             
		} // end of scatter

//---------------------------------------------------------------------------		

	else if (command.equals("Logout")) 
	     {
	     System.exit(0);
	     }


	else if (command.equals("Bar chart"))
		{
		middlePanel.removeAll();
		middlePanel.add(vertBox);
		middlePanel.repaint();
		barChartFrame.getContentPane().add(middlePanel, BorderLayout.CENTER);
		barChartFrame.setVisible(true);
		}

	else if (command.equals("Pie chart"))
		{
		middlePanel.removeAll();
		middlePanel.add(pieBox);
		middlePanel.repaint();
		barChartFrame.getContentPane().add(middlePanel, BorderLayout.CENTER);
		barChartFrame.setVisible(true);
		}
	else if (command.equals("Scatter diagram"))
		{
		middlePanel.removeAll();
		middlePanel.add(scatterBox);
		middlePanel.repaint();
		barChartFrame.getContentPane().add(middlePanel, BorderLayout.CENTER);
		barChartFrame.setVisible(true);
		}
	else if (command.equals("About")) 
	    {
		JOptionPane.showMessageDialog(barChartFrame," Assignment 4 : Java Using Swing \n \n Group No.           :  G6 \n Group members :  Dheren Gala (04305011)\n                              Kriti Puniyani (04305012)");
	    }
	else if (command.equals("Default Analysis Mode") || command.equals("Default Mode")) 
	    {
	    barChartFrame.dispose();
	    Analysis anl = new Analysis();
	    anl.createAndShowGUI();
	    }
	else if (command.equals("Show Results"))
		 JOptionPane.showMessageDialog(barChartFrame,"Please select 1 option in the Radio Buttons provided");
    }	// end of action listener


public void addWidgets()
	{	
	// add stuff in the graphicChoicePanel
	radioButtons = new JRadioButton[numButtons];

	radioButtons[0] = new JRadioButton("Bar chart");
	radioButtons[0].setActionCommand(barCommand);

	radioButtons[1] = new JRadioButton("Pie chart");
	radioButtons[1].setActionCommand(pieCommand);

	radioButtons[2] = new JRadioButton("Scatter diagram");
	radioButtons[2].setActionCommand(scatterCommand);

	for (int i = 0; i < numButtons; i++) 
		{
    		graphicType.add(radioButtons[i]);
		radioButtons[i].addActionListener(this);

		}

        graphicChoicePanel = new JPanel();

        graphicChoicePanel.setLayout(new BoxLayout(graphicChoicePanel, BoxLayout.PAGE_AXIS));

        for (int i = 0; i < numButtons; i++) 
		{            
		graphicChoicePanel.add(radioButtons[i]);
	        }

	// add stuff in the vertBox - bar chart
        barOptions.setBorder(BorderFactory.createEmptyBorder(
                                        30, //top
	                                30, //left
	                                10, //bottom
	                                30) //right
	                                );
	
     	String[] grades={"1","2","3","4","5","6","7","8","9","10"};
	vertBox = new Box(BoxLayout.Y_AXIS);

        JLabel label = new JLabel("Subject");
	vertBox.add(label);
	try {
          Install ins=new Install();
	  ins.init();
	  ResultSet rs = ins.getSubjects();
	  int i=0;
	  checkBox = new Vector();
	  JCheckBox chkBx;
	  while(rs.next()) {
	      subjects[i]=rs.getString(1);
	      chkBx = new JCheckBox(subjects[i]);
	      checkBox.addElement(chkBx);
	      vertBox.add((JCheckBox)checkBox.elementAt(i));
	      i++;
	  }
          noOfSubjects=i;
	vertBox.add(Box.createRigidArea(new Dimension(0,10)));

	JLabel noOfBar= new JLabel("No of Bars to be Displayed");
	vertBox.add(noOfBar);
	JComboBox cB;
	comboBox = new Vector();
	   cB = new JComboBox(grades);
            comboBox.addElement(cB);
            vertBox.add(cB);

	  ins.destroy();
        } catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
	    }


	cancelButton = new JButton("Logout");
	submitButton = new JButton("Show Results");
	analysisButton = new JButton("Default Analysis Mode");

	cancelButton.addActionListener(this);
	submitButton.addActionListener(this);
	analysisButton.addActionListener(this);

	barOptions.add(cancelButton);
	barOptions.add(submitButton);
	barOptions.add(analysisButton);

	// put stuff in the pie chart pieBox
	JLabel subj = new JLabel("Subject");
	pieBox = new Box(BoxLayout.Y_AXIS);
	 radioButtonp = new JRadioButton[15];
	 int i=0;
	try {
          Install ins=new Install();
	  ins.init();
	  ResultSet rs = ins.getSubjects();
	 
	  while(rs.next()) {
		subjects[i]=rs.getString(1);
		radioButtonp[i] = new JRadioButton(subjects[i]);
		radioButtonp[i].setActionCommand(subjects[i]);
	        i++;
	  	}
	ins.destroy();
	}catch(Exception e){}
          noOfSubjects=i;
	pieBox.add(subj);
	for (i = 0; i < noOfSubjects; i++) 
		{
    		graphicTypep.add(radioButtonp[i]);
		radioButtonp[i].addActionListener(this);
		pieBox.add(radioButtonp[i]);
		}

	pieBox.add(Box.createRigidArea(new Dimension(0,10)));

	JLabel noOfPie= new JLabel("No of Sectors in the Pie to be Displayed");
	pieBox.add(noOfPie);
	JComboBox cBp;
	comboBoxp = new Vector();
	   cBp = new JComboBox(grades);
            comboBoxp.addElement(cBp);
            pieBox.add(cBp);

	// put stuff in the scatter diagram box scatterBox

	 scatterBox = new Box(BoxLayout.X_AXIS);
	 Box box1, box2;
	 box1 = new Box(BoxLayout.Y_AXIS);
	 box2 = new Box(BoxLayout.Y_AXIS);

         radioButtonx = new JRadioButton[15];
	 radioButtony = new JRadioButton[15];

	JLabel  xAxis = new JLabel("X Axis Subject Value");
        JLabel  yAxis = new JLabel("Y Axis Subject Value");
                           
	box1.add(xAxis);
        box2.add(yAxis);

         i=0;
        try {
          Install ins=new Install();
          ins.init();
          ResultSet rs = ins.getSubjects();
                                                                                                                             
          while(rs.next()) {
                subjects[i]=rs.getString(1);
                radioButtonx[i] = new JRadioButton(subjects[i]);
                radioButtonx[i].setActionCommand(subjects[i]);
		radioButtony[i] = new JRadioButton(subjects[i]);
                radioButtony[i].setActionCommand(subjects[i]);
                i++;
                }
        ins.destroy();
        }catch(Exception e){}

        noOfSubjects=i;
        for (i = 0; i < noOfSubjects; i++)
                {
                graphicTypex.add(radioButtonx[i]);
                radioButtonx[i].addActionListener(this);
                                                                                                                             
                box1.add(radioButtonx[i]);
		graphicTypey.add(radioButtony[i]);
                radioButtony[i].addActionListener(this);
                box2.add(radioButtony[i]);
                }
                                                                                                                         
       	box1.add(Box.createRigidArea(new Dimension(0,10)));
	box2.add(Box.createRigidArea(new Dimension(0,10)));

	scatterBox.add(Box.createGlue());
	scatterBox.add(box1);
	scatterBox.add(Box.createGlue());
	scatterBox.add(Box.createRigidArea(new Dimension(30,30)));
	scatterBox.add(box2);
	scatterBox.add(Box.createGlue());
    }
	

 
/*
 public static void main(String s[]) 
	{
	Graphics2 g = new Graphics2();
	g.panels();
	}                 
*/
}
