import java.util.*;
import java.sql.*;
import java.io.*;

/** This class acts as a thick wrapper class for the database.
 */
public class Install{
    
    static public Connection conn =  null;
    private Properties dbProps = null;
    private static String confFile = "db.conf";
    private PreparedStatement pstmt;
    
    private static void loadDriver()
    throws Exception {
        String driver = "org.gjt.mm.mysql.Driver";
        Class.forName(driver);
    }
    
    Install() {
        try{
            loadDriver();
            loadProperties(confFile);
        } catch (Exception e){
            e.printStackTrace(System.out);
            System.out.println("Properties could not be loaded... Please restart the server or check for database connectivity.");
        }finally{
        }
    }
    public void init() {
        try {
            if(conn != null) destroy();
            //System.out.print("<");
            conn = getConnection();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void destroy() {
        try{
            pstmt.clearParameters();
            pstmt.close();
            conn.close();
            conn = null;
            //System.out.print(">");
        } catch (Exception e){
     //       e.printStackTrace(System.out);
       //     System.out.println("Destrying Login servlet. Could not close database connection..");
        }finally{
        }
    }
    
    private void loadProperties(String propFileName)
    throws IOException {
        File f = new File(propFileName);
        //System.out.println("The db.conf is in : " + f.getAbsolutePath());
        FileInputStream fis = new FileInputStream(propFileName);
        dbProps = new Properties();
        dbProps.load(fis);
    }
    
    
    public Connection getConnection() throws Exception{
        // Load the required drivers
        Install.loadDriver();
        int dbPort = Integer.parseInt(dbProps.getProperty("dbport"));
        String dbHost = dbProps.getProperty("dbhost");
        String dbUser = dbProps.getProperty("dbuser");
        String dbPassword = dbProps.getProperty("dbpassword");
        String dbName = dbProps.getProperty("dbname");
        String dbType = dbProps.getProperty("dbtype");
        
        String jdbcString = "jdbc:"+dbType+"://"+dbHost+"/"+dbName+"?user="+dbUser+"&password="+dbPassword;
        // Don't print the string as then passwd will be exposed
        
        if(conn == null){
            conn = DriverManager.getConnection(jdbcString);
        }else if(conn.isClosed()){
            System.out.println("Connection was lost, May be because of time out. Reconnect it.");
            conn=DriverManager.getConnection(jdbcString);
        }
        return conn;
    }
    
    public boolean doesUserExist(String loginname) {
  
        boolean r=true;
        try {
            init();
            String query = "Select password from logininfo where login = '"+loginname+"'";
	    //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            if(rs.next())
                      r=true;
                else
                      r=false;
                rs.close();
       
            destroy();
        } catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return(r);
    }
 
    
    public boolean getUserPassword(String loginname, String Password) {
        String password = "";
	boolean r=true;
        try {
            init();
            String query = "Select password from logininfo where login = '"+loginname+"'";
            //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            if(rs.next()) 
		{
		password = rs.getString("password");
		if(password.equals(Password))
			r=true;
		else
			r=false;
	        rs.close();
		}
	    else r = false;
            destroy();
        } catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return(r);
    }
	
    public void addUser(String loginname, String password) {
        
        try {
            init();
            String query = "insert into logininfo (login, password) values (\"" + loginname + "\", \"" + password +"\");";
            //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            pstmt.execute();
	    destroy();
	    } catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
   }

    
    /*public ResultSet getStudentMarks1(String loginid) {
        try {
            String query = "select l.login as k, name as k1, subjectname as Subject ,marks as" +
            " Marks from logininfo l,subjectinfo s,marks m where l.login = m.loginid AND s.subjectid = m.subjectid" +
            (loginid.equals("all") ? "" : " AND m.loginid = " + loginid) +
            " order by l.login";
            System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            return rs;
        }catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return null;
    }*/
    
     public ResultSet getStudentMarks(String loginid) {
        try {
            String query = "select subjectid,marks from marks where loginid = " + loginid;
            //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            return rs;
        }catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return null;
    }
    
    /*public ResultSet getSubjectMarks1(String subjectName,String filterCondition, String filterValue)  {
        try {
            String query = "select subjectname as k, l.login as Login, name as Name, marks as Marks" +
            " from logininfo l,subjectinfo s,marks m where l.login = m.loginid AND s.subjectid = m.subjectid" +
            (subjectName.equals("all") ? "" : " AND s.subjectname = '"+subjectName + "'") +
            (filterCondition == null ? "" : " AND m.marks " + filterCondition + " " + filterValue) +
            " order by subjectname";
            System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            return rs;
        }catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return null;
	}*/
    
    
     public ResultSet getSubjectMarks(int subjectID, int filterValue)  {
        try {
            String query = "select login, marks from  marks  where subjectid = " + subjectID +
            " AND marks = "+ filterValue;
            //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            return rs;
        }catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return null;
    }


    public ResultSet getMarks(int[] lvalue, int[] hvalue, int noOfSubjects) {
	/*for(int i=0;i<noOfSubjects;i++)
	  System.out.println(lvalue[i]+"......."+hvalue[i]+"\n");*/
	try {
	    String[] strnum = {"0","1","2","3","4","5","6","7","8","9","10","11","12","13","14"}; 
	    String fields = " distinct T0.loginid, T0.marks as sub0";
	    String tables = "marks as T0";
	    String condition = "T0.subjectid=0" + " and T0.marks>=" + strnum[lvalue[0]] + " and T0.marks<=" + strnum[hvalue[0]];
	    for(int i=1;i<noOfSubjects;i++) {
		fields += ", T" + strnum[i] + ".marks as sub" + strnum[i];
		tables += ", marks as T" + strnum[i];
		condition +=" and T" + strnum[i-1] + ".loginid=T" + strnum[i] + ".loginid" +  " and T" + strnum[i] + ".subjectid=" + strnum[i] + " and T" + strnum[i] + ".marks>=" + strnum[lvalue[i]] + " and T" + strnum[i] + ".marks<=" + strnum[hvalue[i]];
	    }
	    String query = "select " + fields + " from " + tables + " where " + condition + ";";
	    //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            return rs;
	}catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
	    }
	    return null;
    }
    
    public ResultSet getUsers() {
        try {
            String query = "select name,login from logininfo order by name";
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            return rs;
        }catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return null;
    }
    
    public ResultSet getSubjects() {
        try {
            String query = "select subjectname from subjectinfo";
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            return rs;
        }catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return null;
    }
    
    public String getUserName(String loginid) {
        String name = "";
        try {
            init();
            String query = "Select name from logininfo where login = '"+loginid+"'";
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            name = rs.getString("name");
            rs.close();
            destroy();
        } catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return(name);
    }
    
    public boolean hasBeenSurveyed(String loginid) {
        try {
            //System.out.println("1");
            init();
            //System.out.println("2");
            String query = "select * from marks where loginid = '" + loginid + "'";
            pstmt = conn.prepareStatement(query);
            //System.out.println("3");
            ResultSet rs = pstmt.executeQuery();
            //System.out.println("4");
            //System.out.println("\n\nRows from marks \n");
            boolean b = rs.next();
            destroy();
            return b;
        }catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        return false;
    }

   public int getStats(String subject, int start, int end) {
	int count=0;
	try
	{
	String query = " select count( distinct loginid) from marks, subjectinfo where marks.subjectid = subjectinfo.subjectid and subjectname = \"" + subject + "\" and marks.marks <= " + end + " and marks.marks >= " + start;                                                                                                                              
	//System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            count = rs.getInt(1);
	    //System.out.println("count = " + count);
	}
	 catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
	return count;
   }

	

     public ResultSet  getScatter(String subject) {
	int[] distribution = new int[100];
	try
	   {
	    String query = " select marks from marks, subjectinfo where marks.subjectid = subjectinfo.subjectid and subjectname = \"" + subject + "\" order By marks.loginid";
	    // select marks from marks, subjectinfo where marks.subjectid=subjectinfo.subjectid and subjectname = "Hockey" order By marks.loginid;

  	    //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
	    return rs;
//	    int i=0;
//            while(rs.next())
//		{ 
//		distribution[i] = rs.getInt();
//		i++;
//		}
//            count = rs.getInt(1);
//	System.out.println("count = " + count);
	}
	 catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
	return null;
   }

    public void setSubjects(String[] subjects) {
	try {
	    init();
	    String query = "Delete from logininfo";
	    pstmt = conn.prepareStatement(query);
            pstmt.execute();
	    query = "Delete from subjectinfo";
	    pstmt = conn.prepareStatement(query);
            pstmt.execute();
	    query = "Delete from marks";
	    pstmt = conn.prepareStatement(query);
            pstmt.execute();
	    for(int i=0;i<subjects.length;i++) {
		query = "Insert into subjectinfo values (" + Integer.toString(i) + ",\'" + subjects[i] +"\')";
		pstmt = conn.prepareStatement(query);
		pstmt.execute();
		//System.out.println(query);
	    }
	    destroy();
	}catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        
    }


    
    public void putMarks(String login, String subject, String marks) {
        try {
            init();
            String query = "Select subjectid from subjectinfo where subjectname = '" + subject + "'";
            pstmt = conn.prepareStatement(query);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            int subjectid = rs.getInt(1);
            rs.close();
            destroy();
            init();
            query = "Insert into marks values ( '" +login + "', " + subjectid + ", " + marks + ")";
            //System.out.println(query);
            pstmt = conn.prepareStatement(query);
            pstmt.executeUpdate();
            destroy();
        } catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
        }
        
    }
}
