import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;
import java.sql.*;
import java.io.*; 
                                                                                                                             
                                                                                        
public class PieChart extends JPanel {
    final static int maxCharHeight = 15;
    final static int minFontSize = 6;
	 private Properties formProps = null;
	 private static String conffile = "graphicalForm.cfg";
    String colorString;  
    static Color bg;
    final static Color fg = Color.black;

    final static BasicStroke stroke = new BasicStroke(2.0f);
    final static BasicStroke wideStroke = new BasicStroke(8.0f);


    int ptx = 100, pty = 100;
    int distx, disty;
    int total=0;
    Dimension totalSize;
    FontMetrics fontMetrics;

	 Color[] c;
	 int[] displayValues;
	 String subject;
	 int[] rangeStart;
	 int noOfSectors;
	 int noOfColors;
	 int maxValue;
	int radius = 100;
	int align = 270;

	private void initialiseColor(String colorStr)
		{
		String[] colorArray = colorStr.split("\\s");
		noOfColors = colorArray.length;

		for(int i=0; i<noOfColors; i++)
			c[i] = returnColor(colorArray[i]);		
		
		}
                                                                                                     
    public void init(int displayValues1[], String subject1, int rangeStart1[], int noOfSectors1) {
        //Initialize drawing colors

	int i,j,k;
	 displayValues = new int[15];
         subject = new String();
         rangeStart = new int[15];
         c = new Color[10];

	//initialise parameters
	maxValue=0;
	noOfSectors = noOfSectors1;
	subject = subject1;
	for(i=0; i< noOfSectors; i++)
		rangeStart[i] = rangeStart1[i];
	for(j=0; j< noOfSectors; j++)
		{
		displayValues[j] = displayValues1[j];
		if(displayValues[j] > maxValue)
			maxValue = displayValues[j];
			total += displayValues[j];
		}
	rangeStart[noOfSectors] = 11;
	try{
        loadProperties(conffile);
        } catch(Exception e)
        {
        System.out.println("Properties could not be loaded");
        e.printStackTrace(System.out);
        }
        setBackground(bg);
        setForeground(fg);
	}

	public Color returnColor(String color)
	{
	Color c;
	if(color.equals("red"))	c = Color.red;
	else  if(color.equals("blue"))  c = Color.blue; 
	else  if(color.equals("green"))  c = Color.green;
	else  if(color.equals("black"))  c = Color.black;
	else  if(color.equals("cyan"))  c = Color.cyan;
	else  if(color.equals("gray"))  c = Color.gray;
	else  if(color.equals("darkGray"))  c = Color.darkGray;
        else  if(color.equals("orange"))  c = Color.orange;
        else  if(color.equals("white"))  c = Color.white;
        else  if(color.equals("yellow"))  c = Color.yellow;
        else  if(color.equals("pink"))  c = Color.pink;
        else  if(color.equals("magenta"))  c = Color.magenta;
        else  if(color.equals("lightGray"))  c = Color.lightGray;
	else c = Color.red;
	return c;

	}


      private void loadProperties(String propFileName)  throws IOException {
        File f = new File(propFileName);

        FileInputStream fis = new FileInputStream(propFileName);
        formProps = new Properties();
        formProps.load(fis);
        String circleRadius = formProps.getProperty("radius");
        radius = Integer.parseInt(circleRadius);

        colorString = formProps.getProperty("pieColorOrder");
	String bgColor =  formProps.getProperty("bgColor");
	bg = returnColor(bgColor);

        initialiseColor(colorString);
        String sector = formProps.getProperty("largestSector");
        if(sector.equals("onRight"))
                align = 0;
        else
        if(sector.equals("onLeft"))
                align = 180;
	 else
         if(sector.equals("onTop"))
                align = 90;
	 else
         if(sector.equals("onBottom"))
                align = 270;

                                                                                                                             
        String row = formProps.getProperty("distx");
        distx = Integer.parseInt(row);
                                                                                                                             
        String col = formProps.getProperty("disty");
        disty = Integer.parseInt(col);
      }
 

 
     public void paintComponent(Graphics g1) {
	super.paintComponent(g1);
	if(g1 instanceof Graphics2D)
	{
	int i;
	 setBackground(bg);
        setForeground(fg);

        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension d = getSize();
	int gridWidth = d.width - 100;
        int gridHeight = d.height - 100;

	// some nice 3d rectangle as border in gray color
        Color fg3D = Color.lightGray;
        g2.setPaint(fg3D);
        g2.draw3DRect(0, 0, d.width - 1, d.height - 1, true);
        g2.draw3DRect(3, 3, d.width - 7, d.height - 7, false);
        g2.setPaint(fg);
                                                         
	// set parameters                                                                    
        int x;
        int y ;

	/* algo for pie chart: 1 arcAngle = (float)(360 * displayValues) /total
	prev = arcAngle
	draw from prev to arcAngle
	*/

	int[] arcAngle = new int[15];	// store angle of arc i
	int[] position = new int[15];	// store the starting psition of arc i
	int j;
	int maxValue=0;
	int rotateAngle=0;
	arcAngle[0] = (int)((float)(360 * displayValues[0])/total);
        rotateAngle = arcAngle[0]/2;
        position[1] = arcAngle[0];
	maxValue = arcAngle[0];

	position[0] = 0;
	
	for(i=1; i< noOfSectors; i++)
		{		
		arcAngle[i] = (int)((float)(360 * displayValues[i])/total);
		if(arcAngle[i] > maxValue) rotateAngle = position[i] + arcAngle[i]/2;		
		position[i+1] = arcAngle[i] + position[i];	
		}
	
	arcAngle[noOfSectors-1] = 360 - position[noOfSectors-1];
	g2.rotate(2*3.14*(-align+rotateAngle)/360, ptx/2+distx, pty/2+disty);

	for(i=0; i< noOfSectors; i++)
		{		
		j=i;
		g2.setPaint(c[j%noOfColors]);
		g2.fillArc(distx, disty, ptx, pty, (int)position[i], (int)arcAngle[i]);
		}
	g2.rotate(2*3.14*(+align-rotateAngle)/360, ptx/2+distx, pty/2+disty);

	// write the key
	y=d.height-20;
	for(i=noOfSectors-1; i>=0; i--)
		{
		 g2.setPaint(c[i%noOfColors]);
                 g2.fill(new Rectangle2D.Double(100, y, 24, 12));
		 g2.drawString((Integer.toString(rangeStart[i]) + "-" + Integer.toString(rangeStart[i+1]-1)), 150, y+12);
		 y-=12;

		}
	g2.setPaint(fg);
	g2.drawString("Pie Chart - " + subject, gridWidth/2, 20);


	}	// end of if G1 instanceof
  }       // end of paint

/*
  public static void main(String s[]) 
	{
	BarChart b = new BarChart();
	JFrame barChartFrame = new JFrame("Bar Chart");

	JPanel panel1 = new JPanel();
	JPanel panel2 = new JPanel();
	panel2.setSize(new Dimension(50,50));
	panel1.setSize(new Dimension(450, 300));
	b.init();
	panel1.add(b);
	JLabel label = new JLabel("Click me????");
	panel2.add(label);
	barChartFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	barChartFrame.getContentPane().add(b, BorderLayout.CENTER);
	barChartFrame.getContentPane().add(panel2, BorderLayout.SOUTH);

        barChartFrame.pack();
        barChartFrame.setSize(new Dimension(500, 350));
        barChartFrame.setVisible(true);
	}                                                                 
*/

}	// end of class

