import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;
import java.sql.*;
import java.io.*; 


public class ScatterChart extends JPanel {
 
    final static BasicStroke stroke = new BasicStroke(2.0f);
    final static BasicStroke wideStroke = new BasicStroke(8.0f);
	private Properties formProps =     null;
    Dimension totalSize;
    FontMetrics fontMetrics;
	static Color bg;


    private static String conffile = "graphicalForm.cfg";
	int[] displayValuesx, displayValuesy;
	String subjectx, subjecty;
	int sizex, sizey;
	int maxValue;

	int diameter;
	int radius = diameter/2;
	Color c;
	String circleColor = new String();
	Color fg = Color.black;
	int rowwidth;
	int colwidth;
	int originx, originy;
	int x1, x2, y1, y2;
	int gridOption;
        
public Color returnColor(String color)
	{
	Color c;

	if(color.equals("red"))	c = Color.red;
	else  if(color.equals("blue"))  c = Color.blue; 
	else  if(color.equals("green"))  c = Color.green;
	else  if(color.equals("black"))  c = Color.black;
	else  if(color.equals("cyan"))  c = Color.cyan;
	else  if(color.equals("gray"))  c = Color.gray;
	else  if(color.equals("darkGray"))  c = Color.darkGray;
        else  if(color.equals("orange"))  c = Color.orange;
        else  if(color.equals("white"))  c = Color.white;
        else  if(color.equals("yellow"))  c = Color.yellow;
        else  if(color.equals("pink"))  c = Color.pink;
        else  if(color.equals("magenta"))  c = Color.magenta;
        else  if(color.equals("lightGray"))  c = Color.lightGray;
	else c = Color.red;
	return c;

	}




public void init(int displayValuesx1[], int displayValuesy1[], String subjectx1, String subjecty1, int sizex1, int sizey1) {

	int i,j,k;
	displayValuesx = new int[100];
    	displayValuesy = new int[100];

	//initialise parameters
	maxValue=0;
	subjectx = subjectx1;
	subjecty = subjecty1;
	sizex = sizex1;
	sizey =sizey1;
	for(j=0; j< sizex; j++)
		{
		displayValuesx[j] = displayValuesx1[j];
		}
	 for(j=0; j< sizey; j++)
                {
                displayValuesy[j] = displayValuesy1[j];
                }
	try{
	loadProperties(conffile);
	} catch(Exception e)
	{
	System.out.println("Properties could not be loaded");
	e.printStackTrace(System.out);
	}
	setForeground(c);
	setBackground(bg);
	

	}



    private void loadProperties(String propFileName)  throws IOException {
        File f = new File(propFileName);
        
        FileInputStream fis = new FileInputStream(propFileName);
        formProps = new Properties();
        formProps.load(fis);
        String circleDiameter = formProps.getProperty("diameter");
	diameter = Integer.parseInt(circleDiameter);
	radius = diameter/2;
	circleColor = formProps.getProperty("color");
	c = returnColor(circleColor);
	String bgColor =  formProps.getProperty("scatterbgColor");
	bg = returnColor(bgColor);
	String grid = formProps.getProperty("grid");

	if(grid.equals("yes"))
	        gridOption = 1;
	else
		gridOption = 0;

	String row = formProps.getProperty("rowwidth");
        rowwidth = Integer.parseInt(row);

	String col = formProps.getProperty("colwidth");
        colwidth = Integer.parseInt(col);
   }

  
     public void paintComponent(Graphics g1) {
	super.paintComponent(g1);
	if(g1 instanceof Graphics2D)
	{
        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension d = getSize();
	originx = 100;
	originy = d.height-100;

	// some nice 3d rectangle as border in gray color
        Color fg3D = Color.lightGray;
        g2.setPaint(fg3D);
        g2.draw3DRect(0, 0, d.width - 1, d.height - 1, true);
        g2.draw3DRect(3, 3, d.width - 7, d.height - 7, false);
	g2.setPaint(fg);
	originx = 50;
        originy = 10*rowwidth + 50;

	g2.drawString("Scatter Chart", d.width/2, 20);
        g2.drawString(subjectx, originx+rowwidth*4, originy+20);
	g2.drawString(subjecty, originx-40, originy-colwidth*4);
	g2.setPaint(c);
                                                         
	                                                                  
        int x;
        int y ;
	originx = 50;
	originy = 10*rowwidth + 50;
	int i;

	for(i=0; i< sizex; i++)
		{
		g2.setPaint(c);
		x = originx + displayValuesx[i]*colwidth;
		y = originy - displayValuesy[i]*rowwidth;
		
		g2.draw(new Ellipse2D.Double(x-radius/2, y-radius/2, radius, radius));
		}

	for(i=0;i<=10; i++)
		{
		g2.setPaint(fg);
		x1 = originx;
		y1 = originy - rowwidth*i;
		x2 = originx + 10*colwidth;
		y2 = y1;
		if(gridOption ==  1 || i==0)	g2.draw(new Line2D.Double(x1, y1, x2, y2));
		if(i != 0) 
			g2.drawString(Integer.toString(i), x1-10, y1);
		}
	for(i=0;i<=10; i++)
		{
		x1 = originx + colwidth*i;
		y1 = originy;
		x2 = x1;
		y2 = originy - rowwidth*10;
		if(gridOption == 1 || i==0)	g2.draw(new Line2D.Double(x2, y2, x1, y1));
		g2.drawString(Integer.toString(i), x1, y1+10);
		}

	}
	
    }

}	// end of class

