import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.sql.*;
import java.io.*;



public class Survey implements ActionListener {
    private Properties formProps = null;
    private String formTitle,formBGColor,formButtonColor;
    private int wndWidth,wndHeight,btnWidth,btnHeight,locX,locY,chkBxWidth,chkBxHeight;
    private static String confFile = "dataForm.cfg";
    private static String fontName;
    private static int fontStyle,fontSize;
    Vector comboBox;
    JButton cancelButton,submitButton;
    int noOfSubjects;
    String user,password;
    String[] subjects = new String[15];
    JFrame frame;

        private void loadProperties(String propFileName)
    throws IOException {
        File f = new File(propFileName);
        FileInputStream fis = new FileInputStream(propFileName);
        formProps = new Properties();
        formProps.load(fis);
	formTitle = formProps.getProperty("title");
	formTitle = formTitle.substring(1,formTitle.length()-1);
	formBGColor = formProps.getProperty("bkgndColor");
	formButtonColor = formProps.getProperty("buttonColor");
	String wndSize = formProps.getProperty("wndSize");
	String[] wndDim = wndSize.split("[ ]+");
	wndHeight = Integer.parseInt(wndDim[0]);
	wndWidth = Integer.parseInt(wndDim[1]);
	String btnSize = formProps.getProperty("btnSize");
	String[] btnDim = btnSize.split("[ ]+");
	btnHeight = Integer.parseInt(btnDim[0]);
	btnWidth = Integer.parseInt(btnDim[1]);
	String location = formProps.getProperty("location");
	String[] loccoords = location.split("[ ]+");
	locX = Integer.parseInt(loccoords[0]);
	locY = Integer.parseInt(loccoords[1]);
	String chkBxSize = formProps.getProperty("chkBxSize");
	String[] chkBxDim = chkBxSize.split("[ ]+");
	chkBxHeight = Integer.parseInt(chkBxDim[0]);
	chkBxWidth = Integer.parseInt(chkBxDim[1]);
	fontName = formProps.getProperty("fontName");
	fontName = fontName.substring(1,fontName.length()-1);
	fontStyle = Integer.parseInt(formProps.getProperty("fontStyle"));
	fontSize = Integer.parseInt(formProps.getProperty("fontSize"));
    }

    public Component createComponents() {
        JPanel pane = new JPanel(new GridLayout(2,0));
        pane.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane.setBackground(new Color(Integer.parseInt(formBGColor,16)));
        Vector label = new Vector();
	comboBox = new Vector();
	Box  vertBox1= new Box(BoxLayout.Y_AXIS);
	Box  vertBox2= new Box(BoxLayout.Y_AXIS);
	Box  horBox = new Box(BoxLayout.X_AXIS);
     	String[] grades={"0","1","2","3","4","5","6","7","8","9","10"};
	try {
            Install ins=new Install();
	    ins.init();
            ResultSet rs = ins.getSubjects();
            int i=0;
	    while(rs.next()) {
		subjects[i]=rs.getString(1);
		JLabel lbl = new JLabel();
	      	lbl.setFont(new Font(fontName,fontStyle,fontSize));
		lbl.setText(subjects[i]);
		label.addElement(lbl);
		vertBox1.add(Box.createGlue());
		vertBox1.add((JLabel)label.elementAt(i));
		JComboBox cB = new JComboBox(grades);
		comboBox.addElement(cB);
		vertBox2.add(Box.createGlue());
		cB.setPreferredSize(new Dimension(chkBxWidth,chkBxHeight));
		vertBox2.add((JComboBox)comboBox.elementAt(i));
		i++;
	    }
	    noOfSubjects=i;
            ins.destroy();
        } catch(java.sql.SQLException sqle) {
            System.out.println("SQL Exception found : " + sqle.getLocalizedMessage());
            sqle.printStackTrace();
	}
	vertBox1.add(Box.createGlue());
	vertBox2.add(Box.createGlue());
	horBox.add(Box.createGlue());
	horBox.add(vertBox1);
	horBox.add(vertBox2);
	horBox.add(Box.createGlue());
	pane.add(horBox);
	
	cancelButton = new JButton("Cancel");
	cancelButton.setPreferredSize(new Dimension(btnWidth,btnHeight));
	cancelButton.setBackground(new Color(Integer.parseInt(formButtonColor,16)));
	cancelButton.addActionListener(this);
	submitButton = new JButton("Submit");
	submitButton.setPreferredSize(new Dimension(btnWidth,btnHeight));
	submitButton.setBackground(new Color(Integer.parseInt(formButtonColor,16)));
	submitButton.addActionListener(this);
		
	horBox = new Box(BoxLayout.X_AXIS);
	horBox.add(Box.createGlue());
	horBox.add(cancelButton);
	horBox.add(Box.createGlue());
	horBox.add(submitButton);
	horBox.add(Box.createGlue());
	
	pane.add(horBox);
	return pane;
    }
    
    public void actionPerformed(ActionEvent event) {
	String command=event.getActionCommand();
	if (command.equals("Submit")) {
	    Install ins=new Install();
	    ins.addUser(user,password);
	    for(int i=0;i<noOfSubjects;i++) {
		Integer marks =new Integer(((JComboBox)comboBox.elementAt(i)).getSelectedIndex());
		ins.putMarks(user,subjects[i],marks.toString());
	    }
	    frame.setVisible(false);
	    Analysis anl = new Analysis();
	    anl.createAndShowGUI();
	} else {
	     System.exit(0);
	}
	    
    }

        public  void createAndShowGUI(String username, String pswd) {
        user = username;
	password = pswd;

	try {
	    loadProperties(confFile);
	}catch (Exception e){
            e.printStackTrace(System.out);
            System.out.println("Properties could not be loaded.");
        }finally{
        }

	//Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create and set up the window.
        frame = new JFrame(formTitle);
	

	//frame.setSize(wndWidth,wndHeight);
	//d = frame.getSize();
	//System.out.println("Height....." + d.getHeight());
	//System.out.println("Width....." + d.getWidth());
	
	frame.setBackground(new Color(Integer.parseInt(formBGColor,16)));
	frame.setLocation(locX,locY);
	frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	
        Component contents = createComponents();
	frame.getContentPane().add(contents, BorderLayout.CENTER);
	        
	//Display the window.
        frame.pack();
	frame.setSize(wndWidth,wndHeight);
        frame.setVisible(true);
    }

    /*public static void main(String[] args) {
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
		Survey sur = new Survey();
                sur.createAndShowGUI("dhe3","dhe3");
            }
        });
	}*/
}
