/*
 * Decompiled with CFR 0.152.
 */
package progsynth.logpostprocessing;

import progsynth.utils.package$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.StringAdd$;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class ClientLogToHtml$ {
    public static final ClientLogToHtml$ MODULE$;
    private final String jqueryUrl;
    private final String javascript;
    private final String cssfile;

    static {
        new ClientLogToHtml$();
    }

    public String jqueryUrl() {
        return this.jqueryUrl;
    }

    public String javascript() {
        return this.javascript;
    }

    public String cssfile() {
        return this.cssfile;
    }

    public void main(String[] args) {
        Predef$.MODULE$.assert(args.length == 2);
        String logFilePath = args[0];
        String outputFilePath = args[1];
        this.addPreamble(outputFilePath);
        Source$.MODULE$.fromFile(logFilePath, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(outputFilePath){
            public static final long serialVersionUID = 0L;
            private final String outputFilePath$1;

            public final void apply(String line) {
                String processedLine = ClientLogToHtml$.MODULE$.processLine(line);
                package$.MODULE$.appendFile(this.outputFilePath$1, processedLine);
            }
            {
                this.outputFilePath$1 = outputFilePath$1;
            }
        });
        this.addClosingTxt(outputFilePath);
    }

    public String processLine(String line) {
        String string;
        Regex BeginSection = new StringOps(Predef$.MODULE$.augmentString("\\s*BeginSection\\((.*)\\)")).r();
        Regex EndSection = new StringOps(Predef$.MODULE$.augmentString("EndSection\\((.*)\\)")).r();
        String string2 = line;
        Option option = BeginSection.unapplySeq((Object)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String title = (String)((LinearSeqOptimized)option.get()).apply(0);
            StringBuilder stringBuilder = new StringBuilder().append((Object)"<div class='Section'>\n");
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("SectionTitle"), (MetaData)$md);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)title);
            string = stringBuilder.append((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf)).append((Object)"\n").append((Object)"<div class='SectionBody'>").append((Object)"\n").toString();
        } else {
            Option option2 = EndSection.unapplySeq((Object)string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                string = "</div>\n                \t</div>";
            } else {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("ContentText"), (MetaData)$md);
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)string2);
                string = StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf)), "\n");
            }
        }
        return string;
    }

    public void addPreamble(String outputFilePath) {
        package$.MODULE$.overwriteFile(outputFilePath, new StringBuilder().append((Object)"<html>\n    \t<head>\n    \t<link rel=\"stylesheet\" type=\"text/css\" href=").append((Object)this.cssfile()).append((Object)">\n\t\t<script src=").append((Object)this.jqueryUrl()).append((Object)"></script>\n\t\t<script src=").append((Object)this.javascript()).append((Object)"></script>    \n    \t</head>\n    \t<body>\n        <div class='Section'>\n          \t<div class='SectionTitle'>RootSection</div>\n            <div class='SectionBody'>\n        ").toString());
    }

    public void addClosingTxt(String outputFilePath) {
        package$.MODULE$.appendFile(outputFilePath, "\n        </div>\n        </div>\n        </body>\n        </html>");
    }

    private ClientLogToHtml$() {
        MODULE$ = this;
        this.jqueryUrl = "\"jquery-1.7.1.min.js\"";
        this.javascript = "\"ClientLog.js\"";
        this.cssfile = "\"ClientLog.css\"";
    }
}

