/*
 * Decompiled with CFR 0.152.
 */
package z3.java;

import z3.Pointer;
import z3.Z3Wrapper;
import z3.java.Z3AST;
import z3.java.Z3Config;
import z3.java.Z3Model;
import z3.java.Z3Sort;
import z3.java.Z3Symbol;

public class Z3Context
extends Pointer {
    public static Boolean lbool2Boolean(int n) {
        if (n == -1) {
            return false;
        }
        if (n == 0) {
            return null;
        }
        return true;
    }

    public Z3Context(Z3Config z3Config) {
        super(Z3Wrapper.mkContext(z3Config.ptr));
    }

    public void delete() {
        Z3Wrapper.delContext(this.ptr);
        this.ptr = 0L;
    }

    public void updateParamValue(String string, String string2) {
        Z3Wrapper.updateParamValue(this.ptr, string, string2);
    }

    public Z3Symbol mkIntSymbol(int n) {
        return new Z3Symbol(Z3Wrapper.mkIntSymbol(this.ptr, n));
    }

    public Z3Symbol mkStringSymbol(String string) {
        return new Z3Symbol(Z3Wrapper.mkStringSymbol(this.ptr, string));
    }

    public boolean isEqSort(Z3Sort z3Sort, Z3Sort z3Sort2) {
        return Z3Wrapper.isEqSort(this.ptr, z3Sort.ptr, z3Sort2.ptr);
    }

    public Z3Sort mkUninterpretedSort(Z3Symbol z3Symbol) {
        return new Z3Sort(Z3Wrapper.mkUninterpretedSort(this.ptr, z3Symbol.ptr));
    }

    public Z3Sort mkBoolSort() {
        return new Z3Sort(Z3Wrapper.mkBoolSort(this.ptr));
    }

    public Z3Sort mkIntSort() {
        return new Z3Sort(Z3Wrapper.mkIntSort(this.ptr));
    }

    public Z3Sort mkRealSort() {
        return new Z3Sort(Z3Wrapper.mkRealSort(this.ptr));
    }

    public boolean isEqAST(Z3AST z3AST, Z3AST z3AST2) {
        return Z3Wrapper.isEqAST(this.ptr, z3AST.ptr, z3AST2.ptr);
    }

    public Z3AST mkConst(Z3Symbol z3Symbol, Z3Sort z3Sort) {
        return new Z3AST(Z3Wrapper.mkConst(this.ptr, z3Symbol.ptr, z3Sort.ptr));
    }

    public Z3AST mkTrue() {
        return new Z3AST(Z3Wrapper.mkTrue(this.ptr));
    }

    public Z3AST mkFalse() {
        return new Z3AST(Z3Wrapper.mkFalse(this.ptr));
    }

    public Z3AST mkEq(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkEq(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkDistinct(Z3AST ... z3ASTArray) {
        if (z3ASTArray.length == 0) {
            throw new IllegalArgumentException("mkDistinct needs at least one argument");
        }
        return new Z3AST(Z3Wrapper.mkDistinct(this.ptr, z3ASTArray.length, Z3Wrapper.toPtrArray(z3ASTArray)));
    }

    public Z3AST mkNot(Z3AST z3AST) {
        return new Z3AST(Z3Wrapper.mkNot(this.ptr, z3AST.ptr));
    }

    public Z3AST mkITE(Z3AST z3AST, Z3AST z3AST2, Z3AST z3AST3) {
        return new Z3AST(Z3Wrapper.mkITE(this.ptr, z3AST.ptr, z3AST2.ptr, z3AST3.ptr));
    }

    public Z3AST mkIff(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkIff(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkImplies(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkImplies(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkXor(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkXor(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkAnd(Z3AST ... z3ASTArray) {
        if (z3ASTArray.length == 0) {
            throw new IllegalArgumentException("mkAnd needs at least one argument");
        }
        return new Z3AST(Z3Wrapper.mkAnd(this.ptr, z3ASTArray.length, Z3Wrapper.toPtrArray(z3ASTArray)));
    }

    public Z3AST mkOr(Z3AST ... z3ASTArray) {
        if (z3ASTArray.length == 0) {
            throw new IllegalArgumentException("mkOr needs at least one argument");
        }
        return new Z3AST(Z3Wrapper.mkOr(this.ptr, z3ASTArray.length, Z3Wrapper.toPtrArray(z3ASTArray)));
    }

    public Z3AST mkAdd(Z3AST ... z3ASTArray) {
        if (z3ASTArray.length == 0) {
            throw new IllegalArgumentException("mkAdd needs at least one argument");
        }
        return new Z3AST(Z3Wrapper.mkAdd(this.ptr, z3ASTArray.length, Z3Wrapper.toPtrArray(z3ASTArray)));
    }

    public Z3AST mkMul(Z3AST ... z3ASTArray) {
        if (z3ASTArray.length == 0) {
            throw new IllegalArgumentException("mkMul needs at least one argument");
        }
        return new Z3AST(Z3Wrapper.mkMul(this.ptr, z3ASTArray.length, Z3Wrapper.toPtrArray(z3ASTArray)));
    }

    public Z3AST mkSub(Z3AST ... z3ASTArray) {
        if (z3ASTArray.length == 0) {
            throw new IllegalArgumentException("mkSub needs at least one argument");
        }
        return new Z3AST(Z3Wrapper.mkSub(this.ptr, z3ASTArray.length, Z3Wrapper.toPtrArray(z3ASTArray)));
    }

    public Z3AST mkUnaryMinus(Z3AST z3AST) {
        return new Z3AST(Z3Wrapper.mkUnaryMinus(this.ptr, z3AST.ptr));
    }

    public Z3AST mkDiv(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkDiv(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkMod(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkMod(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkRem(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkRem(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkLT(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkLT(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkLE(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkLE(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkGT(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkGT(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkGE(Z3AST z3AST, Z3AST z3AST2) {
        return new Z3AST(Z3Wrapper.mkGE(this.ptr, z3AST.ptr, z3AST2.ptr));
    }

    public Z3AST mkInt2Real(Z3AST z3AST) {
        return new Z3AST(Z3Wrapper.mkInt2Real(this.ptr, z3AST.ptr));
    }

    public Z3AST mkReal2Int(Z3AST z3AST) {
        return new Z3AST(Z3Wrapper.mkReal2Int(this.ptr, z3AST.ptr));
    }

    public Z3AST mkIsInt(Z3AST z3AST) {
        return new Z3AST(Z3Wrapper.mkIsInt(this.ptr, z3AST.ptr));
    }

    public Z3AST mkInt(int n, Z3Sort z3Sort) {
        return new Z3AST(Z3Wrapper.mkInt(this.ptr, n, z3Sort.ptr));
    }

    public Z3AST mkReal(double d, int n, int n2) {
        return new Z3AST(Z3Wrapper.mkReal(this.ptr, n, n2));
    }

    public Integer getNumeralInt(Z3AST z3AST) {
        Z3Wrapper.IntPtr intPtr = new Z3Wrapper.IntPtr();
        boolean bl = Z3Wrapper.getNumeralInt(this.ptr, z3AST.ptr, intPtr);
        if (bl) {
            return intPtr.value;
        }
        return null;
    }

    public Boolean getBoolValue(Z3AST z3AST) {
        return Z3Context.lbool2Boolean(Z3Wrapper.getBoolValue(this.ptr, z3AST.ptr));
    }

    public void push() {
        Z3Wrapper.push(this.ptr);
    }

    public void pop(int n) {
        Z3Wrapper.pop(this.ptr, n);
    }

    public void assertCnstr(Z3AST z3AST) {
        Z3Wrapper.assertCnstr(this.ptr, z3AST.ptr);
    }

    public Boolean check() {
        return Z3Context.lbool2Boolean(Z3Wrapper.check(this.ptr));
    }

    public Z3Model mkModel() {
        return new Z3Model(this);
    }

    public Boolean checkAndGetModel(Z3Model z3Model) {
        return Z3Context.lbool2Boolean(Z3Wrapper.checkAndGetModel(this.ptr, z3Model));
    }

    public Boolean checkAssumptions(Z3AST[] z3ASTArray, Z3Model z3Model, Z3AST[] z3ASTArray2) {
        return this.checkAssumptionsImpl(z3ASTArray, z3Model, z3ASTArray2);
    }

    public Boolean checkAssumptionsNoModel(Z3AST ... z3ASTArray) {
        Pointer[] pointerArray = new Pointer[z3ASTArray.length];
        for (int i = 0; i < z3ASTArray.length; ++i) {
            pointerArray[i] = new Pointer(0L);
        }
        return this.checkAssumptionsImpl(z3ASTArray, new Z3Model(this), pointerArray);
    }

    private Boolean checkAssumptionsImpl(Z3AST[] z3ASTArray, Z3Model z3Model, Pointer[] pointerArray) {
        Z3Wrapper.IntPtr intPtr = new Z3Wrapper.IntPtr();
        return Z3Context.lbool2Boolean(Z3Wrapper.checkAssumptions(this.ptr, z3ASTArray.length, Z3Wrapper.toPtrArray(z3ASTArray), z3Model, pointerArray.length, intPtr, Z3Wrapper.toPtrArray(pointerArray)));
    }
}

