/// <reference path="typings/jquery/jquery.d.ts" />
/// <reference path="typings/underscore/underscore.d.ts" />
/// <reference path="typings/requirejs/require.d.ts" />
/// <amd-dependency path="metatypes" />

"use strict";
import psJqueryUtils = module("ps_jquery_utils");
var mt = require("metatypes");
	
psJqueryUtils;

export function gatherInputData() {
	var $compositeValDiv = (<any>$(".inputPanel form")).closest_descendent(".CompositeVal");
	return getCompositeValJson($compositeValDiv);
}
	
function getCollectionTypeJson($collectionValDiv){
		
}
	
function getCompositeValJson($compositeValDiv){
	//console.debug("getCompositeValJson called");
	console.log("compositeTypeDiv is " + $compositeValDiv.html());
	var fieldVals = [];
	$compositeValDiv.children(".FieldVal").each( function(){
		fieldVals.push(getFieldTypeJson($(this))); 
	});
	var type = $compositeValDiv.attr("type");
	var retVal = new mt.CompositeVal(type, undefined, fieldVals);
	//console.debug("getCompositeValJson returned " + JSON.stringify(retVal, null, 2));
	if(!retVal) throw new Error("getCompositeValJason Failed" + $compositeValDiv);
	return retVal;
}
	
function getFieldTypeJson($fieldValDiv){
	//console.debug("getFieldTypeJson called" + $fieldValDiv.html());
	var fname = jQuery.trim($fieldValDiv.children(".fname").first().text());
	var fvalDiv = $fieldValDiv.children(".fval");
	var valDiv = fvalDiv.closest_descendent(".CompositeVal, .PrimitiveVal, .ListVal, .TupleVal");
		
	var fval = getAnyValJson(valDiv);
 
	var ftype = $fieldValDiv.attr("ftype");
	var retVal = new mt.FieldVal(fname, ftype, fval);
	//console.debug("getFieldTypeJson returned" + JSON.stringify(retVal, null, 2));
	if(!retVal) throw new Error("getFieldTypeJson failed: " + $fieldValDiv);
	return retVal;
}
	
function getPrimitiveValJson(idiv){
	//console.debug("getPrimitiveValJson called" + idiv.html());
	var type = idiv.attr("typeName");
	var value = null;
	if (idiv.children("input").exists()){
		value = idiv.children("input").val();
	}else if(idiv.children(".mathquill-editable").exists()){
		value = idiv.children(".mathquill-editable").mathquill('latex');
	}else {
		throw new Error("match failed ");
	}
	var retVal = undefined;
	if($.trim(value) !== ""){
		retVal = new mt.PrimitiveVal(type, value);
		//console.debug("getPrimitiveValJson returned " + JSON.stringify(retVal, null, 2));
		if(!retVal) throw new Error("getPrimitiveValJson failed");
	}
	return retVal;
}
	
function getAnyValJson($anyValDiv) {
	var fval = "";
	if($anyValDiv.hasClass("CompositeVal")){
		fval = getCompositeValJson($anyValDiv);
	} else if ($anyValDiv.hasClass("PrimitiveVal")){
		fval = getPrimitiveValJson($anyValDiv);
	} else if ($anyValDiv.hasClass("ListVal")){
		fval = getListValJson($anyValDiv);
	} else if ($anyValDiv.hasClass("TupleVal")){
		fval = getTupleValJson($anyValDiv);
	} else {
		throw new Error("match failed");
	}
	return fval;
}
	
function getListValJson($iDiv) {
	//console.dir($iDiv);
	var ds = $iDiv.children(".listItem");
		
	var items = $.map( ds, function(d){
		var $contentDiv = $(d).children().first();
		return getAnyValJson($contentDiv);
	});
	items = _(items).compact();
		
	var retVal = undefined;
	if(items.length > 0){
		var paramType = "";
		retVal = new mt.ListVal(paramType, items);
	}
	return retVal;
}

function getTupleValJson($iDiv) {
	var ds = $iDiv.children(".tupleItem");
	var items = _(ds).map( function(d){
		var $contentDiv = $(d).children().first();
		return getAnyValJson($contentDiv);
	});
		
	var retVal = undefined;
	if(items.length === 2 && _(items).all(_.identity)){
		var paramTypes = "";
		retVal = new mt.TupleVal(paramTypes, items);
	}
	return retVal;
}
