

var types =
{
	"rootTactic" : [{name: "tactic", type: "Tactic"}],
	"stepIntoUnknownProgIdx": [{name: "idx", type: "Integer"}],
	"stepIntoUnknownProgId": [{name: "idx", type: "Integer"}],
	"replaceFormula": [{name: "newf", type: "FOLFormula"}],
	"retValTactic": [{name: "initTerm", type: "Option[Term]"}],
	"rcvInPost": [{name: "const0", type: "Var"},
	              {name: "initValue0", type: "Term"},
	              {name: "bounds", type: "FOLFormula"}
	              ],
	"rtvInPost": [{name: "const0", type: "Term"},
                 {name: "initValue0", type: "Term"},
                 {name: "bounds", type: "FOLFormula"}
                 ],
	 "deleteConjunct":[	{name: "conjuct", type: "FOLFormula"},
			  			{name: "variant", type: "Term"} 
	 					],
	 "assumeAssignment": [ {name: "lhsRhsTuples", type: "(Var, Term)*"}],
	 "assumeSkip": [ ],
	 "stepOut": [ ],
	 "assignmentDerivation": [{name: "lhsVars", type: "List[Var]"}]

};

var mathquillTypes = ["Option[Term]", "Term", "FOLFormula"]; 
	
var absTypes = {
	"Tactic": {subTypes: ["stepIntoUnknownProgIdx", "stepIntoUnknownProgId", "replaceFormula", "retValTactic", 
	           "rcvInPost", "rtvInPost", "deleteConjunct", "assumeAssignment", "assumeSkip", "stepOut"] }
};


function mkInputBox(tpe) {
	if(tpe in absTypes){
		var options = '<option value="" disabled selected>Choose ...</option>';
		var subTypes = absTypes[tpe]["subTypes"];
        for (var i = 0; i < subTypes.length; i++) {
            options += format('<option value="{subtpe}">{subtpe}</option>', {subtpe: subTypes[i]});  
        }
        return format('<select class="inputPanelTpecombo"> {options} </select>', {options: options});			
	} else {
		console.debug("tpe: #####" + tpe);
		if($.inArray(tpe, mathquillTypes) > -1)
			return '<span class="mathquill-editable"></span>';
		else
			return '<input name="data"/>';
	}
}

//function mkFieldValueRow(fieldName, fieldTpe) {
//	return "<div>" + fieldName + "</div>" + mkInputBox(fieldTpe);
//}

//$(".tacticPanel")
//Given a concrete tpe, it creates field = value divs
function mkFieldsDiv(ctpe) {
	var fieldRows = '';
	var fields = types[ctpe];
	for (var i = 0; i < fields.length; i++) {
	    var field = fields[i];
		var inputBox = mkInputBox(field.type);
		fieldRows += format('<div class="fieldrow"><div class="fieldName"> {fieldName} </div><div> =</div> {inputBox} </div>', 
					{fieldName: field.name, inputBox: inputBox});
	}
	return format('<div class="fields">{fieldRows}</div>', {fieldRows: fieldRows});
}
//////////////////////////////////////////////////////////////////////////////
function initInputPanel() {
	var inputUI = mkFieldsDiv("rootTactic");
	var formElem = jQuery("<form action=''></form>");
	formElem.append(inputUI).append("<div class='button' id='applyTacticBtn'>Apply</div>");
	$(".inputPanel").append(formElem);
	
	//------------------
	//$(".inputPanel").append('<div>MathQuill Edit Box</div>');
	//$('<div><span class="mathquill-editable">\\frac{d}{dx}</span></div>').appendTo('.inputPanel').mathquill('editable');
	//$(".inputPanel").append('<div>MathQuill Embedded</div><div><span class="mathquill-embedded-latex">\frac{d}{dx}\sqrt{x}</span></div>');
	//$(".inputPanel").append('<div>' + $('.mathquill-editable').mathquill('latex') + '</div>');	
	
}


function onComboSelect() {
	var ctype = $(".inputPanelTpecombo option:selected").val();
	console.debug(ctype );		
	var fieldRowDiv = $(this).closest(".fieldrow");
	console.debug(ctype + " " + fieldRowDiv.toString());
	$(fieldRowDiv).children('.fields').remove()
	var inputUI = mkFieldsDiv(ctype);	
	$(fieldRowDiv).append(inputUI);
	$('.inputPanel .mathquill-editable').mathquill('editable');
}

function gatherInputData(){
	var $fields = $(".inputPanel form").closest_descendent(".fields");
	return getFieldRowJson($fields);
}

function getFieldRowJson($fields) {
	var retObj = {};
	//console.debug("entered getFieldRowJson");
	$fields.children(".fieldrow").each( function(){
		var fieldName = jQuery.trim($(this).children(".fieldName").first().text());//There will be only one fieldName
		var fieldValue = null;
		if ($(this).children("input").exists()){
			fieldValue = $(this).children("input").val();
		}
		else if($(this).children(".mathquill-editable").exists()){
			fieldValue = $(this).children(".mathquill-editable").mathquill('latex');
		}else{
			fieldValue = getFieldRowJson($(this).children(".fields"));
			//each object will have an additional type property
			//{p1: 20, p2: 10, tpe: abc}
			fieldValue["tpe"] = $(this).children("select").val();
		} 
		retObj[fieldName] = fieldValue; 
	});
	return retObj;
}


function tacticResponseHandler(nodeDiv) {
	$(".node.selected ")
		.removeClass("selected")
		.append($(nodeDiv).addClass("selected"));
	var newCurNodeId = $.trim($(nodeDiv).children(".nodeid").text());
	$(".curNodeId").text(newCurNodeId);	
}		

function onApplyTactic() {
	console.debug("onApplyTactic called");
	var inputData = gatherInputData();
	console.debug("gatherInputData returned : " + JSON.stringify(inputData));
	
	console.debug("sending post request to server...");
	$.ajax({
	    url: 'applyTactic',
	    type: 'POST',
	    data: JSON.stringify(inputData),
	    contentType: 'application/json; charset=utf-8',
	    dataType: 'html',
	    //async: false,
	    success: tacticResponseHandler
	});
	
	return false;
}

function __EventBindings__(){}

//Populate Input Panel on Document Ready
$(document).ready( function() {
	initInputPanel();
	$('.inputPanelTpecombo').on('change', onComboSelect);
	$('#applyTacticBtn').on('click', onApplyTactic);
});

////////////////////
//$.post('applyTactic', inputData, function(response, status){
//	console.debug("Got response from server");
//	console.debug("status: " + status);
//	console.debug("response: " + response);
//});
