/// <reference path="typings/backbone/backbone.d.ts" />
/// <reference path="typings/requirejs/require.d.ts" />
/// <reference path="typings/log4javascript/log4javascript.d.ts" />
"use strict";
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
define(["require", "exports", "ps_jquery_utils", "psweb.jquery.layout", "templateMgr", "synthtree_model"], function(require, exports, ps_jquery_utils, psweb_jquery_layout, templateMgr, stm) {
    ps_jquery_utils;
    psweb_jquery_layout;
    templateMgr;
    stm;

    var log4javascript = require('log4javascript');

    //
    var InputPanelView = (function (_super) {
        __extends(InputPanelView, _super);
        function InputPanelView(psState, options) {
            _super.call(this, options);
            this.psState = psState;
            /**/ this.logger = log4javascript.getLogger("webapp.InputPanelView");
            /**/ this.logger.trace("BeginSection(InputPanelView.constructor)");
            this.tagName = "div";
            this.tacticInputView = new XYZ.TacticView(new XYZ.TacticTV);
            ;
            /**/ this.logger.trace("EndSection(InputPanelView.constructor)");
        }
        InputPanelView.prototype.initialize = function () {
            /**/ //this.logger.trace("registered handler for click #applyTacticBtn in InputPanelView");
            this.events = {
                "click #applyTacticBtn": "onApplyTactic"
            };
        };

        InputPanelView.prototype.render0 = function () {
            var inputFormTpl = templateMgr.getTemplate("inputForm");
            var formElem = $(inputFormTpl());

            this.tacticInputView.render();
            var subEl = this.tacticInputView.el;

            var placeHolder = formElem.find(".placeholder.inputUI");
            placeHolder.replaceWith(subEl);

            this.$el.append(formElem);
            return this;
        };

        InputPanelView.prototype.render = function () {
            /**/ this.logger.trace("rendering InputPanelView...");
            var template = [
                "<form action=''></form>",
                [
                    this.tacticInputView.render().el,
                    "<div class='button' id='applyTacticBtn'>Apply</div>",
                    "<div class='ApplyTacticError'></div>"
                ]
            ];
            XYZ.HtmlJasonUtils.json2JQuery(template);
            this.$el.append(XYZ.HtmlJasonUtils.json2JQuery(template));

            //(<any>this.$('mathquill-editable')).mathquill('editable');
            return this;
        };

        //render2() {
        //    var compositeVal = mt.compositeValDb["rootTactic"];
        //    var inputUI = compositeVal.mkDiv();
        //    var inputFormTemplate = templateMgr.getTemplate("inputForm");
        //    var formElem = inputFormTemplate({ "inputUI": inputUI });
        //    this.$el.append(formElem);
        //    return this;
        //}
        InputPanelView.prototype.render3 = function () {
            //render subview first
            this.tacticInputView = new XYZ.TacticView(new XYZ.TacticTV); // Remove from render.
            this.tacticInputView.render();

            //render this
            var inputFormTpl = templateMgr.getTemplate("inputForm");
            var formElem = inputFormTpl({ "inputUI": this.tacticInputView.$el[0].outerHTML });

            this.$el.append(formElem);
            return this;
        };

        InputPanelView.prototype.onApplyTactic = function () {
            /**/ this.logger.trace("InputPanelView.onApplyTactic");
            /**/ this.logger.trace("Updating values of InputPanelView.tacticInputView...");
            /**/ this.logger.trace("Collecting input data...");
            this.tacticInputView.updateVal();
            var inputData = this.tacticInputView.tv;

            //add derivation name to inputData
            var derivName = window.location.pathname.replace(/^\/derivation\//, "");

            //inputData['derivName'] = derivName;
            //var inputData = idc.gatherInputData();
            /**/ this.logger.trace("calling psState.applyTactic...");
            this.psState.applyTactic(inputData, derivName);
        };

        InputPanelView.prototype.cleanup = function (event) {
            /**/ this.logger.trace("cleaning up inputPanelView...");
            var $fieldValDiv = $(event.target).closest(".AbstractVal");
            $fieldValDiv.children('.CompositeVal').remove();
        };

        InputPanelView.prototype.close = function () {
            /**/ this.logger.trace("closing inputPanelView...");
        };
        return InputPanelView;
    })(Backbone.View);
    exports.InputPanelView = InputPanelView;

    //////////////////////////////////////////////////////////////////////////
    (function (XYZ) {
        var ClassRegistry;
        (function (ClassRegistry) {
            var tvNameTVMap = {};
            var logger = log4javascript.getLogger("webapp.ClassRegistry");

            function registerClass(className, classFn) {
                tvNameTVMap[className] = classFn;
            }
            ClassRegistry.registerClass = registerClass;
            function getClass(className) {
                return tvNameTVMap[className];
            }
            ClassRegistry.getClass = getClass;

            function createView(aTV) {
                //var clsName = Describer.getClassName(aTV);
                var clsName = aTV.tvName;
                var viewClsName = clsName.replace(/TV$/, "View");
                return new tvNameTVMap[viewClsName](aTV);
            }
            ClassRegistry.createView = createView;

            function createViewFromTVName(tvName) {
                var viewName = tvName.replace(/TV$/, "View");
                var tvClass = ClassRegistry.getClass(tvName);
                var viewClass = ClassRegistry.getClass(viewName);

                var tvClassObj = new tvClass();
                return new viewClass(tvClassObj);
            }
            ClassRegistry.createViewFromTVName = createViewFromTVName;

            function registerTVs() {
                /**/ logger.trace("registering TVs...");
                registerClass('EnumTV', EnumTV);
                registerClass('EnumView', EnumView);
                registerClass('PSTypeTV', PSTypeTV);
                registerClass('PSTypeView', PSTypeView);
                registerClass('NewVarTV', NewVarTV);
                registerClass('NewVarView', NewVarView);
                registerClass('FieldTV', FieldTV);
                registerClass('FieldView', FieldView);
                registerClass('IntegerTV', IntegerTV);
                registerClass('IntegerView', IntegerView);
                registerClass('StringTV', StringTV);
                registerClass('StringView', StringView);
                registerClass('TermView', TermView);
                registerClass('TermTV', TermTV);
                registerClass('VarView', VarView);
                registerClass('VarTV', VarTV);
                registerClass('FOLFormulaView', FOLFormulaView);
                registerClass('FOLFormulaTV', FOLFormulaTV);
                registerClass('TermBoolView', TermBoolView);
                registerClass('TermBoolTV', TermBoolTV);
                registerClass('InitView', InitView);
                registerClass('InitTV', InitTV);
                registerClass('StepIntoUnknownProgIdxView', StepIntoUnknownProgIdxView);
                registerClass('StepIntoUnknownProgIdxTV', StepIntoUnknownProgIdxTV);
                registerClass('RetValView', RetValView);
                registerClass('RetValTV', RetValTV);
                registerClass('RTVInPostView', RTVInPostView);
                registerClass('RTVInPostTV', RTVInPostTV);
                registerClass('DeleteConjunctView', DeleteConjunctView);
                registerClass('DeleteConjunctTV', DeleteConjunctTV);
                registerClass('StepOutView', StepOutView);
                registerClass('StepOutTV', StepOutTV);
                registerClass('SimplifyAutoTV', SimplifyAutoTV);
                registerClass('SimplifyAutoView', SimplifyAutoView);
                registerClass('SimplifyTV', SimplifyTV);
                registerClass('SimplifyView', SimplifyView);
                registerClass('ListView', ListView);
                registerClass('ListTV', ListTV);
                registerClass('TupleView', TupleView);
                registerClass('TupleTV', TupleTV);
                registerClass('AssumeAssignmentView', AssumeAssignmentView);
                registerClass('AssumeAssignmentTV', AssumeAssignmentTV);
                registerClass('Init4View', Init4View);
                registerClass('Init4TV', Init4TV);
                registerClass('MagicView', MagicView);
                registerClass('MagicTV', MagicTV);
                registerClass('StartIfDerivationView', StartIfDerivationView);
                registerClass('StartIfDerivationTV', StartIfDerivationTV);
                registerClass('GuessExprValuesView', GuessExprValuesView);
                registerClass('GuessExprValuesTV', GuessExprValuesTV);
                registerClass('VerifiedTransformationEquivView', VerifiedTransformationEquivView);
                registerClass('VerifiedTransformationEquivTV', VerifiedTransformationEquivTV);
                registerClass('GuessGuardView', GuessGuardView);
                registerClass('GuessGuardTV', GuessGuardTV);
                registerClass('StartGCmdDerivationView', StartGCmdDerivationView);
                registerClass('StartGCmdDerivationTV', StartGCmdDerivationTV);

                ///
                registerClass('DistributivityTV', DistributivityTV);
                registerClass('DistributivityView', DistributivityView);
                registerClass('EmptyRangeTV', EmptyRangeTV);
                registerClass('EmptyRangeView', EmptyRangeView);
                registerClass('OnePointTV', OnePointTV);
                registerClass('OnePointView', OnePointView);
                registerClass('QDistributivityTV', QDistributivityTV);
                registerClass('QDistributivityView', QDistributivityView);
                registerClass('RangeSplitTV', RangeSplitTV);
                registerClass('RangeSplitView', RangeSplitView);
                registerClass('ReplaceByEquivDisplayIdTV', ReplaceByEquivDisplayIdTV);
                registerClass('ReplaceByEquivDisplayIdView', ReplaceByEquivDisplayIdView);
                registerClass('StartAsgnDerivationTV', StartAsgnDerivationTV);
                registerClass('StartAsgnDerivationView', StartAsgnDerivationView);
                registerClass('StepIntoPOTV', StepIntoPOTV);
                registerClass('StepIntoPOView', StepIntoPOView);
                registerClass('StepIntoProgIdTV', StepIntoProgIdTV);
                registerClass('StepIntoProgIdView', StepIntoProgIdView);
                registerClass('StepIntoProgDisplayIdTV', StepIntoProgDisplayIdTV);
                registerClass('StepIntoProgDisplayIdView', StepIntoProgDisplayIdView);
                registerClass('StepIntoSubFormulaTV', StepIntoSubFormulaTV);
                registerClass('StepIntoSubFormulaView', StepIntoSubFormulaView);
                registerClass('StrengthenInvariantTV', StrengthenInvariantTV);
                registerClass('StrengthenInvariantView', StrengthenInvariantView);
                registerClass('TradingMoveToTermTV', TradingMoveToTermTV);
                registerClass('TradingMoveToTermView', TradingMoveToTermView);
                registerClass('UseAssumptionsTV', UseAssumptionsTV);
                registerClass('UseAssumptionsView', UseAssumptionsView);
                registerClass('Init3TV', Init3TV);
                registerClass('Init3View', Init3View);
                registerClass('IntroVariableTV', IntroVariableTV);
                registerClass('IntroVariableView', IntroVariableView);
            }
            ClassRegistry.registerTVs = registerTVs;
        })(ClassRegistry || (ClassRegistry = {}));

        // TypedValue
        var TV = (function () {
            function TV() {
                this.tvName = "TV";
            }
            TV.prototype.clone = function () {
                throw new Error("Abstract method clone not implemented in subclass of TV");
            };
            TV.prototype.copyTo = function (arg) {
                arg.tvName = this.tvName;
            };
            return TV;
        })();
        XYZ.TV = TV;

        var AbstractTV = (function (_super) {
            __extends(AbstractTV, _super);
            function AbstractTV(subTVs) {
                _super.call(this);
                this.tvName = "AbstractTV";
                this.subTVNames = subTVs;
                this.concreteTV = undefined;
            }
            AbstractTV.prototype.clone = function () {
                var retVal = new AbstractTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            AbstractTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.subTVNames = this.subTVNames;
                arg.concreteTV = this.concreteTV.clone();
            };
            return AbstractTV;
        })(TV);
        XYZ.AbstractTV = AbstractTV;

        var NewVarTV = (function (_super) {
            __extends(NewVarTV, _super);
            function NewVarTV(varNameTV, varTypeTV) {
                _super.call(this);
                this.tvName = "NewVarTV";
                this.varNameTV = varNameTV;
                this.varTypeTV = varTypeTV;
            }
            NewVarTV.prototype.clone = function () {
                var retVal = new NewVarTV(undefined, undefined);
                this.copyTo(retVal);
                return retVal;
            };
            NewVarTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.varNameTV = this.varNameTV.clone();
                arg.varTypeTV = this.varTypeTV.clone();
            };
            return NewVarTV;
        })(TV);
        XYZ.NewVarTV = NewVarTV;

        var EnumTV = (function (_super) {
            __extends(EnumTV, _super);
            function EnumTV(elements, selectedElem) {
                _super.call(this);
                this.tvName = "EnumTV";
                this.elements = elements;
                this.selectedElem = selectedElem;
            }
            EnumTV.prototype.clone = function () {
                var retVal = new EnumTV(undefined, undefined);
                this.copyTo(retVal);
                return retVal;
            };
            EnumTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.elements = this.elements;
                arg.selectedElem = this.selectedElem;
            };
            return EnumTV;
        })(TV);
        XYZ.EnumTV = EnumTV;

        var PSTypeTV = (function (_super) {
            __extends(PSTypeTV, _super);
            function PSTypeTV(selectedElem) {
                _super.call(this, ['Int', 'Bool', 'ArrayInt', 'ArrayBool'], selectedElem);
                this.tvName = "PSTypeTV";
            }
            PSTypeTV.prototype.clone = function () {
                var retVal = new PSTypeTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            PSTypeTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
            };
            return PSTypeTV;
        })(EnumTV);
        XYZ.PSTypeTV = PSTypeTV;

        var ClassTV = (function (_super) {
            __extends(ClassTV, _super);
            function ClassTV(fields) {
                _super.call(this);
                this.tvName = "ClassTV";
                this.fields = fields;
            }
            ClassTV.prototype.clone = function () {
                var retVal = new ClassTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            ClassTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.fields = _.map(this.fields, function (field) {
                    return field.clone();
                });
            };
            return ClassTV;
        })(TV);
        XYZ.ClassTV = ClassTV;

        var FieldTV = (function (_super) {
            __extends(FieldTV, _super);
            function FieldTV(fname, ftv) {
                _super.call(this);
                this.tvName = "FieldTV";
                this.fname = fname;
                this.ftv = ftv;
            }
            FieldTV.prototype.clone = function () {
                var retVal = new FieldTV(undefined, undefined);
                this.copyTo(retVal);
                return retVal;
            };
            FieldTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.fname = this.fname;
                arg.ftv = this.ftv.clone();
            };
            return FieldTV;
        })(TV);
        XYZ.FieldTV = FieldTV;

        var PrimitiveTV = (function (_super) {
            __extends(PrimitiveTV, _super);
            function PrimitiveTV(value) {
                _super.call(this);
                this.tvName = "PrimitiveTV";
                this.value = value;
            }
            PrimitiveTV.prototype.clone = function () {
                var retVal = new PrimitiveTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            PrimitiveTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.value = this.value;
            };
            return PrimitiveTV;
        })(TV);
        XYZ.PrimitiveTV = PrimitiveTV;

        
        var PSView = (function (_super) {
            __extends(PSView, _super);
            function PSView(options) {
                _super.call(this, options);
            }
            PSView.prototype.close = function () {
                throw new Error("Abstract method close not implemented in subclass of PSView");
            };
            PSView.prototype.updateVal = function () {
                throw new Error("Abstract method updateVal not implemented in subclass of PSView");
            };
            return PSView;
        })(Backbone.View);
        XYZ.PSView = PSView;

        var AbstractView = (function (_super) {
            __extends(AbstractView, _super);
            function AbstractView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
                this.concreteView = undefined;
            }
            AbstractView.prototype.render = function () {
                this.$el.append("<div>AbstractView</div>");
                return this;
            };

            AbstractView.prototype.close = function () {
                if (this.concreteView) {
                    this.concreteView.close();
                }
            };
            AbstractView.prototype.updateVal = function () {
                this.concreteView.updateVal();
            };
            return AbstractView;
        })(PSView);
        XYZ.AbstractView = AbstractView;

        var NewVarView = (function (_super) {
            __extends(NewVarView, _super);
            function NewVarView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
                this.populateViews();
            }
            NewVarView.prototype.populateViews = function () {
                this.varNameView = ClassRegistry.createView(this.tv.varNameTV);
                this.varTypeView = ClassRegistry.createView(this.tv.varTypeTV);
            };

            NewVarView.prototype.render = function () {
                this.varNameView.render();
                this.varTypeView.render();
                var jsonEle = [
                    '<div class = "NewVarTV"> </div>',
                    [
                        this.varNameView.el,
                        '<div> : </div>',
                        this.varTypeView.el]];

                this.$el.append(HtmlJasonUtils.json2JQuery(jsonEle));
                return this;
            };

            NewVarView.prototype.close = function () {
                this.varTypeView.close();
            };
            NewVarView.prototype.updateVal = function () {
                this.varNameView.updateVal();
                this.varTypeView.updateVal();
            };
            return NewVarView;
        })(PSView);
        XYZ.NewVarView = NewVarView;

        var EnumView = (function (_super) {
            __extends(EnumView, _super);
            function EnumView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
            }
            EnumView.prototype.render = function () {
                var template = templateMgr.getTemplate("enumView");
                var comboBoxDiv = $(template({ 'elements': this.tv.elements }));
                this.$el.append(comboBoxDiv);
                return this;
            };

            EnumView.prototype.close = function () {
            };
            EnumView.prototype.updateVal = function () {
                this.tv.selectedElem = this.$el.find("option:selected").val();
            };
            return EnumView;
        })(PSView);
        XYZ.EnumView = EnumView;

        var PSTypeView = (function (_super) {
            __extends(PSTypeView, _super);
            function PSTypeView() {
                _super.apply(this, arguments);
            }
            return PSTypeView;
        })(EnumView);
        XYZ.PSTypeView = PSTypeView;

        var ClassView = (function (_super) {
            __extends(ClassView, _super);
            function ClassView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
                this.fieldViews = [];
                this.populateFieldViews();
            }
            ClassView.prototype.populateFieldViews = function () {
                var _this = this;
                _.forEach(this.tv.fields, function (field) {
                    var fv = ClassRegistry.createView(field);
                    _this.fieldViews.push(fv);
                });
            };

            ClassView.prototype.render = function () {
                this.$el.empty();
                var elem = $('<table border = "1" ></table>');
                _.forEach(this.fieldViews, function (fv) {
                    //children().first() strips the root .div node
                    var fieldDiv = fv.render().$el;
                    elem.append(fieldDiv.children().first());
                });
                this.$el.append(elem);
                return this;
            };

            ClassView.prototype.close = function () {
                //_.each(this.fieldViews, function (fv) {
                //    fv.close();
                //});
            };
            ClassView.prototype.updateVal = function () {
                this.fieldViews.forEach(function (fv) {
                    fv.updateVal();
                });
            };
            return ClassView;
        })(PSView);
        XYZ.ClassView = ClassView;

        var ListView = (function (_super) {
            __extends(ListView, _super);
            function ListView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'listVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
                this.itemViews = [];
                this.populateItemViews();
            }
            ListView.prototype.populateItemViews = function () {
                var _this = this;
                //Why to clone: the updateval directly picks up data from the objects
                //associated with the views. Hence we need a new object.
                if (this.tv.items.length == 0) {
                    //jQuery extend does not work.
                    //var clonedTpe = <TV>jQuery.extend(true, {}, this.tv.itv);
                    var clonedTpe = this.tv.metaTV.clone();
                    this.tv.items.push(clonedTpe);
                    var clonedTpe2 = this.tv.metaTV.clone();
                    this.tv.items.push(clonedTpe2);
                    var clonedTpe3 = this.tv.metaTV.clone();
                    this.tv.items.push(clonedTpe3);
                    var clonedTpe4 = this.tv.metaTV.clone();
                    this.tv.items.push(clonedTpe4);
                }
                _.forEach(this.tv.items, function (item) {
                    var fv = ClassRegistry.createView(item);
                    _this.itemViews.push(fv);
                });
            };
            ListView.prototype.render = function () {
                this.$el.empty();
                var elem = $('<table border = "1" ></table>');
                _.forEach(this.itemViews, function (iv) {
                    elem.append($("<tr></tr>").append($("<td></td>").append(iv.render().el)));
                });
                this.$el.append(elem);
                return this;
            };

            ListView.prototype.updateVal = function () {
                this.itemViews.forEach(function (fv) {
                    fv.updateVal();
                });
            };
            return ListView;
        })(PSView);
        XYZ.ListView = ListView;

        var TupleView = (function (_super) {
            __extends(TupleView, _super);
            function TupleView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'listVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
                this.view1 = ClassRegistry.createView(tv.item1);
                this.view2 = ClassRegistry.createView(tv.item2);
            }
            TupleView.prototype.render = function () {
                this.$el.empty();
                var elem = $("<div class='tupleview'></div>");
                elem.append(this.view1.render().el);
                elem.append(this.view2.render().el);
                this.$el.append(elem);
                return this;
            };

            TupleView.prototype.updateVal = function () {
                this.view1.updateVal();
                this.view2.updateVal();
            };
            return TupleView;
        })(PSView);
        XYZ.TupleView = TupleView;

        var FieldView = (function (_super) {
            __extends(FieldView, _super);
            function FieldView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
                this.rhsView = ClassRegistry.createView(this.tv.ftv);
            }
            FieldView.prototype.renderWithTr = function () {
                //Add in constructor : this.tagName = "tr";
                this.$el.empty();
                this.$el.addClass("fieldDiv");
                this.$el.append("<td>" + this.tv.fname + "</td>");
                this.$el.append("<td>" + "=" + "</td>");
                this.$el.append($("<td></td>").append(this.rhsView.render().el));
                return this;
            };

            FieldView.prototype.render = function () {
                this.$el.empty();
                this.$el.addClass("fieldDiv");
                var rowElem = $("<tr></tr>");
                rowElem.append("<td>" + this.tv.fname + "</td>");
                rowElem.append("<td>" + "=" + "</td>");
                rowElem.append($("<td></td>").append(this.rhsView.render().el));
                this.$el.append(rowElem);
                return this;
            };

            //using template
            FieldView.prototype.render2 = function () {
                var fieldName = this.tv.tvName;
                var rhsTV = this.tv.ftv;
                var fv = ClassRegistry.createView(rhsTV);

                var fieldValTpl = templateMgr.getTemplate("fieldVal");
                var fieldValElem = $(fieldValTpl({ ftv: rhsTV, fname: fieldName }));
                fieldValElem.find(".placeholder.fieldTVDiv").replaceWith(fv.render().el);

                this.$el.append(fieldValElem);
                return this;
            };

            FieldView.prototype.updateVal = function () {
                this.rhsView.updateVal();
            };
            return FieldView;
        })(PSView);
        XYZ.FieldView = FieldView;

        var PrimitiveView = (function (_super) {
            __extends(PrimitiveView, _super);
            function PrimitiveView(tv, options) {
                _super.call(this, options);
                this.tv = tv;
            }
            return PrimitiveView;
        })(PSView);
        XYZ.PrimitiveView = PrimitiveView;

        //Utils
        var Describer = (function () {
            function Describer() {
            }
            Describer.getClassName = function (inputObj) {
                var funcNameRegex = /function (.{1,})\(/;
                var results = (funcNameRegex).exec(inputObj.constructor.toString());
                return (results && results.length > 1) ? results[1] : "";
            };
            return Describer;
        })();

        var ViewFactory;
        (function (ViewFactory) {
            function createView(aTV) {
                var clsName = Describer.getClassName(aTV);
                var retTV = undefined;
                if (clsName === 'StepIntoUnknownProgIdxTV') {
                    retTV = new StepIntoUnknownProgIdxView(aTV);
                } else if (clsName === 'PrimitiveTV') {
                    retTV = new PrimitiveView(aTV);
                } else if (clsName === 'IntegerTV') {
                    retTV = new IntegerView(aTV);
                }
                return retTV;
            }
            ViewFactory.createView = createView;
        })(ViewFactory || (ViewFactory = {}));

        (function (HtmlJasonUtils) {
            function json2JqueryI(json) {
                var node = json[0];
                var $node = json2JqueryL(node);
                var childs = json[1];
                _.forEach(childs, function (child) {
                    var $child = json2JQuery(child);
                    $node.append($child);
                });
                return $node;
            }

            function json2JqueryL(obj) {
                if (obj instanceof jQuery) {
                    return obj;
                } else {
                    return $(obj);
                }
            }

            function json2JQuery(obj) {
                if ($.isArray(obj)) {
                    return json2JqueryI(obj);
                } else {
                    return json2JqueryL(obj);
                }
            }
            HtmlJasonUtils.json2JQuery = json2JQuery;
        })(XYZ.HtmlJasonUtils || (XYZ.HtmlJasonUtils = {}));
        var HtmlJasonUtils = XYZ.HtmlJasonUtils;

        //User TVs
        var IntegerTV = (function (_super) {
            __extends(IntegerTV, _super);
            function IntegerTV(value) {
                _super.call(this, value);
                this.tvName = "IntegerTV";
                this.value = value;
            }
            IntegerTV.prototype.clone = function () {
                var retVal = new IntegerTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            IntegerTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.value = this.value;
            };
            return IntegerTV;
        })(PrimitiveTV);
        XYZ.IntegerTV = IntegerTV;

        var StringTV = (function (_super) {
            __extends(StringTV, _super);
            function StringTV(value) {
                _super.call(this, value);
                this.tvName = "StringTV";
                this.value = value;
            }
            StringTV.prototype.clone = function () {
                var retVal = new StringTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            StringTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.value = this.value;
            };
            return StringTV;
        })(PrimitiveTV);
        XYZ.StringTV = StringTV;

        var TermTV = (function (_super) {
            __extends(TermTV, _super);
            function TermTV(value) {
                _super.call(this, value);
                this.tvName = "TermTV";
                this.value = value;
            }
            TermTV.prototype.clone = function () {
                var retVal = new TermTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            TermTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.value = this.value;
            };
            return TermTV;
        })(PrimitiveTV);
        XYZ.TermTV = TermTV;

        var VarTV = (function (_super) {
            __extends(VarTV, _super);
            function VarTV(value) {
                _super.call(this, value);
                this.tvName = "VarTV";
                this.value = value;
            }
            VarTV.prototype.clone = function () {
                var retVal = new VarTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            VarTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.value = this.value;
            };
            return VarTV;
        })(PrimitiveTV);
        XYZ.VarTV = VarTV;

        //export class NewVarType extends Type {
        //    varName: string;
        //    varType: PSType;
        //    constructor(varName) {
        //        super("NewVarType");
        //    }
        //    clone(): NewVarType {
        //        var retVal = new NewVarType();
        //        this.copyTo(retVal);
        //        return retVal;
        //    }
        //    copyTo(arg: NewVarType) {
        //        super.copyTo(arg);
        //    }
        //}
        var FOLFormulaTV = (function (_super) {
            __extends(FOLFormulaTV, _super);
            function FOLFormulaTV(value) {
                _super.call(this, value);
                this.tvName = "FOLFormulaTV";
                this.value = value;
            }
            FOLFormulaTV.prototype.clone = function () {
                var retVal = new FOLFormulaTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            FOLFormulaTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.value = this.value;
            };
            return FOLFormulaTV;
        })(PrimitiveTV);
        XYZ.FOLFormulaTV = FOLFormulaTV;

        var TermBoolTV = (function (_super) {
            __extends(TermBoolTV, _super);
            function TermBoolTV(value) {
                _super.call(this, value);
                this.tvName = "TermBoolTV";
                this.value = value;
            }
            TermBoolTV.prototype.clone = function () {
                var retVal = new TermBoolTV(undefined);
                this.copyTo(retVal);
                return retVal;
            };
            TermBoolTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.value = this.value;
            };
            return TermBoolTV;
        })(PrimitiveTV);
        XYZ.TermBoolTV = TermBoolTV;

        var ListTV = (function (_super) {
            __extends(ListTV, _super);
            //TODO: make the val argument optional.
            ////ListTV constructor can not be optional
            ////An empty list must be able to render itself.
            function ListTV(itv, items) {
                _super.call(this);
                this.tvName = "ListTV";
                this.metaTV = itv;
                this.items = items;
            }
            ListTV.prototype.clone = function () {
                var retVal = new ListTV(undefined, undefined);
                this.copyTo(retVal);
                return retVal;
            };
            ListTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.metaTV = this.metaTV.clone();
                arg.items = _.map(this.items, function (item) {
                    return item.clone();
                });
            };
            return ListTV;
        })(TV);
        XYZ.ListTV = ListTV;

        var TupleTV = (function (_super) {
            __extends(TupleTV, _super);
            function TupleTV(val1, val2) {
                _super.call(this);
                this.tvName = "TupleTV";
                this.item1 = val1;
                this.item2 = val2;
            }
            TupleTV.prototype.clone = function () {
                var retVal = new TupleTV(undefined, undefined);
                this.copyTo(retVal);
                return retVal;
            };
            TupleTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.item1 = this.item1.clone();
                arg.item2 = this.item2.clone();
            };
            return TupleTV;
        })(TV);
        XYZ.TupleTV = TupleTV;

        var StepIntoUnknownProgIdxTV = (function (_super) {
            __extends(StepIntoUnknownProgIdxTV, _super);
            function StepIntoUnknownProgIdxTV(idx) {
                var idxField = new FieldTV('idx', new IntegerTV(idx));
                var fields = [idxField];
                _super.call(this, fields);
                this.tvName = "StepIntoUnknownProgIdxTV";
                this.idx = idx;
            }
            StepIntoUnknownProgIdxTV.prototype.clone = function () {
                var retVal = new StepIntoUnknownProgIdxTV();
                this.copyTo(retVal);
                return retVal;
            };
            StepIntoUnknownProgIdxTV.prototype.copyTo = function (arg) {
                _super.prototype.copyTo.call(this, arg);
                arg.idx = this.idx;
            };
            return StepIntoUnknownProgIdxTV;
        })(ClassTV);
        XYZ.StepIntoUnknownProgIdxTV = StepIntoUnknownProgIdxTV;

        //InitTactic(name: String, params: List[Var], retVar: Var, preF: FOLFormula, postF: FOLFormula)
        var InitTV = (function (_super) {
            __extends(InitTV, _super);
            function InitTV(name, params, retVar, preF, postF) {
                var fields = [];
                fields.push(new FieldTV('name', new StringTV(name)));
                var newVarTVList = _.map(params, function (param) {
                    new NewVarTV(new StringTV(param), new PSTypeTV(undefined));
                });
                fields.push(new FieldTV('params', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarTVList)));
                fields.push(new FieldTV('retVar', new NewVarTV(new StringTV(name), new PSTypeTV(undefined))));
                fields.push(new FieldTV('preF', new TermBoolTV(name)));
                fields.push(new FieldTV('postF', new TermBoolTV(name)));
                _super.call(this, fields);
                this.tvName = "InitTV";
            }
            return InitTV;
        })(ClassTV);
        XYZ.InitTV = InitTV;

        var RetValTV = (function (_super) {
            __extends(RetValTV, _super);
            function RetValTV(initTerm) {
                var initTermF = new FieldTV('initTerm', new TermTV(initTerm));
                var fields = [initTermF];
                _super.call(this, fields);
                this.tvName = "RetValTV";
            }
            return RetValTV;
        })(ClassTV);
        XYZ.RetValTV = RetValTV;

        var DeleteConjunctTV = (function (_super) {
            __extends(DeleteConjunctTV, _super);
            //conjunct: FOLFormula, variant: Term
            function DeleteConjunctTV(conjunct, variant) {
                var fields = [];
                fields.push(new FieldTV('conjunct', new TermBoolTV(conjunct)));
                fields.push(new FieldTV('variant', new TermTV(variant)));
                _super.call(this, fields);
                this.tvName = "DeleteConjunctTV";
            }
            return DeleteConjunctTV;
        })(ClassTV);
        XYZ.DeleteConjunctTV = DeleteConjunctTV;

        //AssumeAssignmentTactic(lhsRhsTuples:List[(Var, Term)]) extends FunTactic {
        var AssumeAssignmentTV = (function (_super) {
            __extends(AssumeAssignmentTV, _super);
            function AssumeAssignmentTV(lhsRhsTuples) {
                var fields = [];
                var tupleTVList = _.map(lhsRhsTuples, function (tuple) {
                    var tv1 = new VarTV(tuple[0]);
                    var tv2 = new TermTV(tuple[1]);
                    new TupleTV(tv1, tv2);
                });

                fields.push(new FieldTV('lhsRhsTuples', new ListTV(new TupleTV(new VarTV(), new TermTV()), tupleTVList)));
                _super.call(this, fields);
                this.tvName = "AssumeAssignmentTV";
            }
            return AssumeAssignmentTV;
        })(ClassTV);
        XYZ.AssumeAssignmentTV = AssumeAssignmentTV;

        //Init4Tactic(name: String, mutableVars: List[Var], immutableVars: List[Var],
        //	preF: TermBool, postF: TermBool, globalInvs: List[TermBool])
        var Init4TV = (function (_super) {
            __extends(Init4TV, _super);
            function Init4TV(name, mutableVars, immutableVars, preF, postF, globalInvs) {
                var fields = [];
                fields.push(new FieldTV('name', new StringTV(name)));
                var newVarMutableTVList = _.map(mutableVars, function (mutableVar) {
                    new NewVarTV(new StringTV(mutableVar), new PSTypeTV(undefined));
                });
                var newVarImmutableTVList = _.map(immutableVars, function (immutableVar) {
                    new NewVarTV(new StringTV(immutableVar), new PSTypeTV(undefined));
                });
                fields.push(new FieldTV('mutableVars', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarMutableTVList)));
                fields.push(new FieldTV('immutableVars', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarImmutableTVList)));
                fields.push(new FieldTV('preF', new TermBoolTV(preF)));
                fields.push(new FieldTV('postF', new TermBoolTV(postF)));
                var globalInvsTVList = _.map(globalInvs, function (x) {
                    new TermBoolTV(x);
                });
                fields.push(new FieldTV('globalInvs', new ListTV(new TermBoolTV(""), globalInvsTVList)));
                _super.call(this, fields);
                this.tvName = "Init4TV";
            }
            return Init4TV;
        })(ClassTV);
        XYZ.Init4TV = Init4TV;

        var StartIfDerivationTV = (function (_super) {
            __extends(StartIfDerivationTV, _super);
            function StartIfDerivationTV(lhsVars) {
                var fields = [];
                var varTVList = _.map(lhsVars, function (lVar) {
                    new VarTV(lVar);
                });
                fields.push(new FieldTV('lhsVars', new ListTV(new VarTV(""), varTVList)));
                _super.call(this, fields);
                this.tvName = "StartIfDerivationTV";
            }
            return StartIfDerivationTV;
        })(ClassTV);
        XYZ.StartIfDerivationTV = StartIfDerivationTV;

        var GuessExprValuesTV = (function (_super) {
            __extends(GuessExprValuesTV, _super);
            function GuessExprValuesTV(primedVarTermList) {
                var fields = [];
                var tupleTVList = _.map(primedVarTermList, function (tuple) {
                    var tv1 = new StringTV(tuple[0]);
                    var tv2 = new TermTV(tuple[1]);
                    new TupleTV(tv1, tv2);
                });

                fields.push(new FieldTV('primedVarTermList', new ListTV(new TupleTV(new StringTV(), new TermTV()), tupleTVList)));
                _super.call(this, fields);
                this.tvName = "GuessExprValuesTV";
            }
            return GuessExprValuesTV;
        })(ClassTV);
        XYZ.GuessExprValuesTV = GuessExprValuesTV;

        var VerifiedTransformationEquivTV = (function (_super) {
            __extends(VerifiedTransformationEquivTV, _super);
            function VerifiedTransformationEquivTV(newFormula) {
                var fields = [];
                fields.push(new FieldTV('newFormula', new TermBoolTV(newFormula)));
                _super.call(this, fields);
                this.tvName = "VerifiedTransformationEquivTV";
            }
            return VerifiedTransformationEquivTV;
        })(ClassTV);
        XYZ.VerifiedTransformationEquivTV = VerifiedTransformationEquivTV;

        var GuessGuardTV = (function (_super) {
            __extends(GuessGuardTV, _super);
            function GuessGuardTV(guard) {
                var fields = [];
                fields.push(new FieldTV('guard', new TermBoolTV(guard)));
                _super.call(this, fields);
                this.tvName = "GuessGuardTV";
            }
            return GuessGuardTV;
        })(ClassTV);
        XYZ.GuessGuardTV = GuessGuardTV;

        var StartGCmdDerivationTV = (function (_super) {
            __extends(StartGCmdDerivationTV, _super);
            function StartGCmdDerivationTV(guard) {
                var fields = [];
                _super.call(this, fields);
                this.tvName = "StartGCmdDerivationTV";
            }
            return StartGCmdDerivationTV;
        })(ClassTV);
        XYZ.StartGCmdDerivationTV = StartGCmdDerivationTV;

        var MagicTV = (function (_super) {
            __extends(MagicTV, _super);
            function MagicTV(vars, newF) {
                var fields = [];
                var newVarTVList = _.map(vars, function (aVar) {
                    new NewVarTV(new StringTV(aVar), new PSTypeTV(undefined));
                });
                fields.push(new FieldTV('vars', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarTVList)));
                fields.push(new FieldTV('newF', new TermBoolTV(name)));
                _super.call(this, fields);
                this.tvName = "MagicTV";
            }
            return MagicTV;
        })(ClassTV);
        XYZ.MagicTV = MagicTV;

        var StepOutTV = (function (_super) {
            __extends(StepOutTV, _super);
            function StepOutTV() {
                var fields = [];
                _super.call(this, fields);
                this.tvName = "StepOutTV";
            }
            return StepOutTV;
        })(ClassTV);
        XYZ.StepOutTV = StepOutTV;

        var SimplifyAutoTV = (function (_super) {
            __extends(SimplifyAutoTV, _super);
            function SimplifyAutoTV() {
                var fields = [];
                _super.call(this, fields);
                this.tvName = "SimplifyAutoTV";
            }
            return SimplifyAutoTV;
        })(ClassTV);
        XYZ.SimplifyAutoTV = SimplifyAutoTV;

        var SimplifyTV = (function (_super) {
            __extends(SimplifyTV, _super);
            function SimplifyTV() {
                var fields = [];
                _super.call(this, fields);
                this.tvName = "SimplifyTV";
            }
            return SimplifyTV;
        })(ClassTV);
        XYZ.SimplifyTV = SimplifyTV;

        var RTVInPostTV = (function (_super) {
            __extends(RTVInPostTV, _super);
            function RTVInPostTV(constant, variable, initValue, bounds) {
                var fields = [];
                fields.push(new FieldTV('constant', new TermTV(constant)));
                fields.push(new FieldTV('variable', new NewVarTV(new StringTV(variable), new PSTypeTV(undefined))));

                //fields.push(new FieldTV('variable', new VarTV(variable)));
                fields.push(new FieldTV('initValue', new TermTV(initValue)));
                fields.push(new FieldTV('bounds', new TermBoolTV(bounds)));

                _super.call(this, fields);
                this.tvName = "RTVInPostTV";
            }
            return RTVInPostTV;
        })(ClassTV);
        XYZ.RTVInPostTV = RTVInPostTV;

        ///////////////////////////////////////////////
        var DistributivityTV = (function (_super) {
            __extends(DistributivityTV, _super);
            function DistributivityTV(displayId) {
                var fields = [];
                fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
                _super.call(this, fields);
                this.tvName = "DistributivityTV";
            }
            return DistributivityTV;
        })(ClassTV);
        XYZ.DistributivityTV = DistributivityTV;

        var EmptyRangeTV = (function (_super) {
            __extends(EmptyRangeTV, _super);
            function EmptyRangeTV(displayId) {
                var fields = [];
                fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
                _super.call(this, fields);
                this.tvName = "EmptyRangeTV";
            }
            return EmptyRangeTV;
        })(ClassTV);
        XYZ.EmptyRangeTV = EmptyRangeTV;

        var OnePointTV = (function (_super) {
            __extends(OnePointTV, _super);
            function OnePointTV(displayId) {
                var fields = [];
                fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
                _super.call(this, fields);
                this.tvName = "OnePointTV";
            }
            return OnePointTV;
        })(ClassTV);
        XYZ.OnePointTV = OnePointTV;

        var QDistributivityTV = (function (_super) {
            __extends(QDistributivityTV, _super);
            function QDistributivityTV(displayId) {
                var fields = [];
                fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
                _super.call(this, fields);
                this.tvName = "QDistributivityTV";
            }
            return QDistributivityTV;
        })(ClassTV);
        XYZ.QDistributivityTV = QDistributivityTV;

        var RangeSplitTV = (function (_super) {
            __extends(RangeSplitTV, _super);
            function RangeSplitTV(displayId) {
                var fields = [];
                fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
                _super.call(this, fields);
                this.tvName = "RangeSplitTV";
            }
            return RangeSplitTV;
        })(ClassTV);
        XYZ.RangeSplitTV = RangeSplitTV;

        var ReplaceByEquivDisplayIdTV = (function (_super) {
            __extends(ReplaceByEquivDisplayIdTV, _super);
            function ReplaceByEquivDisplayIdTV(oldSubFId, newSubF) {
                var fields = [];
                fields.push(new FieldTV('oldSubFId', new IntegerTV(oldSubFId)));
                fields.push(new FieldTV('newSubF', new TermBoolTV(newSubF)));
                _super.call(this, fields);
                this.tvName = "ReplaceByEquivDisplayIdTV";
            }
            return ReplaceByEquivDisplayIdTV;
        })(ClassTV);
        XYZ.ReplaceByEquivDisplayIdTV = ReplaceByEquivDisplayIdTV;

        var StartAsgnDerivationTV = (function (_super) {
            __extends(StartAsgnDerivationTV, _super);
            function StartAsgnDerivationTV(lhsVars) {
                var fields = [];
                var lhsVarsTVList = _.map(lhsVars, function (x) {
                    new VarTV(x);
                });
                fields.push(new FieldTV('lhsVars', new ListTV(new VarTV(""), lhsVarsTVList)));
                _super.call(this, fields);
                this.tvName = "StartAsgnDerivationTV";
            }
            return StartAsgnDerivationTV;
        })(ClassTV);
        XYZ.StartAsgnDerivationTV = StartAsgnDerivationTV;

        var StepIntoPOTV = (function (_super) {
            __extends(StepIntoPOTV, _super);
            function StepIntoPOTV() {
                var fields = [];

                _super.call(this, fields);
                this.tvName = "StepIntoPOTV";
            }
            return StepIntoPOTV;
        })(ClassTV);
        XYZ.StepIntoPOTV = StepIntoPOTV;

        var StepIntoProgIdTV = (function (_super) {
            __extends(StepIntoProgIdTV, _super);
            function StepIntoProgIdTV(id) {
                var fields = [];
                fields.push(new FieldTV('id', new IntegerTV(id)));
                _super.call(this, fields);
                this.tvName = "StepIntoProgIdTV";
            }
            return StepIntoProgIdTV;
        })(ClassTV);
        XYZ.StepIntoProgIdTV = StepIntoProgIdTV;

        var StepIntoProgDisplayIdTV = (function (_super) {
            __extends(StepIntoProgDisplayIdTV, _super);
            function StepIntoProgDisplayIdTV(displayId) {
                var fields = [];
                fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
                _super.call(this, fields);
                this.tvName = "StepIntoProgDisplayIdTV";
            }
            return StepIntoProgDisplayIdTV;
        })(ClassTV);
        XYZ.StepIntoProgDisplayIdTV = StepIntoProgDisplayIdTV;

        var StepIntoSubFormulaTV = (function (_super) {
            __extends(StepIntoSubFormulaTV, _super);
            function StepIntoSubFormulaTV(subId) {
                var fields = [];
                fields.push(new FieldTV('subId', new IntegerTV(subId)));
                _super.call(this, fields);
                this.tvName = "StepIntoSubFormulaTV";
            }
            return StepIntoSubFormulaTV;
        })(ClassTV);
        XYZ.StepIntoSubFormulaTV = StepIntoSubFormulaTV;

        var StrengthenInvariantTV = (function (_super) {
            __extends(StrengthenInvariantTV, _super);
            function StrengthenInvariantTV(newInvs) {
                var fields = [];
                var newInvsTVList = _.map(newInvs, function (x) {
                    new TermBoolTV(x);
                });
                fields.push(new FieldTV('newInvs', new ListTV(new TermBoolTV(""), newInvsTVList)));
                _super.call(this, fields);
                this.tvName = "StrengthenInvariantTV";
            }
            return StrengthenInvariantTV;
        })(ClassTV);
        XYZ.StrengthenInvariantTV = StrengthenInvariantTV;

        var TradingMoveToTermTV = (function (_super) {
            __extends(TradingMoveToTermTV, _super);
            function TradingMoveToTermTV(displayId, termToBeMovedId) {
                var fields = [];
                fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
                fields.push(new FieldTV('termToBeMovedId', new IntegerTV(termToBeMovedId)));
                _super.call(this, fields);
                this.tvName = "TradingMoveToTermTV";
            }
            return TradingMoveToTermTV;
        })(ClassTV);
        XYZ.TradingMoveToTermTV = TradingMoveToTermTV;

        var UseAssumptionsTV = (function (_super) {
            __extends(UseAssumptionsTV, _super);
            function UseAssumptionsTV(subFormulaId, newSubF) {
                var fields = [];
                fields.push(new FieldTV('subFormulaId', new IntegerTV(subFormulaId)));
                fields.push(new FieldTV('newSubF', new TermBoolTV(newSubF)));
                _super.call(this, fields);
                this.tvName = "UseAssumptionsTV";
            }
            return UseAssumptionsTV;
        })(ClassTV);
        XYZ.UseAssumptionsTV = UseAssumptionsTV;

        var Init3TV = (function (_super) {
            __extends(Init3TV, _super);
            function Init3TV(name, params, retVar, preF, postF, globalInvs) {
                var fields = [];
                fields.push(new FieldTV('name', new StringTV(name)));
                var paramsTVList = _.map(params, function (x) {
                    new NewVarTV(new StringTV(x), new PSTypeTV(undefined));
                });
                fields.push(new FieldTV('params', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), paramsTVList)));
                fields.push(new FieldTV('retVar', new NewVarTV(new StringTV(retVar), new PSTypeTV(undefined))));
                fields.push(new FieldTV('preF', new TermBoolTV(preF)));
                fields.push(new FieldTV('postF', new TermBoolTV(postF)));
                var globalInvsTVList = _.map(globalInvs, function (x) {
                    new TermBoolTV(x);
                });
                fields.push(new FieldTV('globalInvs', new ListTV(new TermBoolTV(""), globalInvsTVList)));
                _super.call(this, fields);
                this.tvName = "Init3TV";
            }
            return Init3TV;
        })(ClassTV);
        XYZ.Init3TV = Init3TV;

        var IntroVariableTV = (function (_super) {
            __extends(IntroVariableTV, _super);
            function IntroVariableTV(aVar, initVal) {
                var fields = [];
                fields.push(new FieldTV('aVar', new NewVarTV(new StringTV(aVar), new PSTypeTV(undefined))));
                fields.push(new FieldTV('initVal', new TermTV(initVal)));
                _super.call(this, fields);
                this.tvName = "IntroVariableTV";
            }
            return IntroVariableTV;
        })(ClassTV);
        XYZ.IntroVariableTV = IntroVariableTV;

        /////////////////////////////////////////////////////////////////////////////////////
        var TacticTV = (function (_super) {
            __extends(TacticTV, _super);
            function TacticTV() {
                var subTVNames = [
                    "StepIntoUnknownProgIdxTV", "StepIntoUnknownProgIdTV",
                    "RetValTV", "RTVInPost", "DeleteConjunct", "Init", "StepOut", "SimplifyAuto", "Simplify", "AssumeAssignment", "Init4", "Magic",
                    "StartIfDerivation", "GuessExprValues", "VerifiedTransformationEquiv", "GuessGuard", "StartGCmdDerivation",
                    'Distributivity', 'EmptyRange', 'OnePoint', 'QDistributivity', 'RangeSplit', 'ReplaceByEquivDisplayId',
                    'StartAsgnDerivation', 'StepIntoPO', 'StepIntoProgId', 'StepIntoProgDisplayId', 'StepIntoSubFormula', 'StrengthenInvariant',
                    'TradingMoveToTerm', 'UseAssumptions', 'Init3', 'IntroVariable'].sort();
                _super.call(this, subTVNames);
                this.tvName = "TacticTV";
            }
            return TacticTV;
        })(AbstractTV);
        XYZ.TacticTV = TacticTV;

        //User Views
        var IntegerView = (function (_super) {
            __extends(IntegerView, _super);
            function IntegerView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'primitiveVal'> </div>",
                    ["<input name = 'data' />"]
                ];
            }
            IntegerView.prototype.render = function () {
                this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
                return this;
            };
            IntegerView.prototype.updateVal = function () {
                this.tv.value = this.$("input").val();
            };
            return IntegerView;
        })(PrimitiveView);
        XYZ.IntegerView = IntegerView;

        var StringView = (function (_super) {
            __extends(StringView, _super);
            function StringView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'primitiveVal'> </div>",
                    ["<input name = 'data' />"]
                ];
            }
            StringView.prototype.render = function () {
                this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
                return this;
            };
            StringView.prototype.updateVal = function () {
                this.tv.value = this.$("input").val();
            };
            return StringView;
        })(PrimitiveView);
        XYZ.StringView = StringView;

        var TermView = (function (_super) {
            __extends(TermView, _super);
            function TermView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
            }
            TermView.prototype.render = function () {
                this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
                this.$('.mathquill-editable').mathquill('editable');
                return this;
            };
            TermView.prototype.updateVal = function () {
                this.tv.value = this.$(".mathquill-editable").mathquill('latex');
                ;
            };
            return TermView;
        })(PrimitiveView);
        XYZ.TermView = TermView;

        var VarView = (function (_super) {
            __extends(VarView, _super);
            function VarView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
            }
            VarView.prototype.render = function () {
                this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
                this.$('.mathquill-editable').mathquill('editable');
                return this;
            };
            VarView.prototype.updateVal = function () {
                this.tv.value = this.$(".mathquill-editable").mathquill('latex');
                ;
            };
            return VarView;
        })(PrimitiveView);
        XYZ.VarView = VarView;

        var FOLFormulaView = (function (_super) {
            __extends(FOLFormulaView, _super);
            function FOLFormulaView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
            }
            FOLFormulaView.prototype.render = function () {
                this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
                this.$('.mathquill-editable').mathquill('editable');
                return this;
            };
            FOLFormulaView.prototype.updateVal = function () {
                this.tv.value = this.$(".mathquill-editable").mathquill('latex');
                ;
            };
            return FOLFormulaView;
        })(PrimitiveView);
        XYZ.FOLFormulaView = FOLFormulaView;

        var TermBoolView = (function (_super) {
            __extends(TermBoolView, _super);
            function TermBoolView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
                this.template = [
                    "<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
            }
            TermBoolView.prototype.render = function () {
                this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
                this.$('.mathquill-editable').mathquill('editable');
                return this;
            };
            TermBoolView.prototype.updateVal = function () {
                this.tv.value = this.$(".mathquill-editable").mathquill('latex');
                ;
            };
            return TermBoolView;
        })(PrimitiveView);
        XYZ.TermBoolView = TermBoolView;

        var StepIntoUnknownProgIdxView = (function (_super) {
            __extends(StepIntoUnknownProgIdxView, _super);
            function StepIntoUnknownProgIdxView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StepIntoUnknownProgIdxView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                this.tv.idx = this.tv.fields[0].ftv.value;
            };
            return StepIntoUnknownProgIdxView;
        })(ClassView);
        XYZ.StepIntoUnknownProgIdxView = StepIntoUnknownProgIdxView;

        var RTVInPostView = (function (_super) {
            __extends(RTVInPostView, _super);
            function RTVInPostView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            RTVInPostView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return RTVInPostView;
        })(ClassView);
        XYZ.RTVInPostView = RTVInPostView;

        var RetValView = (function (_super) {
            __extends(RetValView, _super);
            function RetValView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            RetValView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return RetValView;
        })(ClassView);
        XYZ.RetValView = RetValView;

        var InitView = (function (_super) {
            __extends(InitView, _super);
            function InitView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            InitView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return InitView;
        })(ClassView);
        XYZ.InitView = InitView;

        var Init4View = (function (_super) {
            __extends(Init4View, _super);
            function Init4View(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            Init4View.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return Init4View;
        })(ClassView);
        XYZ.Init4View = Init4View;

        var StartIfDerivationView = (function (_super) {
            __extends(StartIfDerivationView, _super);
            function StartIfDerivationView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StartIfDerivationView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return StartIfDerivationView;
        })(ClassView);
        XYZ.StartIfDerivationView = StartIfDerivationView;

        var GuessExprValuesView = (function (_super) {
            __extends(GuessExprValuesView, _super);
            function GuessExprValuesView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            GuessExprValuesView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return GuessExprValuesView;
        })(ClassView);
        XYZ.GuessExprValuesView = GuessExprValuesView;

        var VerifiedTransformationEquivView = (function (_super) {
            __extends(VerifiedTransformationEquivView, _super);
            function VerifiedTransformationEquivView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            VerifiedTransformationEquivView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return VerifiedTransformationEquivView;
        })(ClassView);
        XYZ.VerifiedTransformationEquivView = VerifiedTransformationEquivView;

        var GuessGuardView = (function (_super) {
            __extends(GuessGuardView, _super);
            function GuessGuardView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            GuessGuardView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return GuessGuardView;
        })(ClassView);
        XYZ.GuessGuardView = GuessGuardView;

        var StartGCmdDerivationView = (function (_super) {
            __extends(StartGCmdDerivationView, _super);
            function StartGCmdDerivationView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StartGCmdDerivationView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return StartGCmdDerivationView;
        })(ClassView);
        XYZ.StartGCmdDerivationView = StartGCmdDerivationView;

        var MagicView = (function (_super) {
            __extends(MagicView, _super);
            function MagicView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            MagicView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return MagicView;
        })(ClassView);
        XYZ.MagicView = MagicView;

        var DeleteConjunctView = (function (_super) {
            __extends(DeleteConjunctView, _super);
            function DeleteConjunctView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            DeleteConjunctView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return DeleteConjunctView;
        })(ClassView);
        XYZ.DeleteConjunctView = DeleteConjunctView;

        var AssumeAssignmentView = (function (_super) {
            __extends(AssumeAssignmentView, _super);
            function AssumeAssignmentView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            AssumeAssignmentView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return AssumeAssignmentView;
        })(ClassView);
        XYZ.AssumeAssignmentView = AssumeAssignmentView;

        var StepOutView = (function (_super) {
            __extends(StepOutView, _super);
            function StepOutView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StepOutView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return StepOutView;
        })(ClassView);
        XYZ.StepOutView = StepOutView;

        var SimplifyAutoView = (function (_super) {
            __extends(SimplifyAutoView, _super);
            function SimplifyAutoView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            SimplifyAutoView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return SimplifyAutoView;
        })(ClassView);
        XYZ.SimplifyAutoView = SimplifyAutoView;

        var SimplifyView = (function (_super) {
            __extends(SimplifyView, _super);
            function SimplifyView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            SimplifyView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
            };
            return SimplifyView;
        })(ClassView);
        XYZ.SimplifyView = SimplifyView;

        ///////////////////////////
        var DistributivityView = (function (_super) {
            __extends(DistributivityView, _super);
            function DistributivityView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            DistributivityView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return DistributivityView;
        })(ClassView);
        XYZ.DistributivityView = DistributivityView;

        var EmptyRangeView = (function (_super) {
            __extends(EmptyRangeView, _super);
            function EmptyRangeView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            EmptyRangeView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return EmptyRangeView;
        })(ClassView);
        XYZ.EmptyRangeView = EmptyRangeView;

        var OnePointView = (function (_super) {
            __extends(OnePointView, _super);
            function OnePointView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            OnePointView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return OnePointView;
        })(ClassView);
        XYZ.OnePointView = OnePointView;

        var QDistributivityView = (function (_super) {
            __extends(QDistributivityView, _super);
            function QDistributivityView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            QDistributivityView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return QDistributivityView;
        })(ClassView);
        XYZ.QDistributivityView = QDistributivityView;

        var RangeSplitView = (function (_super) {
            __extends(RangeSplitView, _super);
            function RangeSplitView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            RangeSplitView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return RangeSplitView;
        })(ClassView);
        XYZ.RangeSplitView = RangeSplitView;

        var ReplaceByEquivDisplayIdView = (function (_super) {
            __extends(ReplaceByEquivDisplayIdView, _super);
            function ReplaceByEquivDisplayIdView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            ReplaceByEquivDisplayIdView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return ReplaceByEquivDisplayIdView;
        })(ClassView);
        XYZ.ReplaceByEquivDisplayIdView = ReplaceByEquivDisplayIdView;

        var StartAsgnDerivationView = (function (_super) {
            __extends(StartAsgnDerivationView, _super);
            function StartAsgnDerivationView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StartAsgnDerivationView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return StartAsgnDerivationView;
        })(ClassView);
        XYZ.StartAsgnDerivationView = StartAsgnDerivationView;

        //
        var StepIntoPOView = (function (_super) {
            __extends(StepIntoPOView, _super);
            function StepIntoPOView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StepIntoPOView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return StepIntoPOView;
        })(ClassView);
        XYZ.StepIntoPOView = StepIntoPOView;

        var StepIntoProgIdView = (function (_super) {
            __extends(StepIntoProgIdView, _super);
            function StepIntoProgIdView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StepIntoProgIdView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return StepIntoProgIdView;
        })(ClassView);
        XYZ.StepIntoProgIdView = StepIntoProgIdView;

        var StepIntoProgDisplayIdView = (function (_super) {
            __extends(StepIntoProgDisplayIdView, _super);
            function StepIntoProgDisplayIdView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StepIntoProgDisplayIdView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return StepIntoProgDisplayIdView;
        })(ClassView);
        XYZ.StepIntoProgDisplayIdView = StepIntoProgDisplayIdView;

        var StepIntoSubFormulaView = (function (_super) {
            __extends(StepIntoSubFormulaView, _super);
            function StepIntoSubFormulaView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StepIntoSubFormulaView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return StepIntoSubFormulaView;
        })(ClassView);
        XYZ.StepIntoSubFormulaView = StepIntoSubFormulaView;

        var StrengthenInvariantView = (function (_super) {
            __extends(StrengthenInvariantView, _super);
            function StrengthenInvariantView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            StrengthenInvariantView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return StrengthenInvariantView;
        })(ClassView);
        XYZ.StrengthenInvariantView = StrengthenInvariantView;

        var TradingMoveToTermView = (function (_super) {
            __extends(TradingMoveToTermView, _super);
            function TradingMoveToTermView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            TradingMoveToTermView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return TradingMoveToTermView;
        })(ClassView);
        XYZ.TradingMoveToTermView = TradingMoveToTermView;

        var UseAssumptionsView = (function (_super) {
            __extends(UseAssumptionsView, _super);
            function UseAssumptionsView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            UseAssumptionsView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return UseAssumptionsView;
        })(ClassView);
        XYZ.UseAssumptionsView = UseAssumptionsView;

        var Init3View = (function (_super) {
            __extends(Init3View, _super);
            function Init3View(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            Init3View.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return Init3View;
        })(ClassView);
        XYZ.Init3View = Init3View;

        var IntroVariableView = (function (_super) {
            __extends(IntroVariableView, _super);
            function IntroVariableView(tv, options) {
                _super.call(this, tv, options);
                this.tv = tv;
            }
            IntroVariableView.prototype.updateVal = function () {
                _super.prototype.updateVal.call(this);
                //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
            };
            return IntroVariableView;
        })(ClassView);
        XYZ.IntroVariableView = IntroVariableView;

        ///////////////////////////
        var TacticView = (function (_super) {
            __extends(TacticView, _super);
            function TacticView(tv, options) {
                _super.call(this, tv, options);
                /**/ this.logger = log4javascript.getLogger("webapp.TacticView");
                this.tv = tv;
                this.concreteView = undefined;
            }
            TacticView.prototype.initialize = function () {
                if (this.jel) {
                    this.el = this.jel.get();
                }

                /**/ //this.logger.trace("TacticView: registering handler for change .inputPanelTVCombo");
                this.events = {
                    "change .inputPanelTVCombo": "onComboSelect"
                };
            };

            TacticView.prototype.render = function () {
                /**/ this.logger.trace("Rendering TacticView ...");
                this.$el.empty();
                var tacticTVs = _.map(this.tv.subTVNames, function (st) {
                    return st.replace(/TV$/, "");
                });
                var subViewDiv = '';
                if (this.concreteView) {
                    subViewDiv = this.concreteView.render().el;
                }
                var template = templateMgr.getTemplate("abstractVal");
                var comboBoxDiv = template({
                    'subTVs': tacticTVs,
                    'absTVName': this.tv.tvName.replace(/TV$/, ""),
                    'concreteDiv': subViewDiv
                });
                this.$el.append(comboBoxDiv);
                return this;
            };

            TacticView.prototype.onComboSelect = function (event) {
                /**/ this.logger.trace("TacticView.onComboSelect called");
                console.log("Tactic::onComboSelect");
                this.$('.selectedSubTV').empty();
                var tacticName = $(event.target).find("option:selected").val();
                this.concreteView = ClassRegistry.createViewFromTVName(tacticName + 'TV');
                ;
                this.tv.concreteTV = this.concreteView.tv;
                this.$('.selectedSubTV').append(this.concreteView.render().el);
                this.$('.mathquill-editable').mathquill('redraw');

                //Clear Errors
                $(".ApplyTacticError").html("");
            };
            return TacticView;
        })(AbstractView);
        XYZ.TacticView = TacticView;

        ClassRegistry.registerTVs();
    })(exports.XYZ || (exports.XYZ = {}));
    var XYZ = exports.XYZ;
});
//# sourceMappingURL=input_panel2.js.map
