/// <reference path="typings/backbone/backbone.d.ts" />
/// <reference path="typings/requirejs/require.d.ts" />
/// <reference path="typings/log4javascript/log4javascript.d.ts" />

"use strict";

//import mt = module("metatypes");
//import idc = module("input_data_collector");

//import psDerivation = module("ps_derivation"); psDerivation;
import ps_jquery_utils = require("ps_jquery_utils"); ps_jquery_utils;
import psweb_jquery_layout = require("psweb.jquery.layout"); psweb_jquery_layout;
import templateMgr = require("templateMgr"); templateMgr;
import stm = require("synthtree_model"); stm;

var log4javascript = require('log4javascript');
//
export class InputPanelView extends Backbone.View {
    tacticInputView: XYZ.TacticView;
    /**/logger: Log4Javascript;
    constructor(public psState: stm.PSState, options?) {
        super(options);
        /**/this.logger = log4javascript.getLogger("webapp.InputPanelView");
        /**/this.logger.trace("BeginSection(InputPanelView.constructor)");
        this.tagName = "div";
        this.tacticInputView = new XYZ.TacticView(new XYZ.TacticTV);;
        /**/this.logger.trace("EndSection(InputPanelView.constructor)");        
    }

    initialize() {
        /**///this.logger.trace("registered handler for click #applyTacticBtn in InputPanelView");
        this.events = {
            "click #applyTacticBtn": "onApplyTactic"
        };
    }

    render0() {
        var inputFormTpl = templateMgr.getTemplate("inputForm");
        var formElem = $(inputFormTpl());

        this.tacticInputView.render();
        var subEl = this.tacticInputView.el;

        var placeHolder = formElem.find(".placeholder.inputUI");
        placeHolder.replaceWith(subEl);

        this.$el.append(formElem);
        return this;
    }

    render() {
        /**/this.logger.trace("rendering InputPanelView...");
        var template: any[] =
            ["<form action=''></form>",
                [this.tacticInputView.render().el,
                    "<div class='button' id='applyTacticBtn'>Apply</div>",
                    "<div class='ApplyTacticError'></div>"
                ]
            ];
        XYZ.HtmlJasonUtils.json2JQuery(template);
        this.$el.append(XYZ.HtmlJasonUtils.json2JQuery(template));
        //(<any>this.$('mathquill-editable')).mathquill('editable');
        return this;
    }

    //render2() {
    //    var compositeVal = mt.compositeValDb["rootTactic"];
    //    var inputUI = compositeVal.mkDiv();
    //    var inputFormTemplate = templateMgr.getTemplate("inputForm");
    //    var formElem = inputFormTemplate({ "inputUI": inputUI });
    //    this.$el.append(formElem);
    //    return this;
    //}

    render3() {
        //render subview first
        this.tacticInputView = new XYZ.TacticView(new XYZ.TacticTV); // Remove from render.
        this.tacticInputView.render();

        //render this
        var inputFormTpl = templateMgr.getTemplate("inputForm");
        var formElem = inputFormTpl({ "inputUI": this.tacticInputView.$el[0].outerHTML });

        this.$el.append(formElem);
        return this;
    }

    onApplyTactic() {
        /**/this.logger.trace("InputPanelView.onApplyTactic");        
        /**/this.logger.trace("Updating values of InputPanelView.tacticInputView...");
        /**/this.logger.trace("Collecting input data...");
        this.tacticInputView.updateVal();
        var inputData = this.tacticInputView.tv;
        //add derivation name to inputData
        var derivName = window.location.pathname.replace(/^\/derivation\//, "");
        //inputData['derivName'] = derivName;
        //var inputData = idc.gatherInputData();
        /**/this.logger.trace("calling psState.applyTactic...");
        this.psState.applyTactic(inputData, derivName);
    }

    cleanup(event) {
        /**/this.logger.trace("cleaning up inputPanelView...");
        var $fieldValDiv = $(event.target).closest(".AbstractVal");
        $fieldValDiv.children('.CompositeVal').remove();
    }

    close() {
        /**/this.logger.trace("closing inputPanelView...");
    }
}

//////////////////////////////////////////////////////////////////////////
export module XYZ {
    module ClassRegistry {
        var tvNameTVMap = {};
        var logger = log4javascript.getLogger("webapp.ClassRegistry");

        export function registerClass(className: string, classFn: any) {
            tvNameTVMap[className] = classFn;
        }
        export function getClass(className: string): any {
            return tvNameTVMap[className];
        }

        export function createView(aTV: TV): PSView {
            //var clsName = Describer.getClassName(aTV);
            var clsName = aTV.tvName;
            var viewClsName = clsName.replace(/TV$/, "View");
            return new tvNameTVMap[viewClsName](aTV);
        }

        export function createViewFromTVName(tvName: string): PSView {
            var viewName = tvName.replace(/TV$/, "View");
            var tvClass = ClassRegistry.getClass(tvName);
            var viewClass = ClassRegistry.getClass(viewName);

            var tvClassObj = new tvClass();
            return new viewClass(tvClassObj);
        }

        export function registerTVs() {
            /**/logger.trace("registering TVs...");
            registerClass('EnumTV', EnumTV);
            registerClass('EnumView', EnumView);
            registerClass('PSTypeTV', PSTypeTV);
            registerClass('PSTypeView', PSTypeView);
            registerClass('NewVarTV', NewVarTV);
            registerClass('NewVarView', NewVarView);
            registerClass('FieldTV', FieldTV);
            registerClass('FieldView', FieldView);
            registerClass('IntegerTV', IntegerTV);
            registerClass('IntegerView', IntegerView);
            registerClass('StringTV', StringTV);
            registerClass('StringView', StringView);
            registerClass('TermView', TermView);
            registerClass('TermTV', TermTV);
            registerClass('VarView', VarView);
            registerClass('VarTV', VarTV);
            registerClass('FOLFormulaView', FOLFormulaView);
            registerClass('FOLFormulaTV', FOLFormulaTV);
            registerClass('TermBoolView', TermBoolView);
            registerClass('TermBoolTV', TermBoolTV);
            registerClass('InitView', InitView);
            registerClass('InitTV', InitTV);
            registerClass('StepIntoUnknownProgIdxView', StepIntoUnknownProgIdxView);
            registerClass('StepIntoUnknownProgIdxTV', StepIntoUnknownProgIdxTV);
            registerClass('RetValView', RetValView);
            registerClass('RetValTV', RetValTV);
            registerClass('RTVInPostView', RTVInPostView);
            registerClass('RTVInPostTV', RTVInPostTV);
            registerClass('DeleteConjunctView', DeleteConjunctView);
            registerClass('DeleteConjunctTV', DeleteConjunctTV);
            registerClass('StepOutView', StepOutView);
            registerClass('StepOutTV', StepOutTV);
            registerClass('SimplifyAutoTV', SimplifyAutoTV);
            registerClass('SimplifyAutoView', SimplifyAutoView);
            registerClass('SimplifyTV', SimplifyTV);
            registerClass('SimplifyView', SimplifyView);
            registerClass('ListView', ListView);
            registerClass('ListTV', ListTV);
            registerClass('TupleView', TupleView);
            registerClass('TupleTV', TupleTV);
            registerClass('AssumeAssignmentView', AssumeAssignmentView);
            registerClass('AssumeAssignmentTV', AssumeAssignmentTV);
            registerClass('Init4View', Init4View);
            registerClass('Init4TV', Init4TV);
            registerClass('MagicView', MagicView);
            registerClass('MagicTV', MagicTV);
            registerClass('StartIfDerivationView', StartIfDerivationView);
            registerClass('StartIfDerivationTV', StartIfDerivationTV);
            registerClass('GuessExprValuesView', GuessExprValuesView);
            registerClass('GuessExprValuesTV', GuessExprValuesTV);
            registerClass('VerifiedTransformationEquivView', VerifiedTransformationEquivView);
            registerClass('VerifiedTransformationEquivTV', VerifiedTransformationEquivTV);
            registerClass('GuessGuardView', GuessGuardView);
            registerClass('GuessGuardTV', GuessGuardTV);
            registerClass('StartGCmdDerivationView', StartGCmdDerivationView);
            registerClass('StartGCmdDerivationTV', StartGCmdDerivationTV);
            ///
            registerClass('DistributivityTV', DistributivityTV);
            registerClass('DistributivityView', DistributivityView);
            registerClass('EmptyRangeTV', EmptyRangeTV);
            registerClass('EmptyRangeView', EmptyRangeView);
            registerClass('OnePointTV', OnePointTV);
            registerClass('OnePointView', OnePointView);
            registerClass('QDistributivityTV', QDistributivityTV);
            registerClass('QDistributivityView', QDistributivityView);
            registerClass('RangeSplitTV', RangeSplitTV);
            registerClass('RangeSplitView', RangeSplitView);
            registerClass('ReplaceByEquivDisplayIdTV', ReplaceByEquivDisplayIdTV);
            registerClass('ReplaceByEquivDisplayIdView', ReplaceByEquivDisplayIdView);
            registerClass('StartAsgnDerivationTV', StartAsgnDerivationTV);
            registerClass('StartAsgnDerivationView', StartAsgnDerivationView);
            registerClass('StepIntoPOTV', StepIntoPOTV);
            registerClass('StepIntoPOView', StepIntoPOView);
            registerClass('StepIntoProgIdTV', StepIntoProgIdTV);
            registerClass('StepIntoProgIdView', StepIntoProgIdView);
            registerClass('StepIntoProgDisplayIdTV', StepIntoProgDisplayIdTV);
            registerClass('StepIntoProgDisplayIdView', StepIntoProgDisplayIdView);
            registerClass('StepIntoSubFormulaTV', StepIntoSubFormulaTV);
            registerClass('StepIntoSubFormulaView', StepIntoSubFormulaView);
            registerClass('StrengthenInvariantTV', StrengthenInvariantTV);
            registerClass('StrengthenInvariantView', StrengthenInvariantView);
            registerClass('TradingMoveToTermTV', TradingMoveToTermTV);
            registerClass('TradingMoveToTermView', TradingMoveToTermView);
            registerClass('UseAssumptionsTV', UseAssumptionsTV);
            registerClass('UseAssumptionsView', UseAssumptionsView);
            registerClass('Init3TV', Init3TV);
            registerClass('Init3View', Init3View);
            registerClass('IntroVariableTV', IntroVariableTV);
            registerClass('IntroVariableView', IntroVariableView);
        }
    }

    // TypedValue
    export class TV {
        tvName: string;
        constructor() {
            this.tvName = "TV";
        }
        clone(): TV {
            throw new Error("Abstract method clone not implemented in subclass of TV");
        }
        copyTo(arg: TV) {
            arg.tvName = this.tvName;
        }
    }

    export class AbstractTV extends TV {
        subTVNames: string[];
        concreteTV: TV;
        constructor(subTVs: string[]) {
            super();
            this.tvName = "AbstractTV";
            this.subTVNames = subTVs;
            this.concreteTV = undefined;
        }
        clone(): AbstractTV {
            var retVal = new AbstractTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: AbstractTV) {
            super.copyTo(arg);
            arg.subTVNames = this.subTVNames;
            arg.concreteTV = this.concreteTV.clone();
        }
    }

    export class NewVarTV extends TV {
        varNameTV: StringTV;
        varTypeTV: PSTypeTV;
        constructor(varNameTV, varTypeTV) {
            super();
            this.tvName = "NewVarTV";
            this.varNameTV = varNameTV;
            this.varTypeTV = varTypeTV;
        }
        clone(): NewVarTV {
            var retVal = new NewVarTV(undefined, undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: NewVarTV) {
            super.copyTo(arg);
            arg.varNameTV = this.varNameTV.clone();
            arg.varTypeTV = this.varTypeTV.clone();
        }
    }

    export class EnumTV extends TV {
        elements: string[];
        selectedElem: string;
        constructor(elements: string[], selectedElem: string) {
            super();
            this.tvName = "EnumTV";
            this.elements = elements;
            this.selectedElem = selectedElem;
        }
        clone(): EnumTV {
            var retVal = new EnumTV(undefined, undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: EnumTV) {
            super.copyTo(arg);
            arg.elements = this.elements;
            arg.selectedElem = this.selectedElem;
        }
    }

    export class PSTypeTV extends EnumTV {
        constructor(selectedElem: string) {
            super(['Int', 'Bool', 'ArrayInt', 'ArrayBool'], selectedElem);
            this.tvName = "PSTypeTV";
        }
        clone(): PSTypeTV {
            var retVal = new PSTypeTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: PSTypeTV) {
            super.copyTo(arg);
        }
    }

    export class ClassTV extends TV {
        fields: FieldTV[];
        constructor(fields: FieldTV[]) {
            super();
            this.tvName = "ClassTV";
            this.fields = fields;
        }
        clone(): ClassTV {
            var retVal = new ClassTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: ClassTV) {
            super.copyTo(arg);
            arg.fields = _.map(this.fields, (field) => field.clone());
        }

    }

    export class FieldTV extends TV {
        fname: string;
        ftv: TV;
        constructor(fname: string, ftv: TV) {
            super();
            this.tvName = "FieldTV"
            this.fname = fname;
            this.ftv = ftv;
        }
        clone(): FieldTV {
            var retVal = new FieldTV(undefined, undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: FieldTV) {
            super.copyTo(arg);
            arg.fname = this.fname;
            arg.ftv = this.ftv.clone();
        }
    }

    export class PrimitiveTV extends TV {
        value: any;
        constructor(value?: any) {
            super();
            this.tvName = "PrimitiveTV";
            this.value = value;
        }
        clone(): PrimitiveTV {
            var retVal = new PrimitiveTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: PrimitiveTV) {
            super.copyTo(arg);
            arg.value = this.value;
        }
    }

    //Basic Views 
    export interface Closable {
        close(): void;
    }
    export class PSView extends Backbone.View implements Closable {
        tv: TV;
        constructor(options?) {
            super(options);
        }
        close() { throw new Error("Abstract method close not implemented in subclass of PSView") }
        updateVal() { throw new Error("Abstract method updateVal not implemented in subclass of PSView") }
    }

    export class AbstractView extends PSView {
        tv: AbstractTV;
        concreteView: PSView;
        constructor(tv: AbstractTV, options?) {
            super(options);
            this.tv = tv;
            this.concreteView = undefined;
        }

        render() {
            this.$el.append("<div>AbstractView</div>");
            return this;
        }

        close() {
            if (this.concreteView) {
                this.concreteView.close();
            }
        }
        updateVal() {
            this.concreteView.updateVal();
        }
    }

    export class NewVarView extends PSView {
        tv: NewVarTV;
        varNameView: StringView;
        varTypeView: PSTypeView;
        constructor(tv: NewVarTV, options?) {
            super(options);
            this.tv = tv;
            this.populateViews();
        }
        populateViews() {
            this.varNameView = <StringView>ClassRegistry.createView(this.tv.varNameTV);
            this.varTypeView = <PSTypeView>ClassRegistry.createView(this.tv.varTypeTV);
        }

        render() {
            this.varNameView.render();
            this.varTypeView.render();
            var jsonEle: any[] =
                ['<div class = "NewVarTV"> </div>',
                    [this.varNameView.el,
                    '<div> : </div>',
                     this.varTypeView.el]];

            this.$el.append(HtmlJasonUtils.json2JQuery(jsonEle));
            return this;
        }

        close() {
            this.varTypeView.close();
        }
        updateVal() {
            this.varNameView.updateVal();
            this.varTypeView.updateVal();
        }
    }

    export class EnumView extends PSView {
        tv: EnumTV;

        constructor(tv: EnumTV, options?) {
            super(options);
            this.tv = tv;
        }

        render() {
            var template = templateMgr.getTemplate("enumView");
            var comboBoxDiv = $(template({ 'elements': this.tv.elements }));
            this.$el.append(comboBoxDiv);
            return this;
        }

        close() {
        }
        updateVal() {
            this.tv.selectedElem = this.$el.find("option:selected").val();
        }
    }

    export class PSTypeView extends EnumView {
    }

    export class ClassView extends PSView {
        tv: ClassTV;
        fieldViews: FieldView[];
        constructor(tv: ClassTV, options?) {
            super(options);
            this.tv = tv;
            this.fieldViews = [];
            this.populateFieldViews();
        }

        populateFieldViews() {
            _.forEach(this.tv.fields, (field) => {
                var fv = ClassRegistry.createView(field);
                this.fieldViews.push(<FieldView>fv);
            });
        }

        render() {
            this.$el.empty();
            var elem = $('<table border = "1" ></table>');
            _.forEach(this.fieldViews, (fv: FieldView) => {
                //children().first() strips the root .div node
                var fieldDiv = fv.render().$el;
                elem.append(fieldDiv.children().first());
            });
            this.$el.append(elem);
            return this;
        }

        close() {
            //_.each(this.fieldViews, function (fv) {
            //    fv.close();
            //});
        }
        updateVal() {
            this.fieldViews.forEach(fv => { fv.updateVal() });
        }
    }

    export class ListView extends PSView {
        tv: ListTV;
        itemViews: PSView[];
        template: any[];

        constructor(tv: ListTV, options?) {
            super(options);
            this.tv = tv;
            this.template =
                ["<div class = 'listVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
            this.itemViews = [];
            this.populateItemViews();
        }
        populateItemViews() {
            //Why to clone: the updateval directly picks up data from the objects 
            //associated with the views. Hence we need a new object.
            if (this.tv.items.length == 0) {
                //jQuery extend does not work.
                //var clonedTpe = <TV>jQuery.extend(true, {}, this.tv.itv);
                var clonedTpe = this.tv.metaTV.clone();
                this.tv.items.push(clonedTpe);
                var clonedTpe2 = this.tv.metaTV.clone();
                this.tv.items.push(clonedTpe2);
                var clonedTpe3 = this.tv.metaTV.clone();
                this.tv.items.push(clonedTpe3);
                var clonedTpe4 = this.tv.metaTV.clone();
                this.tv.items.push(clonedTpe4);
            }
            _.forEach(this.tv.items, (item: TV) => {
                var fv = ClassRegistry.createView(item);
                this.itemViews.push(<PSView>fv);
            });
        }
        render() {
            this.$el.empty();
            var elem = $('<table border = "1" ></table>');
            _.forEach(this.itemViews, (iv: PSView) => {
                elem.append($("<tr></tr>").append($("<td></td>").append(iv.render().el)));
            });
            this.$el.append(elem);
            return this;
        }

        updateVal() {
            this.itemViews.forEach(fv => { fv.updateVal() });
        }
    }

    export class TupleView extends PSView {
        tv: TupleTV;
        view1: PSView;
        view2: PSView;
        template: any[];

        constructor(tv: TupleTV, options?) {
            super(options);
            this.tv = tv;
            this.template =
                ["<div class = 'listVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
            this.view1 = ClassRegistry.createView(tv.item1);
            this.view2 = ClassRegistry.createView(tv.item2);
        }
        render() {
            this.$el.empty();
            var elem = $("<div class='tupleview'></div>");
            elem.append(this.view1.render().el);
            elem.append(this.view2.render().el);
            this.$el.append(elem);
            return this;
        }

        updateVal() {
            this.view1.updateVal();
            this.view2.updateVal();
        }
    }

    export class FieldView extends PSView {
        tv: FieldTV;
        rhsView: PSView;
        constructor(tv: FieldTV, options?) {
            super(options);
            this.tv = tv;
            this.rhsView = ClassRegistry.createView(this.tv.ftv);
        }

        renderWithTr() {
            //Add in constructor : this.tagName = "tr";
            this.$el.empty();
            this.$el.addClass("fieldDiv");
            this.$el.append("<td>" + this.tv.fname + "</td>");
            this.$el.append("<td>" + "=" + "</td>");
            this.$el.append($("<td></td>").append(this.rhsView.render().el));
            return this;
        }

        render() {
            this.$el.empty();
            this.$el.addClass("fieldDiv");
            var rowElem = $("<tr></tr>");
            rowElem.append("<td>" + this.tv.fname + "</td>");
            rowElem.append("<td>" + "=" + "</td>");
            rowElem.append($("<td></td>").append(this.rhsView.render().el));
            this.$el.append(rowElem);
            return this;
        }

        //using template
        render2() {
            var fieldName = this.tv.tvName;
            var rhsTV = this.tv.ftv;
            var fv = ClassRegistry.createView(rhsTV);

            var fieldValTpl = templateMgr.getTemplate("fieldVal");
            var fieldValElem = $(fieldValTpl({ ftv: rhsTV, fname: fieldName }));
            fieldValElem.find(".placeholder.fieldTVDiv").replaceWith(fv.render().el);

            this.$el.append(fieldValElem);
            return this;
        }

        updateVal() {
            this.rhsView.updateVal();
        }
    }

    export class PrimitiveView extends PSView {
        tv: PrimitiveTV;
        constructor(tv: PrimitiveTV, options?) {
            super(options);
            this.tv = tv;
        }
    }

    //Utils
    class Describer {
        static getClassName(inputObj) {
            var funcNameRegex = /function (.{1,})\(/;
            var results = (funcNameRegex).exec((<any> inputObj).constructor.toString());
            return (results && results.length > 1) ? results[1] : "";
        }
    }

    module ViewFactory {
        export function createView(aTV: TV): Backbone.View {
            var clsName = Describer.getClassName(aTV);
            var retTV: Backbone.View = undefined;
            if (clsName === 'StepIntoUnknownProgIdxTV') {
                retTV = new StepIntoUnknownProgIdxView(<StepIntoUnknownProgIdxTV>aTV);
            } else if (clsName === 'PrimitiveTV') {
                retTV = new PrimitiveView(<PrimitiveTV>aTV);
            } else if (clsName === 'IntegerTV') {
                retTV = new IntegerView(<IntegerTV>aTV);
            }
            return retTV;
        }
    }

    export module HtmlJasonUtils {
        function json2JqueryI(json: any[]): JQuery {
            var node = json[0];
            var $node = json2JqueryL(node);
            var childs = json[1];
            _.forEach(childs, (child) => {
                var $child = json2JQuery(child);
                $node.append($child);
            });
            return $node;
        }

        function json2JqueryL(obj: any): JQuery {
            if (obj instanceof jQuery) {
                return obj;
            } else {
                return $(obj);
            }
        }

        export function json2JQuery(obj): JQuery {
            if ($.isArray(obj)) {
                return json2JqueryI(obj);
            } else {
                return json2JqueryL(obj);
            }
        }
    }

    //User TVs
    export class IntegerTV extends PrimitiveTV {
        value: number;
        constructor(value?: number) {
            super(value);
            this.tvName = "IntegerTV";
            this.value = value;
        }
        clone(): IntegerTV {
            var retVal = new IntegerTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: IntegerTV) {
            super.copyTo(arg);
            arg.value = this.value;
        }
    }

    export class StringTV extends PrimitiveTV {
        value: string;
        constructor(value?: string) {
            super(value);
            this.tvName = "StringTV";
            this.value = value;
        }
        clone(): StringTV {
            var retVal = new StringTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: StringTV) {
            super.copyTo(arg);
            arg.value = this.value;
        }
    }

    export class TermTV extends PrimitiveTV {
        value: string;
        constructor(value?: string) {
            super(value);
            this.tvName = "TermTV";
            this.value = value;
        }
        clone(): TermTV {
            var retVal = new TermTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: TermTV) {
            super.copyTo(arg);
            arg.value = this.value;
        }
    }

    export class VarTV extends PrimitiveTV {
        value: string;
        constructor(value?: string) {
            super(value);
            this.tvName = "VarTV";
            this.value = value;
        }
        clone(): VarTV {
            var retVal = new VarTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: VarTV) {
            super.copyTo(arg);
            arg.value = this.value;
        }
    }

    //export class NewVarType extends Type {
    //    varName: string;
    //    varType: PSType;
    //    constructor(varName) {
    //        super("NewVarType");
    //    }
    //    clone(): NewVarType {
    //        var retVal = new NewVarType();
    //        this.copyTo(retVal);
    //        return retVal;
    //    }
    //    copyTo(arg: NewVarType) {
    //        super.copyTo(arg);
    //    }
    //}

    export class FOLFormulaTV extends PrimitiveTV {
        value: string;
        constructor(value?: string) {
            super(value);
            this.tvName = "FOLFormulaTV";
            this.value = value;
        }
        clone(): FOLFormulaTV {
            var retVal = new FOLFormulaTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: FOLFormulaTV) {
            super.copyTo(arg);
            arg.value = this.value;
        }
    }

    export class TermBoolTV extends PrimitiveTV {
        value: string;
        constructor(value?: string) {
            super(value);
            this.tvName = "TermBoolTV";
            this.value = value;
        }
        clone(): TermBoolTV {
            var retVal = new TermBoolTV(undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: TermBoolTV) {
            super.copyTo(arg);
            arg.value = this.value;
        }
    }

    export class ListTV extends TV {
        metaTV: TV; //meta tv
        items: TV[];
        //TODO: make the val argument optional.        
        ////ListTV constructor can not be optional
        ////An empty list must be able to render itself.
        constructor(itv: TV, items: TV[]) {
            super();
            this.tvName = "ListTV";
            this.metaTV = itv;
            this.items = items;
        }
        clone(): ListTV {
            var retVal = new ListTV(undefined, undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: ListTV) {
            super.copyTo(arg);
            arg.metaTV = this.metaTV.clone();
            arg.items = _.map(this.items, (item) => item.clone());
        }
    }

    export class TupleTV extends TV {
        item1: TV;
        item2: TV;
        constructor(val1: TV, val2: TV) {
            super();
            this.tvName = "TupleTV";
            this.item1 = val1;
            this.item2 = val2;
        }
        clone(): TupleTV {
            var retVal = new TupleTV(undefined, undefined);
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: TupleTV) {
            super.copyTo(arg);
            arg.item1 = this.item1.clone();
            arg.item2 = this.item2.clone();
        }
    }

    export class StepIntoUnknownProgIdxTV extends ClassTV {
        idx: number;
        constructor(idx?: number) {
            var idxField = new FieldTV('idx', new IntegerTV(idx))
            var fields: FieldTV[] = [idxField];
            super(fields);
            this.tvName = "StepIntoUnknownProgIdxTV";
            this.idx = idx;
        }
        clone(): StepIntoUnknownProgIdxTV {
            var retVal = new StepIntoUnknownProgIdxTV();
            this.copyTo(retVal);
            return retVal;
        }
        copyTo(arg: StepIntoUnknownProgIdxTV) {
            super.copyTo(arg);
            arg.idx = this.idx;
        }
    }

    //InitTactic(name: String, params: List[Var], retVar: Var, preF: FOLFormula, postF: FOLFormula) 
    export class InitTV extends ClassTV {
        constructor(name: string, params: string[], retVar: string, preF: string, postF: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('name', new StringTV(name)));
            var newVarTVList = _.map(params, param => { new NewVarTV(new StringTV(param), new PSTypeTV(undefined)) });
            fields.push(new FieldTV('params', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarTVList)));
            fields.push(new FieldTV('retVar', new NewVarTV(new StringTV(name), new PSTypeTV(undefined))));
            fields.push(new FieldTV('preF', new TermBoolTV(name)));
            fields.push(new FieldTV('postF', new TermBoolTV(name)));
            super(fields);
            this.tvName = "InitTV";
        }
    }

    export class RetValTV extends ClassTV {
        constructor(initTerm: string) {
            var initTermF = new FieldTV('initTerm', new TermTV(initTerm));
            var fields: FieldTV[] = [initTermF];
            super(fields);
            this.tvName = "RetValTV";
        }
    }

    export class DeleteConjunctTV extends ClassTV {
        //conjunct: FOLFormula, variant: Term
        constructor(conjunct: string, variant: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('conjunct', new TermBoolTV(conjunct)));
            fields.push(new FieldTV('variant', new TermTV(variant)));
            super(fields);
            this.tvName = "DeleteConjunctTV";
        }
    }

    //AssumeAssignmentTactic(lhsRhsTuples:List[(Var, Term)]) extends FunTactic {
    export class AssumeAssignmentTV extends ClassTV {
        constructor(lhsRhsTuples: string[][]) {
            var fields: FieldTV[] = [];
            var tupleTVList = _.map(lhsRhsTuples,
                function (tuple) {
                    var tv1 = new VarTV(tuple[0]);
                    var tv2 = new TermTV(tuple[1]);
                    new TupleTV(tv1, tv2);
                });

            fields.push(new FieldTV('lhsRhsTuples', new ListTV(new TupleTV(new VarTV(), new TermTV()), tupleTVList)));
            super(fields);
            this.tvName = "AssumeAssignmentTV";
        }
    }

    //Init4Tactic(name: String, mutableVars: List[Var], immutableVars: List[Var],
    //	preF: TermBool, postF: TermBool, globalInvs: List[TermBool])
    export class Init4TV extends ClassTV {
        constructor(name: string, mutableVars: string[], immutableVars: string[], preF: string, postF: string, globalInvs: string[]) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('name', new StringTV(name)));
            var newVarMutableTVList = _.map(mutableVars, mutableVar => { new NewVarTV(new StringTV(mutableVar), new PSTypeTV(undefined)) });
            var newVarImmutableTVList = _.map(immutableVars, immutableVar => { new NewVarTV(new StringTV(immutableVar), new PSTypeTV(undefined)) });
            fields.push(new FieldTV('mutableVars', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarMutableTVList)));
            fields.push(new FieldTV('immutableVars', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarImmutableTVList)));            
            fields.push(new FieldTV('preF', new TermBoolTV(preF)));
            fields.push(new FieldTV('postF', new TermBoolTV(postF)));
            var globalInvsTVList = _.map(globalInvs, x => { new TermBoolTV(x) });
            fields.push(new FieldTV('globalInvs', new ListTV(new TermBoolTV(""), globalInvsTVList)));
            super(fields);
            this.tvName = "Init4TV";
        }
    }

    export class StartIfDerivationTV extends ClassTV {
        constructor( lhsVars: string[]) {
            var fields: FieldTV[] = [];
            var varTVList = _.map(lhsVars, lVar=> { new VarTV(lVar) });
            fields.push(new FieldTV('lhsVars', new ListTV(new VarTV(""), varTVList)));
            super(fields);
            this.tvName = "StartIfDerivationTV";
        }
    }

    export class GuessExprValuesTV extends ClassTV {
        constructor(primedVarTermList: string[][]) {
            var fields: FieldTV[] = [];
            var tupleTVList = _.map(primedVarTermList,
                function (tuple) {
                    var tv1 = new StringTV(tuple[0]);//The metavariable is passed as normal string tv.
                    var tv2 = new TermTV(tuple[1]);
                    new TupleTV(tv1, tv2);
                });

            fields.push(new FieldTV('primedVarTermList', new ListTV(new TupleTV(new StringTV(), new TermTV()), tupleTVList)));
            super(fields);
            this.tvName = "GuessExprValuesTV";
        }
    }

    export class VerifiedTransformationEquivTV extends ClassTV {
        constructor(newFormula: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('newFormula', new TermBoolTV(newFormula)));
            super(fields);
            this.tvName = "VerifiedTransformationEquivTV";
        }
    }


    export class GuessGuardTV extends ClassTV {
        constructor(guard: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('guard', new TermBoolTV(guard)));
            super(fields);
            this.tvName = "GuessGuardTV";
        }
    }


    export class StartGCmdDerivationTV extends ClassTV {
        constructor(guard: string) {
            var fields: FieldTV[] = [];
            super(fields);
            this.tvName = "StartGCmdDerivationTV";
        }
    }


    export class MagicTV extends ClassTV {
        constructor(vars: string[], newF: string) {
            var fields: FieldTV[] = [];
            var newVarTVList = _.map(vars, aVar => { new NewVarTV(new StringTV(aVar), new PSTypeTV(undefined)) });
            fields.push(new FieldTV('vars', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), newVarTVList)));
            fields.push(new FieldTV('newF', new TermBoolTV(name)));
            super(fields);
            this.tvName = "MagicTV";
        }
    }

    export class StepOutTV extends ClassTV {
        constructor() {
            var fields: FieldTV[] = [];
            super(fields);
            this.tvName = "StepOutTV";
        }
    }

    export class SimplifyAutoTV extends ClassTV {
        constructor() {
            var fields: FieldTV[] = [];
            super(fields);
            this.tvName = "SimplifyAutoTV";
        }
    }

    export class SimplifyTV extends ClassTV {
        constructor() {
            var fields: FieldTV[] = [];
            super(fields);
            this.tvName = "SimplifyTV";
        }
    }

    export class RTVInPostTV extends ClassTV {
        constructor(constant: string, variable: string, initValue: string, bounds: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('constant', new TermTV(constant)));
            fields.push(new FieldTV('variable', new NewVarTV(new StringTV(variable), new PSTypeTV(undefined))));
            //fields.push(new FieldTV('variable', new VarTV(variable)));
            fields.push(new FieldTV('initValue', new TermTV(initValue)));
            fields.push(new FieldTV('bounds', new TermBoolTV(bounds)));

            super(fields);
            this.tvName = "RTVInPostTV";
        }
    }
///////////////////////////////////////////////

    export class DistributivityTV extends ClassTV {
        constructor(displayId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
            super(fields);
            this.tvName = "DistributivityTV";
        }
    }


    export class EmptyRangeTV extends ClassTV {
        constructor(displayId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
            super(fields);
            this.tvName = "EmptyRangeTV";
        }
    }


    export class OnePointTV extends ClassTV {
        constructor(displayId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
            super(fields);
            this.tvName = "OnePointTV";
        }
    }

    export class QDistributivityTV extends ClassTV {
        constructor(displayId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
            super(fields);
            this.tvName = "QDistributivityTV";
        }
    }


    export class RangeSplitTV extends ClassTV {
        constructor(displayId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
            super(fields);
            this.tvName = "RangeSplitTV";
        }
    }


    export class ReplaceByEquivDisplayIdTV extends ClassTV {
        constructor(oldSubFId: number, newSubF: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('oldSubFId', new IntegerTV(oldSubFId)));
            fields.push(new FieldTV('newSubF', new TermBoolTV(newSubF)));
            super(fields);
            this.tvName = "ReplaceByEquivDisplayIdTV";
        }
    }


    export class StartAsgnDerivationTV extends ClassTV {
        constructor(lhsVars: string[]) {
            var fields: FieldTV[] = [];
            var lhsVarsTVList = _.map(lhsVars, x => { new VarTV(x) });
            fields.push(new FieldTV('lhsVars', new ListTV(new VarTV(""), lhsVarsTVList)));
            super(fields);
            this.tvName = "StartAsgnDerivationTV";
        }
    }


    export class StepIntoPOTV extends ClassTV {
        constructor() {
            var fields: FieldTV[] = [];

            super(fields);
            this.tvName = "StepIntoPOTV";
        }
    }


    export class StepIntoProgIdTV extends ClassTV {
        constructor(id: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('id', new IntegerTV(id)));
            super(fields);
            this.tvName = "StepIntoProgIdTV";
        }
    }

    export class StepIntoProgDisplayIdTV extends ClassTV {
        constructor(displayId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
            super(fields);
            this.tvName = "StepIntoProgDisplayIdTV";
        }
    }



    export class StepIntoSubFormulaTV extends ClassTV {
        constructor(subId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('subId', new IntegerTV(subId)));
            super(fields);
            this.tvName = "StepIntoSubFormulaTV";
        }
    }


    export class StrengthenInvariantTV extends ClassTV {
        constructor(newInvs: string[]) {
            var fields: FieldTV[] = [];
            var newInvsTVList = _.map(newInvs, x => { new TermBoolTV(x) });
            fields.push(new FieldTV('newInvs', new ListTV(new TermBoolTV(""), newInvsTVList)));
            super(fields);
            this.tvName = "StrengthenInvariantTV";
        }
    }


    export class TradingMoveToTermTV extends ClassTV {
        constructor(displayId: number, termToBeMovedId: number) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('displayId', new IntegerTV(displayId)));
            fields.push(new FieldTV('termToBeMovedId', new IntegerTV(termToBeMovedId)));
            super(fields);
            this.tvName = "TradingMoveToTermTV";
        }
    }


    export class UseAssumptionsTV extends ClassTV {
        constructor(subFormulaId: number, newSubF: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('subFormulaId', new IntegerTV(subFormulaId)));
            fields.push(new FieldTV('newSubF', new TermBoolTV(newSubF)));
            super(fields);
            this.tvName = "UseAssumptionsTV";
        }
    }


    export class Init3TV extends ClassTV {
        constructor(name: string, params: string[], retVar: string, preF: string, postF: string, globalInvs: string[]) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('name', new StringTV(name)));
            var paramsTVList = _.map(params, x => { new NewVarTV(new StringTV(x), new PSTypeTV(undefined)) });
            fields.push(new FieldTV('params', new ListTV(new NewVarTV(new StringTV(""), new PSTypeTV(undefined)), paramsTVList)));
            fields.push(new FieldTV('retVar', new NewVarTV(new StringTV(retVar), new PSTypeTV(undefined))));
            fields.push(new FieldTV('preF', new TermBoolTV(preF)));
            fields.push(new FieldTV('postF', new TermBoolTV(postF)));
            var globalInvsTVList = _.map(globalInvs, x => { new TermBoolTV(x) });
            fields.push(new FieldTV('globalInvs', new ListTV(new TermBoolTV(""), globalInvsTVList)));
            super(fields);
            this.tvName = "Init3TV";
        }
    }

    export class IntroVariableTV extends ClassTV {
        constructor(aVar: string, initVal: string) {
            var fields: FieldTV[] = [];
            fields.push(new FieldTV('aVar', new NewVarTV(new StringTV(aVar), new PSTypeTV(undefined))));
            fields.push(new FieldTV('initVal', new TermTV(initVal)));
            super(fields);
            this.tvName = "IntroVariableTV";
        }
    }

/////////////////////////////////////////////////////////////////////////////////////
    export class TacticTV extends AbstractTV {
        constructor() {
            var subTVNames = ["StepIntoUnknownProgIdxTV", "StepIntoUnknownProgIdTV",
                "RetValTV", "RTVInPost", "DeleteConjunct", "Init", "StepOut", "SimplifyAuto", "Simplify", "AssumeAssignment", "Init4", "Magic",
            "StartIfDerivation", "GuessExprValues", "VerifiedTransformationEquiv", "GuessGuard", "StartGCmdDerivation",
            'Distributivity', 'EmptyRange','OnePoint','QDistributivity','RangeSplit','ReplaceByEquivDisplayId',
                'StartAsgnDerivation', 'StepIntoPO', 'StepIntoProgId', 'StepIntoProgDisplayId','StepIntoSubFormula','StrengthenInvariant',
            'TradingMoveToTerm', 'UseAssumptions', 'Init3', 'IntroVariable'].sort();
            super(subTVNames);
            this.tvName = "TacticTV";
        }
    }

    //User Views    
    export class IntegerView extends PrimitiveView {
        tv: IntegerTV;
        template: any[];

        constructor(tv: IntegerTV, options?) {
            super(tv, options);
            this.tv = tv;
            this.template =
                ["<div class = 'primitiveVal'> </div>",
                    ["<input name = 'data' />"]
                ];
        }

        render() {
            this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
            return this;
        }
        updateVal() {
            this.tv.value = this.$("input").val();
        }
    }

    export class StringView extends PrimitiveView {
        tv: StringTV;
        template: any[];

        constructor(tv: StringTV, options?) {
            super(tv, options);
            this.tv = tv;
            this.template =
                ["<div class = 'primitiveVal'> </div>",
                    ["<input name = 'data' />"]
                ];
        }

        render() {
            this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
            return this;
        }
        updateVal() {
            this.tv.value = this.$("input").val();
        }
    }

    export class TermView extends PrimitiveView {
        tv: TermTV;
        template: any[];

        constructor(tv: TermTV, options?) {
            super(tv, options);
            this.tv = tv;
            this.template =
                ["<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
        }

        render() {
            this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
            (<any>this.$('.mathquill-editable')).mathquill('editable');
            return this;
        }
        updateVal() {
            this.tv.value = (<any>this.$(".mathquill-editable")).mathquill('latex');;
        }
    }

    export class VarView extends PrimitiveView {
        tv: VarTV;
        template: any[];

        constructor(tv: VarTV, options?) {
            super(tv, options);
            this.tv = tv;
            this.template =
                ["<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
        }

        render() {
            this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
            (<any>this.$('.mathquill-editable')).mathquill('editable');
            return this;
        }
        updateVal() {
            this.tv.value = (<any>this.$(".mathquill-editable")).mathquill('latex');;
        }
    }

    export class FOLFormulaView extends PrimitiveView {
        tv: FOLFormulaTV;
        template: any[];

        constructor(tv: FOLFormulaTV, options?) {
            super(tv, options);
            this.tv = tv;
            this.template =
                ["<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
        }

        render() {
            this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
            (<any>this.$('.mathquill-editable')).mathquill('editable');
            return this;
        }
        updateVal() {
            this.tv.value = (<any>this.$(".mathquill-editable")).mathquill('latex');;
        }
    }

    export class TermBoolView extends PrimitiveView {
        tv: TermBoolTV;
        template: any[];

        constructor(tv: TermBoolTV, options?) {
            super(tv, options);
            this.tv = tv;
            this.template =
                ["<div class = 'primitiveVal'> </div>",
                    ["<span class='mathquill-editable'></span>"]
                ];
        }

        render() {
            this.$el.append(HtmlJasonUtils.json2JQuery(this.template));
            (<any>this.$('.mathquill-editable')).mathquill('editable');
            return this;
        }
        updateVal() {
            this.tv.value = (<any>this.$(".mathquill-editable")).mathquill('latex');;
        }
    }

    export class StepIntoUnknownProgIdxView extends ClassView {
        tv: StepIntoUnknownProgIdxTV;
        constructor(tv: StepIntoUnknownProgIdxTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class RTVInPostView extends ClassView {
        tv: RTVInPostTV;
        constructor(tv: RTVInPostTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class RetValView extends ClassView {
        tv: RetValTV;
        constructor(tv: RetValTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class InitView extends ClassView {
        tv: InitTV;
        constructor(tv: InitTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class Init4View extends ClassView {
        tv: Init4TV;
        constructor(tv: Init4TV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }


    export class StartIfDerivationView extends ClassView {
        tv: StartIfDerivationTV;
        constructor(tv: StartIfDerivationTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class GuessExprValuesView extends ClassView {
        tv: GuessExprValuesTV;
        constructor(tv: GuessExprValuesTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class VerifiedTransformationEquivView extends ClassView {
        tv: VerifiedTransformationEquivTV;
        constructor(tv: VerifiedTransformationEquivTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class GuessGuardView extends ClassView {
        tv: GuessGuardTV;
        constructor(tv: GuessGuardTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class StartGCmdDerivationView extends ClassView {
        tv: StartGCmdDerivationTV;
        constructor(tv: StartGCmdDerivationTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class MagicView extends ClassView {
        tv: MagicTV;
        constructor(tv: MagicTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class DeleteConjunctView extends ClassView {
        tv: DeleteConjunctTV;
        constructor(tv: DeleteConjunctTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class AssumeAssignmentView extends ClassView {
        tv: AssumeAssignmentTV;
        constructor(tv: AssumeAssignmentTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class StepOutView extends ClassView {
        tv: StepOutTV;
        constructor(tv: StepOutTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class SimplifyAutoView extends ClassView {
        tv: SimplifyAutoTV;
        constructor(tv: SimplifyAutoTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }

    export class SimplifyView extends ClassView {
        tv: SimplifyTV;
        constructor(tv: SimplifyTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
        }
    }
///////////////////////////
    export class DistributivityView extends ClassView {
        tv: DistributivityTV;
        constructor(tv: DistributivityTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class EmptyRangeView extends ClassView {
        tv: EmptyRangeTV;
        constructor(tv: EmptyRangeTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class OnePointView extends ClassView {
        tv: OnePointTV;
        constructor(tv: OnePointTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class QDistributivityView extends ClassView {
        tv: QDistributivityTV;
        constructor(tv: QDistributivityTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class RangeSplitView extends ClassView {
        tv: RangeSplitTV;
        constructor(tv: RangeSplitTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class ReplaceByEquivDisplayIdView extends ClassView {
        tv: ReplaceByEquivDisplayIdTV;
        constructor(tv: ReplaceByEquivDisplayIdTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class StartAsgnDerivationView extends ClassView {
        tv: StartAsgnDerivationTV;
        constructor(tv: StartAsgnDerivationTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }
    //
    export class StepIntoPOView extends ClassView {
        tv: StepIntoPOTV;
        constructor(tv: StepIntoPOTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class StepIntoProgIdView extends ClassView {
        tv: StepIntoProgIdTV;
        constructor(tv: StepIntoProgIdTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class StepIntoProgDisplayIdView extends ClassView {
        tv: StepIntoProgDisplayIdTV;
        constructor(tv: StepIntoProgDisplayIdTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class StepIntoSubFormulaView extends ClassView {
        tv: StepIntoSubFormulaTV;
        constructor(tv: StepIntoSubFormulaTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class StrengthenInvariantView extends ClassView {
        tv: StrengthenInvariantTV;
        constructor(tv: StrengthenInvariantTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class TradingMoveToTermView extends ClassView {
        tv: TradingMoveToTermTV;
        constructor(tv: TradingMoveToTermTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class UseAssumptionsView extends ClassView {
        tv: UseAssumptionsTV;
        constructor(tv: UseAssumptionsTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class Init3View extends ClassView {
        tv: Init3TV;
        constructor(tv: Init3TV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }

    export class IntroVariableView extends ClassView {
        tv: IntroVariableTV;
        constructor(tv: IntroVariableTV, options?) {
            super(tv, options);
            this.tv = tv;
        }
        updateVal() {
            super.updateVal();
            //this.tv.idx = (<IntegerTV>this.tv.fields[0].ftv).value
        }
    }
///////////////////////////
    export class TacticView extends AbstractView {
        tv: TacticTV;
        /**/logger: Log4Javascript;

        initialize() {
            if ((<any>this).jel) {
                this.el = (<any>this).jel.get();
            }
            /**///this.logger.trace("TacticView: registering handler for change .inputPanelTVCombo");
            this.events = {
                "change .inputPanelTVCombo": "onComboSelect"
            }
        }

        constructor(tv: TacticTV, options?) {
            super(tv, options);
            /**/this.logger = log4javascript.getLogger("webapp.TacticView");
            this.tv = tv;
            this.concreteView = undefined;
        }

        render() {
            /**/this.logger.trace("Rendering TacticView ...");
            this.$el.empty();
            var tacticTVs = _.map(this.tv.subTVNames, (st) => { return st.replace(/TV$/, "") });
            var subViewDiv = '';
            if (this.concreteView) {
                subViewDiv = this.concreteView.render().el;
            }
            var template = templateMgr.getTemplate("abstractVal");
            var comboBoxDiv = template({
                'subTVs': tacticTVs,
                'absTVName': this.tv.tvName.replace(/TV$/, ""),
                'concreteDiv': subViewDiv
            });
            this.$el.append(comboBoxDiv);
            return this;
        }

        onComboSelect(event) {
            /**/this.logger.trace("TacticView.onComboSelect called");
            console.log("Tactic::onComboSelect");
            this.$('.selectedSubTV').empty();
            var tacticName = $(event.target).find("option:selected").val();
            this.concreteView = ClassRegistry.createViewFromTVName(tacticName + 'TV');;
            this.tv.concreteTV = this.concreteView.tv;
            this.$('.selectedSubTV').append(this.concreteView.render().el);
            (<any>this.$('.mathquill-editable')).mathquill('redraw');
            //Clear Errors
            $(".ApplyTacticError").html("");
        }
    }

    ClassRegistry.registerTVs();
}
