define(function (require) {
	"use strict";
	//var $ = jQuery = require("jquery-1.7.1.min");
	//var psDerivation = require("ps_derivation");
	require("lib/backbone");
	var psJqueryUtils = require("ps_jquery_utils");
	var pswebJqueryLayout = require("psweb.jquery.layout");
	var mathquill = require("lib/mathquill/mathquill");
	var jqueryHotkeys = require("lib/jquery.hotkeys");
	var jqueryUi = require("lib/jquery-ui-1.10.0.custom");
	var hydrateMod = require("lib/Hydrate");
	var mt = require("metatypes");
	var idc = require("input_data_collector");
	require("lib/handlebars");
	var templateMgr = require("templateMgr");
	
	var InputPanelView = Backbone.View.extend({

		initialize: function() {
			//initialize	
		},
		
		events : {
			"change .inputPanelTypeCombo" : "onComboSelect",
			"click #applyTacticBtn" : "onApplyTactic"
		},
		
		render: function() {
			var compositeVal = mt.compositeValDb["rootTactic"];
			var inputUI = compositeVal.mkDiv();
			
			var inputFormTemplate = templateMgr.getTemplate("inputForm");
			var formElem = inputFormTemplate({"inputUI": inputUI});
			this.$el.append(formElem);
			
			return this;
		},
		
		onComboSelect: function(event) {
			var ctype = $(".inputPanelTypeCombo option:selected").val();
			console.debug("ctype: " + ctype );
			console.debug(event);
			
			var $fieldValDiv = $(event.target).closest(".AbstractVal");
			$fieldValDiv.children('.CompositeVal').remove();
			var typeObj = mt.getType(ctype);
			var inputUI = mt.mkTypeDiv(typeObj);
			$fieldValDiv.append(inputUI);
			$('.mathquill-editable').mathquill('editable');			
		},
		
		onApplyTactic: function() {
			console.debug("onApplyTactic called");
			var inputData = idc.gatherInputData();
			//var hydrate = new Hydrate();
			console.log("gatherInputData returned : "); 
			console.dir(inputData);
			//$(".inputPanel").append("<div class='Hydrate'>" + hydrate.stringify(inputData) + "</div>");
			
			console.debug("sending post request to server...");

			$.ajax({
			    url: 'applyTactic',
			    type: 'POST',
			    //data: JSON.stringify(inputData),
			    data: JSON.stringify(inputData),
			    contentType: 'application/json; charset=utf-8',
			    dataType: 'html',
			    //async: false,
			    success: $.proxy(this.tacticResponseHandler, this) //jquery way of binding the proper context to the event handler.
			});
			
			return false;			
		},
		
		tacticResponseHandler: function(nodeDiv) {
			var $nodeDiv = $(nodeDiv);
			var psDerivation = require("ps_derivation");
			
			var curNodeId = $.trim($(".curNodeId").text());
			var newCurNodeId = this._getNodeId($nodeDiv);
			
			if(curNodeId != newCurNodeId) {
				//get current node
				var curNode = this._getNodeFromId(curNodeId);
				//add new node div to current node.
				curNode.append($nodeDiv);
				//activate the added node (select this and deselect others)
				psDerivation.activateNodeElem($nodeDiv);
				//update curNodeId
				$(".curNodeId").text(newCurNodeId);
			}			
		},
		
		_getNodeFromId: function(iNodeId) {
			var $nodes = $(".node").filter(function(index) {
				var nodeId = $.trim($(this).children(".nodeid").first().text());
				return  nodeId == iNodeId;
			});
			return $nodes.first();
		},
		
		_getNodeId: function ($node) {
			return $.trim($node.children(".nodeid").first().text());
		}
	});
	
	$(document).ready( function() {
		var inputPanelView = new InputPanelView();
		inputPanelView.render();
		console.log(inputPanelView.el);
		$(".inputPanel").append(inputPanelView.el);
	})
});
